/*
 * @Author: aniom
 * @Date:   2020-04-27 19:48:12
 * @Last Modified by:   aniom
 * @Last Modified time: 2020-09-02 02:41:19
 */

//#region GENERAL

var youtubeObject = null;
function playYtVideo(videoId) {
	changeShowHideBlurred(true, ".youtubeVideoView", 2);

	$(".youtubeVideoView .open_in_browser").data("video-id", videoId);
	$(".youtubeVideoView .ulContent").html(
		'<iframe width="400" height="300" src="https://www.youtube-nocookie.com/embed/' +
			videoId +
			'?autoplay=1&rel=0&showinfo=0&start=0" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>'
	);
	// youtubeObject = new YT.Player('videoTagObject', {
	//     width: 360,
	//     height: 240,
	//     // height: customResolution ? customResolution[1] : '160',
	//     playerVars: {
	//         'autoplay': 1,
	//         // 'controls': 0,
	//         // 'autohide': 1,
	//         'wmode': 'opaque',
	//         'origin': 'http://localhost:8000'
	//     },
	//     host: 'https://www.youtube.com',

	//     videoId: videoId,
	//     // events: {
	//     //     'onReady': function(event) {
	//     //             event.target.setVolume(30);
	//     //             event.target.playVideo();
	//     //         },
	//     //     'onError': function(event){console.log(event);}
	//     // }
	// });

	// lastIFramePlayerObject.push(player);
}

function stopYtVideo() {
	changeShowHideBlurred(false, ".youtubeVideoView", 2);

	$(".youtubeVideoView .ulContent").html("");
	// if(youtubeObject){
	//     youtubeObject.destroy();
	// }
}

var lastIFramePlayerObject = [];

function playIFrame(videoIdTag, videoId, customResolution) {
	var player = new YT.Player(videoIdTag, {
		width: customResolution ? customResolution[0] : "280",
		height: customResolution ? customResolution[1] : "160",
		// playerVars: {
		//     'autoplay': 1,
		//     // 'controls': 0,
		//     'autohide': 1,
		//     'wmode': 'opaque',
		//     'origin': 'http://localhost:8000'
		// },
		host: "https://www.youtube.com",

		videoId: videoId,
		events: {
			onReady: function (event) {
				event.target.setVolume(30);
				event.target.playVideo();
			},
			onError: function (event) {
				console.log(event);
			}
		}
	});
	lastIFramePlayerObject.push(player);
}

function stopAllYoutubePlayers(eachJClassToOff) {
	//restore other iframes (turn off all)

	//stop videos and destroy
	if (lastIFramePlayerObject.length > 0) {
		$(lastIFramePlayerObject).each(function () {
			// this.stopVideo();
			this.destroy();
		});
	}

	//reset images
	if (eachJClassToOff) {
		$(eachJClassToOff).each(function () {
			$(this).parent().parent().find(".over-video").fadeIn();
		});
	}

	//clear all objects video players
	lastIFramePlayerObject = [];
}

function popupBackButton() {
	// stopAllYoutubePlayers();
	popupContentSwitcher();
}

//#endregion

//#region SETTINGS

/**
 * Change inputs in settings popup window (get data from JSX to JS)
 * Will loaded with JS @func preloadExtension
 */
function settingsPanelInputs(reloadOnlyPrefsSets) {
	var fullPrefPSets = editLocalPSets(false);
	for (var prefKey in fullPrefPSets) {
		if (fullPrefPSets.hasOwnProperty(prefKey)) {
			var prefVal = fullPrefPSets[prefKey];

			var cssEl = '#popupContent .poBlock.atomSettings input[name="' + prefKey + '"]';
			//for radio
			if ($(cssEl + '[type="radio"]')) {
				$(cssEl + '[type="radio"][value="' + prefVal + '"]').prop("checked", true);
			}
			//for checkbox
			if ($(cssEl + '[type="checkbox"]')) {
				$(cssEl + '[type="checkbox"]').prop("checked", prefVal);
			}
			//for inputs
			if ($(cssEl + '[type="text"]')) {
				$(cssEl + '[type="text"]').val(prefVal);
			}
		}
	}
	if (!reloadOnlyPrefsSets) {
		//set revision info in settings
		$("#popupContent .poBlock.atomSettings .revisionVersion").text(
			extensionRevisionInfo ? extensionAppVersion + "x" + extensionRevisionInfo : extensionAppVersion
		);
	}
}

//#endregion

//#region VIDEO TUTORIALS

function checkAssignedPackageVideoTuts(groupBinding) {
	if (groupBinding && currentTempPackagePrefab.pack) {
		if (groupBinding == currentTempPackagePrefab.pack["name"]) {
			return true;
		}
	}
	return false;
}
/**
 * Create HTML for Video Tutorials in popup data
 * @param {*} json_obj JSON data from server
 * @param {string} css_bind_link Css to set content in popup HTML ID
 * @updated 30.05.2021
 */
function generateVideoTutorials(json_obj, css_bind_link) {
	var genHtmlArr = [];
	var iframeRes = [320, 213];
	var collectSameNamePackages = {};
	for (var key in json_obj) {
		if (json_obj.hasOwnProperty(key)) {
			if (collectSameNamePackages[json_obj[key]["name"]]) {
				//same group name
				var getPackVideos = collectSameNamePackages[json_obj[key]["name"]]["videos"];
				collectSameNamePackages[json_obj[key]["name"]]["videos"] = getPackVideos.concat(json_obj[key]["videos"]);

				var getPackMark = collectSameNamePackages[json_obj[key]["name"]]["mark"];
				//no mark from same package but has other
				if (!getPackMark) {
					collectSameNamePackages[json_obj[key]["name"]]["mark"] = json_obj[key]["mark"];
				}
			} else {
				//first add
				collectSameNamePackages[json_obj[key]["name"]] = json_obj[key];
			}
		}
	}
	$("#tools .notifyToolbarBadge").removeClass("hasNotify");
	for (var key in collectSameNamePackages) {
		if (collectSameNamePackages.hasOwnProperty(key)) {
			var vitem = collectSameNamePackages[key]; //collectSameNamePackages[key];
			var groupName = vitem["name"]; //string
			var groupSpoilerName = "VideoTutorialUID_" + key;
			var groupMark = vitem["mark"]; //arr if exists
			var groupVideos = vitem["videos"]; //arr
			var groupBinding = vitem["bind"]; //string - we get package name instead ID from server-side

			var temp_collect_str = "";

			//Pack binding to tutorial group (works only if one or more packages installed)
			// var checkPackBinding = false;
			// if (groupBinding && currentTempPackagePrefab.pack) {
			//     if (groupBinding == currentTempPackagePrefab.pack['name']) {
			//         checkPackBinding = true;
			//     }
			// }

			var checkPackBinding = checkAssignedPackageVideoTuts(groupBinding);

			if (checkPackBinding) {
				$("#tools .notifyToolbarBadge").addClass("hasNotify");
			}

			/* CREATE GROUP */
			var groupIcon = checkPackBinding ? "bind_pack" : "video";
			var groupBindedClass = checkPackBinding ? "binded" : "";
			var countVideoInGroup = groupVideos.length;
			var groupItemCounts = ""; //'<sup class="count">' + countVideoInGroup + '</sup>';
			//if mark exists
			var htmlMarkTitle = "";
			if (groupMark && groupMark.toString().length) {
				htmlMarkTitle = '<sup class="' + groupMark[1] + '">' + groupMark[0] + "</sup>";
			}
			temp_collect_str +=
				'<div class="tutGroup ' +
				groupBindedClass +
				'" spoiler="' +
				groupSpoilerName +
				'" spoiler-type="vtuts"><div class="i ' +
				groupIcon +
				'"></div>' +
				groupName +
				groupItemCounts +
				htmlMarkTitle +
				'<div class="expand_btn"></div></div>';

			/* CREARE GROUP VIDEOS WITH SPOILER */
			temp_collect_str += '<div class="tutItems spoilerContainer" data-view="' + groupSpoilerName + '">';
			temp_collect_str += "<ul>";

			for (var li = 0; li < countVideoInGroup; li++) {
				temp_collect_str += '<li video_id="' + groupVideos[li] + '" style="width:' + iframeRes[0] + "px;height:" + iframeRes[1] + 'px;">'; //width="' + iframeRes[0] + '" height="' + iframeRes[1] + '"

				temp_collect_str +=
					'<div class="over-video"><div data-action="play" class="play_button"></div><div data-action="open_browser" class="open_in_browser"><div class="icon"></div>in browser</div>';
				temp_collect_str +=
					'<img src="http://i3.ytimg.com/vi/' +
					groupVideos[li] +
					'/hqdefault.jpg" onerror="notImgFillDummies(this, \'video_placeholder\');" width="335" height="252"></div>';

				temp_collect_str += '<div class="videoBlock"><div id="tutVidID_' + li + "_" + groupVideos[li] + '"></div></div>';

				// temp_collect_str += '<img style="width:'+iframeRes[0]+'px;height:'+iframeRes[1]+'px;" src="http://i3.ytimg.com/vi/'+groupVideos[li]+'/hqdefault.jpg">';
				// temp_collect_str += ('<iframe width="' + iframeRes[0] + '" height="' + iframeRes[1] + '" src="https://www.youtube.com/embed/' + groupVideos[li] + '" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>');
				temp_collect_str += "</li>";
			}

			temp_collect_str += "</ul>";
			temp_collect_str += "</div>";

			//if bind with this pack name/ add this loop data from beginning of array
			//why it need? To binded package will from top of all tuts
			if (checkPackBinding) {
				var curBindPackHtml = "<h2>Related to the active package</h2>" + temp_collect_str + '<hr><h2 class="other">Other tutorials</h2>';
				genHtmlArr.unshift(curBindPackHtml);
			} else {
				genHtmlArr.push(temp_collect_str);
			}
		}
	}

	var addPremadesHTML = ""; //'<div class="bchead">Also you can watch video tutorials at <div class="link" data-open="openVTuts">website</div></div>';
	addPremadesHTML += '<div class="vt_body">';
	addPremadesHTML += genHtmlArr.join("");
	addPremadesHTML += "</div>";

	$('#popupContent .poBlock[data-view="' + css_bind_link + '"] .pbody').html(addPremadesHTML);
}

//#endregion

//#region ATOM MARKET

var usedLocalMarketStorage = "";
var isSubscriptionMarketModel = false;
/**
 * Create HTML for Market popup
 * @param {*} json_obj Parsed JSON from server
 * @param {string} css_bind_link Popup ID to set HTML
 */
function generateMarket(json_obj, css_bind_link) {
	// var isPersonalized = atomxCore.personalizer.getPersonalizedAuthorName();
	// var usedLocalMarketStorage = isPersonalized ? tempLocalPersonalizedMarketHandleData[isPersonalized] : tempLocalMarketHandleData;

	var isPersonalized = atomxCore.personalizer.getPersonalizedAuthorName();

	if (isPersonalized) {
		if (!tempLocalPersonalizedMarketHandleData[isPersonalized]) {
			tempLocalPersonalizedMarketHandleData[isPersonalized] = new Object();
		}
		usedLocalMarketStorage = tempLocalPersonalizedMarketHandleData[isPersonalized];

		/* Market by subscription model system and authed user */
		if (maskedIVE && maskedIVE.settings.marketSubscriptionService && tempLocalPersonalizedAuthSystemData["usid"]) {
			isSubscriptionMarketModel = true;
		}
	} else {
		usedLocalMarketStorage = tempLocalMarketHandleData;
	}

	var preparedHtmlBlock = "";

	var catArrHtml = [];
	var catCourseArrHtml = [];
	// var getWidthBtnLenght = objectToArrProps(json_obj).length+1;
	var globalExtraSwitchArrHtml = [];

	var package_tags = [];
	//get only market data
	for (var key in json_obj) {
		if (json_obj.hasOwnProperty(key)) {
			//category sector
			var arr_items = [];
			var categories_arr = json_obj[key];

			if (key == "Packages") {
				var packages_by_softwares = { AE: [], PR: [], AI: [], PS: [] };
				for (var keyx in categories_arr) {
					if (categories_arr.hasOwnProperty(keyx)) {
						var element = categories_arr[keyx];
						if ((hasTags = element["tags"])) {
							package_tags = package_tags.concat(hasTags.toString().split(","));
						}
						packages_by_softwares[element["primary_type"]].push(element);

						tempLocalMarketGettingFromServer[element["id"]] = {
							pack_name: element["pack_name"],
							pack_author: element["author"],
							pack_appID: element["primary_type"],
							pack_version: element["version"],
							notify: false
						};
					}
				}

				var htmlTagsItems = [];
				/* Parse only unique tags */
				package_tags = package_tags.reduce((acc, item) => {
					if (acc.includes(item)) {
						return acc;
					}
					htmlTagsItems.push(`<li>${item}</li>`);
					return [...acc, item];
				}, []);

				var btnWidthPercent = 100 / 3;
				var globalSwitcher = "";
				// hideAllPackages
				// if (maskedIVE.settings.marketplaceOptions.coursesGlobalSection) {
				//   globalExtraSwitchArrHtml.push(
				//     '<div in-show-content-gl-market-switcher="packages"  class="btn selected" style="width:50%">Packages<strong>' +
				//       categories_arr.length +
				//       "</strong></div>"
				//   );
				//   globalExtraSwitchArrHtml.push(
				//     '<div in-show-content-gl-market-switcher="courses"  class="btn" style="width:50%">Courses<strong>' +
				//       categories_arr.length +
				//       "</strong></div>"
				//   );

				//   // globalSwitcher = `<div class="hideContent" style="display:${
				//   //   isSelected ? "block" : "none"
				//   // }" show-content="${key}">${arr_items.join("")}</div>`;
				// }

				if (maskedIVE.settings && maskedIVE.settings.marketplaceOptions && maskedIVE.settings.marketplaceOptions.hideAllPackages) {
					marketSelectedSoftware = "ae";
					btnWidthPercent = 50;
					catArrHtml.push(
						'<div in-show-content="ae" show-content-type="market" class="btn selected" style="width:' +
							btnWidthPercent +
							'%">After Effects<strong>' +
							packages_by_softwares.AE.length +
							"</strong></div>"
					);

					catArrHtml.push(
						'<div in-show-content="pr" show-content-type="market" class="btn" style="width:' +
							btnWidthPercent +
							'%">Premiere Pro<strong>' +
							packages_by_softwares.PR.length +
							"</strong></div>"
					);
					preparedHtmlBlock += iterateMarketItems(packages_by_softwares.AE, usedLocalMarketStorage, "ae", true);

					preparedHtmlBlock += iterateMarketItems(packages_by_softwares.PR, usedLocalMarketStorage, "pr");
				} else {
					catArrHtml.push(
						'<div in-show-content="ae" show-content-type="market" class="btn" style="width:' +
							btnWidthPercent +
							'%">After Effects<strong>' +
							packages_by_softwares.AE.length +
							"</strong></div>"
					);
					catArrHtml.push(
						'<div in-show-content="all" show-content-type="market" class="btn selected" style="width:' +
							btnWidthPercent +
							'%">All Packages<strong>' +
							categories_arr.length +
							"</strong></div>"
					);
					catArrHtml.push(
						'<div in-show-content="pr" show-content-type="market" class="btn" style="width:' +
							btnWidthPercent +
							'%">Premiere Pro<strong>' +
							packages_by_softwares.PR.length +
							"</strong></div>"
					);

					/* Iteration */
					preparedHtmlBlock += iterateMarketItems(packages_by_softwares.AE, usedLocalMarketStorage, "ae");
					preparedHtmlBlock += iterateMarketItems(categories_arr, usedLocalMarketStorage, "all", true);
					preparedHtmlBlock += iterateMarketItems(packages_by_softwares.PR, usedLocalMarketStorage, "pr");
				}
			}

			if (key == "Courses") {
				// var courses_software = [];
				var courses_by_softwares = { AE: [], PR: [], AI: [], PS: [] };
				for (var keyx in categories_arr) {
					if (categories_arr.hasOwnProperty(keyx)) {
						var element = categories_arr[keyx];
						// courses_software = package_tags.concat(
						//   element["apps_sort"].toString().split(",")
						// );

						courses_by_softwares[element["apps_sort"]].push(element);
					}
				}
				// hideAllPackages
				if (maskedIVE.settings && maskedIVE.settings.marketplaceOptions && maskedIVE.settings.marketplaceOptions.coursesGlobalSection) {
					globalExtraSwitchArrHtml.push(
						'<div in-show-content-gl-market-switcher="packages"  class="btn selected" style="width:50%">Packages<strong>' +
							json_obj["Packages"].length +
							"</strong></div>"
					);
					globalExtraSwitchArrHtml.push(
						'<div in-show-content-gl-market-switcher="courses"   class="btn" style="width:50%">Courses<strong>' +
							json_obj["Courses"].length +
							"</strong></div>"
					);

					catCourseArrHtml.push(
						'<div in-show-content="course_ae" show-content-type="course" class="btn selected" style="width:' +
							btnWidthPercent +
							'%">After Effects<strong>' +
							courses_by_softwares.AE.length +
							"</strong></div>"
					);

					catCourseArrHtml.push(
						'<div in-show-content="course_pr" show-content-type="course" class="btn" style="width:' +
							btnWidthPercent +
							'%">Premiere Pro<strong>' +
							courses_by_softwares.PR.length +
							"</strong></div>"
					);
				}
				/* Iteration */

				preparedHtmlBlock += iterateMarketCourseItems(courses_by_softwares.AE, "ae");

				// preparedHtmlBlock += iterateMarketCourseItems(
				//   courses_by_softwares.PR,
				//   "pr"
				// );
			}
		}
	}

	preparedHtmlBlock += `<div class="hideContent" show-content="tag_sorted"></div>`;

	var categoryButtons = '<ul class="customizeElement" data-type="market_switcher" data-opt="package_softwares"><li><div class="block clearfix">';
	categoryButtons += catArrHtml.join("");
	categoryButtons += "</div></li></ul>";

	if (globalExtraSwitchArrHtml.length > 0) {
		categoryButtons +=
			'<ul class="customizeElement" data-type="market_switcher" data-opt="course_softwares" style="display:none;"><li><div class="block clearfix">';
		categoryButtons += catCourseArrHtml.join("");
		categoryButtons += "</div></li></ul>";

		var prevBtns = categoryButtons;
		categoryButtons = '<ul class="customizeElement" data-type="market_switcher" data-opt="global_switcher"><li><div class="block clearfix">';
		categoryButtons += globalExtraSwitchArrHtml.join("");
		categoryButtons += "</div></li></ul>";
		categoryButtons += prevBtns;
	}

	var tagsButtons = htmlTagsItems.length > 0 ? '<ul class="market_tags_button"><span>Sort By Tags:</span> ' + htmlTagsItems.join("") + "</ul>" : "";

	if (maskedIVE.settings && maskedIVE.settings.marketplaceOptions && maskedIVE.settings.marketplaceOptions.hideSortTags) {
		tagsButtons = "";
	}

	var vtBodyContent = '<div class="vt_body">' + preparedHtmlBlock + "</div>";
	var lastButtonLoadMore = '<div class="loadMoreButton">Go to web-store</div>';

	//set content to market html
	$('#popupContent .poBlock[data-view="' + css_bind_link + '"] .pbody').html(categoryButtons + tagsButtons + vtBodyContent + lastButtonLoadMore);

	//change size only after append HTML vt_body
	customizeMarketGridItemsWidth($(window).width());

	//add bg after any server preload info blocks - success
	if (!$('#popupContent .poBlock[data-view="' + css_bind_link + '"] .pbody').hasClass("bg")) {
		$('#popupContent .poBlock[data-view="' + css_bind_link + '"] .pbody').addClass("bg");
	}
}

var marketSelectedSoftware = "all";
var coursesSelectedSoftware = "";

function sortMarketItems(sortOf) {
	// serverTempMarketplaceJSON
	// console.log(sortOf);
	if (sortOf) {
		$(".atomMarket .hideContent").hide();
		var objectByTags = [];
		for (var item of serverTempMarketplaceJSON["Packages"]) {
			if (item.tags && item.tags.indexOf(sortOf) !== -1) {
				objectByTags.push(item);
			}
		}

		var itemsByTag = iterateMarketItems(objectByTags, usedLocalMarketStorage, "tag_sorted", true);

		$('.atomMarket .hideContent[show-content="tag_sorted"]').html(itemsByTag).show();
	} else {
		$(".atomMarket .hideContent").hide();

		$('.customizeElement div[show-content-type="market"]').removeClass("selected");
		$('.customizeElement div[show-content-type="market"][in-show-content="all"]').addClass("selected");
		$('.atomMarket .hideContent[show-content="all"]').show();
	}
}

function iterateMarketItems(categories_arr, usedLocalMarketStorage, key, isSelected) {
	var arr_items = [];
	var propSeparator = ":";
	//cycle with each item in category
	for (var index = 0; index < categories_arr.length; index++) {
		var tempLineStr = "";
		var element = categories_arr[index];

		var id = element["id"];
		var name = element["name"];
		var author = element["author"] ? element["author"] : "";
		var version = element["version"] ? element["version"] : "";
		var ext_version = element["ext_version"] ? element["ext_version"] : "";
		var primary_type = element["primary_type"]; //AE/PS/Scripts - one type
		var secondary_type = element["secondary_type"]; //AE/PS/Scripts - can more types via :

		// if(element['tags']){
		//     package_tags = package_tags.concat(element['tags'].toString().split(','));
		// }

		var compatible_version = element["compatible_version"] ? element["compatible_version"] : "";

		var discount = element["discount"];
		var custom_price = element["custom_price"];
		var bind_pack = element["bind_pack"] ? element["bind_pack"] : "";
		var extra_href = element["extra_href"] ? element["extra_href"] : "";
		var video_id = element["video_id"];
		var image_url = element["image_url"];
		image_url += "?v=" + version; //Add version of image to refresh if updated on server
		var pack_name = element["pack_name"];
		var pack_try_free = element["pack_try_free"];
		var item_by_subscription = element["pack_is_abs"];

		var badgeNewestItem = "";
		//if category - Packages - save info in temp obj
		if (usedLocalMarketStorage && usedLocalMarketStorage["loadOption"]) {
			if (usedLocalMarketStorage["content"] && usedLocalMarketStorage["content"][id] && usedLocalMarketStorage["content"][id]["notify"] == true) {
				badgeNewestItem = '<div class="badgeNew"></div>';
			}
		}

		var price_html = discount ? '<div class="saleIcon"></div>$' + custom_price + "<sub>$" + discount + "</sub>" : "$" + custom_price;

		price_html = !custom_price || custom_price === 0 ? "Free" : price_html;

		var try_free_btn = pack_try_free ? "" : "disabled";
		var buy_item_btn = {
			css: "buy",
			text: "Buy Item",
			type: "premium"
		};

		if (price_html == "Free") {
			buy_item_btn["css"] = "free";
			buy_item_btn["text"] = "Get Free";
		}

		/* Change text if subscription model */
		if (item_by_subscription) {
			if (tempLocalPersonalizedAuthSubscriptionStatus) {
				price_html = "Covered by Subscription";
			} else {
				price_html += ' <small style="opacity:0.8;">or </small>Free <small style="opacity:0.8;">by Subscription</small>';
			}

			if (isSubscriptionMarketModel) {
				buy_item_btn["text"] = "Install";
				buy_item_btn["css"] = "download_subs";
				buy_item_btn["type"] = "download_by_subs";
			}
		}

		var version_html = version ? '<div class="labelVersion">v' + version + "</div>" : "";
		var specialGlowByInstalledPackCss = "";
		//Installed package checks
		var installed_notify_html = "";

		switch (marketCheckAlreadyInstalledPackage(pack_name, author, version, primary_type)) {
			case "ALREADY_INSTALLED":
				installed_notify_html = '<div class="labelInstalledNotify">installed</div>';

				if (isSubscriptionMarketModel) {
					buy_item_btn["text"] = "Installed";
					buy_item_btn["css"] = "disabled";
				}

				specialGlowByInstalledPackCss = "featured";
				break;
			case "UPDATE_PACKAGE":
				installed_notify_html = '<div class="labelInstalledNotify">Update to v' + version + "</div>";
				buy_item_btn["text"] = "Update";
				buy_item_btn["css"] = "update";
				specialGlowByInstalledPackCss = "updating";
				break;
			case "DEMO_INSTALLED":
				installed_notify_html = '<div class="labelInstalledNotify">Demo installed</div>';
				break;
		}

		//create compatibles
		var compatibles_html = ""; //compatibles
		var info_desc_html = ""; //special desc in hidden section
		var app_first_compatible_version = "";
		if (primary_type) {
			var compatibleSwitchData_one = e_marketCompatibles(primary_type);
			var getAppFullName = softAssetsByAppID[bind_pack] ? softAssetsByAppID[bind_pack]["name"] : "";
			//bind to
			var specialPackCustomHref = extra_href && bind_pack ? 'custom-href="true"' : "";
			compatibles_html += bind_pack
				? "<div " +
				  specialPackCustomHref +
				  ' has-version="' +
				  bind_pack +
				  '" tooltip="Open ' +
				  getAppFullName +
				  ' version" tooltip-type="pack_manager"><div class="f gi min ' +
				  bind_pack +
				  '"></div></div>'
				: "";
			app_first_compatible_version = compatible_version.toString().split(propSeparator)[0];
			//default icon
			compatibles_html +=
				'<div tooltip="' +
				compatibleSwitchData_one["desc"] +
				" " +
				app_first_compatible_version +
				'" tooltip-type="pack_manager"><div class="gi min ' +
				compatibleSwitchData_one["icon"] +
				'"></div></div>';

			info_desc_html += bind_pack
				? "<p>This project has a <strong " + specialPackCustomHref + ' has-version="' + bind_pack + '">' + getAppFullName + "</strong> version</p>"
				: "";
		}
		if (secondary_type) {
			//if more one item_type info
			for (var it = 0; secondary_type.toString().split(propSeparator)[it]; it++) {
				var it_e = secondary_type.toString().split(propSeparator)[it]; //item_type
				var cl_ver = compatible_version.toString().split(propSeparator)[it + 1]; //compatible version
				cl_ver = cl_ver ? cl_ver : "";

				var compatibleSwitchData_two = e_marketCompatibles(it_e);

				compatibles_html +=
					'<div tooltip="' +
					compatibleSwitchData_two["desc"] +
					" " +
					cl_ver +
					'" tooltip-type="pack_manager"><div class="gi min ' +
					compatibleSwitchData_two["icon"] +
					'"></div></div>';
			}
			info_desc_html += "<p><i>All-in-one:</i> This project contains several versions for different applications</p>";
		}

		if (item_by_subscription) {
			compatibles_html +=
				'<div style="padding-left:0px;" tooltip="Free by subscription" tooltip-type="pack_manager"><div class="gi min subscription"></div></div>';
		}
		var buttonsMaked = "";

		var buttonPlayIconSub = '<div class="play_button"></div>';
		if (maskedIVE.settings && maskedIVE.settings.marketAsPackageManager && installed_notify_html) {
			buttonPlayIconSub = '<div class="apply_as_package"></div>';
		}

		buttonsMaked = itemMarketButtonsGenerator({
			main_file: {
				css: buy_item_btn["css"],
				type: buy_item_btn["type"],
				text: buy_item_btn["text"]
			},
			demo:
				maskedIVE.settings && maskedIVE.settings.marketplaceOptions && maskedIVE.settings.marketplaceOptions.hideTryFreeButtons
					? null
					: {
							css: try_free_btn
					  },
			details: {
				css: ""
			}
		});

		tempLineStr +=
			'<div class="mitem ' +
			specialGlowByInstalledPackCss +
			'" item_id="' +
			id +
			'" video_id="' +
			video_id +
			'" market_item_type="' +
			key +
			'" pack-name="' +
			pack_name +
			'" pack-appid="' +
			primary_type +
			'"pack-author="' +
			author +
			'"pack-version="' +
			version +
			'"pack-ext-version="' +
			ext_version +
			'"pack-appversion="' +
			app_first_compatible_version +
			'">\
            ' +
			badgeNewestItem +
			'\
            <div class="label">' +
			price_html +
			"</div>\
            " +
			version_html +
			installed_notify_html +
			'<div class="over-video">' +
			buttonPlayIconSub +
			'<img src="' +
			image_url +
			'" onerror="notImgFillDummies(this, \'video_placeholder\');" width="280" height="160">\
            </div>\
            <div class="videoBlock"><div id="vidID_' +
			index +
			'"></div></div>\
            <div class="content">\
                <div class="clearfix">\
                    <div class="title" title="' +
			name +
			'">' +
			name +
			'</div>\
                    <div class="compatibles">' +
			compatibles_html +
			'</div>\
                </div>\
                <div class="author">by <strong>' +
			author +
			'</strong></div>\
                <div class="hiddenContent">\
                    <ul class="customizeElement">\
                        <li>\
                            <div class="block clearfix">' +
			buttonsMaked +
			"</div>\
                        </li>\
                        <li>" +
			info_desc_html +
			"</li>\
                    </ul>\
                </div>\
            </div>\
        </div>";

		arr_items.push(tempLineStr);
	}

	return `<div class="hideContent" style="display:${isSelected ? "block" : "none"}" show-content="${key}">${arr_items.join("")}</div>`;
}

function iterateMarketCourseItems(categories_arr, key, isSelected) {
	var arr_items = [];
	var propSeparator = ":";
	//cycle with each item in category
	for (var index = 0; index < categories_arr.length; index++) {
		var tempLineStr = "";
		var element = categories_arr[index];

		var id = element["id"];
		var name = element["name"];
		var version = element["version"] ? element["version"] : "";
		var primary_type = element["apps_sort"];
		// if(element['tags']){
		//     package_tags = package_tags.concat(element['tags'].toString().split(','));
		// }

		var discount = element["discount"];
		var custom_price = element["price"];
		var extra_href = element["link"] ? element["link"] : "";
		var video_id = element["yt_video_id"];
		var image_url = element["image_url"];
		image_url += "?v=" + version; //Add version of image to refresh if updated on server

		var badgeNewestItem = "";

		var price_html = discount ? '<div class="saleIcon"></div>$' + custom_price + "<sub>$" + discount + "</sub>" : "$" + custom_price;

		price_html = !custom_price || custom_price === 0 ? "Free" : price_html;

		var buy_item_btn = {
			css: "buy",
			text: "Buy This Course",
			type: "premium"
		};

		if (price_html == "Free") {
			buy_item_btn["css"] = "free";
			buy_item_btn["text"] = "Get Free";
		}

		/* Change text if subscription model */
		// if (item_by_subscription) {
		//   if (tempLocalPersonalizedAuthSubscriptionStatus) {
		//     price_html = "Covered by Subscription";
		//   } else {
		//     price_html +=
		//       ' <small style="opacity:0.8;">or </small>Free <small style="opacity:0.8;">by Subscription</small>';
		//   }

		//   if (isSubscriptionMarketModel) {
		//     buy_item_btn["text"] = "Install";
		//     buy_item_btn["css"] = "download_subs";
		//     buy_item_btn["type"] = "download_by_subs";
		//   }
		// }

		var version_html = version ? '<div class="labelVersion">v' + version + "</div>" : "";
		var specialGlowByInstalledPackCss = "";
		//Installed package checks
		var installed_notify_html = "";

		//create compatibles
		var compatibles_html = ""; //compatibles
		var info_desc_html = ""; //special desc in hidden section
		if (primary_type) {
			var compatibleSwitchData_one = e_marketCompatibles(primary_type);

			// var getAppFullName = softAssetsByAppID[primary_type]
			//   ? softAssetsByAppID[primary_type]["name"]
			//   : "";

			// var specialPackCustomHref =
			//   extra_href && primary_type ? 'custom-href="true"' : "";
			// compatibles_html += primary_type
			//   ? "<div " +
			//     specialPackCustomHref +
			//     ' has-version="' +
			//     primary_type +
			//     '" tooltip="Open ' +
			//     getAppFullName +
			//     ' version" tooltip-type="pack_manager"><div class="f gi min ' +
			//     primary_type +
			//     '"></div></div>'
			//   : "";

			compatibles_html +=
				'<div tooltip="Course for ' +
				compatibleSwitchData_one["desc"] +
				'" tooltip-type="pack_manager"><div class="gi min ' +
				compatibleSwitchData_one["icon"] +
				'"></div></div>';

			info_desc_html += element["description"];
		}

		// if (item_by_subscription) {
		//   compatibles_html +=
		//     '<div style="padding-left:0px;" tooltip="Free by subscription" tooltip-type="pack_manager"><div class="gi min subscription"></div></div>';
		// }
		var buttonsMaked = "";

		var buttonPlayIconSub = '<div class="play_button"></div>';

		buttonsMaked = itemMarketButtonsGenerator({
			main_file: {
				css: buy_item_btn["css"],
				type: buy_item_btn["type"],
				text: buy_item_btn["text"]
			},
			details: {
				css: ""
			}
		});

		tempLineStr += `
    <div class="mitem" item_id="${id}" video_id="${video_id}" market_item_type="${key}" link_name="${extra_href}">
      ${badgeNewestItem}
      <div class="label">${price_html}</div>
      ${version_html}
      ${installed_notify_html}
      <div class="over-video">
        ${buttonPlayIconSub}
        <img src="${image_url}" onerror="notImgFillDummies(this, 'video_placeholder');" width="280" height="160">
      </div>
      <div class="videoBlock">
        <div id="vidID_${index}"></div>
      </div>
      <div class="content">
        <div class="clearfix">
          <div class="title" title="${name}">${name}</div>
          <div class="compatibles">${compatibles_html}</div>
        </div>

        <div class="hiddenContent">
          <ul class="customizeElement">
            <li>
              <div class="block clearfix">${buttonsMaked}</div>
            </li>
            <li>${info_desc_html}</li>
          </ul>
        </div>
      </div>
    </div>
  `;

		arr_items.push(tempLineStr);
	}

	return `<div class="hideContent" style="display:${isSelected ? "block" : "none"}" show-content="course_${key
		.toString()
		.toLowerCase()}">${arr_items.join("")}</div>`;
}

function itemMarketButtonsGenerator(options) {
	var makeButtonPanel = "";
	var btnWidthPercent = options.demo ? 34 : 50;
	if (options.main_file) {
		makeButtonPanel += `<div btn-type="${options.main_file.type}" class="btn ${options.main_file.css}" style="width:${btnWidthPercent}%"><div class="icon"></div>${options.main_file.text}</div>`;
	}
	if (options.demo) {
		makeButtonPanel += `<div btn-type="try_free" class="btn try_free ${options.demo.css}" style="width:32%"><div class="icon"></div>Try Free</div>`;
	}
	if (options.details) {
		makeButtonPanel += `<div btn-type="details" class="btn link ${options.details.css}" style="width:${btnWidthPercent}%"><div class="icon"></div>Details</div>`;
	}
	return makeButtonPanel;
}

/**
 * Atom Market get icon and desc compatibles
 * @param {*} item_type AE/PR/PS... or PLUGIN/MIX
 */
function e_marketCompatibles(item_type) {
	var fullSoftName = "",
		iconSoftID = "";
	switch (item_type) {
		case "AE":
		case "PR":
		case "PS":
		case "AI":
			fullSoftName = softAssetsByAppID[item_type]["name"];
			iconSoftID = item_type;
			break;
		case "PLUGIN":
			fullSoftName = "Script/Plugin";
			iconSoftID = item_type;
			break;
		default:
			fullSoftName = "Mixed Content";
			iconSoftID = "MIX";
	}
	return {
		icon: iconSoftID,
		desc: fullSoftName
	};
}

/**
 * System of information to user - if package installed (full/demo/update) in extension - you can show about in market
 * @param {string} pack_name name
 * @param {string} pack_author author
 * @param {string} pack_version version
 * @param {string} pack_appID AE/PS...
 */
function marketCheckAlreadyInstalledPackage(pack_name, pack_author, pack_version, pack_appID) {
	var arrPackList = currentTempPackagePrefab.list;

	if (arrPackList) {
		for (var i = 0; i < arrPackList.length; i++) {
			var curPack = arrPackList[i];

			//pack name and author found
			if (curPack.name == pack_name && curPack.author == pack_author) {
				if (curPack.version == pack_version && curPack.appID == pack_appID) {
					//FULL MATCH
					return "ALREADY_INSTALLED";
				} else {
					//appID checks
					if (curPack.appID == pack_appID) {
						//versions checks
						if (curPack.version != pack_version) {
							if (curPack.version == "DEMO") {
								return "DEMO_INSTALLED";
							}
							if (curPack.version < pack_version) {
								return "UPDATE_PACKAGE";
							}
							if (curPack.version > pack_version) {
								return "ALREADY_INSTALLED";
							}
						}
					}
				}
			}
		}
	}
}

/**
 * Send message from market (server aniom)
 * @param {string} active Status icon
 * @param {string} newMessage Show message
 */
function marketNewMessage(active, newMessage) {
	var j_calloutMarket = $("#header .headMenu .calloutsMarket");
	var j_shoppingCart = $("#header .headMenu .shoppingCart");
	if (active) {
		if (newMessage) {
			j_calloutMarket.html(newMessage);
		}
		j_shoppingCart.addClass("active");
		j_calloutMarket.stop().fadeIn(200);
		// j_calloutMarket.stop().animate({ 'visibility': 'visible', 'display': 'block'}, 300 );
	} else {
		//remove message anyway when change panel size
		disableCalloutMarketMessage = true;
		//change
		j_shoppingCart.removeClass("active");
		j_calloutMarket.stop().fadeOut(200);
		// j_calloutMarket.stop().animate({ 'visibility': 'hidden', 'display': 'none'}, 300 );
	}
}

/**
 * Show notify counter callout in CSS
 * @param {string|number} unread_items_num Number of counts
 */
function marketNotify(unread_items_num) {
	var notifyCss = "#header .headMenu .notifyCounter";
	var setNumHtml = "";
	if (unread_items_num) {
		//show button - hide notify
		$("#popupContent .poBlock.atomMarket .top > div[data-buttons] .notify_off").show();

		if (unread_items_num > 9) {
			setNumHtml = '<span data-count="' + unread_items_num + '">9+</span>';
			$(notifyCss).addClass("constantlyShake");
		} else {
			setNumHtml = '<span data-count="' + unread_items_num + '">' + unread_items_num + "</span>";
			if ($(notifyCss).hasClass("constantlyShake")) {
				$(notifyCss).removeClass("constantlyShake");
			}
		}
	}

	$(notifyCss).html(setNumHtml);
}

/**
 * Global turn off notify from market (global and by one)
 * @param {*} global_turn_off Global Turn off
 * @param {*} one_item_id ID for turn off by one item
 */
function marketTurnOffNotify(global_turn_off, one_item_id) {
	// var isPersonalized = atomxCore.personalizer.getPersonalizedAuthorName();
	// var usedLocalMarketStorage = isPersonalized ? tempLocalPersonalizedMarketHandleData[isPersonalized] : tempLocalMarketHandleData;
	// var saveMarketLike = isPersonalized ? "personalMarketNotifier" : "MarketNotifier";

	var isPersonalized = atomxCore.personalizer.getPersonalizedAuthorName();
	var usedLocalMarketStorage = "",
		saveMarketLike = "";
	if (isPersonalized) {
		if (!tempLocalPersonalizedMarketHandleData[isPersonalized]) {
			tempLocalPersonalizedMarketHandleData[isPersonalized] = new Object();
		}
		usedLocalMarketStorage = tempLocalPersonalizedMarketHandleData[isPersonalized];
		saveMarketLike = "personalMarketNotifier";
	} else {
		usedLocalMarketStorage = tempLocalMarketHandleData;
		saveMarketLike = "MarketNotifier";
	}

	var anyChangesCheck = false;
	var countNumNotify = Number($("#header .headMenu .notifyCounter span").data("count"));
	if (usedLocalMarketStorage && usedLocalMarketStorage["loadOption"]) {
		if (global_turn_off) {
			for (var id in usedLocalMarketStorage["content"]) {
				if (usedLocalMarketStorage["content"][id]["notify"] == true) {
					usedLocalMarketStorage["content"][id]["notify"] = false;
					anyChangesCheck = true;
					countNumNotify--;
				}
			}
			//animate off badge
			$("#popupContent .poBlock.atomMarket .mitem .badgeNew").fadeOut();
		} else {
			if (one_item_id) {
				if (usedLocalMarketStorage["content"][one_item_id]["notify"] == true) {
					usedLocalMarketStorage["content"][one_item_id]["notify"] = false;
					anyChangesCheck = true;
					countNumNotify--;
				}
			}
		}
	}
	//save changes
	if (anyChangesCheck) {
		marketNotify(countNumNotify); //change count in callout icon
		saveLocalPreferences(saveMarketLike); //save in preferences
	}
}

/**
 * Create number of count to notify user
 * Show to user and save in prefs for future
 * @changed SavePreferences only when has server data with changesm or first create JSON content
 */
function marketNotifyChecker() {
	var isPersonalized = atomxCore.personalizer.getPersonalizedAuthorName();
	var usedLocalMarketStorage = "",
		saveMarketLike = "";
	if (isPersonalized) {
		if (!tempLocalPersonalizedMarketHandleData[isPersonalized]) {
			tempLocalPersonalizedMarketHandleData[isPersonalized] = new Object();
		}
		usedLocalMarketStorage = tempLocalPersonalizedMarketHandleData[isPersonalized];
		saveMarketLike = "personalMarketNotifier";
	} else {
		usedLocalMarketStorage = tempLocalMarketHandleData;
		saveMarketLike = "MarketNotifier";
	}
	marketNotify(0); /* Reset notifier to change package with custom markets */

	//in Market Local Content can be unused packages if they removed from server after download to local iteration
	//but unused package not will shown and used in market

	//if exists market data from prefs (old info)
	if (usedLocalMarketStorage && usedLocalMarketStorage["loadOption"]) {
		//not first start - can check saved content and server content to find differents and show it to user
		//if server content exists
		if (tempLocalMarketGettingFromServer) {
			var notify_count_num = 0;
			var notify_one_check = 0;
			var last_pack_data = {};
			//let cycle by items

			for (var id in tempLocalMarketGettingFromServer) {
				if (tempLocalMarketGettingFromServer.hasOwnProperty(id)) {
					var serverItem = tempLocalMarketGettingFromServer[id]; //as main coz source of content data
					var localItem = usedLocalMarketStorage["content"][id];

					//if local item exists with this item ID
					if (localItem) {
						if (
							serverItem["pack_name"] == localItem["pack_name"] &&
							serverItem["pack_author"] == localItem["pack_author"] &&
							serverItem["pack_appID"] == localItem["pack_appID"]
						) {
							//new version check (server version more than local) - throw notify
							if (serverItem["pack_version"] > localItem["pack_version"]) {
								//set last data temp
								last_pack_data["name"] = serverItem["pack_name"]; //set pack name
								last_pack_data["appID"] = serverItem["pack_appID"]; //set appID
								last_pack_data["notify_by"] = "version"; //set notify type

								//set data to prefs in future
								usedLocalMarketStorage["content"][id]["pack_version"] = serverItem["pack_version"];
								usedLocalMarketStorage["content"][id]["notify"] = true; //set notify as NEW (UPD/any changes)
								//update from server pack data

								notify_count_num++;
								notify_one_check++;
							} else {
								if (localItem["notify"] == true) {
									notify_count_num++;
								}
							}
						} else {
							//refresh local item with server id if name/author/appID will changed on server
							usedLocalMarketStorage["content"][id] = {
								pack_name: serverItem["pack_name"],
								pack_author: serverItem["pack_author"],
								pack_appID: serverItem["pack_appID"],
								pack_version: serverItem["pack_version"],
								notify: localItem["notify"]
							};
							notify_count_num++;
						}
					} else {
						//if no - new item in market - do notify about it
						//set last data temp
						last_pack_data["name"] = serverItem["pack_name"]; //set pack name
						last_pack_data["appID"] = serverItem["pack_appID"]; //set appID
						last_pack_data["notify_by"] = "package"; //set notify type

						//create new local item with server id
						usedLocalMarketStorage["content"][id] = {
							pack_name: serverItem["pack_name"],
							pack_author: serverItem["pack_author"],
							pack_appID: serverItem["pack_appID"],
							pack_version: serverItem["pack_version"],
							notify: true
						};
						notify_count_num++;
						notify_one_check++;
					}
				}
			}

			//if more 0 - show notify - only newest notify
			if (notify_count_num > 0) {
				if (last_pack_data["name"]) {
					//show message only if notify getting first time
					var msgText = "Check what's new in market!<p>Updates and new packages!</p>"; //default message
					var fullAppName = softAssetsByAppID[last_pack_data["appID"]]
						? softAssetsByAppID[last_pack_data["appID"]]["name"]
						: softAssetsByAppID["AE"]["name"];
					//if notify about new package
					if (notify_one_check == 1 && last_pack_data["notify_by"] == "package") {
						msgText = "Checkout new package!<p>" + last_pack_data["name"] + " for " + fullAppName + "</p>";
					}
					//if notify about version
					if (notify_one_check == 1 && last_pack_data["notify_by"] == "version") {
						msgText = "Available new version!<p>Pack: " + last_pack_data["name"] + "</p>";
					}
					//show message
					marketNewMessage(true, msgText);
				}
				//show notify
				marketNotify(notify_count_num);
				//save in prefs json file
				if (notify_one_check) {
					//save to prefs
					saveLocalPreferences(saveMarketLike);
				}
			}
		}
	} else {
		//if no data - just create (it's first start the extension)
		usedLocalMarketStorage["loadOption"] = "INITIALIZED"; //execute options
		usedLocalMarketStorage["content"] = tempLocalMarketGettingFromServer; //set server data to prefs

		//save in prefs json file
		saveLocalPreferences(saveMarketLike);
	}
}

//#endregion

//#region POPUP SERVER LOAD

function changePreloadServerInfoBlock(dataView, method) {
	var errorContent = "";
	switch (method) {
		case "parse":
			errorContent = '<div class="ci bug"></div><h1>Error on server</h1><h2>Please try later, or write to support</h2>';
			break;
		case "connect":
			errorContent = '<div class="ci warning"></div><h1>No connection</h1><h2>Check your internet connection</h2>';
			break;
		case "timeout":
			errorContent = '<div class="ci timeout"></div><h1>Timeout</h1><h2>Please try again later</h2>';
			break;
		case "load":
			errorContent = '<div class="ci blocked"></div><h1>Unable to load</h1><h2>No content due to server errors</h2>';
			break;
		case "bad_search":
			errorContent = '<div class="ci blocked"></div><h1>Assets not found</h1><h2>Please change your search query and try again</h2>';
			break;
		case "end_search":
			errorContent = '<div class="ci warning"></div><h1>Content is out</h1><h2>You have reached the end of items matching your search query</h2>';
			break;
	}

	if (dataView) {
		$('#popupContent .poBlock[data-view="' + dataView + '"] .pbody .preloadInfoBlock').html(errorContent);
	} else {
		return `<div class='preloadInfoBlock'>${errorContent}</div>`;
	}
}

function upServerContent(mtype, arg, callback) {
	try {
		/* Personalization for market/tuts */
		var isPersonalizingAuthorName = atomxCore.personalizer.getAuthorName();

		switch (mtype) {
			case "vtuts":
				//VIDEO TUTORIALS connect to server only one time for session

				//personalized extension
				if (maskedIVE) {
					//if direct - just open vtuts in browser link
					if (maskedIVE["settings"]["videoTutorials"] == "direct") {
						linkCore("link", "video_tutorials");
						return false;
					}
				}

				var xhURI = mainApiURI + "vtuts";
				//personalization for Video Tutorials content
				if (isPersonalizingAuthorName) {
					xhURI += "?king=" + isPersonalizingAuthorName;
				}

				var cssPopupLink = "ATOM_VIDEO_TUTS";
				// if (!serverTempVideoTutsJSON || (serverTempVideoTutsJSON && atomxCore.personalizer.checkRefreshContent(isPersonalizingAuthorName))) {
				if (!serverTempVideoTutsJSON) {
					cHttpAsync(xhURI, function (result, success) {
						if (success && result) {
							try {
								//prepare to JSON obj from string
								var json_vtuts = JSON.parse(result);
								//save this json in temp to use inside session without connect to server
								serverTempVideoTutsJSON = json_vtuts;
								//create video tuts content from json
								generateVideoTutorials(json_vtuts, cssPopupLink);
							} catch (ex) {
								//if can't read JSON from server
								changePreloadServerInfoBlock(cssPopupLink, "parse");
							}
						} else {
							//no connection/any errors
							if (result == "NO_CONNECTION") {
								changePreloadServerInfoBlock(cssPopupLink, "connect");
							}
							//timeout loading
							if (result == "REQUEST_TIMEOUT") {
								changePreloadServerInfoBlock(cssPopupLink, "timeout");
							}
							//no success load or no content in result
							if (result == "NO_SUCCESS_LOAD" || !result) {
								changePreloadServerInfoBlock(cssPopupLink, "load");
							}
						}
					});
				} else {
					//recreate content with temp json from server (special if switched package to bind within)
					generateVideoTutorials(serverTempVideoTutsJSON, cssPopupLink);
				}
				break;
			case "marketAndUpdater":
				//do not get server data for tests
				/*             if(arg == 'openMarket'){
                                return false;
                            } */
				//MARKETPLACE connect to server only one time for session
				//also here update notification from server
				var cssPopupLink = "ATOM_MARKET";

				if (!serverTempMarketplaceJSON || (serverTempMarketplaceJSON && atomxCore.personalizer.checkRefreshContent(isPersonalizingAuthorName))) {
					var uriPiecesArr = [];

					var xhURI = mainApiURI + "mau";

					//Personalized market
					if (isPersonalizingAuthorName) {
						uriPiecesArr.push("king=" + isPersonalizingAuthorName);

						//Get subscribed user data to continue (subscription market service)
						if (maskedIVE && maskedIVE.settings.marketSubscriptionService && tempLocalPersonalizedAuthSystemData["usid"]) {
							uriPiecesArr.push("usid=" + tempLocalPersonalizedAuthSystemData["usid"], "email=" + tempLocalPersonalizedAuthSystemData["email"]); //add USID
							uriPiecesArr.push("usp=" + getUserSystemPrint()); //add USP user data
							uriPiecesArr.push("has_control_devices=true");

							if (maskedIVE.settings && maskedIVE.settings.marketplaceOptions && maskedIVE.settings.marketplaceOptions.coursesGlobalSection) {
								uriPiecesArr.push("courses_content=true");

								
							}
													if (maskedIVE.settings && maskedIVE.settings.authWithSitePassword) {
								uriPiecesArr.push("auth_password=true");

								
							}

							// window.prompt("Copy to clipboard: Ctrl+C, Enter", getUserSystemPrint());
						}
					}

					//GRACE MODULE CONTENT
					//!!!mode required: name (pack)/author/appid like in row above
					//run graceModule
					if (useModules["graceModule"]) {
						var getGM = graceModule();
						if (getGM) {
							uriPiecesArr.push(getGM);
						}

						atomxCore.boot.throwBootLoader("- graceModule");
					}

					//final xhURI
					xhURI += "?" + uriPiecesArr.join("&");

					// alert(xhURI);

					updateCenter(true); //add plug to notify updater before async content load
					cHttpAsync(xhURI, function (result, success) {
						if (success && result) {
							try {
								//prepare to JSON obj from string
								var json_market = JSON.parse(result);

								//personal market or global?
								// personalizedMarketBool = json_market['personalization'];
								//save this json in temp to use inside session without connect to server
								serverTempMarketplaceJSON = json_market["market"];

								// serverPersonalizedSystemService = json_market['personalization'];
								atomxCore.personalizer.setPersonalizedAuthorName(json_market["personalization"]);

								//create update notify in extension
								updateCenter(false, json_market["updater"]);
								//external module for analytics/content iframes
								externalModule(json_market["iframe"], json_market["analytics"]);
								//create video tuts content from json
								generateMarket(json_market["market"], cssPopupLink);

								// if (json_market["courses_content"]) {
								//   generateCoursesContent(
								//     json_market["courses_content"],
								//     cssPopupLink
								//   );
								// }
								//market notify comparing (save to local to check in future) - only after @func generateMarket
								marketNotifyChecker();

								//Subscription market personalized - load subscribed info
								if (maskedIVE && maskedIVE.settings.marketSubscriptionService) {
									if (tempLocalPersonalizedAuthSystemData["usid"]) {
										if (json_market["auth"]) {
											//auth is ok, set subscription status and auth data to prefs
											// alert(json_market['auth']['subscribed']);

											//add error data on server (auto-auth when reload extension)
											// if (json_market["auth"].toString().indexOf("-") == -1) {
											//   tempLocalPersonalizedAuthSpecialErrorsOnStartup =
											//     json_market["auth"];
											// }

											if (!json_market["auth"]["usid"]) {
												tempLocalPersonalizedAuthSpecialErrorsOnStartup = json_market["auth"];
											}

											if (maskedIVE.settings.authBeforeStart && tempLocalPersonalizedAuthSpecialErrorsOnStartup) {
												authBeforeStartInit();
												marketLoginResponseList(json_market["auth"]);
											} else {
												checkAuthLogin(true, json_market["auth"]);
											}
										} else {
											//clear login data if invalid user on server
											tempLocalPersonalizedAuthSystemData = {};
											saveLocalPreferences("personalAuthSystem");
										}
									} else {
										if (maskedIVE.settings.authBeforeStart) {
											authBeforeStartInit();
										}
									}

									/* Show subscription buttons for market */
									$("#popupContent .poBlock.atomMarket .top > div[data-buttons]").hide(); //hide all options
									$('#popupContent .poBlock.atomMarket .top > div[data-buttons="subscription"]').show(); //show subscription btns

									//run callback from app.js (because async load data from market - auth/subscription status)
									callback();
								}

								atomxCore.boot.throwBootLoader("MAU");
							} catch (ex) {
								//if can't read JSON from server
								changePreloadServerInfoBlock(cssPopupLink, "parse");
							}
						} else {
							//no connection/any errors
							if (result == "NO_CONNECTION") {
								changePreloadServerInfoBlock(cssPopupLink, "connect");
							}
							//timeout loading
							if (result == "REQUEST_TIMEOUT") {
								changePreloadServerInfoBlock(cssPopupLink, "timeout");
							}
							//no success load or no content in result
							if (result == "NO_SUCCESS_LOAD" || !result) {
								changePreloadServerInfoBlock(cssPopupLink, "load");
							}

							//set current status to temp var
							loadMarketErrorStatus = result;

							if (maskedIVE && maskedIVE.settings.marketSubscriptionService) {
								callback();
							}
						}
					});
				} else {
					//recreate content with temp json from server (special if switched package to bind within)
					generateMarket(serverTempMarketplaceJSON, cssPopupLink);
				}
				break;
		}
		return true;
	} catch (e) {
		createMessage("Error Market", "Can't load market: " + e.toString(), "error", true);
	}
}

function authBeforeStartInit() {
	if (maskedIVE.settings.authWithSitePassword) {
		$(".personalizedMarketLogin input[name='token']").attr("placeholder", "Password");
		$(".personalizedMarketLogin p.desc").html("Please login to continue");
		$(".personalizedMarketLogin .btn.cancel").hide();
		$(".personalizedMarketLogin .hlink[data-href='help_auth_data']").html("New here? Create free account!");

		// New here? Create free account
	}

	changeShowHideBlurred(true, ".personalizedMarketLogin", 3);
}

//#endregion

//#region PACKAGE MANAGER

function prepareAndInsertListKeysPackageSorting(listName, objectList) {
	var html = "";
	for (var key in objectList) {
		html += '<div class="sorting-dropdown-item" data-value="' + key + '">' + objectList[key] + "</div>";
	}
	$(".packageManager .sortingSelector[data-type='" + listName + "'] .sorting-dropdown-list").html(html);
}

function packageManagerPanelInputs() {
	var sortingByFavoritesPacks = editLocalPSets(false, "packSortFavorited");
	var sortingByNames = editLocalPSets(false, "packSortByNames");
	var sortingByApp = editLocalPSets(false, "packSortApp");

	var sortListNames = {
		0: "Default",
		1: "Name: A-Z",
		2: "Name: Z-A"
	};
	var sortListApps = {
		none: "Any App",
		current: "Current App",
		AE: "After Effects",
		PR: "Premiere Pro"
	};

	prepareAndInsertListKeysPackageSorting("packSortByNames", sortListNames);
	prepareAndInsertListKeysPackageSorting("packSortApp", sortListApps);

	UIPackSortSelecting("packSortFavorited", sortingByFavoritesPacks == 0);
	UIPackSortSelecting("packSortByNames", sortingByNames == 0, sortListNames[sortingByNames]);
	UIPackSortSelecting("packSortApp", sortingByApp == "none", sortListApps[sortingByApp]);
}

function UIPackSortSelecting(type, isDefault, text_value) {
	var select = $(".sortingSelector[data-type='" + type + "']");
	if (select) {
		if (!isDefault) {
			select.addClass("active");
		} else {
			select.removeClass("active");
		}
		if (type != "packSortFavorited") {
			select.find(".sorting-dropdown-header").text(text_value);
		}
	}
}

/**
 * Create HTML package manager from pack.list object
 * @param {object} jsonOBJ Pack List object from JSX
 */
function packageManagerBuilder(jsonOBJ, packIsLoad) {
	var toHTML = "";

	//if test mode is active - plug
	if (checkIsActiveTestMode) {
		toHTML =
			"<div class='no_packages'><div class='boxLogo testModeActive'></div><h4 class='ye'>You cannot use manager</h4><p>when test mode is active</p></div>";
		$(".packageManager .content .ulContent").html(toHTML);
		return false;
	}

	if (jsonOBJ.length > 0) {
		var clonePackages = {};
		var compatibleBundleData = {};
		var splitCharsComp = [":", "|"];
		var getCurShortAppID = getCurSoftShortID();
		var sortingByFavoritesPacks = editLocalPSets(false, "packSortFavorited");
		var sortingByNames = editLocalPSets(false, "packSortByNames");
		var sortingByApp = editLocalPSets(false, "packSortApp");

		// var isSubscriptionMarketModel = false;
		// /* Check extension by subscription system */
		// if (maskedIVE.settings.marketSubscriptionService) {
		//     isSubscriptionMarketModel = true;
		// }

		//collect to compatible object (collect all same names but with other appID)
		for (var i = 0; i < jsonOBJ.length; i++) {
			var item = jsonOBJ[i];
			if (item) {
				//create clone obj with packages (removed same pack names, but set as main action to cur appID)
				if (clonePackages[item.name]) {
					//if found, check cur app id, if equal add new item with same pack name
					var tempItem = item;

					if (clonePackages[item.name]["item"].load || tempItem.load) {
						tempItem.load = getCurShortAppID;
					}

					clonePackages[item.name] = {
						item: tempItem,
						multipleVersions: true
					};
				} else {
					//if not found item name in clone packs = add
					clonePackages[item.name] = {
						item: item,
						multipleVersions: false
					};
				}

				//if can be is load

				//create compatibles object (appIDs)
				if (compatibleBundleData[item.name]) {
					compatibleBundleData[item.name] += item.appID + splitCharsComp[0] + item.appVersion + splitCharsComp[1];
				} else {
					compatibleBundleData[item.name] = item.appID + splitCharsComp[0] + item.appVersion + splitCharsComp[1];
				}
			}
		}

		if (sortingByNames > 0) {
			var sortedPackages = {};
			var keys = Object.keys(clonePackages);

			// Sort keys first
			for (var i = 0; i < keys.length; i++) {
				for (var j = 0; j < keys.length - 1; j++) {
					var shouldSwap =
						sortingByNames == 1 ? keys[j].toLowerCase() > keys[j + 1].toLowerCase() : keys[j].toLowerCase() < keys[j + 1].toLowerCase();

					if (shouldSwap) {
						var temp = keys[j];
						keys[j] = keys[j + 1];
						keys[j + 1] = temp;
					}
				}
			}

			// Build new object in sorted order
			for (var i = 0; i < keys.length; i++) {
				sortedPackages[keys[i]] = clonePackages[keys[i]];
			}

			clonePackages = sortedPackages;
		}

		var packSortShown = 0;
		//search in clone packages
		for (key in clonePackages) {
			if (clonePackages.hasOwnProperty(key)) {
				var curClone = clonePackages[key];
				var item = curClone["item"];
				var itemHasMultipleVersions = curClone["multipleVersions"];

				var isCurrentPackHTML = ["", ""];
				if (item["load"]) {
					if (packIsLoad.name == item.name) {
						if (packIsLoad.appID == item.appID) {
							//set by appID
							isCurrentPackHTML = ['class="currentPack"', '<div class="statusLine"></div>'];
						}
						if (itemHasMultipleVersions) {
							isCurrentPackHTML = ['class="currentPack"', '<div class="statusLine"></div>'];
						}
					}
				}

				if (sortingByFavoritesPacks) {
					if (!item["favorited"]) {
						continue;
					}
				}

				if (sortingByApp && sortingByApp != "none") {
					if (sortingByApp == "current") {
						if (item["appID"] != getCurShortAppID) {
							continue;
						}
					} else if (item["appID"] != sortingByApp) {
						continue;
					}
				}

				var packageTitle = item["name"];
				//set custom package name if exists
				if (item["c_name"]) {
					packageTitle = item["c_name"];
				}
				var packBySubs = "";
				//Package by subscription label
				if (item.abs) {
					packBySubs =
						'<div class="iconManagerSubs" style="padding-right:0px;" tooltip="Only by subscription" tooltip-position="right" tooltip-type="pack_manager"><div class="gi min subscription"></div></div>';
				}

				var packFavorited = "";
				if (item.favorited) {
					packFavorited = "active";
				}

				toHTML +=
					"<li style='position:relative' " +
					isCurrentPackHTML[0] +
					' data-name="' +
					item["name"] +
					'" data-author="' +
					item["author"] +
					'" data-appid="' +
					item["appID"] +
					'" data-appversion="' +
					item["appVersion"] +
					'">' +
					isCurrentPackHTML[1] +
					'<div class="packDetails">' +
					'<div class="favoritePackage ' +
					packFavorited +
					'" title="Favorite"></div>' +
					'<div class="info_sector" data-author="' +
					item["author"] +
					'">' +
					'<div class="name">' +
					packageTitle +
					"</div>" +
					'<div class="author">by <strong>' +
					item["author"] +
					"</strong>" +
					packBySubs +
					"</div>" +
					"</div>" + //info_sector
					'<div class="icons_sector">';

				//compatibles
				for (var i = 0; compatibleBundleData[item.name].split(splitCharsComp[1])[i]; i++) {
					var compatibleData = compatibleBundleData[item.name].split(splitCharsComp[1])[i];
					var appID = compatibleData.split(splitCharsComp[0])[0].toString().toUpperCase();
					var appVersion = compatibleData.split(splitCharsComp[0])[1];
					appVersion = softAssetsByAppID[appID]["name"] + " " + appVersion;

					toHTML += '<div class="gi min ' + appID + '" tooltip="' + appVersion + '" tooltip-position="left" tooltip-type="pack_manager"></div>';
				}

				toHTML +=
					"</div>" +
					"</div>" + //end packDetails
					'<div class="managerButtons">' +
					'<div class="left"><div class="btn apply" data-action="apply"><div class="i apply_pack"></div></div></div>' +
					'<div class="right"><div class="btn small_btns" data-action="remove"><div class="i remove_pack"></div></div>' +
					'<div class="btn small_btns" data-action="similar"><div class="i similar_pack"></div></div></div></div>' +
					"</li>";
			}
			packSortShown++;
		}

		var infoAboutShowMorePacks = "";
		var packLength = Object.keys(clonePackages).length;
		if (packLength != packSortShown) {
			infoAboutShowMorePacks =
				"<p class='filterHiddenNotify'><strong>" + Number(packLength - packSortShown) + " package(s)</strong> are hidden due to filters</p>";
		}

		if (!packSortShown) {
			toHTML +=
				"<div class='no_packages'><div class='boxLogo noOnePackDueFilters'></div><h4>No packages match the filters</h4><p>Please reset filters to display packages</p></div>";
		}
		$(".packageManager .content .ulContent").html("<ul>" + toHTML + infoAboutShowMorePacks + "</ul>");
	} else {
		toHTML =
			"<div class='no_packages'><div class='boxLogo'></div><h4>No installed packages</h4><p>Just drag and drop <br/>or <a data-way='install'>browse</a> to install</p></div>";
		$(".packageManager .content .ulContent").html(toHTML);
	}
}

//#endregion

//#region HELPFUL TIPS

function constantTip(type) {
	if (type == "COMP") {
		hideSystemMessage();
		changeShowHideBlurred(true, ".noActiveComp", 4);
	}

	if (type == "ACCESS_PR_MAC") {
		hideSystemMessage();
		changeShowHideBlurred(true, ".noAccessPPRO_mac", 4);
	}

	if (type == "ACCESS_PR_WIN") {
		hideSystemMessage();
		changeShowHideBlurred(true, ".noAccessPPRO_win", 4);
	}
}

//#endregion HELPFUL TIPS
