/*
 * @Author: aniom
 * @Date:   2020-04-15 05:27:03
 * @Last Modified by:   aniom
 * @Last Modified time: 2020-06-17 16:23:49
 */

//#region SPECIAL APPLYING/ADDING EVENTS PROCESSING

var applyCounting_oneTemplate = 0;
var applyCounting_diffTemplatesObject = {};

var addedToFavoriteCountingForSession = 0;

var cantApplyItemCounting = 0;

/**
 * Trigger when user successfully applied the item (AE/PR)
 */
function doApplyItem(itemName, itemGroup) {
  var getShortAppID = getCurSoftShortID();
  //if applied After Effects items
  if (getShortAppID == "AE" && currentPackEngineType == "_COMPOSER") {
    //add ticks when applied item
    applyCounting_oneTemplate++;
    //reset cant apply counter coz we successfully applied it
    cantApplyItemCounting = 0;

    //check: if user applied items from different templates
    //if no group info - add it
    if (!applyCounting_diffTemplatesObject[itemGroup]) {
      applyCounting_diffTemplatesObject[itemGroup] = true;
    }

    var applyCounting_diffTemplates = 0;
    for (var key in applyCounting_diffTemplatesObject) {
      if (applyCounting_diffTemplatesObject.hasOwnProperty(key)) {
        applyCounting_diffTemplates++;
      }
    }
    //if user applied one (or more items) from X templates / or added much more scenes from one template - do trigger
    //for notify about Remove Unused
    if (applyCounting_oneTemplate == 6 || applyCounting_diffTemplates == 5) {
      // 6 and 5
      tipUserNotifier("toolbar_ae_remove_unused");
    }

    //for notify about use Customizer
    // if(applyCounting_oneTemplate == 1){
    //     tipUserNotifier('check_customizer');
    // }
  }
}

/**
 * Trigger when user can't apply item (AE/PR) coz: Not selected composition
 * Will shown one time for sessions - but each refresh (without saving in memory)
 */
function cantApplyItem(errorCode, itemName, itemGroup) {
  var getShortAppID = getCurSoftShortID();
  //if applied After Effects items
  if (getShortAppID == "AE" /*  && currentPackEngineType == engines[2] */) {
    //no active composition
    if (errorCode == "COMP") {
      cantApplyItemCounting++;
      //first click
      if (cantApplyItemCounting == 1) {
        //run func only if user trying apply with error 2 times in 10 sec - after reset and again
        var timeleft = 10;
        var downloadTimer = setInterval(function () {
          if (timeleft <= 0) {
            cantApplyItemCounting = 0;
            clearInterval(downloadTimer);
          } else {
            if (cantApplyItemCounting == 2) {
              constantTip("COMP");
              cantApplyItemCounting = 0;
              clearInterval(downloadTimer);
            }
          }
          timeleft -= 1; //decreaming
        }, 1000);
      }
    }
  }
}

/**
 * Trigger when user added new favorite (any softs)
 */
function doAddedFavorite() {
  addedToFavoriteCountingForSession++;
  //if user added more 3 - show tip
  if (addedToFavoriteCountingForSession == 2) {
    tipUserNotifier("check_favorites");
  }
}

function uploadPhotoAnimatorImageToServer(imageFileObject) {
  var headers = {
    "X-Requested-With": "Atom_X",
    "User-Agent": "AniomExtension_Atom",
    // 'Content-Type': 'application/json'
  };

  var formData = new FormData();
  formData.append("initImage", imageFileObject);
  formData.append("pack", currentTempPackagePrefab.pack.name);
  formData.append("appid", currentTempPackagePrefab.pack.appID);
  formData.append("author", currentTempPackagePrefab.pack.author);
  formData.append("usp", currentTempPackagePrefab.pack.usp);

  var curXhrURI = `${mainApiURI}npa`;

  cHttpUploadPostAsync(
    curXhrURI,
    formData,
    headers,
    function (result, success) {
      if (success && result) {
        httpTempRequester["status"] = "SUCCESS";
      } else {
        //XHR results
        if (result == "NO_CONNECTION") {
          result = "NO_CONNECTION";
        }
        if (result == "REQUEST_TIMEOUT") {
          result = "TIMEOUT";
        } //timeout loading
        if (result == "NO_SUCCESS_LOAD" || !result) {
          result = "NO_SUCCESS_LOAD";
        } //set status if no results
        httpTempRequester["status"] = result;
      }
    }
  );
}

function inputPhotoAnimatorImage(fileObject) {
  var imgFileTypes = ["png", "jpg", "jpeg"];
  //file as object check (wrong if dnd from app)
  if (fileObject) {
    //size check - error if 0 (in archive)
    if (fileObject.size) {
      var sizeInKB = fileObject.size / 1000;
      if (sizeInKB <= 10000) {
        //less or == 10MB
        var imgName = fileObject.name.toString();

        var re = /(?:\.([^.]+))?$/;
        var get_file_format = re.exec(imgName)[1];
        var checkFiletype = imgFileTypes.indexOf(
          get_file_format.toString().toLowerCase()
        );
        if (checkFiletype >= 0) {
          var file_string_path = fileObject.path;
          var dndClass = $(".dragAndDropPhotoAnimator");
          var getThisImage = dndClass.parent().find(".dndShowImage img");
          dndClass.addClass("pickedBorderActive");

          getThisImage.attr("src", file_string_path);
          // dndClass.data('image-path', file_string_path);//set image path to dndClass

          dndClass
            .parent()
            .find("p")
            .eq(2)
            .text(
              imgName.length > 14
                ? imgName.substr(0, 14) + "..." + get_file_format
                : imgName
            );
          dndClass.parent().find(".buttonContent").removeClass("disabled");

          getThisImage[0].onload = function () {
            // document.getElementById(outImage).src = fr.result;
            var width = this.naturalWidth || this.width;
            var height = this.naturalHeight || this.height;

            var thumbPlateOriginal = $(
              `#photoAnimator .stepContent[data-view="selectResolution"] .thumbnailPlate li[data-pickplace="original"]`
            );
            //change paragraph
            thumbPlateOriginal
              .find("p:first")
              .html(`${width} <span>x</span> ${height}`);
            //change data-resolution
            thumbPlateOriginal.data("resolution", `${width}-${height}`);
          };
        } else {
          createMessage(
            "Wrong Type",
            "Choose image with filetype (JPG, JPEG, or PNG)",
            "error"
          );
        }
      } else {
        createMessage(
          "Image Size",
          "Choose image with max size less than 10 MB",
          "error"
        );
      }
    } else {
      createMessage(
        "Unzip Files",
        "Extract images files from archive",
        "error"
      );
    }
  } else {
    createMessage(
      "Wrong Object",
      "Choose local image files (JPG, JPEG, or PNG)",
      "error"
    );
  }
}

//#endregion SPECIAL APPLYING/ADDING EVENTS PROCESSING

//#region PACKPRINT PROTECTOR

/**
 * Create package print
 * Protect from recreate manually preferences file (to user can't copied pref to another computer and use)
 * @param {*} arrayParams Params to encrypt
 */
function packPrintHandler(arrayParams) {
  var createPrintLine = "";
  var encryotPrintLine = "";
  var te_chars = "mstxynopqrfghizauvjklwbcde";
  //join arr params in one line

  for (k = 0; k < arrayParams.length; k++) {
    createPrintLine += arrayParams[k].toString();
  }

  //add custom in print line
  createPrintLine += fsmodule.fileDirectory(
    csInterface.getSystemPath("myDocuments")
  );

  //create encrypt char pieces
  for (j = 0; j < createPrintLine.length; j++) {
    var part1 = createPrintLine.charCodeAt(j);
    var a = part1.toString().substring(0, 1) || 12;
    var b = part1.toString().substring(1, 2) || 8;
    var c = part1.toString().substring(2, 3) || 4;
    switch (j % 4) {
      case 0:
        encryotPrintLine += te_chars[b] + a + te_chars[c];
        break;
      case 1:
        encryotPrintLine += b + te_chars[c] + a;
        break;
      case 2:
        encryotPrintLine += c + b + te_chars[a];
        break;
    }
  }
  return encryotPrintLine;
}

//#endregion PACKAGE PROTECTOR

//#region PACKAGES (JSON EDITING)
// Work with packages (JSON Prefs)/install checks
// Package sample functions - handler @func handlerPackagePrefs
// For installation checks/get by/remove/setFavorites and etc...

/**
 * Get all packages as lists arr (json inside each) from gloval pref @var localPreferences
 * @return {array} Packages array
 */
function packageGetLists() {
  if (localPreferences["packages"]) {
    return localPreferences["packages"];
  }
}

/**
 * Check exists the package before installation
 * @param {string} name Pack name
 * @param {string} author Author Name
 * @param {string} appID AI/PS/AE and etc...
 * @param {number} version Pack Version
 * @param {string} path Pack file path from JS
 * @return {string} Error string / if no string - true and we can install package (in other func)
 */
function packageInstallCheck(name, author, appID, version, path) {
  var sendObj = {
    name: name,
    author: author,
    appID: appID,
    version: version,
    path: path,
  };
  return handlerPackagePrefs("installCheck", sendObj);
}

/**
 * Get package object by name
 * @param {string} name Pack name
 * @return {object} Get pack object if found
 */
function packageGetByName(name) {
  var sendObj = {
    name: name,
  };
  return handlerPackagePrefs("getByName", sendObj);
}

/**
 * Get package by name/author/appID
 * @param {string} name Pack name
 * @param {string} author Author Name
 * @param {string} appID AE/PS/AI...
 * @return {object} Get pack object if found
 */
function packageGetBy(name, author, appID) {
  var sendObj = {
    name: name,
    author: author,
    appID: appID,
  };
  return handlerPackagePrefs("getBy", sendObj);
}

/**
 * Get Is Load Package
 * @return {object} Get is current load='true' package prefab
 */
function packageGetIsLoad() {
  return handlerPackagePrefs("getIsLoad");
}

/**
 * Set new Is Load Package
 * @param {string} name Pack name
 * @param {string} author Author Name
 * @param {string} appID AE/PS/AI...
 * @return {false} Nothing return if true/or false
 */
function packageSetToLoad(name, author, appID) {
  var sendObj = {
    name: name,
    author: author,
    appID: appID,
  };
  return handlerPackagePrefs("setToLoad", sendObj);
}

/**
 * Set to change package (update pack data)
 * @param {string} name Pack name
 * @param {string} author Author name
 * @param {string} appID AE/PS/AI...
 * @param {object} changePackObject Object with which need to change {key: value, ...}
 * @return {object} Get changed pack object
 */
function packageChange(name, author, appID, changePackObject) {
  var sendObj = {
    name: name,
    author: author,
    appID: appID,
  };
  return handlerPackagePrefs("change", sendObj, changePackObject);
}

/**
 * Change package favorites (rewrite)
 * @param {object} packObject Pack object or object to find pack as default params: (name, author, appID)
 * @param {string} favorites New favorites from JS (as ITEMID1:ITEMID2...)
 * @return {false} Nothing return
 */
function packageControlFavorites(packObject, favorites) {
  var sendObj = {
    name: packObject["name"],
    author: packObject["author"],
    appID: packObject["appID"],
  };
  return handlerPackagePrefs("setFavorites", sendObj, favorites);
}

/**
 * Add new package by template to JSON preferences (unload all other packs when will added new by default load="true")
 * Also will saved to JSON pref file after actions
 * @param {string} name Pack name
 * @param {string} author Author name
 * @param {string} version Pack version
 * @param {string} path Full path to pack
 * @param {string} engine Pack engine (_COMPOSER/_TEXT_PRESETS/...)
 * @param {string} appID AE/PS/AE...
 * @param {string|number} appVersion AppID ver: CC18/CC19...
 * @param {string} customPackageName Custom package name
 * @param {string} purchaseCode Encrypted purchase code (to silent checks, another options)
 * @param {boolean} bySubscriptionOnly Available by subscription or simple package (gen hash to checks)
 * @param {string} setFavorites If set favorites like (ITEM1:ITEM2...)
 * @return {object} Current pack object by template with insert params
 */
function packageInsertNew(
  name,
  author,
  version,
  path,
  engine,
  appID,
  appVersion,
  customPackageName,
  purchaseCode,
  bySubscriptionOnly,
  setFavorites
) {
  setFavorites = setFavorites || "";
  var templateObj = {
    name: name,
    c_name: customPackageName, //custom package name option
    author: author,
    version: version,
    load: getCurSoftShortID(),
    path: path,
    engine: engine,
    appID: appID,
    appVersion: appVersion,
    favorites: setFavorites,
    packprint: packPrintHandler([name, author, version, engine, appID]),
    pcsc: encryptPurchaseCodeToSilenceChecks(purchaseCode), //save purchase code in b64, or user hash id for subscription model in b64 too
  };

  //Personlized Market and subscription market service
  //Add special hash to check pack by subscription or not
  if (maskedIVE && maskedIVE.settings.marketSubscriptionService) {
    templateObj["abs"] = Boolean(bySubscriptionOnly);
    templateObj["hbs"] = absHashMake(name, templateObj["abs"], author, appID);
  }

  handlerPackagePrefs("unloadAllPacks");
  var packArrPrefs = localPreferences["packages"];
  packArrPrefs.push(templateObj);
  //save new file
  if (savePrefJSON_File()) {
    return templateObj;
  }
}

/**
 * Just return example template of @func packageInsertNew
 * Used for TEST MODE
 * @param {string} name Pack name
 * @param {string} author Author name
 * @param {string} version Pack version
 * @param {string} path Full path to pack
 * @param {string} engine Pack engine (_COMPOSER/_TEXT_PRESETS/...)
 * @param {string} appID AE/PS/AE...
 * @param {string|number} appVersion AppID ver: CC18/CC19...
 * @param {string} customPackageName Custom package name
 * @param {string} purchaseCode Encrypted purchase code (to silent checks, another options)
 * @param {boolean} bySubscriptionOnly Available by subscription or simple package (gen hash to checks)
 * @param {string} setFavorites If set favorites like (ITEM1:ITEM2...)
 * @param {boolean} disableLoad If need disable load option, or will set current application short ID to load
 * @return {object} Current example pack object by template with insert params
 */
function packageTestPackage(
  name,
  author,
  version,
  path,
  engine,
  appID,
  appVersion,
  customPackageName,
  purchaseCode,
  bySubscriptionOnly,
  setFavorites,
  disableLoad
) {
  setFavorites = setFavorites || "";
  disableLoad = disableLoad ? "" : getCurSoftShortID();

  var templateObj = {
    name: name,
    c_name: customPackageName, //custom package name option
    author: author,
    version: version,
    load: disableLoad,
    path: path,
    engine: engine,
    appID: appID,
    appVersion: appVersion,
    favorites: setFavorites,
    packprint: packPrintHandler([name, author, version, engine, appID]),
    pcsc: encryptPurchaseCodeToSilenceChecks(purchaseCode), //save purchase code in b64
  };

  //Personlized Market and subscription market service
  //Add special hash to check pack by subscription or not
  if (maskedIVE && maskedIVE.settings.marketSubscriptionService) {
    templateObj["abs"] = Boolean(bySubscriptionOnly);
    templateObj["hbs"] = absHashMake(name, templateObj["abs"], author, appID);
  }

  return templateObj;
}

/**
 * Unload all packages (load="false")
 * @return {false} Nothing return
 */
function packageUnloadAll() {
  return handlerPackagePrefs("unloadAllPacks");
}

/**
 * Remove package from JSON prefs (temp and local) and return any other pack if exists
 * @param {object} packObject Full package object (or object with name/author/appID) to find pack
 * @return {object} If removed - return any previosly package object to load
 */
function packageRemove(packObject) {
  return handlerPackagePrefs("remove", packObject);
}

/**
 * Main Package Engine Handler (for sample pack functions)
 * @param {string} type installCheck/getByName/getBy/...
 * @param {object} is_obj Object datas to find/check
 * @param {object} set_obj Set new data if need
 * @return {false|object} Return pack object if ok/or null
 */
function handlerPackagePrefs(type, is_obj, set_obj) {
  //get pref files
  var packArrPrefs = localPreferences["packages"];
  var returnData;
  var returnSamePackObj;
  var demoVersionString = "DEMO";
  var checkNeedUpdateJSON = false;
  var cloneWhenRemoveArr = [];

  var samePackCompare = {};
  var getShortCurAppID = getCurSoftShortID();

  //Priority load (if same pack with diff appID)
  if (type == "getIsLoad" || type == "setToLoad" || type == "getBy") {
    for (var i = 0; i < packArrPrefs.length; i++) {
      var pack = packArrPrefs[i];

      if (!samePackCompare[pack["name"]]) {
        samePackCompare[pack["name"]] = [pack["appID"]];
      } else {
        samePackCompare[pack["name"]].push(pack["appID"]);
      }

      if (type == "setToLoad") {
        //unload other package
        if (pack["load"] == getShortCurAppID) {
          pack["load"] = "";
        }
      }
    }
  }

  var keepGoing = true;
  for (var i = 0; i < packArrPrefs.length; i++) {
    var pack = packArrPrefs[i];

    switch (type) {
      //check package before install (duplicates/versions/etc...)
      case "installCheck":
        //check by name/author/appID
        if (
          pack["name"] == is_obj["name"] &&
          pack["author"] == is_obj["author"] &&
          pack["appID"] == is_obj["appID"]
        ) {
          //Versions checks
          if (pack["version"] == is_obj["version"]) {
            returnData = "SAME_VERSION";
          }
          if (pack["version"] < is_obj["version"]) {
            returnData = "UPPER_VERSION";
          }
          if (pack["version"] > is_obj["version"]) {
            returnData = "LOWER_VERSION";
          }

          //Demo packages check
          if (
            pack["version"] != demoVersionString &&
            is_obj["version"] == demoVersionString
          ) {
            returnData = "DOWNGRADE_DEMO_PACK";
          }
          if (
            pack["version"] == demoVersionString &&
            is_obj["version"] != demoVersionString
          ) {
            returnData = "UPGRADE_DEMO_PACK";
          }

          //Package path (for custom load pack)
          if (pack["version"] == is_obj["version"]) {
            //if portable option is active and install pack with new path (only if old pack path not exists)
            if (
              editLocalPSets(false, "portablePackageInstallation") &&
              pack["path"] != is_obj["path"] &&
              !fsmodule.exists(pack["path"])
            ) {
              returnData = "REPLACE_PACK_PATH";
            }
            //allow replace pack path also if not exist pack in prefs path (for all install methods)
            if (!fsmodule.exists(pack["path"])) {
              returnData = "REPLACE_PACK_PATH";
            }
          }
          // if(pack['version'] == is_obj['version'] && editLocalPSets(false, "portablePackageInstallation") && pack['path'] != is_obj['path']){returnData = "REPLACE_PACK_PATH";}
          // //allow replace pack path also if not exist pack in prefs path
          // if(pack['version'] == is_obj['version'] && !fsmodule.exists(pack['path'])){returnData = "REPLACE_PACK_PATH";}
        }
        break;
      //get pack object by name (first item if same names for other softwares)
      case "getByName":
        if (pack["name"] == is_obj["name"]) {
          returnData = pack;
        }
        break;
      //get pack object by name/author/appID
      case "getBy":
        if (
          pack["name"] == is_obj["name"] &&
          pack["author"] == is_obj["author"]
        ) {
          //PRIORITY CURRENT APP
          //get package for current application ID (or any other if not found for current soft)
          if (pack["appID"] == getShortCurAppID) {
            returnData = pack;
          } else {
            returnSamePackObj = pack;
          }
        }

        break;
      //get loaded package (one)
      case "getIsLoad":
        /* REWORKED AtomX 3.1 */
        //set load priority by app (pack type app == current app)
        if (pack["load"]) {
          //if pack wants load for current app
          if (pack["load"] == getShortCurAppID) {
            //PRIORITY 1 - will loaded first found pack for conditions
            //pack with different applications (like duplicate pack by name, diff appID)
            if (samePackCompare[pack.name].length > 1) {
              //pack with current appID for application
              if (pack["appID"] == getShortCurAppID) {
                returnData = pack;
                keepGoing = false; //stop cycle coz found main pack with appID
              } else {
                //no pack for appID for current app - just load appID any last installed pack with same name
                returnSamePackObj = pack;
              }
            } else {
              //no difference app - it lone pack - just load (doesn't matter appID)
              returnData = pack;
              keepGoing = false;
            }
          } else {
            //NO PRIORITY - will loaded last pack from list by this conditions
            //just load any package even if not load for current application - just to view preview of elements
            //load by current appID (if packahes wrong load, but correct for current app by appID)
            if (pack["appID"] == getShortCurAppID) {
              returnData = pack;
            } else {
              //any package
              returnSamePackObj = pack;
            }
          }
        }
        break;
      //set package to load in next time (and save it) - unset other packages
      case "setToLoad":
        if (
          pack["name"] == is_obj["name"] &&
          pack["author"] == is_obj["author"]
        ) {
          //just set load (even for pack with different applications because getIsLoad give us right appID for current application)

          //multiple version apps

          if (samePackCompare[pack.name].length > 1) {
            if (pack["appID"] == getShortCurAppID) {
              pack["load"] = getShortCurAppID;
            } else {
              for (var m = 0; m < samePackCompare[pack.name].length; m++) {
                var appID_xc = samePackCompare[pack.name][m];
                if (pack.appID == appID_xc) {
                  pack["load"] = getShortCurAppID; //appID_xc;
                }
              }
            }
          } else {
            pack["load"] = getShortCurAppID;
          }

          checkNeedUpdateJSON = true;
        }

        break;
      //unload all packs
      case "unloadAllPacks":
        //unload only packs for this appID == packAppID
        if (pack["load"] == getShortCurAppID) {
          pack["load"] = "";
        }
        break;
      //change package information (and save it)
      case "change":
        if (
          pack["name"] == is_obj["name"] &&
          pack["author"] == is_obj["author"] &&
          pack["appID"] == is_obj["appID"]
        ) {
          //find in cycle and rewrite
          for (key in pack) {
            if (pack.hasOwnProperty(key)) {
              if (set_obj[key]) {
                pack[key] = set_obj[key];
              }
            }
          }
          returnData = pack;
          checkNeedUpdateJSON = true;
        }
        break;
      //set favorites to pack (without JSON save, coz save in other function)
      case "setFavorites":
        if (
          pack["name"] == is_obj["name"] &&
          pack["author"] == is_obj["author"] &&
          pack["appID"] == is_obj["appID"]
        ) {
          pack["favorites"] = set_obj;
        }
        break;
      //remove package (and save it)
      case "remove":
        if (
          pack["name"] == is_obj["name"] &&
          pack["author"] == is_obj["author"] &&
          pack["appID"] == is_obj["appID"]
        ) {
          checkNeedUpdateJSON = true;
        } else {
          if (pack) {
            //priority return pack by current app ID runs
            if (pack["appID"] == getShortCurAppID) {
              returnData = pack; //set return pack to load instead already removed package (priority pack same current application)
            } else {
              returnSamePackObj = pack; //set return any pack if not found by current app
            }

            //add packs to new arr to sort (without already removed package)
            cloneWhenRemoveArr.push(pack);

            //if pack file not found in list - skip
            if (!fsmodule.exists(pack.path)) {
              continue;
            }
          }
        }
        break;
    }

    if (!keepGoing) break; //end cycle outside switch via variable
  }

  //Special Priority load pack check - if not found packages to load for this app/load for other app
  //worked for: getIsLoad, remove
  if (!returnData) {
    returnData = returnSamePackObj || false;
  }

  //If need update file (new data saving)
  if (checkNeedUpdateJSON == true) {
    //when remove pack = reset packs
    if (type == "remove") {
      localPreferences["packages"] = cloneWhenRemoveArr;
    }
    savePrefJSON_File();
  }

  return returnData;
}

//#endregion

//#region PACKAGE CONTROL [SOURCE HANDLER]

/**
 * Module of Initialization the package [ASYNC]
 * Used when Installataion/Load App with pack/Switch package
 * Work with New and Old Atom
 * @param {string} pack_path String path pack from JS
 * @param {function(object|false, string)} initCallback Callback func (object, err)
 * @example
 * return {
 *  method: "JSON",
 *	full_content: newPackStructure,
 *	settings: newPackStructure["settings"],
 *	structure: newPackStructure["structure"],
 *	header_bytes: packNewEvalObj[1],
 *	pack_hash: packNewEvalObj[0]
 *  }
 */
function initPackage(pack_path, initCallback) {
  //file pack not found when init progress
  if (!fsmodule.exists(pack_path)) {
    return initCallback(false, "PACK_NOT_FOUND");
  }
  //read file async as binary encoding
  fsmodule._fs.readFile(
    pack_path,
    { encoding: "binary" },
    function (err, data) {
      if (err) return initCallback(false, "CANT_OPEN");

      var packContent = data;
      //if test mode
      //open checks as default JS/JSON code
      if (checkIsActiveTestMode) {
        //IN TEST MODE
        try {
          //check if trying test compiled package (old/new Atom)
          if (
            packContent.indexOf(pdGlobalSplitOne) != -1 ||
            packContent.indexOf(oldAtomFPiece) != -1
          ) {
            return initCallback(
              false,
              "CORRUPTED_TEST_PACK|Please use an uncompiled package"
            );
          }

          var parsedContents = JSON.parse(packContent);
          return initCallback({
            method: "JSON",
            full_content: parsedContents,
            settings: parsedContents["settings"],
            structure: parsedContents["structure"],
            header_bytes: "",
            pack_hash: "",
          });
        } catch (ex) {
          return initCallback(false, "CORRUPTED_TEST_PACK|" + ex.message);
        }
      } else {
        //FIND IN ENCRYPTED FILE PACKAGE
        //check find split info for Atom 3.0+
        if (packContent.indexOf(pdGlobalSplitOne) != -1) {
          //NEW PACKAGE TYPE(Atom 3.0+)
          //Core based on own system Base64 with custom keywords to decode

          var packNewEvalObj = PDRefractoring(packContent);
          try {
            var newPackStructure = JSON.parse(packNewEvalObj[2]);
            return initCallback({
              method: "JSON",
              full_content: newPackStructure,
              settings: newPackStructure["settings"],
              structure: newPackStructure["structure"],
              header_bytes: packNewEvalObj[1],
              pack_hash: packNewEvalObj[0],
            });
          } catch (ex) {
            return initCallback(false, "CORRUPTED_PACK");
          }
        } else if (packContent.indexOf(oldAtomFPiece) != -1) {
          //OLD PACKAGES TYPE (Before Atom 3.0)
          try {
            //create image header for old pack (coz can't return bytes in JSON)
            //SEND TO JSX Coz encrypted via JSXBIN
            csInterface.evalScript(
              "runPackageJSXBIN(" + JSON.stringify(pack_path) + ")",
              function (result) {
                if (result !== "undefined") {
                  try {
                    return initCallback(JSON.parse(result));
                  } catch (exi) {
                    systemDebuggerCommandLines.push(
                      "initPackage -> E-PACK CONTENT  [" + exi.message + "]"
                    );
                    return initCallback(false, result);
                  }
                }
              }
            );
          } catch (ex) {
            systemDebuggerCommandLines.push(
              "initPackage -> E-PACK INIT [" + ex.message + "]"
            );
            return initCallback(false, "UNKNOWN_ERROR");
          }
        } else {
          return initCallback(false, "CORRUPTED_PACK");
        }
      }
    }
  );
}

/**
 * Remove package from preferences (JSON)
 * 1) Get Pack prefab by Pack name and run func to remove package from JSON prefs
 * 2) Run any previosly package (if exists) and return pack obj
 * @param {*} pack Pack get data (name/author/appID)
 * @return {*} Pack prefab object or error string ID
 */
function removePackageHandler(pack) {
  setupProgressBar(true, "Removing");
  testMode(true); //Test Mode Off
  var packObj = packageGetBy(pack["name"], pack["author"], pack["appID"]);
  var nextLoadPackObj = packageRemove(packObj);
  if (nextLoadPackObj) {
    setupProgressBar(false);
    //clear temp xhr object (by defaault is empty, but when error installation - with data and need reset)
    installationTempXHRObject = {};

    if (
      packObj["abs"] &&
      maskedIVE &&
      maskedIVE.settings.marketSubscriptionService
    ) {
      if (tempLocalPersonalizedAuthSystemData["usid"]) {
        //No active subscription
        if (!tempLocalPersonalizedAuthSubscriptionStatus) {
          // return createMessage('No Subscription', '<a data-action="renew_subscription">Renew subscription</a> to use this package', 'info', true);
          packageSetToLoad(
            nextLoadPackObj["name"],
            nextLoadPackObj["author"],
            nextLoadPackObj["appID"]
          );
          return reloadExtensionPanel();
        }
      }
    }

    return runPackageHandler(true, nextLoadPackObj, true, "remove");
  } else {
    // return packResponseListFromEngine("REMOVE_LAST_PACKAGE");
    //if no more package - we deleted last pack, then reload the extension
    return reloadExtensionPanel();
  }

  //do check - do not delete package outside appData (for WIN/MAC)
  /*      csInterface.evalScript('deletePackageFiles('+JSON.stringify(packObj['path'])+')', function(result){
            if(result != 'undefined'){
                // if(result == "DELETED"){};
                //remove package from prefs (even if not deleted on disk)
                 var nextLoadPackObj = packageRemove(packObj);
                if(nextLoadPackObj){
                    setupProgressBar(false);
                    return runPackageHandler(true, nextLoadPackObj, true);
                }else{
                    return packResponseListFromEngine("REMOVE_LAST_PACKAGE");
                }
            }
        }); */
}

function packageMarketSubscriptionErrors(internet_status) {
  if (internet_status == "NO_CONNECTION") {
    createMessage(
      "No Connection",
      "Fix the internet to use this package",
      "error",
      true
    );
  }
  //timeout loading
  if (internet_status == "REQUEST_TIMEOUT") {
    createMessage("Timeout", "Please try again later", "error", true);
  }
  //no success load or no content in result
  if (internet_status == "NO_SUCCESS_LOAD" || !internet_status) {
    createMessage(
      "Unable to load",
      "No content due to server errors",
      "error",
      true
    );
  }
}

/**
 * Run package by pack object/or pack name from preferences
 * @param {boolean} checkIsPackObject If already object with full data/ or need find by name/author/appID
 * @param {string|object} pack String pack name or Pack prefab object
 * @param {boolean} setIsLoad Set to Load this pack in next time (inside current application)
 * @param {string} ref referal (where is run? Init/just run) will used also in func @exePackage
 */
function runPackageHandler(checkIsPackObject, pack, setIsLoad, ref) {
  if (ref != "init") {
    setupProgressBar(true, "Initializing", 50);
  }

  testMode(true); //Test Mode Off

  if (!ref) {
    ref = "run";
  } //if no ref (default run)

  var getPackLists = packageGetLists();
  //If not full data pack - get pack by name/author/appID
  if (!checkIsPackObject) {
    pack = packageGetBy(pack["name"], pack["author"], pack["appID"]);

    if(!checkSoftwareAttrsToRun(true, pack["appID"], pack["appVersion"])){
      return false;
    }

    // st_install["pack"]["software_id"], st_install["pack"]["software_version"]
  }

  //check if no pack/and pack list = 0
  if (!pack && getPackLists.length > 0) {
    return packResponseListFromEngine("PACK_PREF_NOT_FOUND");
  }

  //set vars
  var curPackPath = pack["path"];
  var curPackAuthor = pack["author"];
  var curPackAppID = pack["appID"];

  //init (open) package path
  initPackage(curPackPath, function (obj, err) {
    var initBRun = obj;
    //if ok when go next
    if (!err && typeof initBRun === "object") {
      //main package details
      var ips = initBRun.settings.main;

      //PACKPRINT PROTECTOR (should be before setLoad and any changes as main error - can't to load broken pack)

      //IN PACK FILE - packprint compare inside pack data with packprint created earlier (if pack settings after init not comparing with installed info - error)
      if (!ips["software_id"]) {
        ips["software_id"] = "AE";
      } //fixed for old AE packs set [IMPORTANT]
      if (
        packPrintHandler([
          ips["name"],
          ips["cc_author_username"],
          ips["version"],
          ips["engine_pack"],
          ips["software_id"],
        ]) != pack["packprint"]
      ) {
        if (ref == "init") {
          packageIsBrokenStyle();
        } //show broken style if errs - only when first init
        return packResponseListFromEngine("WRONG_PACKPRINT_FILE");
      }

      //IN PREFERENCES - packprint check pref file for comparing (if pack content in prefs was changed - error)
      if (
        packPrintHandler([
          pack["name"],
          pack["author"],
          pack["version"],
          pack["engine"],
          pack["appID"],
        ]) != pack["packprint"]
      ) {
        if (ref == "init") {
          packageIsBrokenStyle();
        } //show broken style if errs - only when first init
        return packResponseListFromEngine("WRONG_PACKPRINT_PREF");
      }

      //CHECK AUTH/SUBSCRIPTION - for personal extension by subscription
      if (maskedIVE && maskedIVE.settings.marketSubscriptionService) {
        //check HBS hash for every packages in personalized extension
        if (pack["hbs"]) {
          //Check package hash ABS
          if (
            !absHashChecking(
              pack["name"],
              pack["abs"],
              pack["author"],
              pack["appID"],
              pack["hbs"]
            )
          ) {
            if (ref == "init") {
              return packageIsNoSubscriptionStyle("WRONG_ABS_HASH");
            } else {
              return createMessage(
                "Wrong ABS Hash",
                "Reinstall the package to fix it.",
                "error",
                true
              );
            }
          }

          //Pack only by subscription
          if (pack["abs"]) {
            //has internet errors
            if (loadMarketErrorStatus) {
              if (ref == "init") {
                return packageIsNoSubscriptionStyle(loadMarketErrorStatus);
              } else {
                return packageMarketSubscriptionErrors(loadMarketErrorStatus);
              }
            } else {
              //success loaded market statuses
              if (tempLocalPersonalizedAuthSystemData["usid"]) {
                //Errors with this auth (disabled/wrong mac and etc...)
                if (tempLocalPersonalizedAuthSpecialErrorsOnStartup) {
                  if (ref == "init") {
                    return packageIsNoSubscriptionStyle("ISSUES");
                  } else {
                    return createMessage(
                      "Authorization issues",
                      '<a data-action=".personalizedMarketLogin" data-type="popup">Click</a> to see about the problem ',
                      "error",
                      true
                    );
                  }
                } else {
                  //No active subscription
                  if (!tempLocalPersonalizedAuthSubscriptionStatus) {
                    if (ref == "init") {
                      return packageIsNoSubscriptionStyle("NO_ACTIVE");
                    } else {
                      return createMessage(
                        "No Subscription",
                        '<a data-action="renew_subscription">Renew subscription</a> to use this package',
                        "info",
                        true
                      );
                    }
                  }
                }
              } else {
                if (ref == "init") {
                  return packageIsNoSubscriptionStyle("AUTH");
                } else {
                  return createMessage(
                    "Log In",
                    '<a data-action=".personalizedMarketLogin" data-type="popup">Log in</a> to use this package',
                    "info",
                    true
                  );
                }
              }
            }
          }
        } else {
          if (ref == "init") {
            return packageIsNoSubscriptionStyle("NO_ABS_HASH");
          } else {
            return createMessage(
              "No ABS Hash",
              "Reinstall the package to fix it.",
              "error",
              true
            );
          }
        }
      }

      //Load this pack in next time (deselect other)
      if (setIsLoad) {
        setupProgressBar(false); //stop any progress
        packageSetToLoad(pack["name"], curPackAuthor, curPackAppID);
      }
      var cbackObject = exeBackendRunner(
        pack,
        initBRun.settings.inside_option_sets,
        initBRun.structure,
        initBRun.settings.stylization,
        curPackPath
      );
      return exePackage(ref, cbackObject);
    } else {
      if (ref == "init") {
        packageIsBrokenStyle();
      } //show broken style if errs - only when first init
      return packResponseListFromEngine(err);
    }
  });
}

/**
 * Set temporary pack objects and return JSON stringiry to RUN package (use in RUN/INIT)
 * Created to was one func to return data in JS
 * @param {*} pObj currentPackObject
 * @param {*} pOpts st_install['insideOptions']
 * @param {*} pStruct st_install['structure']
 * @param {*} packStyle st_install['stylization']
 * @param {*} installedPPath installedPackagePath
 */
function exeBackendRunner(pObj, pOpts, pStruct, packStyle, installedPPath) {
  //Save temporary package objects (will used in progress work with pack)
  currentTempPackagePrefab = pObj; //save to temp prefab pack JSON
  currentTempPackageInsideOptionsSets = pOpts; //save to temp pack inside options sets Object

  //return it
  return {
    pack: pObj,
    structure: pStruct,
    assets: getParentPackageFolderWith(installedPPath),
    list: packageGetLists(),
    styles: getPackStylization(packStyle, installedPPath),
  };
}

//#endregion

function parsePackageFileFormat(filename, customFileType) {
  var re = /(?:\.([^.]+))?$/; //regexp to get format
  var get_file_format = re.exec(filename.toString())[1];
  var ptype = customFileType ? customFileType : mainPackageFiletype; //default like: atom
  if (get_file_format && get_file_format.toString().toLowerCase() == ptype) {
    return true;
  } else {
    return false;
  }
}

//#region INSTALLATION AND EXECUTABLE
/**
 * Main Package Installation (get only file object to check and install)
 * @param {object} file_object File Object JS to get path
 */
function packageInstallation(file_object) {
  var ptype = mainPackageFiletype; //default like: atom

  //file as object check (wrong if dnd from app)
  if (file_object) {
    //size check - error if 0 (in archive)
    if (file_object.size) {
      /* Updated */
      if (parsePackageFileFormat(file_object.name, ptype)) {
        installPackageFirstCheck(file_object.path);
      } else {
        createMessage(
          "Wrong Type",
          "Choose package file (*." + ptype + ")",
          "error"
        );
      }

      // var get_file_format = re.exec(file_object.name.toString())[1];
      // if (get_file_format && get_file_format.toString().toLowerCase() == ptype) {
      //     var file_string_path = file_object.path;
      //     //do install
      //     installPackageFirstCheck(file_string_path);
      // } else {
      //     createMessage('Wrong Type', "Choose package file (*." + ptype + ")", 'error');
      // }
    } else {
      createMessage(
        "Unzip Files",
        "Make sure to extract all files from the archive",
        "error"
      );
    }
  } else {
    createMessage(
      "The file path is too long",
      "Shorten the directory path and try again",
      "error"
    );
  }
}

/**
 * Main executing to packages (with object data) and generating package content (menu/content from pack prefab)
 * @param {string} msource Type mark for ExePack [init/install/run]
 * @param {object} pack_prefab Object package
 */
function exePackage(msource, pack_prefab) {
  installationTempXHRObject = {}; //clear temp xhr object (previous installation data)
  try {
    var cur_pref_pack = pack_prefab.pack;
    //set engine from pack to toolbar
    currentPackEngineType = cur_pref_pack.engine;
    currentPackShortAppID = cur_pref_pack.appID;
    //create arr from string favorites
    currentPackFavoritesObject = convertFavoritesStrToObj(
      cur_pref_pack.favorites
    );
    //create package manager HTML (if init - builder works by other methods and not need here)
    //msource params: init/install/run
    if (msource != "init") {
      packageManagerBuilder(pack_prefab.list, cur_pref_pack);
    }

    //save pack prefab to temporary variable
    currentTempPackagePrefab = pack_prefab;

    // exePackBindingJSX(); //send data into JSX engine to use apply/customize in Adobe's applications
    atomxCore.appTransfer.exePackBindingJSX();
    atomxCore.boot.throwBootLoader("Checks Load Pack Run"); //throw to array debug list

    previewPresaveInvoke = false;
    if (generatePackageContent("default", pack_prefab)) {
      packageHeaderSets(cur_pref_pack, pack_prefab.styles);

      //Reset popups / ready UI Sets after applied the package
      //close packageManager
      //remove special bg fill (blurring inside panel overlay)
      changeShowHideBlurred(false, ".packageManager", 2);

      if (maskedIVE.settings && maskedIVE.settings.marketAsPackageManager) {
        popupContentSwitcher();
      }

      //ready UI states (footer icons/changes preview/auto-play and etc...)
      readyUISettingsPackSwitched();

      //load market under package (personalized if exists)
      upServerContent("marketAndUpdater");
      /* Load tuts / show notify about assigned package */
      // if (maskedIVE && maskedIVE['settings']['videoTutorials'] == 'direct') {
      //     linkCore('link', 'video_tutorials');
      //     return false;
      // }
      upServerContent("vtuts");
    }
  } catch (e) {

    createMessage("Execute Error", "@exePackage->" + e.message, "error", true);
  }
}

//#endregion




function checkSoftwareAttrsToRun(isRunning, packSoftwareId, packSoftwareVersion){


      var msgType_sameSoft = isRunning ? 'REQUIRED_SAME_SOFTWARE_RUNNING' : 'REQUIRED_SAME_SOFTWARE';
      var msgType_updSoft = isRunning ? 'REQUIRE_UPDATED_SOFTWARE_RUNNING' : 'REQUIRE_UPDATED_SOFTWARE';
      var samePackAndSoftType = getCurSoftShortID() == packSoftwareId;
      var errSameSoftText = softAssetsByAppID[packSoftwareId]['name'] + " " + packSoftwareVersion;

      if(isInstallPackageSameAppOnly && !samePackAndSoftType){
          packResponseListFromEngine(msgType_sameSoft+"|"+errSameSoftText);
          return false;
      }

      // Same software check but lower version than we need to install
      if(samePackAndSoftType && !compareSoftwareVersion(packSoftwareVersion)){
        packResponseListFromEngine(msgType_updSoft+"|"+errSameSoftText);
        return false;
      }

      return true;
}

function checkExtVersionAttrsToRun(requiredExtVersion){

      if (checkIsNewerAppVersion(requiredExtVersion)) {
        packResponseListFromEngine("REQUIRE_UPDATES");
        return false;
      }

      return true;
}

//#region INSTALLATION PROCESSING [SOURCE HANDLER]

/**
 * Main installation for packages
 * Initial package before (to read and let first checks), and let's try pass to install checks
 * @param {string} file_path String file path from JS (.atom)
 * @param {string} by_subscription_with_user_hash Install this package without activation codes - by subscription
 * @return {*} Pack prefab object or string ID with error
 */
function installPackageFirstCheck(file_path, by_subscription_with_user_hash) {
  setupProgressBar(true, "Preparing", 20);
  //get init data

  initPackage(file_path, function (json_content, error) {
    if (error) {
      return packResponseListFromEngine(error);
    }

    var inits = json_content;

    //do check settings/structure if broken but pack is works
    if (!inits.settings) {
      return packResponseListFromEngine("NO_PACK_SETTINGS");
    }
    if (!inits.structure) {
      return packResponseListFromEngine("NO_PACK_STRUCTURE");
    }

    if (typeof inits === "object") {
      //variables

      //pack Details - now globally MAIN group for old and new packages
      var initMainSettings = inits.settings.main;
      //Check new create as new pack/or replace or need request code or not
      var upSetInsertNew = true,
        upSetPurchaseCheck = true;

      //reset old temp installation obj
      st_install = {};

      //general
      st_install["structure"] = inits.structure;
      st_install["headerBytes"] = inits.header_bytes;
      st_install["stylization"] = inits.settings.stylization;
      st_install["insideOptions"] = inits.settings.inside_option_sets;
      //pack path
      st_install["packFilePath"] = file_path;
      //pack main details
      st_install["pack"] = {
        name: initMainSettings.name,
        version: initMainSettings.version,
        required_app_version: initMainSettings.required_app_version || "1.0", //def 1.0 (for old packs - atom 1.0+)
        software_id: initMainSettings.software_id || "AE", //def AE (for old packs)
        software_version: initMainSettings.software_version || "CC17", //def CC17 (for old packs)
        engine_pack: initMainSettings.engine_pack || "_COMPOSER",
        inside_security: initMainSettings.inside_security,
        required_purchase_code: initMainSettings.required_purchase_code,
        cc_author_username: initMainSettings.cc_author_username,
        pack_hash: inits.pack_hash,
        custom_package_name:
          initMainSettings.custom_package_name ||
          "" /* New for Vcgmotion - Custom Package Name */,
        none_collect_email:
          initMainSettings.none_collect_email ||
          false /* New Option to do not collect email when activation (NeuronFx request) */,
      };

      //check assets files exists
      if (!getParentPackageFolderWith(file_path)) {
        return packResponseListFromEngine("ASSETS_NOT_FOUND");
      }

      // var packSoftwareLabel = softAssetsByAppID[st_install["pack"]["software_id"]]['name'];
      // var samePackAndSoftType = getCurSoftShortID() == st_install["pack"]["software_id"];
      // var errSameSoftText = packSoftwareLabel + " " + st_install["pack"]["software_version"];

      // //  Install pack only in same software (if trying in another version)
      // if(isInstallPackageSameAppOnly && !samePackAndSoftType){
      //     return packResponseListFromEngine("REQUIRED_SAME_SOFTWARE|"+errSameSoftText);
      // }

      // // Same software check but lower version than we need to install
      // if(samePackAndSoftType && !compareSoftwareVersion(st_install["pack"]["software_version"])){
      //   return packResponseListFromEngine("REQUIRE_UPDATED_SOFTWARE|"+errSameSoftText);
      // }


      if(!checkSoftwareAttrsToRun(false, st_install["pack"]["software_id"], st_install["pack"]["software_version"])){
        return false;
      }

      //check required version extension to install package (if required vers newest than current app - request updates to install pack)
      //ADDED IN V2.0 (from old Atom)
      //UPDATED IN V3.0.0 AtomX
      // if (checkIsNewerAppVersion(st_install["pack"]["required_app_version"])) {
      //   return packResponseListFromEngine("REQUIRE_UPDATES");
      // }

      if(!checkExtVersionAttrsToRun(st_install["pack"]["required_app_version"])){
        return false;
      }



      //MAIN HANDLER
      if (checkIsActiveTestMode) {
        var getCustomPackName = st_install["pack"]["custom_package_name"]
          ? st_install["pack"]["custom_package_name"]
          : "";
        // IF TEST MODE - RUN WITHOUT INSTALLATION
        var currentPackObject = packageTestPackage(
          st_install["pack"]["name"],
          st_install["pack"]["cc_author_username"],
          st_install["pack"]["version"],
          file_path,
          st_install["pack"]["engine_pack"],
          st_install["pack"]["software_id"],
          st_install["pack"]["software_version"],
          getCustomPackName
        );
        //show message only first time when activated test mode
        if (specialMemoryVariables["testModeFirstInit"] == true) {
          createMessage(
            "Working in test mode",
            "Make your package great!",
            "success"
          );
        } else {
          setupProgressBar(false, "_STOP");
        }

        changeShowHideBlurred(false, ".testModeWindow", 3); //hide test mode window popup

        var cbackObject = exeBackendRunner(
          currentPackObject,
          st_install["insideOptions"],
          st_install["structure"],
          st_install["stylization"],
          file_path
        );
        return exePackage("install", cbackObject);
      } else {
        // MAIN INSTALLATION

        //check hash stamp [Protection Module 1]
        //Will if Hash Stamp found - in next time (set permanently, disable pack if without hash stamp - it's old packs)
        if (st_install["pack"]["pack_hash"]) {
          if (
            stampHashRequest([
              st_install["pack"]["name"],
              st_install["pack"]["version"],
              st_install["pack"]["required_purchase_code"],
              st_install["pack"]["cc_author_username"],
            ]) != st_install["pack"]["pack_hash"]
          ) {
            return packResponseListFromEngine("WRONG_HASH_SIGNATURE");
          }
        }

        //collect to install check
        var installCheck = packageInstallCheck(
          st_install["pack"]["name"],
          st_install["pack"]["cc_author_username"],
          st_install["pack"]["software_id"],
          st_install["pack"]["version"],
          file_path
        );

        switch (installCheck) {
          case "SAME_VERSION":
            return packResponseListFromEngine("DUPLICATE");
            break;
          case "LOWER_VERSION":
            return packResponseListFromEngine("DUPLICATE_LOWER_VERSION");
            break;
          case "DOWNGRADE_DEMO_PACK":
            return packResponseListFromEngine("DOWNGRADE_DEMO_PACK");
            break;
          //without returns (let default install)
          case "UPGRADE_DEMO_PACK":
            upSetInsertNew = false;
            upSetPurchaseCheck = true;
            break;
          case "REPLACE_PACK_PATH":
            upSetInsertNew = false;
            upSetPurchaseCheck = false;
            break;
          case "UPPER_VERSION":
            upSetInsertNew = false;
            upSetPurchaseCheck = false;
            break;
        }

        //special check if user want update old package version without code to new version
        //request code for all versions before 3.0.0 (because new structure of system)
        if (
          installCheck == "UPPER_VERSION" &&
          checkIsNewerAppVersion(
            st_install["pack"]["required_app_version"],
            true,
            reqCodeUpperVersionFromExtVer
          )
        ) {
          //if req version lower than current app - trying update old package type (EVAL)
          upSetPurchaseCheck = true;
        }

        //add new data into sp install obj
        st_install["installCheck"] = installCheck;
        st_install["insertNew"] = upSetInsertNew;

        //LET'S PRE-INSTALL!

        //save JSON to global temp variable
        installationTempXHRObject = {
          premiumPack: st_install["pack"]["required_purchase_code"],
          reqACheck: upSetPurchaseCheck,
          name: st_install["pack"]["name"],
          author: st_install["pack"]["cc_author_username"],
          appID: st_install["pack"]["software_id"],
          pack_version: st_install["pack"]["version"],
          none_collect_email: st_install["pack"]["none_collect_email"],
        };

        /* None collect email - extra package option */
        if (st_install["pack"]["none_collect_email"]) {
          $('.verifyInstallationPack input[name="email"]').val("").hide();
          $(".verifyInstallationPack .subscribeNewsletter").hide();
          /* Uncheck the box */
          $(".verifyInstallationPack input[name='subscribeNewPackage']").prop(
            "checked",
            false
          );

          $(".verifyInstallationPack .desc").html(
            "Please enter Purchase Code to activate this package!"
          );
        } else {
          $('.verifyInstallationPack input[name="email"]').show();
          $(".verifyInstallationPack .subscribeNewsletter").show();
          $(".verifyInstallationPack .desc").html(
            "Please enter E-mail and Purchase Code to activate this package!"
          );
        }

        //reset vars for window activation
        var autoFillValues = editLocalPSets(false, "autofillValues");
        if (
          autoFillValues["email"] &&
          !st_install["pack"]["none_collect_email"]
        ) {
          $('.verifyInstallationPack input[name="email"]').val(
            autoFillValues["email"]
          );

          if (
            $(".verifyInstallationPack input[name='subscribeNewPackage']").is(
              ":checked"
            )
          ) {
            $(".verifyInstallationPack .subscribeNewsletter").hide();
          }
        }

        $('.verifyInstallationPack input[name="code"]').val(""); //reset input

        installationAntiFloodCounter = 0; //reset anti-flood
        clearInterval(installationAntiFloodTimerIntervalObj["interval"]); //clear auti-flood timer
        installationAntiFloodTimerIntervalObj["interval"] = null; //reset anti-floor interval
        infoMessageInActivationWindow(); //reset message and hide olds

        setupProgressBar(false, "_STOP"); //Stop progress for all (important stop for Premium pack to hide before verify window)

        //if install by subscription - don't need require the purchase code just go to install
        if (by_subscription_with_user_hash) {
          st_install["pack"]["abs"] = by_subscription_with_user_hash;
          installPackageStepFileSystem(); //continue installation
        } else {
          //if premium and required enter code param - show window to get purchase code
          if (
            installationTempXHRObject.premiumPack &&
            installationTempXHRObject.reqACheck
          ) {
            //stop progress bar and show window with input code
            changeShowHideBlurred(true, ".verifyInstallationPack", 3); //show popup window to enter code
          } else {
            //if without code - skip popup window step
            packageActivationServer(false, installationTempXHRObject);
          }
        }
      }
    } else {
      return packResponseListFromEngine(error);
    }
  });
}

/**
 * Finally step to install package - copy package and set data about installation to pref
 * @version 2 - added double comparing server results
 * @return {*} pack data to run
 */
function installPackageStepFileSystem(callbackedPackPath) {
  try {
    //first run without callbacked pack path
    if (!callbackedPackPath) {
      setupProgressBar(true, "Installation", 70, 5200);

      //Continue without copying for packs by subscription, not by subscription (because by subs already downloaded and inside appData)
      if (st_install["pack"]["abs"]) {
        installPackageStepFileSystem(st_install["packFilePath"]);
      } else {
        //Re-cheking server results
        //comparing server datas second time
        if (!specialComparingResultServer()) {
          toBreakPiratedPackageFile(
            st_install["packFilePath"],
            st_install["headerBytes"]
          ); //break package file - coz pirated
          return packResponseListFromEngine("CANT_OPEN");
        }

        //Use custom path for package (without copy to appData)
        if (editLocalPSets(false, "portablePackageInstallation")) {
          //without copy to appdata
          installPackageStepFileSystem(st_install["packFilePath"]); //Deep self
        } else {
          //copy to appdata
          var packFileType = "." + mainPackageFiletype; //default like: atom
          //Create(copy) folders for app templates (if exists)
          var folderTemplateAppName =
            softAssetsByAppID[st_install["pack"]["software_id"]]["folder"];
          var folderExtAppData = _globalPathObjects["atomDataFolder"]; //Extension AppData
          var folderAssetsName = _globalPathObjects["atomAssetsPath"]; //Assets Folder Name

          //prepare path for folder pack (also add appID in end of line via -)
          var genAppFolderPath = convertToSystemPath(
            folderExtAppData +
              "/" +
              st_install["pack"]["name"] +
              " - " +
              st_install["pack"]["software_id"]
          );
          //create folder for current pack (absolute path)
          fsmodule.checkOrCreateAbsolute(genAppFolderPath);

          //FILE PACK PATH
          var sourcePackFilePath = st_install["packFilePath"];
          var packFileDirectory = fsmodule.fileDirectory(sourcePackFilePath);

          var sendTransferObj = {
            source: {
              pack: convertToSystemPath(sourcePackFilePath),
              assets: convertToSystemPath(
                packFileDirectory + "/" + folderAssetsName
              ),
              templates: convertToSystemPath(
                packFileDirectory + "/" + folderTemplateAppName
              ),
            },
            target: {
              pack: convertToSystemPath(
                genAppFolderPath +
                  "/" +
                  st_install["pack"]["name"] +
                  packFileType
              ),
              assets: convertToSystemPath(
                genAppFolderPath + "/" + folderAssetsName
              ),
              templates: convertToSystemPath(
                genAppFolderPath + "/" + folderTemplateAppName
              ),
            },
          };

          //run jsx copying pack data
          csInterface.evalScript(
            "copyPackageToAppData(" + JSON.stringify(sendTransferObj) + ")",
            function (res) {
              if (res != "undefined") {
                return installPackageStepFileSystem(res);
              } else {
                return packResponseListFromEngine("COPIED_PACK_FAILED");
              }
            }
          );
        }
      }

      //callback return from @func copyPackageIntoAppData
    } else {
      //REPLACED_INTO_JSX

      var installedPackagePath = callbackedPackPath;
      var currentPackObject = null;

      var isPackBySubscription = st_install["pack"]["abs"]
        ? st_install["pack"]["abs"]
        : false;
      var getGatekeeperActivationCode = getActivationGatekeeper().code; //purchase code checks

      //If package by subscription
      if (isPackBySubscription) {
        getGatekeeperActivationCode = isPackBySubscription;
      } else {
        //ANTI-HACK HAVE FUN
        //Double server checking status
        if (!doubleServerCheckingStatus) {
          toBreakPiratedPackageFile(
            installedPackagePath,
            st_install["headerBytes"]
          ); //break package file - coz pirated
          return packResponseListFromEngine("COPIED_PACK_FAILED");
        }
      }

      // create header image from bytes if exists (only sync)
      if (st_install["headerBytes"]) {
        var headerImagePath = getPackHeaderPath(installedPackagePath);
        //for old JSXBIN Packs - do image via JSX
        if (st_install["headerBytes"] == "REPLACED_INTO_JSX") {
          //fixes for old packages - create image header inside JSX from temp memory bytes
          csInterface.evalScript(
            'createImageHeaderFromBytes("' + headerImagePath + '")'
          );
        } else {
          //new packs - create image via nodeJS
          fsmodule.writeImageBytesSync(
            headerImagePath,
            st_install["headerBytes"]
          );
        }
      }

      var getCustomPackName = st_install["pack"]["custom_package_name"]
        ? st_install["pack"]["custom_package_name"]
        : "";
      //insert package data into JSON (and save it, error if wrong)
      if (st_install["insertNew"]) {
        currentPackObject = packageInsertNew(
          st_install["pack"]["name"],
          st_install["pack"]["cc_author_username"],
          st_install["pack"]["version"],
          installedPackagePath,
          st_install["pack"]["engine_pack"],
          st_install["pack"]["software_id"],
          st_install["pack"]["software_version"],
          getCustomPackName,
          getGatekeeperActivationCode, //get purchase code from gatekeeper
          isPackBySubscription
        );
      } else {
        /* Work with current package - Upgrade Demo pack, upper version and etc... */
        //unload all (included by default only when adding new package func@packageInsertNew, but here need for upgrading) add manually
        packageUnloadAll();
        //change package data
        if (
          st_install["installCheck"] == "UPGRADE_DEMO_PACK" ||
          st_install["installCheck"] == "UPPER_VERSION"
        ) {
          var doPackPrint = packPrintHandler([
            st_install["pack"]["name"],
            st_install["pack"]["cc_author_username"],
            st_install["pack"]["version"],
            st_install["pack"]["engine_pack"],
            st_install["pack"]["software_id"],
          ]);

          currentPackObject = packageChange(
            st_install["pack"]["name"],
            st_install["pack"]["cc_author_username"],
            st_install["pack"]["software_id"],
            {
              path: installedPackagePath,
              version: st_install["pack"]["version"],
              appVersion: st_install["pack"]["software_version"],
              load: getCurSoftShortID(),
              packprint: doPackPrint,
              c_name: getCustomPackName,
            }
          );
        }

        if (st_install["installCheck"] == "REPLACE_PACK_PATH") {
          currentPackObject = packageChange(
            st_install["pack"]["name"],
            st_install["pack"]["cc_author_username"],
            st_install["pack"]["software_id"],
            {
              path: installedPackagePath,
              load: getCurSoftShortID(),
            }
          );
        }
      }
      //no obj returned when insert/changed
      if (!currentPackObject) {
        return packResponseListFromEngine("CANT_SAVE_PACK_PREFS");
      }

      //reset hidden double checking (comparing result response - code)
      resetParamsBeforeNextInstallation();

      //Hey! All cool!
      createMessage(
        "Successfully",
        "The package is installed. Enjoy!",
        "success"
      );
      var cbackObject = exeBackendRunner(
        currentPackObject,
        st_install["insideOptions"],
        st_install["structure"],
        st_install["stylization"],
        installedPackagePath
      );
      return exePackage("install", cbackObject);
    }
  } catch (ex) {
    return packResponseListFromEngine("SYS_ERROR|" + ex.message);
  }
}

//#region PACK BY SUBSCRIPTION

/**
 * Check Hash for subscription packages (only for personalized extension)
 * @param {*} packName
 * @param {*} abs
 * @param {*} appID
 * @param {*} usid
 * @param {*} currentHbs
 * @returns
 */
function absHashChecking(packName, abs, author, appID, currentHbs) {
  if (absHashMake(packName, abs, author, appID) == currentHbs) {
    return true;
  } else {
    return false;
  }
}

/**
 * Create Hash for Subscription packages (only for personalized extension)
 * @param {string} packName Pack name
 * @param {boolean} abs Available by subscription
 * @param {string} appID App ID: AE/PR/...
 * @param {string} usid User token if authed
 * @returns {string} Hash
 */
function absHashMake(packName, abs, author, appID) {
  var createPrintLine = "";
  var encryotPrintLine = "";
  var te_chars = "abcqkeoolsfc";

  createPrintLine += packName.toString();
  createPrintLine += author.toString();
  createPrintLine += abs ? abs.toString() : false;
  createPrintLine += appID ? appID.toString() : "AE";
  createPrintLine += fsmodule.fileDirectory(
    csInterface.getSystemPath("myDocuments")
  );

  //create encrypt char pieces
  for (j = 0; j < createPrintLine.length; j++) {
    var part1 = createPrintLine.charCodeAt(j);
    var a = part1.toString().substring(0, 1) || 12;
    var b = part1.toString().substring(1, 2) || 8;
    var c = part1.toString().substring(2, 3) || 4;
    switch (j % 4) {
      case 0:
        encryotPrintLine += te_chars[b] + a + te_chars[c];
        break;
      case 1:
        encryotPrintLine += b + te_chars[c] + a;
        break;
      case 2:
        encryotPrintLine += c + b + te_chars[a];
        break;
    }
  }
  return encryotPrintLine;
}

//#endregion

//#endregion

//#region PACK STYLIZATION

function getPackHeaderPath(pack_path) {
  return convertToSystemPath(
    fsmodule.fileDirectory(pack_path) +
      "/" +
      _globalFileNameObjects["headerFile"],
    true
  );
}

/**
 * Get OBJ with color/image data to transfer JS (for stylization - set header and color)
 * @param {string} cur_pack_stylization Pack obj key with stylization
 * @param {string|File} pack_path Pack path to get parent folder and header image
 * @return {object} Return color/image in obj to JS
 */
function getPackStylization(cur_pack_stylization, pack_path) {
  return {
    color: cur_pack_stylization ? cur_pack_stylization.header_color_hex : "", //HEX color like #ddd
    image:
      cur_pack_stylization && pack_path ? getPackHeaderPath(pack_path) : "", //Header image path use Unix def /
    extension_styles:
      cur_pack_stylization && cur_pack_stylization.extension_styles
        ? cur_pack_stylization.extension_styles
        : false,
  };
}

/**
 * Change extension header data after switch package (pack name/image/color)
 * @param {string} setPackName Pack name
 * @param {string} setAuthorName Author name
 * @param {string} setPackVersion Pack version
 * @param {object} setStylizationObj Object ['color', 'image'] data
 */
function packageHeaderSets(curPackagePrefs, setStylizationObj) {
  var packDetailsCSS = $("#header .packDetails");
  //set package name/author name/version to title header

  var setPackName = curPackagePrefs.name;
  var setAuthorName = curPackagePrefs.author;
  var setPackVersion = curPackagePrefs.version;

  //has custom package name from prefs of the pack
  if (curPackagePrefs.c_name) {
    setPackName = curPackagePrefs.c_name;
  }

  packDetailsCSS.find(".packName").text(setPackName);
  packDetailsCSS.find(".packAuthor strong").text(setAuthorName);
  packDetailsCSS.find(".togglePackInfo strong").text(setPackVersion);

  //set color/image header

  var sColor = setStylizationObj["color"] || "#1D1D1E"; //HEX
  var sImage = setStylizationObj["image"] || ""; //IMAGE PATH

  //set almost def logo placer if not found image, color too change
  if (
    !sImage ||
    sImage == "false" ||
    sImage == undefined ||
    !fsmodule.exists(sImage)
  ) {
    sColor = "#B71A65";
    sImage = "img/headers/if_not_image_header.png";
  }
  var numImgCache = Math.random();
  sImage = sImage + "?v=" + numImgCache;
  packDetailsCSS
    .parent()
    .css("background", 'url("' + sImage + '") no-repeat left center ' + sColor); //set new header image

  /* Personal Engines Sets - for Neuronfx at the moment */
  if (currentPackEngineType == "_PRESET_MANAGER") {
    if (setAuthorName != "Neuronfx" || setPackVersion == "DEMO") {
      $(
        '#tools div[data-engine="_PRESET_MANAGER"] .external_engine_image'
      ).show();
    } else {
      $(
        '#tools div[data-engine="_PRESET_MANAGER"] .external_engine_image'
      ).hide();
    }
  }
  // if(currentPackEngineType)
  // $('#tools .external_engine_image')

  //restore if run package after broken pack
  //show
  packDetailsCSS.show(); //show pack details (author/pack name)
  $(".splitBothResizer").show(); //show split menu/container

  //hide all pack info sectors
  $(".outsideWrapper .bsPackageSector").hide();

  /* Package Stylization outside masked system */
  if (setStylizationObj.extension_styles) {
    var stylesheets = [];
    if (setStylizationObj.extension_styles.menuMainColor) {
      var menuMainColor = setStylizationObj.extension_styles.menuMainColor;
      stylesheets.push(
        "#menu ul li.current{border-right-color:" + menuMainColor + ";}"
      );
      stylesheets.push(
        "#menu ul li.folder.active > .title sup, #menu ul li.used_demo{background:" +
          menuMainColor +
          "!important;}"
      );
      // stylesheets.push('#menu ul li.folder.active sup, #menu ul li.folder.active ul li.folder.active sup, #menu ul li.used_demo{background:' + menuMainColor + ';}');
      stylesheets.push(
        "#menu ul li.folder.active, #menu ul li.folder.last-active:hover{border-left-color:" +
          menuMainColor +
          ";}"
      );
    }

    if (setStylizationObj.extension_styles.packAuthorField) {
      stylesheets.push(
        "#header .packDetails .packAuthor{background:" +
          setStylizationObj.extension_styles.packAuthorField +
          ";}"
      );
    }

    if (stylesheets.length) {
      $("head").append(
        '<style data="ext_style_pack">' + stylesheets.join("") + "</style>"
      );
    }
  } else {
    $('style[data="ext_style_pack"]').remove();
  }

  //unwrap greyscale container to header
  if (packDetailsCSS.parent().hasClass("corruptedPackGreyFHeader")) {
    packDetailsCSS.parent().removeClass("corruptedPackGreyFHeader");
  }
}

/**
 * If package is corrupted/broken change design sets (header/content/menu)
 */
function packageIsBrokenStyle() {
  readyUISettingsState(); //load preferences (even pack not loaded) - as error
  //stylization
  var packDetailsCSS = $("#header .packDetails");
  //hide all pack info sectors
  $(".outsideWrapper .bsPackageSector").hide();

  var sColor = "#B71A65";
  var sImage = "img/headers/if_not_image_header.png";
  packDetailsCSS
    .parent()
    .css("background", 'url("' + sImage + '") no-repeat left center ' + sColor);

  //hide
  packDetailsCSS.hide(); //hide pack details (author/pack name)
  $(".splitBothResizer").hide(); //hide split menu/container

  //show brokenPackage area
  // $('.brokenPackage').show();

  //clear menu/content space
  $("#container #menu").html("");
  // $("#container #content").html("");

  items.viewReset();

  //wrap greyscale container to header
  // packDetailsCSS.parent().wrap("<div class='corruptedPackGreyFHeader'></div>");

  packDetailsCSS.parent().addClass("corruptedPackGreyFHeader");

  $('.outsideWrapper .bsPackageSector[section="brokenPackage"]').show();
}

/**
 * If personal extension and package by subscription but no auth/no active subscription
 * @param {string} type Special type
 */
function packageIsNoSubscriptionStyle(type) {
  readyUISettingsState(); //load preferences (even pack not loaded) - as error
  //stylization
  var packDetailsCSS = $("#header .packDetails");
  //hide all pack info sectors
  $(".outsideWrapper .bsPackageSector").hide();

  var sColor = "#B71A65";
  var sImage = "img/headers/if_not_image_header.png";
  packDetailsCSS
    .parent()
    .css("background", 'url("' + sImage + '") no-repeat left center ' + sColor);

  //hide
  packDetailsCSS.hide(); //hide pack details (author/pack name)
  $(".splitBothResizer").hide(); //hide split menu/container

  //show brokenPackage area
  // $('.brokenPackage').show();

  //clear menu/content space
  $("#container #menu").html("");
  // $("#container #content").html("");

  items.viewReset();

  //wrap greyscale container to header
  // packDetailsCSS.parent().wrap("<div class='corruptedPackGreyFHeader'></div>");
  packDetailsCSS.parent().addClass("corruptedPackGreyFHeader");

  var sectionHtml = "";

  switch (type) {
    case "AUTH":
      sectionHtml =
        '<p>Please log in</p>\
            <p>This package by subscription</p>\
            <p>for authorized users only</p>\
            <div class="subscriptionPack"></div>\
            <div class="btn" data-action="login">Log in here</div>';
      break;
    case "NO_ACTIVE":
      sectionHtml =
        '<p>No Subscription</p>\
            <p>Your subscription has expired</p>\
            <p>Renew to use this package</p>\
            <div class="subscriptionPack r"></div>\
            <div class="btn" data-action="renew">Renew</div>';
      break;
    case "NO_CONNECTION":
      sectionHtml =
        '<p>No Connection</p>\
            <p>Fix the internet</p>\
            <p>to use this package</p>\
            <div class="ci onMain warning"></div>\
            <div class="btn" data-action="refresh">Refresh</div>';
      break;
    case "REQUEST_TIMEOUT":
      sectionHtml =
        '<p>Timeout</p>\
            <p>Please try again later</p>\
            <p>or reload the extension</p>\
            <div class="ci onMain timeout"></div>\
            <div class="btn" data-action="refresh">Refresh</div>';
      break;
    case "NO_SUCCESS_LOAD":
      sectionHtml =
        '<p>No Response</p>\
            <p>The server is temporarily</p>\
            <p>unresponsive</p>\
            <div class="ci onMain blocked"></div>\
            <div class="btn" data-action="refresh">Refresh</div>';
      break;
    case "WRONG_ABS_HASH":
      sectionHtml =
        '<p>Invalid ABS Hash</p>\
            <p>Please reinstall</p>\
            <p>this package</p>\
            <div class="ci onMain hash"></div>';
      break;
    case "NO_ABS_HASH":
      sectionHtml =
        '<p>No ABS Hash</p>\
            <p>Please reinstall</p>\
            <p>this package</p>\
            <div class="ci onMain hash"></div>';
      break;
    case "ISSUES":
      sectionHtml =
        '<p>Auth Problems</p>\
            <p>Problems with</p>\
            <p>authorization</p>\
            <div class="ci onMain warning"></div>\
            <div class="btn" data-action="login">See in profile</div>';
      break;
  }
  $(
    '.outsideWrapper .bsPackageSector[section="subscriptionContent"] .place'
  ).html(sectionHtml);
  $('.outsideWrapper .bsPackageSector[section="subscriptionContent"]').show();
}

/**
 * If no package - first start the extension (change design sets)
 */
function packageNoFirstExtRun() {
  readyUISettingsState(); //load preferences (even pack not loaded) - as error

  //stylization
  var packDetailsCSS = $("#header .packDetails");

  //hide
  packDetailsCSS.hide(); //hide pack details (author/pack name)
  $(".splitBothResizer").hide(); //hide split menu/container

  //remove only menu
  $("#container #menu").html("");
}

//#endregion

//#region VERIFICATION

/**
 * Change text in msg (verify window) for premium packages
 * @param {string} message Text
 * @param {boolean} isWaiting Set opacity blink to text with yellow color
 */
function infoMessageInActivationWindow(message, isWaiting, customClass) {
  customClass = customClass ? customClass : "verifyInstallationPack";
  var jq = $("." + customClass + " .msg");

  if (isWaiting) {
    jq.addClass("waiting");
  } else {
    jq.removeClass("waiting");
  }
  if (message) {
    //if not hidden - hide with slideUp
    if (!jq.is(":hidden")) {
      jq.stop().slideUp();
    }
    if (isWaiting) {
      //show without animate
      jq.html(message).stop(true, true).show();
    } else {
      jq.html(message).stop(true, true).slideDown();
    }
  } else {
    jq.hide();
  }
}

/**
 * Request to server JSON data and get response with status - activate or no with error code
 * @param {boolean} premium Package type
 * @param {*} obj_string object with params (name/author/appID) package (also for premium included - code)
 * @version 2 - main point was hacked (just replaced "code" input and remove if checks)
 * @version 3 - Added finger print data (mac/os and etc), this info saved in pack to check in silent mode and etc...
 */
function packageActivationServer(premium, obj_string) {
  try {
    //check do exists install temp data before send it to server
    if (!installationTempXHRObject["name"]) {
      return verifyPackResponseList("NO_TEMP_XHR", premium);
    }

    //additional analytics info about user
    var setAdditionalInfo = {
      ext_version: `${extensionAppVersion}x${extensionRevisionInfo}`,
      pack_version: obj_string["pack_version"],
      soft_app: getCurSoftShortID(),
      soft_version: init_sets["appVersion"],
      soft_locale: init_sets["appLocale"],
    };

    //global obj content
    var postJSON = {
      name: obj_string["name"],
      author: obj_string["author"],
      appid: obj_string["appID"],
      usp: getUserSystemPrint(), //new (finger print - mac/os name/os/other details) from AtomX 3.1+
      minfo: JSON.stringify(setAdditionalInfo), //new additional data about software/ext version from AtomX 3.1+
    };

    if (premium) {
      postJSON["code"] = obj_string["code"];
      postJSON["email"] = obj_string["email"];
      postJSON["subscribe_newsletter"] = Number(
        obj_string["subscribe_newsletter"]
      );

      //animate msg for waiting response from server
      infoMessageInActivationWindow("Validation...", true);
    } else {
      postJSON["pack_version"] = obj_string["pack_version"];
      postJSON["app_version"] = extensionAppVersion;
      setupProgressBar(true, "Validation", 50);
    }

    var headers = {
      "X-Requested-With": "Atom_X",
      "User-Agent": "AniomExtension_Atom",
      "Content-Type": "application/json",
    };
    var curXhrURI =
      mainApiURI + "verification?method=" + (premium ? "premium" : "free");

    cHttpPostAsync(
      curXhrURI,
      JSON.stringify(postJSON),
      headers,
      function (result, success) {
        if (success && result) {
          try {
            var parseSData = JSON.parse(result);
            if (parseSData["check"] == true) {
              //fast stop progress for Validation - if not premium
              if (!premium) {
                setupProgressBar(false, "_STOP");
              }
              //hide verify window
              changeShowHideBlurred(false, ".verifyInstallationPack", 3);

              //activation verify response status and code (have fun for hackers - little bit obfus)
              setActivationGatekeeper(postJSON["code"], parseSData, result);

              /* Update saved email - if have email input */
              if (obj_string["email"]) {
                editLocalPSets(true, "autofillValues", {
                  email: obj_string["email"],
                });
              }

              //if all okay - processing installation
              //ask installation method if need
              if (editLocalPSets(false, "askInstallationMethodEachTime") == 1) {
                //show ask window (choose installation method and continue)
                changeShowHideBlurred(true, ".chooseInstallationMethod", 2);
              } else {
                installPackageStepFileSystem(); //continue installation
              }
            } else {
              return verifyPackResponseList(parseSData["code"], premium);
            }
          } catch (ex) {
            return verifyPackResponseList(parseSData["code"], premium);
          }
        } else {
          //XHR results
          if (result == "NO_CONNECTION") {
            result = "NO_CONNECTION";
          }
          if (result == "REQUEST_TIMEOUT") {
            result = "TIMEOUT";
          } //timeout loading
          if (result == "NO_SUCCESS_LOAD" || !result) {
            result = "NO_SUCCESS_LOAD";
          } //set status if no results
          return verifyPackResponseList(result, premium);
        }
      }
    );
  } catch (error) {
    return verifyPackResponseList("WRONG_WITH_PARAMS", premium);
  }
}

/**
 * Show msg when response server for both type (Jus text to premium popup, or full systemMessage for demo packages)
 * @param {*} result to compare with switch list (catch error)
 * @param {*} verifyWindowActive Show text in activation popup / or full message
 */
function verifyPackResponseList(result, verifyWindowActive) {
  var _msg = {};
  switch (result) {
    //ANY
    case "WRONG_WITH_PARAMS":
      _msg = preMsgHelper(
        "Unknown Error",
        "Something wrong with parameters",
        "error"
      );
      break;
    //XHR CONNECT
    case "NO_TEMP_XHR":
      _msg = preMsgHelper("No Data", "No Temp XHR Request Data", "error");
      break;
    case "NO_SUCCESS_LOAD":
      _msg = preMsgHelper(
        "Unable to Load",
        "Unable to load server response!",
        "error"
      );
      break;
    case "NO_CONNECTION":
      _msg = preMsgHelper(
        "Connection Failure",
        "Fix connection and try again!",
        "error"
      );
      break;
    case "TIMEOUT":
      _msg = preMsgHelper(
        "Timeout",
        "Too long no response, try later",
        "error"
      );
    //FROM SERVER
    case "DEPRECATED_CODE":
      _msg = preMsgHelper(
        "Deprecated Code",
        "Validity of the code has expired!",
        "error"
      );
      break;
    case "INVALID_CODE":
      _msg = preMsgHelper("Invalid Code", "Invalid purchase code!", "error");
      break;
    case "FAILED_QUERY_API":
      _msg = preMsgHelper("Api Failed", "Failed to query API!", "error");
      break;
    case "ERROR_VALIDATE":
      _msg = preMsgHelper(
        "Validation Error",
        "Write to support and try again later",
        "error"
      );
      break;
    case "SUCCESS_FOR_OTHER_ITEM":
      _msg = preMsgHelper(
        "Almost Successful",
        "Code is valid, but for other package",
        "info"
      );
      break;
    case "DB_CONNECT_FAILED":
      _msg = preMsgHelper(
        "Server Failure",
        "Server failure, write in support",
        "error"
      );
      break;
    case "NO_PACKAGE":
      _msg = preMsgHelper(
        "Unknown Package",
        "This package is not identified on server",
        "info"
      );
      break;
    case "CODE_BANNED":
      _msg = preMsgHelper(
        "Code Banned",
        "This purchase code was banned",
        "error"
      );
      break;
    case "PACKAGE_NO_SERVICED":
      _msg = preMsgHelper(
        "Unable to Install",
        "This package is disabled or not activated",
        "error"
      );
      break;
    case "NO_LONGER_INSTALLED":
      _msg = preMsgHelper(
        "No Longer Installed",
        "You can no longer install this package",
        "error"
      );
      break;
    case "CANT_PARSE_CONTENT":
      _msg = preMsgHelper(
        "Wrong Response",
        "Cannot parse response, write to support",
        "error"
      );
      break;
  }

  if (_msg["title"] && _msg["body"]) {
    if (verifyWindowActive) {
      //show message in verify window (for premium packages)
      infoMessageInActivationWindow(_msg["body"]);
    } else {
      //show system message for non-premium package without verify window (messages stopped all progressBars)
      installationTempXHRObject = {}; //reset installation XHR OBJECT for free packages if error
      createMessage(
        _msg["title"],
        _msg["body"],
        _msg["type"],
        _msg["hold"],
        _msg["d_load"]
      );
    }
  }
}

//#endregion
