/*
 * @Author: aniom
 * @Date:   2020-05-10 19:24:29
 * @Last Modified by:   aniom
 * @Last Modified time: 2020-09-03 01:02:13
 */

atomxCore.personalizer = {
	lastOwnerAuthorName: false,
	isPersonalized: false,
	getAuthorName: function () {
		if (maskedIVE) {
			/* Personalized Extension */
			/* Set init author name */
			if (!this.lastOwnerAuthorName) {
				this.lastOwnerAuthorName = maskedIVE.author;
			}
			return maskedIVE.author;
		} else {
			/* Classic AtomX with active package */
			var loadedCPack = currentTempPackagePrefab ? currentTempPackagePrefab.pack : false;
			if (loadedCPack) {
				/* Set init author name */
				if (!this.lastOwnerAuthorName) {
					this.lastOwnerAuthorName = loadedCPack.author;
				}
				return loadedCPack.author;
			}
		}
	},
	/**
	 * Refresh market/etc when selected new package from another author
	 * @param {*} name
	 * @returns
	 */
	checkRefreshContent: function (name) {
		// var packAuthorName = this.getAuthorName();
		if (this.lastOwnerAuthorName != name) {
			this.lastOwnerAuthorName = name;
			tempLocalMarketGettingFromServer = {};
			return true;
		} else {
			this.lastOwnerAuthorName = name;
			return false;
		}
	},
	getPersonalizedAuthorName: function () {
		if (this.isPersonalized) {
			return this.lastOwnerAuthorName;
		} else {
			return false;
		}
	},
	setPersonalizedAuthorName: function (bool) {
		this.isPersonalized = bool;
	}
};

atomxCore.boot = {
	indexBootSection: 0,
	throwBootLoader: function (throw_message) {
		this.indexBootSection++;
		systemDebuggerBootLoader.push(this.indexBootSection + ": " + throw_message + ". Ok.");
	}
};

/**
 * Convert encoding from - to
 */
encoder.extras = {
	utf8_to_b64: function (str) {
		return window.btoa(unescape(encodeURIComponent(str)));
	},

	b64_to_utf8: function (base64str) {
		// If a base64 string contains any whitespace character, DOM Exception 5 occurs during window.atob, please see
		// http://stackoverflow.com/questions/14695988/dom-exception-5-invalid-character-error-on-valid-base64-image-string-in-javascri
		base64str = base64str.replace(/\s/g, "");
		return decodeURIComponent(escape(window.atob(base64str)));
	},

	binary_to_b64: function (binary) {
		return window.btoa(binary);
	},

	b64_to_binary: function (base64str) {
		return window.atob(base64str);
	},

	ascii_to_b64: function (ascii) {
		return window.btoa(ascii);
	},

	b64_to_ascii: function (base64str) {
		return window.atob(base64str);
	}
};

security = {
	encodeUserSystemServerPrint: function (defaultString) {
		defaultString = encoder.extras.utf8_to_b64(defaultString); //convert to b64
		var key1 = "SSBsb3ZlIHlvdQ==",
			key2 = "WkRDcmFja2Vy",
			key3 = "SGF2ZSBGVU4=";
		var part1 = defaultString.substring(0, 4);
		part1 += key1.substr(0, key1.length - 2);
		part1 += defaultString.substring(4, 7);
		part1 += key2.substr(0, key2.length);
		part1 += defaultString.substring(7, 12);
		part1 += key3.substr(0, key3.length - 1);
		part1 += defaultString.substring(12, defaultString.length);
		return part1;

		// alert(window.atob(part1.replace('SSBsb3ZlIHlvdQ', '').replace('WkRDcmFja2Vy', '').replace('SGF2ZSBGVU4', '')) + '\n' + window.atob(defaultString));
	}
};

//#region FILE SYSTEM FUNCTIONS

//Require and set in var nodeJS modules
fsmodule._fs = require("fs");
fsmodule._path = require("path");
fsmodule._os = require("os");
fsmodule._mac = require("macaddress");
fsmodule._promisify = require("util").promisify;
fsmodule._exec = fsmodule._promisify(require("child_process").exec);
fsmodule._gunzip = require("gunzip-file");
fsmodule._gzip = require("zlib").gzip;

fsmodule.systemInfo = {
	getAsyncData: function () {
		var splitUserDocumentPath = csInterface.getSystemPath(SystemPath.MY_DOCUMENTS).toString().split("/");
		var getUserNameFromDocPath = splitUserDocumentPath[splitUserDocumentPath.length - 2];
		fsmodule._mac.one(function (err, mac) {
			//set data to global var
			userUSPData = {
				mac: !err ? mac : "Error",
				user: getUserNameFromDocPath,
				os: csInterface.getOSInformation()
			};
		});
	}
};

/**
 * Get file directory
 * @param {*} path
 */
fsmodule.fileDirectory = function (path) {
	if (this.exists(path)) {
		return this._path.dirname(path);
	} else {
		return false;
	}
};

/**
 * Create folder sync [nodeJS _fs]
 * @param {string} path
 */
fsmodule.createFolder = function (path) {
	var result = this._fs.mkdirSync(path);
	if (result) {
		return true;
	} else {
		return false;
	}
};

/**
 * Recurse creating folder (or return path if exists)
 */
fsmodule.checkOrCreateAbsolute = function (path) {
	if (!this.exists(path)) {
		this.checkOrCreateAbsolute(this._path.join(path, ".."));
		this.createFolder(path);
	}
	return path;
};

/**
 * Write file async (overwrite) [nodeJS _fs]
 * @param {*} path
 * @param {*} content
 */
fsmodule.writeFileAsync = function (path, content, encoding) {
	encoding = encoding ? encoding : "utf8";
	this._fs.writeFile(path, content, encoding, function (err) {
		if (err) {
			return false;
		}
	});
};

/**
 * Write file sync (overwrite) [nodeJS _fs]
 * @param {*} path
 * @param {*} content
 */
fsmodule.writeFileSync = function (path, content, set_encoding) {
	this._fs.writeFileSync(path, content, { encoding: set_encoding ? set_encoding : "utf8" });
};

fsmodule.writeImageBytesSync = function (path, content) {
	this._fs.writeFileSync(path, content, { encoding: "binary" });
};

/**
 * Read file sync [nodeJS _fs]
 * @param {*} path
 */
fsmodule.readFile = function (path, set_encoding) {
	var result = this._fs.readFileSync(path, { encoding: set_encoding ? set_encoding : "utf8" });
	if (result) {
		return result;
	} else {
		return false;
	}
};

fsmodule.readDir = function (path) {
	return this._fs.readdirSync(path);
};

/**
 * Check exists folder/file sync [nodeJS _fs]
 * @param {*} path
 */
fsmodule.exists = function (path) {
	if (this._fs.existsSync(path)) {
		return true;
	} else {
		return false;
	}
};

fsmodule.fileSize = function (path) {
	var fileStats = this._fs.statSync(path);
	return fileStats.size;
};

fsmodule.removeAsync = function (path) {
	this._fs.unlink(path, function (err) {
		if (err) {
			return createMessage("Deletion Error", err.message, "error", true);
		}
		// alert(err);
	});
};

/**
 * Copy file sync for @func copyFolderRecursiveSync
 * @param {string} source
 * @param {string} target
 */
fsmodule.copyFileSync = function (source, target) {
	var targetFile = target;
	//if target is a directory a new file with the same name will be created
	if (this._fs.existsSync(target)) {
		if (this._fs.lstatSync(target).isDirectory()) {
			targetFile = this._path.join(target, this._path.basename(source));
		}
	}

	this._fs.writeFileSync(targetFile, this._fs.readFileSync(source));
	return target;
};

/**
 * Recursive copying folder and files inside (absolute)
 */
fsmodule.copyFolderRecursiveSync = function (source, target) {
	var files = [];

	//check if folder needs to be created or integrated
	var targetFolder = this._path.join(target, this._path.basename(source));

	if (!this._fs.existsSync(targetFolder)) {
		this._fs.mkdirSync(targetFolder);
	}

	//copy
	if (this._fs.lstatSync(source).isDirectory()) {
		files = this._fs.readdirSync(source);
		for (var i = 0; i < files.length; i++) {
			var curSource = this._path.join(source, files[i]);
			if (this._fs.lstatSync(curSource).isDirectory()) {
				this.copyFolderRecursiveSync(curSource, targetFolder);
			} else {
				this.copyFileSync(curSource, targetFolder);
			}
		}
	}
};

/**
 * Copy file sync for
 * @param {string} source
 * @param {string} target
 */
fsmodule.copyFile = function (source, target, callback) {
	var targetFile = target;
	//if target is a directory a new file with the same name will be created
	if (this._fs.existsSync(target)) {
		if (this._fs.lstatSync(target).isDirectory()) {
			targetFile = this._path.join(target, this._path.basename(source));
		}
	}

	this._fs.writeFile(targetFile, this._fs.readFileSync(source), callback);
};

/**
 * Recursive copying folder and files inside (absolute)
 */
fsmodule.copyFolderRecursive = function (source, target, callback) {
	var files = [];

	//check if folder needs to be created or integrated
	var targetFolder = this._path.join(target, this._path.basename(source));

	if (!this._fs.existsSync(targetFolder)) {
		this._fs.mkdir(targetFolder);
	}

	//copy
	if (this._fs.lstatSync(source).isDirectory()) {
		files = this._fs.readdirSync(source);
		for (var i = 0; i < files.length; i++) {
			var curSource = this._path.join(source, files[i]);
			if (this._fs.lstatSync(curSource).isDirectory()) {
				this.copyFolderRecursive(curSource, targetFolder, callback);
			} else {
				this.copyFile(curSource, targetFolder);
			}
		}
	}
};

//#endregion
