function checkAuthLogin(onLoad, subscription_object, signout) {
  var subscription_status = subscription_object["status"];
  var setUserLogin = "Logged In";

  var subsStatusTitle = "";
  var subsStatusIcon = "";

  if (tempLocalPersonalizedAuthSpecialErrorsOnStartup) {
    tempLocalPersonalizedAuthSubscriptionStatus = false;

    subsStatusTitle = "Authorization issues";
    subsStatusIcon = '<div class="icon subscription r"></div>';
    returnMsg = marketLoginResponseList(
      tempLocalPersonalizedAuthSpecialErrorsOnStartup,
      true
    );
    $(
      ".personalizedMarketLogin .content div[data-signed=1] .centered-content"
    ).html('<div style="font-weight:bold;color:red;">' + returnMsg + "</div>");
    // tempLocalPersonalizedAuthSpecialErrorsOnStartup = false; //same disable this
  } else {
    if (!subscription_status) {
      tempLocalPersonalizedAuthSubscriptionStatus = false;
      subsStatusTitle = "No subscription";
      subsStatusIcon = '<div class="icon subscription r"></div>';
      $(
        ".personalizedMarketLogin .content div[data-signed=1] .centered-content"
      ).html(
        '<div class="gi mid-2 subscription r"></div> No subscription<br><small class="btn" data-act="renew">Click to get or renew</small>'
      );
      setDevicesView(subscription_object["devices"]);
    } else {
      tempLocalPersonalizedAuthSubscriptionStatus = true;

      setDevicesView(subscription_object["devices"]);
      subsStatusTitle = "Subscription is active";
      subsStatusIcon = '<div class="icon subscription"></div>';
      $(
        ".personalizedMarketLogin .content div[data-signed=1] .centered-content"
      ).html(
        '<div class="gi mid-2 subscription"></div> Subscription is <strong>active</strong>'
      );

      //   _fo(tempLocalPersonalizedAuthSystemData);
    }
  }

  if (signout) {
    $(".personalizedMarketLogin .content div[data-signed=0]").show();
    $(".personalizedMarketLogin .content div[data-signed=1]").hide();
    $(
      '#popupContent .poBlock.atomMarket .top > div[data-buttons="subscription"] .market_site'
    ).html('<div class="icon profile"></div>Login');

    $(
      '#popupContent .poBlock.atomMarket .top > div[data-buttons="subscription"] .market_site'
    ).removeAttr("tooltip");

    tempLocalPersonalizedAuthSystemData = {};
    saveLocalPreferences("personalAuthSystem");
    //close auth form
    changeShowHideBlurred(false, ".personalizedMarketLogin", 3);
    createMessage("Log Out", "You have logged out of your account", "info");
    infoMessageInActivationWindow(false, false, "personalizedMarketLogin");

    if (maskedIVE.settings.authBeforeStart) {
      authBeforeStartInit();
    }
  } else {
    $(
      '.personalizedMarketLogin .content div[data-signed=1] .btn[data-act="relogin"]'
    ).text(tempLocalPersonalizedAuthSystemData["email"]);
    $(".personalizedMarketLogin .content div[data-signed=1]").show();
    $(".personalizedMarketLogin .content div[data-signed=0]").hide();
    $(
      '#popupContent .poBlock.atomMarket .top > div[data-buttons="subscription"] .market_site'
    ).html(subsStatusIcon + "Profile"); //'<div class="icon profile_ok"></div>Logged In'

    $(
      '#popupContent .poBlock.atomMarket .top > div[data-buttons="subscription"] .market_site'
    )
      .attr("tooltip", subsStatusTitle)
      .attr("tooltip-position", "left");
  }

  if (!onLoad) {
    upServerContent("marketAndUpdater");
  }

  //Re-run package only for packages by subscription (when auth/check subscription/logout)
  //need to disable package by sub if no subscription/or activate package by subscription again
  var packIsLoad = packageGetIsLoad();
  if (packIsLoad.abs) {
    runPackageHandler(true, packIsLoad, false, "init");
  }
}

function installPackageBySubs(mainFolder, packageArchive, packageFolderName) {
  setupProgressBar(true, "Unpacking", 60, 2000);

  //Setup NodeJS unzipper
  var archiveFilePath = convertToSystemPath(mainFolder + "/" + packageArchive);
  try {
    var unpackedFolder = convertToSystemPath(
      mainFolder + "/" + packageFolderName
    );

    // var AdmZip = require("adm-zip");
    // var zip = new AdmZip(archiveFilePath);
    // //Unzip all files (with overwrite)
    // zip.extractAllTo(unpackedFolder, true);

    // unzipLocalArchive(archiveFilePath, unpackedFolder);

    var unzipper = require("unzipper");

    fsmodule._fs
      .createReadStream(archiveFilePath)
      .pipe(unzipper.Extract({ path: unpackedFolder }))
      .on("finish", function () {
        // var packageFileOriginName = '';
        //Find package file in directory
        // var parseInDir = fsmodule._fs.readdirSync(unpackedFolder);
        // for (var key in parseInDir) {
        //     if (Object.hasOwnProperty.call(parseInDir, key)) {
        //         var oneFile = parseInDir[key];
        //         if (oneFile && parsePackageFileFormat(oneFile)) {
        //             packageFileOriginName = oneFile;

        //             break;
        //         }
        //     }
        // }
        setTimeout(function () {
          try {
            fsmodule._fs.readdir(unpackedFolder, function (err, files) {
              if (!err) {
                var packageFileOriginName = "";
                for (var key in files) {
                  if (Object.hasOwnProperty.call(files, key)) {
                    var oneFile = files[key];
                    if (oneFile && parsePackageFileFormat(oneFile)) {
                      packageFileOriginName = oneFile;
                      break;
                    }
                  }
                }
                if (packageFileOriginName) {
                  setupProgressBar(true, "Package Checking", 100, 800);
                  setTimeout(function () {
                    var finalPathPackage = convertToSystemPath(
                      unpackedFolder + "/" + packageFileOriginName
                    );
                    if (fsmodule.fileSize(finalPathPackage) > 0) {
                      if(installPackageFirstCheck(
                        finalPathPackage,
                        tempLocalPersonalizedAuthSystemData["usid"]
                      )){
                        //if success install - remove archive for package
                        
                      }

                      fsmodule.removeAsync(archiveFilePath);
                      //Hide Market and stop all youtube previews (like Back button)
                      popupBackButton();

                    } else {
                      createMessage(
                        "Empty package",
                        "The package cannot be read, please reinstall it",
                        "error",
                        true
                      );
                    }
                  }, 1600);
                } else {
                  createMessage(
                    "Not found package",
                    "Not found package in downloaded archive",
                    "error",
                    true
                  );
                }
              } else {
                createMessage(
                  "Error File Path",
                  "Cannot parse package file in folder",
                  "error",
                  true
                );
              }
            });
          } catch (e) {
            createMessage("RD Exception", "Error: " + e.message, "error", true);
          }
        }, 3000);
      });

    // zip.extractAllTo(destinationPath + '/lola/', true);
    //
  } catch (e) {
    createMessage("Wrong Subs Install", "Error: " + e.message, "error", true);
    //remove package if something wrong inside (to download new from server)
    fsmodule.removeAsync(archiveFilePath);
  }
}

function downloadPackageBySubscription(package_object) {
  // setupProgressBar(true, 'Lolka', 0, false, (bar, percent, barSteps) => {
  //     bar.width(40 + '%');
  //     barSteps(40);
  // });

  // setTimeout(function(){
  //     setupProgressBar(true, 'Unpacking', 60, 2000);
  // }, 2000);

  // return 0;

  //Check login
  if (tempLocalPersonalizedAuthSystemData["usid"]) {
    //Has active subscription
    if (tempLocalPersonalizedAuthSubscriptionStatus) {

      if(!checkSoftwareAttrsToRun(false, package_object["appid"], package_object['appversion'])){
        return false;
      }
      if(package_object['ext_version']){
        if(!checkExtVersionAttrsToRun(package_object['ext_version'])){
          return false;
        }
      }

      var xhURI =
        mainApiURI +
        "package?type=by_subscription&appid=" +
        package_object["appid"] +
        "&name=" +
        package_object["name"] +
        "&author=" +
        package_object["author"] +
        "&usid=" +
        tempLocalPersonalizedAuthSystemData["usid"] +
        "&usp=" +
        getUserSystemPrint();
      var packZipName =
        package_object["name"] +
        "-" +
        package_object["appid"] +
        "-v" +
        parseFloat(package_object["version"]) +
        ".zip";
      setupProgressBar(true, "Processing", 30, 2000);

      try {
        var subsFolder = getFolderSubscriptionPackages();

        var finalArchivePath = convertToSystemPath(
          subsFolder + "/" + packZipName
        );

        //UPD 2.0 - we can install from archive local, but after download by subs is default archive will be removed inside @installPackageBySubs functions
        if (
          fsmodule.exists(finalArchivePath) &&
          fsmodule.fileSize(finalArchivePath) > 10000
        ) {
          //if file more 10k bytes
          //Archive with package already exists - let's install (to don't download again from server)
          installPackageBySubs(
            subsFolder,
            packZipName,
            package_object["name"] + " - " + package_object["appid"]
          );
        } else {
          //Download file from network
          cHttpAsyncBinaryFile(
            xhURI,
            function (result, success) {
              // $('input[name="devTerminal"]').val(xhURI).addClass('result');
              if (success && result) {
                try {
                  fsmodule._fs.writeFile(
                    finalArchivePath,
                    result,
                    function (err) {
                      if (err) {
                        createMessage(
                          "Unable to write file",
                          "File Write access error",
                          "error",
                          true
                        );
                        return false;
                      }
                      installPackageBySubs(
                        subsFolder,
                        packZipName,
                        package_object["name"] + " - " + package_object["appid"]
                      );
                    }
                  );
                } catch (ex) {
                  //if can't read JSON from server
                  createMessage(
                    "Unknown Error",
                    "Error:" + ex.message,
                    "error",
                    true
                  );
                }
              } else {
                if (result == "NO_CONNECTION") {
                  result = "NO_CONNECTION";
                }
                if (result == "REQUEST_TIMEOUT") {
                  result = "TIMEOUT";
                } //timeout loading
                if (result == "NO_SUCCESS_LOAD" || !result) {
                  result = "NO_SUCCESS_LOAD";
                } //set status if no results

                var mainMsg = "";
                try {
                  var parseSData = JSON.parse(result);
                  mainMsg = parseSData["code"];
                } catch (e) {
                  mainMsg = "SERVER_ERROR";
                }
                var msgData = marketLoginResponseList(mainMsg, "head");
                return createMessage(
                  msgData["title"],
                  msgData["body"],
                  "error",
                  true
                );
              }
            },
            3600000,
            "Downloading"
          ); //Timeout 1 hour to download it
        }
      } catch (error) {
        return createMessage("Unknown Error", error.message, "error", true);
      }
    } else {
      createMessage(
        "No Subscription",
        "<a data-action='renew_subscription'>Get or Renew</a> the subscription, or buy the <a data-action='premium' data-type='package' data-pack-name='" +
          package_object["name"] +
          "' data-pack-appid='" +
          package_object["appid"] +
          "' data-pack-author='" +
          package_object["author"] +
          "'>full version</a>",
        "info",
        true
      );
    }
  } else {
    createMessage("Log In", "Log In to continue", "info", true);
  }
}

function checkSplitSuccessCode(serverCode) {
  var splitCode = serverCode.toString().split("-");
  return {
    status: parseInt(splitCode[0]),
    usid: splitCode[1],
    max: parseInt(splitCode[2]),
  };
}

function startupGetAuth(serverCode) {
  // var checkReturnCode = checkSplitSuccessCode(serverCode);

  if (serverCode["status"]) {
    return true;
  } else {
    return false;
  }
}

function revokeDeviceByUSID(usid, ip) {
  try {
    var postJSON = {};
    postJSON["author_name"] = maskedIVE.author;
    postJSON["usid"] = usid;
    postJSON["ip"] = ip;
    //animate msg for waiting response from server

    var headers = {
      "X-Requested-With": "Atom_X",
      "User-Agent": "AniomExtension_Atom",
      "Content-Type": "application/json",
    };

    var curXhrURL = "revoke_device";

    cHttpPostAsync(
      mainApiURI + curXhrURL,
      JSON.stringify(postJSON),
      headers,
      function (result, success) {
        if (success && result) {
          // alert(result);
          try {
            var parseSData = JSON.parse(result);
            // alert(result);
            if (parseSData["success"] == true) {
              // var checkReturnCode = checkSplitSuccessCode(parseSData["code"]);
              var subCheck = parseSData["status"];
              var subUsid = parseSData["usid"];

              //Disable errors auth
              tempLocalPersonalizedAuthSpecialErrorsOnStartup = false;
            }
          } catch (ex) {
            return marketLoginResponseList(parseSData["code"]);
          }
        } else {
          //XHR results
          if (result == "NO_CONNECTION") {
            result = "NO_CONNECTION";
          }
          if (result == "REQUEST_TIMEOUT") {
            result = "TIMEOUT";
          } //timeout loading
          if (result == "NO_SUCCESS_LOAD" || !result) {
            result = "NO_SUCCESS_LOAD";
          } //set status if no results
          return marketLoginResponseList(result);
        }
      }
    );
  } catch (error) {
    return marketLoginResponseList("WRONG_WITH_PARAMS");
  }
}

function packageMarketLoginService(recheck, email, token) {
  try {
    //global obj content
    var postJSON = {};

    if (recheck) {
      postJSON["usid"] = tempLocalPersonalizedAuthSystemData["usid"];
      postJSON["email"] = tempLocalPersonalizedAuthSystemData["email"];

    } else {
      postJSON["email"] = email;
      postJSON["token"] = token;
    }

    postJSON["author_name"] = maskedIVE.author;
    postJSON["has_control_devices"] = true;

    if (maskedIVE.settings.authWithSitePassword) {
      postJSON["auth_password"] = true;
    }

    postJSON["usp"] = getUserSystemPrint(); //new (finger print - mac/os name/os/other details) from AtomX 3.1+

    //animate msg for waiting response from server
    infoMessageInActivationWindow(
      "Checking...",
      true,
      "personalizedMarketLogin"
    );

    var headers = {
      "X-Requested-With": "Atom_X",
      "User-Agent": "AniomExtension_Atom",
      "Content-Type": "application/json",
    };

    var curXhrURL = recheck ? "recheck" : "auth";

    // if (recheck) {
    //   curXhrURL += '?email=' + tempLocalPersonalizedAuthSystemData["email"];
    // }

    cHttpPostAsync(
      mainApiURI + curXhrURL,
      JSON.stringify(postJSON),
      headers,
      function (result, success) {
        if (success && result) {
          // alert(result);
          try {
            var parseSData = JSON.parse(result);
            // alert(result);
            if (parseSData["success"] == true) {
              // var checkReturnCode = checkSplitSuccessCode(parseSData["code"]);
              var subCheck = parseSData["status"];
              var subUsid = parseSData["usid"];

              //Disable errors auth
              tempLocalPersonalizedAuthSpecialErrorsOnStartup = false;

              if (recheck) {
                checkAuthLogin(false, parseSData);
              } else {
                //Save user token
                tempLocalPersonalizedAuthSystemData["usid"] = subUsid;
                tempLocalPersonalizedAuthSystemData["email"] = email;
                saveLocalPreferences("personalAuthSystem");
                //Change UI when logged
                checkAuthLogin(false, parseSData);

                //hide window
                changeShowHideBlurred(false, ".personalizedMarketLogin", 3);

                createMessage(
                  "Logged In",
                  subCheck
                    ? "Your subscription is active!"
                    : "You don't have an active subscription",
                  "success"
                );
              }

              setTimeout(function () {
                infoMessageInActivationWindow(
                  false,
                  false,
                  "personalizedMarketLogin"
                );
              }, 1000);

  
            } else {
              //Set if user do recheck with errors
              if (recheck) {
                tempLocalPersonalizedAuthSpecialErrorsOnStartup =
                  parseSData["code"];
                checkAuthLogin(false, parseSData);
              }
              return marketLoginResponseList(parseSData["code"]);
            }
          } catch (ex) {
            return marketLoginResponseList(parseSData["code"]);
          }
        } else {
          //XHR results
          if (result == "NO_CONNECTION") {
            result = "NO_CONNECTION";
          }
          if (result == "REQUEST_TIMEOUT") {
            result = "TIMEOUT";
          } //timeout loading
          if (result == "NO_SUCCESS_LOAD" || !result) {
            result = "NO_SUCCESS_LOAD";
          } //set status if no results
          return marketLoginResponseList(result);
        }
      }
    );
  } catch (error) {
    return marketLoginResponseList("WRONG_WITH_PARAMS");
  }
}

function setDevicesView(devices) {
  var devicesHtml = "";

  for (var key in devices) {
    if (Object.prototype.hasOwnProperty.call(devices, key)) {
      var element = devices[key];
      var decode_fingerprint = JSON.parse(element["user_fingerprint"]);
      var mac = decode_fingerprint["mac"];
      var ip = element["ip"];
      var name = decode_fingerprint["user"];
      var usid = element["usid"];
      var currentState =
        userUSPData.mac == mac
          ? '<div class="current_device">Current</div>'
          : '<div class="btn" data-usid="' +
            usid +
            '" data-ip="' +
            ip +
            '">Revoke</div>';
      var os =
        decode_fingerprint["os"].toString().toLowerCase().indexOf("win") != -1
          ? "win"
          : "mac";
      devicesHtml +=
        '<li><div class="user"><span class="aui ' +
        os +
        '"></span> <span class="name">' +
        name +
        '</span><div class="macAddr">' +
        mac +
        '</div><div class="ipAddr">' +
        ip +
        "</div></div>" +
        currentState +
        "</li>";
    }
  }
  $(
    ".personalizedMarketLogin .content div[data-signed=1] .authorizationLists ul"
  ).html(devicesHtml);
}

function marketLoginResponseList(result, returnMsg) {
  var _msg = {};
  switch (result) {
    //ANY
    case "WRONG_WITH_PARAMS":
      _msg = preMsgHelper(
        "Unknown Error",
        "Something wrong with parameters",
        "error"
      );
      break;
    case "NO_SUCCESS_LOAD":
      _msg = preMsgHelper(
        "Unable to Load",
        "Unable to load server response!",
        "error"
      );
      break;
    case "SERVER_ERROR":
      _msg = preMsgHelper(
        "Server Error",
        "Something is wrong on the server",
        "error"
      );
      break;
    case "NO_CONNECTION":
      _msg = preMsgHelper(
        "Connection Failure",
        "Fix connection and try again!",
        "error"
      );
      break;
    case "TIMEOUT":
      _msg = preMsgHelper(
        "Timeout",
        "Too long no response, try later",
        "error"
      );
    //FROM SERVER
    case "DEPRECATED_CODE":
      _msg = preMsgHelper(
        "Deprecated Code",
        "Validity of the code has expired!",
        "error"
      );
      break;
    case "INVALID_AUTH":
      _msg = preMsgHelper(
        "Invalid Auth",
        "Invalid email or password!",
        "error"
      );
      break;
    case "INVALID_USID":
      _msg = preMsgHelper("Invalid Token", "No Token - Please relog", "error");
      break;
    case "MISSING_PARAMS":
      _msg = preMsgHelper("Missing Params", "Missing Parameters!", "error");
      break;
    case "LIMIT_USED_PC":
      _msg = preMsgHelper(
        "Limit",
        "Exceeded the number of computers using the subscription!",
        "info"
      );
      break;
    case "WRONG_MAC_ADDR":
      _msg = preMsgHelper(
        "Wrong MAC Address",
        "MAC address doesn't match - Please relog",
        "error"
      );
      break;
    case "USID_DISABLED":
      _msg = preMsgHelper(
        "Disabled",
        "Authorization disabled - Please relog",
        "error"
      );
      break;
    case "NO_SOURCE_FILE":
      _msg = preMsgHelper(
        "File Not Found",
        "The file was not found on the server",
        "error"
      );
      break;
    case "NO_CERT_FILE":
      _msg = preMsgHelper(
        "Cert Not Found",
        "AWS certificate is missing",
        "error"
      );
      break;

    default:
      _msg = preMsgHelper(
        "Unknown Server",
        "Unknown server error, write to the administrator.",
        "error"
      );
  }

  if (returnMsg) {
    if (returnMsg == "head") {
      return _msg;
    } else {
      return _msg["body"];
    }
  } else {
    if (_msg["title"] && _msg["body"]) {
      infoMessageInActivationWindow(
        _msg["body"],
        false,
        "personalizedMarketLogin"
      );
    }
  }
}
