/*
 * @Author: aniom
 * @Date:   2020-04-15 03:58:46
 * @Last Modified by:   aniom
 * @Last Modified time: 2020-09-03 00:22:01
 */

var previousLayersEventWaitingInterval = null;

/**
 * Timer for system Message func
 * @func createMessage
 */
var messageFadeTimer = null;

/**
 * Timer to save preferences file (wait before save if so many actions)
 * @func saveLocalPreferences
 */
var presaveLocalPrefsTimer = null;

/**
 * Special menu default width (save menu changes for other packs)
 */
var menuDefWidth = 150;

//#region EXTRAS

/**
 * Validate Email field
 * @param {string} email
 */
function validateEmail(email) {
	var re =
		/^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
	return re.test(email);
}

/**
 * Create new msg to response in JS Panel
 * @param {string} throw_name Throw message data (ex: NO_DATA)
 * @return {string} Return set message
 */
function newOutThrow(throw_name) {
	systemResponse = throw_name;
	return throw_name;
}

/**
 * Setted global message to response in JS Panel
 * @return {string} Setted message
 */
function getOutThrows() {
	return systemResponse;
}

/**
 * Get arr from obj
 * @param {*} obj
 */
function objectToArrProps(obj) {
	var keys = [],
		k;
	for (k in obj) {
		if (obj.hasOwnProperty.call(obj, k)) {
			keys.push(k);
		}
	}
	return keys;
}

/**
 * Convert color to special number for rgb object and set to JSX
 * @param {*} rgb_object
 */
function convertColorRgbToAppSystem(rgb_object) {
	return [Number(rgb_object["r"]) / 255, Number(rgb_object["g"]) / 255, Number(rgb_object["b"]) / 255];
}

/**
 * Convert array ARGB to HEX (without alpha channel) - required for Premiere Pro MOGRT component colors
 * @param {array} argb [alpha, r, g, b]
 */
function convertColorArgbToHexPR(argb) {
	r = Math.round(argb[1]).toString(16);
	g = Math.round(argb[2]).toString(16);
	b = Math.round(argb[3]).toString(16);

	if (r.length == 1) r = "0" + r;
	if (g.length == 1) g = "0" + g;
	if (b.length == 1) b = "0" + b;

	return "#" + r + g + b;
}

/**
 * Rgb To Hex converter by pieces rgb
 * @param {number} red
 * @param {number} green
 * @param {number} blue
 */
function rgb2hex(red, green, blue) {
	red = red * 255;
	green = green * 255;
	blue = blue * 255;
	var rgb = blue | (green << 8) | (red << 16);

	return (0x1000000 + rgb).toString(16).slice(1);
}

//#endregion

//#region APPLICATION SPECIAL FUNC

/**
 * Generate random number for SequenceID in Premiere Pro or any action
 * @param {number} len Count of nums
 * @return {string} Random string
 */
function rndSeqID(len) {
	var maxlen = 8;
	var min = Math.pow(16, Math.min(len, maxlen) - 1);
	var max = Math.pow(16, Math.min(len, maxlen)) - 1;
	var n = Math.floor(Math.random() * (max - min + 1)) + min;
	var r = n.toString(16);
	while (r.length < len) {
		r = r + rndSeqID(len - maxlen);
	}
	return r;
}

/**
 * Add XML element as string </>
 * @param {*} name
 * @param {*} value
 * @return {string} String for XML Node
 */
function addEl(name, value) {
	return "<" + name + ">" + value + "</" + name + ">";
}

//#endregion

//#region ITEM ARGUMENTS

/**
 * Arguments will converted to stringity
 * @param {*} objArguments
 */
function convertArgumentsToString(objArguments) {
	return JSON.stringify(objArguments);
}

/**
 * Parse and return argument
 * @param {*} objArguments
 * @param {*} isGet
 * @return {json}
 */
function parseAndGetArguments(objArguments, isGet) {
	var parsedObj = JSON.parse(objArguments);
	if (isGet) {
		//get one parsed
		return parsedObj[isGet];
	} else {
		//get all parsed data
		return parsedObj;
	}
}

//#endregion

//#region GLOBAL FUNCTIONS
let debounceTimeoutId;
function inputDebounce(callback, delay) {
	clearTimeout(debounceTimeoutId); // Очищаем предыдущий таймер
	debounceTimeoutId = setTimeout(() => {
		callback();
	}, delay);
}

/**
 * Switch to show new content and hide previosly (hide current menu selected if need)
 * @param {string} setPointer pointer (data-view) string to show content
 * @param {boolean} resetMenuSelected default false, reset global menu tree currents/last-actives
 */
function contentSwitcher(setPointer, resetMenuSelected, resetToolNMenuSelected) {
	// remove current/last-active from menu if need
	if (resetMenuSelected) {
		$("#menu .global li").removeClass("current").removeClass("last-active");
	} else {
		//deselect (except CHECKBOX type) all tools btn (if clicked to menu)
		$('#tools .global li:not([data-type="checkbox"])').removeClass("current");
	}

	if (resetToolNMenuSelected) {
		$("#menu ul li").removeClass("current").removeClass("last-active");
		$('#tools .global li:not([data-type="checkbox"])').removeClass("current");
	}

	if (setPointer) {
		eventWatcherForCustomizerChanges(setPointer);
		// hide all content
		$("#content .coBlock").removeClass("current");
		// show only selected content
		$('#content .coBlock[data-view="' + setPointer + '"]').addClass("current");
	}
}

/**
 * Popup (Window over content) for package manager/Video tutorials and etc
 * @param {string} setPointer pointer (data-view) string to show content
 */
function popupContentSwitcher(setPointer) {
	// hide all content
	$("#popupContent .poBlock").removeClass("current");
	// remove blur from end-side bg
	$(".whenPopupBlur, #header, .outsideWrapper").removeClass("blurredMode");

	// show content
	if (setPointer) {
		// add blur to header/wrapper
		$(".whenPopupBlur, #header, .outsideWrapper").addClass("blurredMode");
		// show only selected content
		$('#popupContent .poBlock[data-view="' + setPointer + '"]').addClass("current");
	}
}

/**
 * Show/Hide any content by class as Popup, overlay background like @func popupContentSwitcher
 * @param {boolean} show Show - true/hide - false
 * @param {string} m_class Class to show/hide
 * @param {number} blurred_mode 1-3 - class blurredMode
 */
function changeShowHideBlurred(show, m_class, blurred_mode) {
	var blurredClass = "blurredMode";
	if (blurred_mode == 1) {
		blurredClass = "blurredMode";
	}
	if (blurred_mode == 2) {
		blurredClass = "blurredMode_packManager";
	}
	if (blurred_mode == 3) {
		blurredClass = "blurredMode_activationService";
	}
	if (blurred_mode == 4) {
		blurredClass = "blurredMode_confirmPopup";
	}

	if (show) {
		$(m_class).show();
		$(".whenPopupBlur, #header, .outsideWrapper").addClass(blurredClass);
	} else {
		$(m_class).hide();
		$(".whenPopupBlur, #header, .outsideWrapper").removeClass(blurredClass);
	}
}

function changeStepByStepContentSwitcher(setPointer) {
	// hide all content
	$(".stepContent").hide().removeClass("current");

	//show one content
	if (setPointer) {
		$('.stepContent[data-view="' + setPointer + '"]')
			.show()
			.addClass("current");
	}
}

/**
 * Info placeholder on header
 * @param {boolean} show
 * @param {*} setPointer
 * @param {string} rewriteContent
 */
function placeboardSwitcher(show, setPointer, rewriteContent) {
	//hide all

	$(".infoPlaceboard").hide();

	if (rewriteContent) {
		$('.infoPlaceboard[data-type="' + setPointer + '"] .bodyPlace h1').text(rewriteContent);
	}
	//show content if exists
	if (show && setPointer) {
		$('.infoPlaceboard[data-type="' + setPointer + '"]').show();
	}
}

/**
 * Extension window layout changes
 */
function panelLayoutResize() {
	//get width and height this window
	var width = $(window).width();
	var height = $(window).height();

	var toolsGlobalH = $("#tools").height();
	var new_menuHeight = height - toolsGlobalH - 116;

	//resize menu (height)
	//   $("#menu").height(new_menuHeight);
	//   $("#content").height(new_menuHeight);
	$(".splitBothResizer").height(new_menuHeight);

	//fix height for popup windows
	$("#popupContent .poBlock .pbody").height(height - 56);

	//fix height for package manager items
	$(".packageManager .ulContent").height(height - 230);

	// half size responsive
	if (width < 300) {
		//342
		//hide callout market box
		$("#header .headMenu .calloutsMarket").css("display", "none");
		//shop cart
		$("#header .headMenu").addClass("resLayoutShop");
		//search
		$("#tools .global input.search").addClass("resLayoutRes");

		//change width range - previews
		$('#footer .change_view input[type="range"].style_sliding').addClass("resSmall");
	} else {
		//show callout market box - show only if has content

		if ($("#header .headMenu .calloutsMarket").text().toString().length && !disableCalloutMarketMessage) {
			$("#header .headMenu .calloutsMarket").css("display", "block");
		}

		//shop cart
		$("#header .headMenu").removeClass("resLayoutShop");
		//search
		$("#tools .global input.search").removeClass("resLayoutRes");

		//change width range - previews
		$('#footer .change_view input[type="range"].style_sliding').removeClass("resSmall");
	}

	// auto change preview size when changing ext window
	autoSizingPreviewItems();

	//customize market items
	customizeMarketGridItemsWidth(width);
}

/**
 * Customize market grid item width
 * @param {number|string} globalWidth
 */
function customizeMarketGridItemsWidth(globalWidth) {
	//Customize items width in Atom market
	if (globalWidth >= 960) {
		$(".atomMarket .pbody .vt_body").width("100%");
	} else if (globalWidth >= 630) {
		$(".atomMarket .pbody .vt_body").width("620px");
	} else {
		$(".atomMarket .pbody .vt_body").width("310px");
	}
}

/**
 * Auto-fit preview items change size
 * @version 2 - was fully changed
 */
function autoSizingPreviewItems() {
	if (editLocalUI(false, "autoResizingItems")) {
		var mbody = $("#content");
		var gotval = mbody.width();

		//check visible scrollbar for scrolling or not
		/*         var clientSize = mbody.prop('clientHeight');
                var scrollHeight = mbody.prop('scrollHeight');

                

                var scrollingVisible = false;
                if(clientSize != scrollHeight){
                    scrollingVisible = true;
                }else{
                    scrollingVisible = false;
                }
                var addSpecialDifForSclBar = scrollingVisible ? 0 : 0; */

		//main system
		var customVal_240 = 120; //from 120 to 360 max - def 240
		var customVal_135 = 67.5;

		//RESIZING FOR WIDE - 240
		if (gotval >= 130 && gotval < 251) {
			//3.87

			customVal_240 = gotval - 10;
		} else if (gotval >= 253 && gotval < 375) {
			customVal_240 = ((gotval - 13) / 100) * 50;
		} else if (gotval >= 375 && gotval < 628) {
			customVal_240 = ((gotval - 13) / 100) * 33;
		} else if (gotval >= 628 && gotval < 984) {
			customVal_240 = ((gotval - 13) / 100) * 24.7;
		} else if (gotval >= 984 && gotval < 1230) {
			customVal_240 = ((gotval - 13) / 100) * 19.7;
		} else if (gotval >= 1230 && gotval < 2000) {
			customVal_240 = 240;
		} else {
			customVal_240 = 120;
		}

		//RESIZING FOR VERTICAL AND BOX
		if (gotval >= 78 && gotval < 147) {
			//3.87

			customVal_135 = gotval - 10;
		} else if (gotval >= 148 && gotval < 218) {
			customVal_135 = ((gotval - 13) / 100) * 50;
		} else if (gotval >= 218 && gotval < 355) {
			customVal_135 = ((gotval - 13) / 100) * 33;
		} else if (gotval >= 355 && gotval < 500) {
			customVal_135 = ((gotval - 13) / 100) * 24.5;
		} else if (gotval >= 500 && gotval < 626) {
			customVal_135 = ((gotval - 13) / 100) * 19.6;
		} else if (gotval >= 626 && gotval < 760) {
			customVal_135 = ((gotval - 13) / 100) * 16.3;
		} else {
			customVal_135 = 67.5;
		}

		var sizeInRange = 7;
		if (customVal_240 >= 168) {
			sizeInRange = 9;
		} else {
			sizeInRange = 7;
		}

		previewSizeLayoutChange(sizeInRange, false, true, [Math.ceil(customVal_240), Math.ceil(customVal_135)]);
		// $('.packName').html(gotval + '  240: ' + Math.ceil(customVal_240) + ' 135: ' + Math.ceil(customVal_135));
	}
}

/**
 * Apply UI saved settings when new package switched/installed/initialized. [ONLY PACKAGE ACTION]
 */
function readyUISettingsPackSwitched() {
	// Sets for start the extension
	// $('#tools ul.global li').removeClass('current');
	//if exist packages - open first template to show items (menu/content)
	var obx = $("#menu > ul > li.folder:nth-child(1) > div.title");
	// alert(obx.find('li.folder:nth-child(1)')[0].innerHTML);
	if (obx.length > 0) {
		//has folders (one or more)
		obx[0].click();
		// alert($('#menu ul li:first-child').data('view'));
		/* Three deep folders */
		if ((deepThree = $("#menu > ul > li.folder:nth-child(1) li.folder:nth-child(1) li.folder:nth-child(1) > div.title"))) {
			if (deepThree.length > 0) {
				deepThree[0].click();
			}
		}

		/* Close to show only groups */
		obx[0].click();
	} else {
		//if no folders
		$("#menu li")[0].click();
	}

	var curPackGlobOpt = currentTempPackageInsideOptionsSets;
	//pack has hide menu var
	if (curPackGlobOpt && curPackGlobOpt.hide_menu) {
		$("#menu").hide();
		$(".splitBothResizer").hide();
		$('#tools ul.global li[data-view="SHOW_MAIN_ITEMS"]').show().addClass("current");
	} else {
		$("#menu").show();
		$(".splitBothResizer").show();
		$('#tools ul.global li[data-view="SHOW_MAIN_ITEMS"]').hide().removeClass("current");
		//default: show menu and set menu width
		$("#menu").width("auto");
		var getCurMenuWidthAfterAuto = $("#menu").width();
		$("#menu").width((getCurMenuWidthAfterAuto > 190 ? getCurMenuWidthAfterAuto : 200) * 0.75);
	}

	/* Engine changes for design */
	var engines = softAssetsByAppID[currentPackShortAppID]["engine"];

	/* Engine _NEURO_PHOTO_ANIMATOR */
	if (currentPackEngineType == engines[2]) {
		/* Hide Tools/Content for Engine Photo Animator */
		$("#tools .global").hide();
		$(`#tools [data-engine="${currentPackEngineType}"]`).show();

		$("#container").hide();
		/* Show engine content */
		$("#photoAnimator").show();

		// alert(getFolderWithAssetsItems());
		//show startup content (step-by-step) for current engine
		changeStepByStepContentSwitcher("startup"); //startup //selectResolution //selectAnimatorType

		//Set toolbar as engine _COMPOSER
		// currentPackEngineType = engines[1];
	}

	/* Engine _TEXT_ANIMATOR */
	if (currentPackEngineType == engines[3]) {
		var setSignsOfTextAnimatorPack = curPackGlobOpt.available_symbols_base64
			? encoder.extras.b64_to_utf8(curPackGlobOpt.available_symbols_base64)
			: curPackGlobOpt.available_symbols;

		var engineBlock = $('#tools .specialToolPlace[data-engine="' + engines[3] + '"]');
		engineBlock.show();
		/* Set available symbols */
		engineBlock.find(".title span").text(setSignsOfTextAnimatorPack);
		/* Hide Toolbar */
		$('#tools ul.global li[data-view="SHOW_TOOLS"]').hide();

		/* Use Randomizer */
		if (curPackGlobOpt.use_randomizer) {
			engineBlock.find('.btn[data-action="open_randomizer"]').show();
		}
	}

	// current tools pack by engine type includes appID
	changeToolbarToEngine(currentPackEngineType, currentPackShortAppID);
	// Global sets UI
	readyUISettingsState();
}

function changeToolbarToEngine(packEngine, packAppID) {
	$(".toolSpoilerContainer div").removeClass("showEngineTools"); //hide all
	$('.toolSpoilerContainer div[data-engine="' + packEngine + '"][data-app="' + packAppID + '"]').addClass("showEngineTools"); //set toolbar for current engine
}

/**
 * Set by default Audio/AutoPlay/SizeLayout in footer (data from JSX Prefs)
 */
function readyUISettingsState() {
	//set ready to audio container
	audioVolumeChange(editLocalUI(false, "audioVolume"), true, true);

	//set global auto-play
	autoPlayPreviewChange(editLocalUI(false, "previewAutoPlay"), true, true);

	//change preview size
	if (!editLocalUI(false, "autoResizingItems")) {
		//if auto-size is active = do not change layout size from memory
		previewSizeLayoutChange(editLocalUI(false, "previewLayoutSize"), true, true);
	} else {
		//start auto-sizing to sort items even without resizing window
		autoSizingPreviewItems();
	}

	sfxItemsEnable(getCurSoftShortID() == "PR", false);
	// demoWithPremiumItemsInMenu(false);

	//set status auto-resizing items
	previewAutoResizingItems(editLocalUI(false, "autoResizingItems"), true);
}

function getRandomInt(min, max) {
	min = Math.ceil(min);
	max = Math.floor(max);
	return Math.floor(Math.random() * (max - min)) + min;
}

/**
 * Setup for Progress Bar (setup to start/end) - will be stopped after any messages @func createMessage
 * @param {boolean} preStart True for start / False to end progress
 * @param {string} set_title New title for bar
 * @param {number} percents Set new percent as number (default 40 + random)
 * @param {number} duration New duration in ms (default 2500ms)
 */
function setupProgressBar(preStart, set_title, percents, duration, callback) {
	var pmain = $("#progressBar");
	var pbar = pmain.find(".progress-bar");

	var p_TitleBlock = pmain.find(".title");
	var p_TextTitle = p_TitleBlock.find("span.text");
	var p_PercentTitle = p_TitleBlock.find("span.percent");

	if (!percents) {
		percents = getRandomInt(25, 70);
	} else {
		percents = getRandomInt(Math.abs(percents - 5), percents); // Math.random() * 10 + percents; //rnd percent
	}
	percents = percents < 90 ? percents : getRandomInt(90, 100); //if more 90 set 80
	percents = percents >= 100 ? getRandomInt(Math.abs(percents - 5), percents) : percents;

	duration = duration ? duration : 2000;

	if (preStart) {
		pmain.finish().fadeIn("slow");
		p_TextTitle.text(set_title);

		pbar.finish().width(0);

		if (callback) {
			percents = 0;
			callback(pbar, p_PercentTitle, barSteps);
			// if (!pbar.hasClass('smoothProgress')) {
			//     pbar.addClass('smoothProgress');
			// }
		} else {
			pbar.animate(
				{
					width: percents + "%"
				},
				{
					duration: duration,
					easing: "linear",
					step: barSteps,
					complete: function () {}
				}
			);
			if (pbar.hasClass("smoothProgress")) {
				pbar.removeClass("smoothProgress");
			}
		}
	} else {
		if (set_title == "_STOP") {
			pmain.hide();
		} else {
			pbar.finish().animate(
				{
					width: "100%"
				},
				{
					duration: 200,
					easing: "linear",
					step: barSteps,
					complete: function () {
						pmain.finish().fadeOut("slow");
						$(".preStartFill").fadeOut("slow");
					}
				}
			);
		}
	}

	function barSteps(a, b) {
		var curVal = Math.round(a);
		if (curVal >= 100) {
			curVal = 100;
		}
		if (set_title) {
			p_TextTitle.text(set_title);
			p_PercentTitle.text(" " + curVal + "%");
		} else {
			p_PercentTitle.text(" " + curVal + "%");
		}

		if (curVal >= 0) {
			rgb = "#f63a0f";
		}
		if (curVal >= 25) {
			rgb = "#f27011";
		}
		if (curVal >= 50) {
			rgb = "#f2b01e";
		}
		if (curVal >= 75) {
			rgb = "#f2d31b";
		}
		if (curVal >= 95) {
			rgb = "#86e01e";
		}

		pbar.css({
			backgroundColor: rgb
		});
	}
}

//#endregion

//#region FOOTER HANDLER OPTIONS

function audioTimeSeeker(thisAudio) {
	var progressBar = Math.floor((thisAudio.currentTime / thisAudio.duration) * $(".insteadPackDetailsBlock").width()) + "px"; //(Math.floor(thisAudio.currentTime / thisAudio.duration * 100))   + "%";

	var curmins = Math.floor(thisAudio.currentTime / 60);
	var cursecs = Math.floor(thisAudio.currentTime - curmins * 60);
	var durmins = Math.floor(thisAudio.duration / 60);
	var dursecs = Math.floor(thisAudio.duration - durmins * 60);

	durmins = durmins || 0;
	dursecs = dursecs || 0;

	if (dursecs < 1) {
		dursecs = "1";
	}
	if (cursecs < 10) {
		cursecs = "0" + cursecs;
	}
	if (dursecs < 10) {
		dursecs = "0" + dursecs;
	}
	if (curmins < 10) {
		curmins = "0" + curmins;
	}
	if (durmins < 10) {
		durmins = "0" + durmins;
	}

	var curTime = curmins + ":" + cursecs;
	var durTime = durmins + ":" + dursecs;

	$(".insteadPackDetailsBlock").html(curTime + " <small>/</small> " + durTime + "  <small>[Loop]</small>");
	$(".audioSeekerByWidth").width(progressBar); //progress line
}

/**
 * Audio Controller (play audio and show audio container with timing)
 * @param {boolean} run Run Audio or pause
 * @param {string} audioPath Path to audio .wav
 */
function audioController(run, audioPath) {
	var thisAudio = $("audio#atomAudioObject")[0]; //get audio container (need [0] to get tag)
	thisAudio.volume = Number(editLocalUI(false, "audioVolume")) / 100; //set volume from global var

	if (run) {
		$(".audioBoardInfo").show();
		$(".packDetails").hide();
		$("canvas#audioBody").stop().fadeIn(200);

		if (!thisAudio.volume) {
			$(".audioBoardInfo .audioSeekerByWidth").width(0);
			$(".audioBoardInfo .insteadPackDetailsBlock").text("Turn on the sound!");
			return 0;
		}
		if (thisAudio.volume <= 0.04) {
			$(".audioBoardInfo .audioSeekerByWidth").width(0);
			$(".audioBoardInfo .insteadPackDetailsBlock").text("Add sound volume!");
			return 0;
		}

		thisAudio.src = audioPath;
		thisAudio.currentTime = 0; //reset time
		thisAudio.play();

		$("audio#atomAudioObject").on("loadedmetadata", function () {
			audioTimeSeeker(thisAudio);
		});
		$("audio#atomAudioObject").on("timeupdate", function () {
			audioTimeSeeker(thisAudio);
		});
		// $('audio#atomAudioObject').on("loadedmetadata", function(){
		//     $('.insteadPackDetailsBlock').html(this.duration);
		// });

		// Visualization Audio Waveform (need visualizate only RUN)
		if (editLocalPSets(false, "audioVisualization") != 0) {
			letAudiowaveForm(thisAudio, editLocalPSets(false, "audioVisualization"));
		}
	} else {
		$("canvas#audioBody").stop().fadeOut(200);
		$(".packDetails").show();
		$(".audioBoardInfo").hide();
		thisAudio.pause();
	}
}

/**
 * All actions with audio volume (change tooltip volume info, save it to temp variable, add/remove active class)
 * @param {number} volume Volume Number
 * @param {boolean} setIRangeVol Is set new volume from Volume Number to Input Range
 * @param {boolean} onlyTempSet Only temporary set / or save to local preferences
 */
function audioVolumeChange(volume, setIRangeVol, onlyTempSet) {
	volume = Number(volume);
	//another for audio (active = disabled icon)
	if (volume > 0) {
		footerIconActiveChanger(false, "audio");
	} else {
		footerIconActiveChanger(true, "audio");
	}

	var audioIconClass = $('#footer .main_btn ul li[data-type="audio"]');
	var rangeVolumeContainer = audioIconClass.find(".audioVolumeRangeContainer");
	rangeVolumeContainer.attr("tooltip", "Volume: " + volume);

	if (setIRangeVol) {
		rangeVolumeContainer.children("input").val(volume);
	}
	//save changes in global var
	editLocalUI(true, "audioVolume", volume);
	if (!onlyTempSet) {
		saveLocalPreferences("UI");
	}
}

function previewAssignBoxType(boxType, width){
	return $(`${boxType} > img, ${boxType} > video, ${boxType}>.body`).width(width);
}

/**
 * Preview items change size (input and buttons)
 * @param {number} val Value Range from 5 before 15 = 10 possible sizes
 * @param {boolean} setIRangeSize Set new value to range input
 */
function previewSizeLayoutChange(val, setIRangeSize, onlyTempSet, customResizingVal) {
	val = Number(val);
	//vars
	var preEObjectClass_def = '.element[res="DEFAULT"]';
	var preEObjectClass_ver = '.element[res="VERTICAL"]';
	var preEObjectClass_max = '.element[res="BOX_MAX"]';
	var preEObjectClass_min = '.element[res="BOX_MIN"]';

	var storageSizes_max = {
		width: 13,
		fontSize: 1.0
	};

	var storageSizes_min = {
		width: 13,
		fontSize: 1.0
	};

	var jClassPath_title_max = preEObjectClass_def + " .body .title, " + preEObjectClass_max + " .body .title";
	var jClassPath_title_min = preEObjectClass_min + " .body .title, " + preEObjectClass_ver + " .body .title";
	var jClassPath_controlButtons = ".element .applyControls .button";
	var jClassPath_elBodyUsage = ".element .body .usage";
	var defButton_fontSize = 9;

	var specialCustomResizingSetTempVal = 5;

	//min 5 and max 15 = 10 possible sizes
	if (val >= 5 && val <= 15) {
		// change size (save AR - aspect ratio)

		if (customResizingVal) {
			//--- 240px width
			var styleSetW = customResizingVal[0];
			var styleSetH = customResizingVal[1];
			//default AR

			
			previewAssignBoxType(preEObjectClass_def, styleSetW);
			previewAssignBoxType(preEObjectClass_max, styleSetW);
			previewAssignBoxType(preEObjectClass_ver, styleSetH);
			previewAssignBoxType(preEObjectClass_min, styleSetH);
			// $(`${preEObjectClass_def} > img, ${preEObjectClass_def} > video.source-video, ${preEObjectClass_def}>.body`).width(styleSetW);
			//max box AR
			// $(preEObjectClass_max + " img, " + preEObjectClass_max + " .body").width(styleSetW);

			// //--- 135px width
			// //vertical AR
			// $(preEObjectClass_ver + " img, " + preEObjectClass_ver + " .body").width(styleSetH);
			// //min box AR
			// $(preEObjectClass_min + " img, " + preEObjectClass_min + " .body").width(styleSetH);
		} else {
			//--- 240px width
			var styleSetW = val * 24;
			var styleSetH = val * 13.5;
			// //default AR
			// $(preEObjectClass_def + " img, " + preEObjectClass_def + " .body").width(styleSetW);
			// //max box AR
			// $(preEObjectClass_max + " img, " + preEObjectClass_max + " .body").width(styleSetW);

			// //--- 135px width
			// //vertical AR
			// $(preEObjectClass_ver + " img, " + preEObjectClass_ver + " .body").width(styleSetH);
			// //min box AR
			// $(preEObjectClass_min + " img, " + preEObjectClass_min + " .body").width(styleSetH);

					previewAssignBoxType(preEObjectClass_def, styleSetW);
			previewAssignBoxType(preEObjectClass_max, styleSetW);
			previewAssignBoxType(preEObjectClass_ver, styleSetH);
			previewAssignBoxType(preEObjectClass_min, styleSetH);
		}

		//disable full button text for min (vertical/small box) view - if used custom Resizing
		if (customResizingVal) {
			//For Wide/max box
			var specialPathToMaxButtons = preEObjectClass_def + " .applyControls .button," + preEObjectClass_max + " .applyControls .button";
			if (customResizingVal[0] >= 168) {
				//155 def
				$(jClassPath_title_max).css("visibility", "visible");
				$(specialPathToMaxButtons).css("font-size", defButton_fontSize);

				if (customResizingVal[0] >= 180) {
					storageSizes_max["width"] = customResizingVal[0] / 3.4;
					storageSizes_max["fontSize"] = 11;
				} else {
					storageSizes_max["width"] = customResizingVal[0] / 3.4;
					storageSizes_max["fontSize"] = 9;
				}
			} else {
				$(jClassPath_title_max).css("visibility", "hidden");
				$(specialPathToMaxButtons).css("font-size", 0);
				storageSizes_max["width"] = val * 6;
				storageSizes_max["fontSize"] = val * 1;
			}
			//For Vertical/mini box
			var specialPathToMinButtons = preEObjectClass_min + " .applyControls .button," + preEObjectClass_ver + " .applyControls .button";
			if (customResizingVal[1] >= 108) {
				$(jClassPath_title_min).css("visibility", "visible");
				$(specialPathToMinButtons).css("font-size", defButton_fontSize);

				if (customResizingVal[1] >= 120) {
					storageSizes_min["width"] = customResizingVal[1] / 3.4;
					storageSizes_min["fontSize"] = 11;
				} else {
					storageSizes_min["width"] = customResizingVal[1] / 3.4;
					storageSizes_min["fontSize"] = 9;
				}
			} else {
				$(jClassPath_title_min).css("visibility", "hidden");
				$(specialPathToMinButtons).css("font-size", 0);
				storageSizes_min["width"] = val * 4.5;
				storageSizes_min["fontSize"] = val * 1;
			}
		} else {
			// resizes for default layout (% width/px font-size)
			// changes for 240px width
			if (val >= 13) {
				storageSizes_max["width"] = val * 5;
				storageSizes_max["fontSize"] = 12;
			} else if (val <= 8) {
				storageSizes_max["width"] = val * 6;
				storageSizes_max["fontSize"] = 9;
			} else {
				storageSizes_max["width"] = val * 6;
				storageSizes_max["fontSize"] = val * 1;
			}

			// changes for 135px width
			if (val >= 13) {
				storageSizes_min["width"] = val * 4;
				storageSizes_min["fontSize"] = 12;
			} else if (val <= 8) {
				storageSizes_min["width"] = val * 3;
				storageSizes_min["fontSize"] = 6;
			} else {
				storageSizes_min["width"] = val * 4.5;
				storageSizes_min["fontSize"] = val * 1;
			}

			//show/hide title item
			if (val <= 7) {
				//hide max titles
				$(jClassPath_title_max).css("visibility", "hidden");
				//hide min titles
				$(jClassPath_title_min).css("visibility", "hidden");
				//hide/show text on control buttons (global)
				$(jClassPath_controlButtons).css("font-size", 0);
			} else {
				//show max titles
				$(jClassPath_title_max).css("visibility", "visible");
				//show min titles
				$(jClassPath_title_min).css("visibility", "visible");
				//hide/show text on control buttons (global)
				$(jClassPath_controlButtons).css("font-size", defButton_fontSize);
			}
		}

		// apply resize for titles
		//width 135px
		$(jClassPath_title_min)
			.css("width", storageSizes_min["width"] + "%")
			.css("font-size", storageSizes_min["fontSize"]);
		//width 240px
		$(jClassPath_title_max)
			.css("width", storageSizes_max["width"] + "%")
			.css("font-size", storageSizes_max["fontSize"]);

		//if need change input via buttons
		if (setIRangeSize) {
			$("#footer .change_view .previewRangeInput input").val(val);
		}
		//save to var
		editLocalUI(true, "previewLayoutSize", val);
		if (!onlyTempSet) {
			saveLocalPreferences("UI");
		}
	}
}

function newItemsNotifyInMenu(initialButton, updateData, setVal, onlyTempSet) {
	var iconBtn = $("#footer ul li.newItemNotify");
	if (initialButton) {
		var shyBadges = true;
		if (updateData) {
			setVal = Number(setVal);
			footerIconActiveChanger(setVal, "newItemsNotify");
			if (setVal) {
				shyBadges = false;
			}
			//save
			editLocalUI(true, "newItemsNotify", setVal);
			if (!onlyTempSet) {
				saveLocalPreferences("UI");
			}
		} else {
			var getCurStatus = Number(editLocalUI(false, "newItemsNotify"));
			if (getCurStatus) {
				shyBadges = false;
			}

			footerIconActiveChanger(getCurStatus, "newItemsNotify");
		}

		//action with menu badge
		if (!shyBadges) {
			$("#menu li .is_new, #menu li .is_new_group").show();
		} else {
			$("#menu li .is_new, #menu li .is_new_group").hide();
		}

		if ($(iconBtn).is(":hidden")) {
			iconBtn.show(); //show icon button
		}
	} else {
		iconBtn.hide();
	}
}


function sfxItemsEnable(initialButton, updateData, setVal, onlyTempSet) {
	var iconBtn = $("#footer ul li.sfxItems");
	if (initialButton) {
		if (updateData) {
			setVal = Number(setVal);
			footerIconActiveChanger(setVal, "sfxItems");
			//save
			editLocalUI(true, "sfxItems", setVal);
			if (!onlyTempSet) {
				saveLocalPreferences("UI");
			}
		} else {
			var getCurStatus = Number(editLocalUI(false, "sfxItems"));

			footerIconActiveChanger(getCurStatus, "sfxItems");
		}

		if ($(iconBtn).is(":hidden")) {
			iconBtn.show(); //show icon button
		}
	} else {
		iconBtn.hide();
	}
}

function demoWithPremiumItemsInMenu(initialButton, updateData, setVal, onlyTempSet) {
	var iconBtn = $("#footer ul li.demoWithPremiumItems");
	if (initialButton) {
		var shyBadges = true;
		if (updateData) {
			setVal = Number(setVal);
			footerIconActiveChanger(setVal, "demoWithPremiumItems");
			if (setVal) {
				shyBadges = false;
			}
			//save
			editLocalUI(true, "demoWithPremiumItems", setVal);
			if (!onlyTempSet) {
				saveLocalPreferences("UI");
			}
		} else {
			var getCurStatus = Number(editLocalUI(false, "demoWithPremiumItems"));
			if (getCurStatus) {
				shyBadges = false;
			}

			footerIconActiveChanger(getCurStatus, "demoWithPremiumItems");
		}

		//action with menu badge
		if (shyBadges) {
			// $('#menu li sup').hide();

			$('#menu li[data-count-items="0"]').hide();
			$("#menu li sup.is_premium_group").hide();
			$(".element.is_demo_lock").hide();
		} else {
			// $('#menu li sup').show();
			$('#menu li[data-count-items="0"]').show();
			$("#menu li sup.is_premium_group").show();
			$(".element.is_demo_lock").show();
		}

		if ($(iconBtn).is(":hidden")) {
			iconBtn.show(); //show icon button
		}
	} else {
		iconBtn.hide();
	}
}

/**
 * Auto-resizing/auto-fit preview items (fit when resize window width)
 * @param {boolean} status On/Off
 */
function previewAutoResizingItems(status, onlyTempSet) {
	status = Number(status);
	footerIconActiveChanger(status, "autoFit");
	//save
	editLocalUI(true, "autoResizingItems", status);
	if (!onlyTempSet) {
		saveLocalPreferences("UI");
	}
}

function itemPreviewWebmPart(container, hasAudioVolume, append){
	var videoObject = container.find("video")[0];
	if(!videoObject){
		return 0;
	}
	videoObject.muted = !hasAudioVolume;
	videoObject.volume = hasAudioVolume;
	if(append){
		// var videoTypeO = currentTempPackageInsideOptionsSets && currentTempPackageInsideOptionsSets.use_webm_preview == 'mp4' ? '.mp4' : '.webm';
		
 		videoObject.play();
		// if (container.find("video.source-video").length === 0) {
		// 	var mp4Src = img_holder.attr("src").replace(/\.png$/i, videoTypeO);
		// 	var width = img_holder.outerWidth();
		// 	var height = img_holder.outerHeight();
		// 	var video = $('<video>', {
		// 		src: mp4Src,
		// 		autoplay: true,
		// 		loop: true,
		// 		poster: img_holder,
		// 		playsinline: true,
		// 		class: "source-video",
				

		// 	}).css({
		// 		width: width,

		// 		display: "block"
		// 	}).prop('muted', !hasAudioVolume).prop('volume', hasAudioVolume);
		// 	img_holder.hide();
		// 	container.append(video);
		// }
	}else{

		 videoObject.src = videoObject.src
		// videoObject.poster = img_holder.attr("poster");
		// container.find("video.source-video").remove();
		// img_holder.show();
	}

}

// функция обновления preview для item - WEBM video preview
function updateItemPreview(container, isFootageFile, isAudioFile, disableWebmItem, state, disableAudioVol) {
    // state: true = hover / активируем preview
    // state: false = убираем preview (mouseleave)
// флаг включения аудио
var webmPreviewAudio = false; // по дефолту звук выключен
    if (isFootageFile != "JPG" && isFootageFile != "PNG") {
 

            var hasAudioVolume = disableAudioVol ? false : Number(editLocalUI(false, "audioVolume")) / 100;
            if (state) {
                // при наведении
                if (
                  currentTempPackageInsideOptionsSets &&
                  currentTempPackageInsideOptionsSets.use_webm_preview &&
                  !isAudioFile &&
                  !disableWebmItem
                ) {
                  // var videoTypeO = currentTempPackageInsideOptionsSets.use_webm_preview == 'mp4' ? '.mp4' : '.webm';
                  // var mp4Src = img_holder.attr("src").replace(/\.png$/i, videoTypeO);

                  itemPreviewWebmPart(container, hasAudioVolume, true);
                  // if (container.find("video.source-video").length === 0) {
                  //        var width = img_holder.outerWidth();
                  //     var height = img_holder.outerHeight();
                  // 	var video = $('<video>', {
                  //         src: mp4Src,
                  //         autoplay: true,
                  //         loop: true,

                  //         playsinline: true,
                  //         class: "source-video",

                  //     }).css({
                  // 		width: width,

                  // 		display: "block"
                  // 	}).prop('muted', !hasAudioVolume).prop('volume', hasAudioVolume);
                  //     img_holder.hide();
                  //     container.append(video);
                  // }
                } else {
                  var img_holder = container.find("img.source");
                  var gifSrc = img_holder
                    .attr("src")
                    .replace(/\.png$/i, ".gif");
                  img_holder.attr("src", gifSrc);
                }

            } else {
                // при уходе мыши — сброс

                if (currentTempPackageInsideOptionsSets && currentTempPackageInsideOptionsSets.use_webm_preview && (!isAudioFile  &&  !disableWebmItem)) {
                    // container.find("video.source-video").remove();
                    // img_holder.show();
					itemPreviewWebmPart(container, hasAudioVolume, false);
                } else {

					var img_holder = container.find("img.source");
                    var pngSrc = img_holder.attr("src").replace(/\.gif$/i, ".png");
                    img_holder.attr("src", pngSrc);
                }
            }

    }
}

/**
 * Auto-play for preview
 * @param {boolean} autoplay true - png to gif, false gif to png
 * @param {boolean} forEach change preview for each
 */
function autoPlayPreviewChange(autoplay, forEach, onlyTempSet) {
	autoplay = Number(autoplay);

	if(autoplay && currentTempPackageInsideOptionsSets && currentTempPackageInsideOptionsSets.use_webm_preview){
        // включаем observer
        observerWebmPreviews();
	}else{
		        // выключаем observer
        destroyWebmObserver();
	}

	if (forEach) {
		$(".element").each(function () {
			//is footage check - do not need change src to gif if footage type is image
			var getItemArguments = $(this).attr("arguments") || "{}";
			   var parseArguments = parseAndGetArguments(getItemArguments);
      var isAudioFile = parseArguments.is_audio;
      var isFootageFile = parseArguments.is_footage;
	   var disableWebmItem = parseArguments.disable_webm_preview;
			// var isFootageFile = parseAndGetArguments(getItemArguments, "is_footage");

			// var img_holder = $(this).find("img.source");
			// var img_src = img_holder.attr("src");

				if (autoplay) {
					updateItemPreview($(this), isFootageFile, isAudioFile, disableWebmItem, true, true);
					// img_holder.attr("src", img_src.replace(/\.png$/i, ".gif"));
					$(this).attr("data-autoplayed", true);
				} else {
					// img_holder.attr("src", img_src.replace(/\.gif$/i, ".png"));
					updateItemPreview($(this), isFootageFile, isAudioFile, disableWebmItem, false, true);
					$(this).attr("data-autoplayed", null);
				}
		});
	}

	footerIconActiveChanger(autoplay, "autoplay");
	//save
	editLocalUI(true, "previewAutoPlay", autoplay);
	if (!onlyTempSet) {
		saveLocalPreferences("UI");
	}
}

/**
 * Click handler for footer buttons (add/remove active class - change icon)
 * @param {boolean} setActive set class or remove
 * @param {string} dataTypeIcon data-type of li item to change (globally)
 */
function footerIconActiveChanger(setActive, dataTypeIcon) {
	var jClass = $('#footer ul li[data-type="' + dataTypeIcon + '"]');
	if (setActive) {
		jClass.addClass("active");
	} else {
		jClass.removeClass("active");
	}
}

/**
 * Footer info text (item names and etc) when hover
 * @param {boolean} show True/False
 * @param {string} text Show text
 */
function footerInfoText(show, text) {
	var infoTextHTML = $("#footer .main_btn ul li.info_footer_text");

	if (show) {
		infoTextHTML.html(text);
		infoTextHTML.stop().show();
	} else {
		infoTextHTML.stop().hide();
	}
}

//#endregion

//#region FAVORITES

/**
 * Convert favorite string from JSX (Pref JSON file) to object
 * @param {string} favorites_string String as (ID1:ID2:ID3 ...)
 * @return {array} return empty array or with pieces
 */
function convertFavoritesStrToObj(favorites_string) {
	var createNFObj = {};
	if (favorites_string.toString().length > 0) {
		var splitChar = ":";
		var splitString = favorites_string.toString().split(splitChar);
		for (var index = 0; splitString[index]; index++) {
			var currentFID = splitString[index];
			createNFObj[currentFID] = true;
		}
	}
	return createNFObj;
}

/**
 * Convert favorite string to array
 * @param {string} favorites_string String as (ID1:ID2:ID3 ...)
 * @return {array} return empty array or with pieces
 */
function convertFavoritesStrToArr(favorites_string) {
	var createNFArr = [];
	if (favorites_string.toString().length > 0) {
		var splitChar = ":";
		var splitString = favorites_string.toString().split(splitChar);
		for (var index = 0; splitString[index]; index++) {
			var currentFID = splitString[index];
			createNFArr.push(currentFID);
		}
	}
	return createNFArr;
}

/**
 * Convert favorite array to string and insert to JSX from JS (Prefs)
 * @param {*} favorites_array Object with favorites ['ID1', 'ID2', 'ID3']
 * @return {string} Join object datas to string via (:) to get - ID1:ID2:ID3
 */
function convertFavoritesObjToStr(favorites_object) {
	var createNFStr = "";
	for (var key in favorites_object) {
		if (favorites_object.hasOwnProperty(key)) {
			if (favorites_object[key]) {
				createNFStr += key + ":";
			}
		}
	}
	return createNFStr;
}

/**
 * Favorite add html pinBorder or remove
 * @param {*} jQueryThis
 * @param {*} curElement
 * @param {*} manually
 * @param {*} customSetBoolean
 */
function favoriteHTMLEventHandler(jQueryThis, curElement, manually, customSetBoolean) {
	var setFavorite = false;
	if (manually) {
		setFavorite = customSetBoolean ? true : false;
	} else {
		setFavorite = jQueryThis.hasClass("active") ? false : true;
	}

	if (setFavorite) {
		curElement.addClass("pinBorder"); //this element
		jQueryThis.addClass("active").attr("tooltip", "Remove");
		return true;
	} else {
		curElement.removeClass("pinBorder"); //this element
		jQueryThis.removeClass("active").attr("tooltip", "Add to favorite"); //this favorite button
		return false;
	}
}

/**
 * Set in temp Obj favorites/delete and save
 * @param {*} add
 * @param {*} item_id
 */
function favoritesController(add, item_id) {
	if (add) {
		//add favorite
		//processing events when added to favorite
		doAddedFavorite();
		//do main
		currentPackFavoritesObject[item_id] = true;
	} else {
		//remove favorite
		try {
			delete currentPackFavoritesObject[item_id];
		} catch (e) {
			currentPackFavoritesObject[item_id] = false;
		}
	}
	//save preferences with delay
	saveLocalPreferences("Favorites");
}

//#endregion

//#region SYSTEM MESSAGE

function hideSystemMessage() {
	$(".systemMessage").stop().animate({ top: "-130px" }, 200);
}

/**
 * Create and show system message to user (with icon/title and text)
 * @param {string} title Main msg title
 * @param {string} message Text message
 * @param {string} type Type (logo/title color) - success, notify, error, info
 * @param {boolean} without_timeout default false, true - don't use auto hide
 * @param {boolean} stop_progress_sharp Stop any progress Sharp without fading animation
 */
function createMessage(title, message, type, without_timeout, stop_progress_sharp) {
	var makeMsgString = "";
	var timerMs = 2900;
	var speedMsgIn = 100;
	var speedMsgOut = 200;

	//icon
	if (!type) {
		type = "info";
	}
	makeMsgString += '<div class="i ' + type + '"></div>';
	//title
	makeMsgString += '<h1 class="' + type + '">' + title + "</h1>";
	//message
	makeMsgString += "<p>" + message + "</p><small></small>";
	//set new content to msg
	$(".systemMessage .content").html(makeMsgString);
	$(".systemMessage").stop().animate({ top: "0" }, speedMsgIn);

	//get closing text element from content
	var objCountingText = $(".systemMessage .content").find("small");

	//clear old timer
	clearTimeout(messageFadeTimer);
	//if not need without timer
	if (!without_timeout) {
		//show info about time to closing
		countingNumber(objCountingText, 6, 0, ["Auto-hide ", ""], 3950);
		//set new timer with animate off
		messageFadeTimer = setTimeout(function () {
			$(".systemMessage").stop().animate({ top: "-130px" }, speedMsgOut);
		}, timerMs);
	} else {
		objCountingText.text("click to close");
	}
	//stop and hide any progress bars (fading, or sharp)
	var sharpStop = stop_progress_sharp ? "_STOP" : "";
	setupProgressBar(false, sharpStop);
	return true;

	//moved to events.js
	//event handler - click to close message
	/*     $('.systemMessage .content small').on('click', function(){
            $('.systemMessage').stop().animate({'top': '-130px'}, speedMsgOut);
        }); */
}

/**
 * Counting number animation for sys message
 * @function createMessage
 * @param {*} sourceToAnimate object tag small for animation
 * @param {number} countMin Counting from
 * @param {number} countMax Counting to
 * @param {array} messageCounting Text ['prefix text ', 'endfix text']
 * @param {number} durationCounting Milliseconds duration 1000ms = 1s (default: 3150ms)
 */
function countingNumber(sourceToAnimate, countMin, countMax, messageCounting, durationCounting) {
	var $this = sourceToAnimate;
	$({ countNum: countMin }).animate(
		{
			countNum: countMax
		},
		{
			duration: durationCounting ? durationCounting : 3150,
			easing: "linear",
			step: function () {
				if (messageCounting) {
					$this.html(messageCounting[0] + '<div class="nums">' + Math.floor(this.countNum) + '<div class="circle"></div></div>' + messageCounting[1]);
				} else {
					$this.html(Math.floor(this.countNum));
				}
			}
			/*         complete: function() {
                        $this.text(this.countNum);
                    } */
		}
	);
}

//#endregion

/* Only for engine _PRESET_MANAGER */
function eventWatcherForCustomizerChanges(curContentType) {
	try {
		/* Only for engine _PRESET_MANAGER */
		var engines = softAssetsByAppID[currentPackShortAppID]["engine"];
		if (engines[4] == currentPackEngineType || engines[5] == currentPackEngineType) {
			if (previousLayersEventWaitingInterval) {
				clearInterval(previousLayersEventWaitingInterval);
			}

			if (curContentType == "ATOM_CUSTOMIZER_GROUP") {
				previousLayersEventWaitingInterval = setInterval(function () {
					csInterface.evalScript("customizeHandler('_GET', 'check_event_layers')", function (result) {
						if (result != "undefined") {
							var parsed = JSON.parse(result);
							if (generatePackageContent("customizer_PM", currentTempPackagePrefab, parsed)) {
								readyUISettingsState();
							}
							contentSwitcher("ATOM_CUSTOMIZER_GROUP", true);
						}
					});
				}, 1200);
			}
		}
	} catch (e) {
		createMessage("Customizer Event", "Error: " + e.message, "error", true, true);
	}
}

//#region CUSTOMIZER (HANDLER FUNCTIONS)

/**
 * Create cuztomizer panel with options inside Customizer Window (for all applications)
 * @param {string} getSetPointerCustomizer String with current customizer ID - ATOM_CUSTOMIZER_GROUP
 */
function customizerIComposer(getSetPointerCustomizer) {
	try {
		csInterface.evalScript("customizeHandler('_GET')", function (result) {
			if (itemResponseListFromEngine(result)) {
				items.viewReset();
				var parsed = JSON.parse(result);
				var engines = softAssetsByAppID[currentPackShortAppID]["engine"];
				switch (currentPackShortAppID) {
					case "AE":
						//_TEXT_PRESETS
						if (engines[0] == currentPackEngineType) {
							if (generatePackageContent("customizer_TP", currentTempPackagePrefab, parsed)) {
								readyUISettingsState();
							}
						}
						//_COMPOSER or _TEXT_ANIMATOR
						if (engines[1] == currentPackEngineType || engines[3] == currentPackEngineType) {
							generateCustomizeContent_AfterEffects(parsed);
						}
						//_COMPOSER or _TEXT_ANIMATOR
						if (engines[4] == currentPackEngineType || engines[5] == currentPackEngineType) {
							if (generatePackageContent("customizer_PM", currentTempPackagePrefab, parsed)) {
								readyUISettingsState();
							}
						}
						break;
					case "PR":
						//_COMPOSER
						if (engines[0] == currentPackEngineType) {
							generateCustomizeContent_PremierePro(parsed);
						}
						break;
				}

				contentSwitcher(getSetPointerCustomizer, true);
			} else {
				$('#content .coBlock[data-view="' + getSetPointerCustomizer + '"]').html("<strong>No customizer</strong>");
				contentSwitcher(false, false);
			}
		});
	} catch (e) {
		createMessage("Customizer Error", "Error: " + e.message, "error", true, true);
	}
}

function customizerRequestCustom(arg, pointPlace) {
	var getSetPointerCustomizer = pointPlace ? pointPlace : "ATOM_CUSTOMIZER_GROUP";
	try {
		csInterface.evalScript("customizeHandler('_GET', '" + arg + "')", function (result) {
			if (itemResponseListFromEngine(result)) {
				var parsed = JSON.parse(result);
				// var engines = softAssetsByAppID[currentPackShortAppID]['engine'];
				switch (currentPackShortAppID) {
					case "AE":
						generateCustomizeContent_AfterEffects(parsed, pointPlace);
					case "PR":
						generateCustomizeContent_PremierePro(parsed, pointPlace);
						break;
				}
				contentSwitcher(getSetPointerCustomizer, true);
			} else {
				$('#content .coBlock[data-view="' + getSetPointerCustomizer + '"]').html("<strong>No customizer</strong>");
				contentSwitcher(false, false);
			}
		});
	} catch (e) {
		createMessage("Customizer PX Error", "Error: " + e.message, "error", true, true);
	}
}

/**
 *  Parse and create customize properties for After Effects only (pseudo/default effects)
 * @version 1.0 Create from AtomX 3.0.5
 * @param {string} MG_type Effect type from JSX (Slider/Colors and etc)
 * @param {object} objectData All paramaters to create html data for property
 * @returns
 */
function parseCustomizeProperties_AfterEffects(MG_type, objectData) {
	var print = "";

	var pseudoFxNameEndfix = { css: "", text: "" };
	if (objectData.fx_name_endfix) {
		pseudoFxNameEndfix = {
			css: ' <span class="pseudoFxNamePrefix">' + objectData.fx_name_endfix + "</span>",
			text: " [" + objectData.fx_name_endfix + "]"
		};
	}

	//has custom min/max for Pseudo Effector fx - rewrite also global pack custom ranges
	if (objectData.custom_ranges) {
		objectData.slider_ranges = [objectData.custom_ranges[0], objectData.custom_ranges[1], 1];
	}

	switch (MG_type) {
		case "Slider":
			print += '<small><div class="icon slider"></div>' + objectData.title + pseudoFxNameEndfix.css + "</small>";
			print += '<div fx-number="' + objectData.fx_number + '" fx-extra-pseudo="' + objectData.fx_pseudo_prop + '">';
			print +=
				'<input tooltip="' +
				objectData.fx_value +
				'" tooltip-position="top" tooltip-type="customizerRange" name="slider_' +
				objectData.fx_number +
				'" type="range" class="style_customize_slider noselect" min="' +
				objectData.slider_ranges[0] +
				'" max="' +
				objectData.slider_ranges[1] +
				'" step="' +
				objectData.slider_ranges[2] +
				'" value="' +
				objectData.fx_value +
				'"/>';
			print += "</div>";

			objectData.containerSliders.push(print);
			break;
		case "Checkbox":
			var checkboxChecked = objectData.fx_value == 1 ? "checked" : "";

			print +=
				'<label fx-number="' +
				objectData.fx_number +
				'" fx-extra-pseudo="' +
				objectData.fx_pseudo_prop +
				'" class="labelBox">' +
				objectData.title +
				pseudoFxNameEndfix.css;
			print += '<input type="checkbox" name="checkbox_name_' + objectData.fx_number + '" ' + checkboxChecked + ">";
			print += '<span class="checkmark"></span>';
			print += "</label>";

			objectData.containerCheckbox.push(print);
			break;
		case "Point3D":
			print += '<small><div class="icon point3d"></div>' + objectData.title + pseudoFxNameEndfix.css + "</small>";
			print += '<div fx-number="' + objectData.fx_number + '" fx-extra-pseudo="' + objectData.fx_pseudo_prop + '" class="multiSlidersXYZ clearfix">';
			print +=
				'<input tooltip="' +
				objectData.fx_value.split(",")[0] +
				'" tooltip-position="top" tooltip-type="customizerRange" name="point3d_name1_' +
				objectData.fx_number +
				'" type="range" class="style_customize_slider noselect" min="' +
				objectData.slider_ranges[0] +
				'" max="' +
				objectData.slider_ranges[1] +
				'" value="' +
				objectData.fx_value.split(",")[0] +
				'"/>';
			print +=
				'<input tooltip="' +
				objectData.fx_value.split(",")[1] +
				'" tooltip-position="top" tooltip-type="customizerRange" name="point3d_name2_' +
				objectData.fx_number +
				'" type="range" class="style_customize_slider noselect" min="' +
				objectData.slider_ranges[0] +
				'" max="' +
				objectData.slider_ranges[1] +
				'" value="' +
				objectData.fx_value.split(",")[1] +
				'"/>';
			print +=
				'<input tooltip="' +
				objectData.fx_value.split(",")[2] +
				'" tooltip-position="top" tooltip-type="customizerRange" name="point3d_name3_' +
				objectData.fx_number +
				'" type="range" class="style_customize_slider noselect" min="' +
				objectData.slider_ranges[0] +
				'" max="' +
				objectData.slider_ranges[1] +
				'" value="' +
				objectData.fx_value.split(",")[2] +
				'"/>';
			print += "</div>";

			objectData.containerSliders.push(print);
			break;
		case "Point":
			print += '<small><div class="icon point"></div>' + objectData.title + pseudoFxNameEndfix.css + "</small>";
			print += '<div fx-number="' + objectData.fx_number + '" fx-extra-pseudo="' + objectData.fx_pseudo_prop + '" class="multiSlidersXY clearfix">';
			print +=
				'<input tooltip="' +
				objectData.fx_value.split(",")[0] +
				'" tooltip-position="top" tooltip-type="customizerRange" name="point_name1_' +
				objectData.fx_number +
				'" type="range" class="style_customize_slider noselect" min="' +
				objectData.slider_ranges[0] +
				'" max="' +
				objectData.slider_ranges[1] +
				'" value="' +
				objectData.fx_value.split(",")[0] +
				'"/>';
			print +=
				'<input tooltip="' +
				objectData.fx_value.split(",")[1] +
				'" tooltip-position="top" tooltip-type="customizerRange" name="point_name2_' +
				objectData.fx_number +
				'" type="range" class="style_customize_slider noselect" min="' +
				objectData.slider_ranges[0] +
				'" max="' +
				objectData.slider_ranges[1] +
				'" value="' +
				objectData.fx_value.split(",")[1] +
				'"/>';
			print += "</div>";

			objectData.containerSliders.push(print);
			break;
		case "Color":
			// var genColorNameInstance = 'color_' + objectData.fx_number;
			var genColorPickerInstanceId = "";

			//add Custom number property for pseudo effects
			if (objectData.fx_pseudo_prop) {
				genColorPickerInstanceId = "colorPicker_" + objectData.fx_number + "_" + objectData.fx_pseudo_prop;
			} else {
				genColorPickerInstanceId = "colorPicker_" + objectData.fx_number + "_1";
			}

			var getHexColor = rgb2hex(objectData.fx_value.split(",")[0], objectData.fx_value.split(",")[1], objectData.fx_value.split(",")[2]).toString();
			print +=
				'<div fx-number="' +
				objectData.fx_number +
				'" fx-extra-pseudo="' +
				objectData.fx_pseudo_prop +
				'" style="width: REPLACE_COLOR_BLOCK_WIDTH;" tooltip="' +
				objectData.title +
				pseudoFxNameEndfix.text +
				'" tooltip-position="top" tooltip-type="customizer">';
			print += '<input name="' + genColorPickerInstanceId + '" type="text" id="' + genColorPickerInstanceId + '" value="' + getHexColor + '"/>';
			print += "</div>";

			//add # to pick as ID in colorPicker
			objectData.colorControlInstanceInit.push("#" + genColorPickerInstanceId);
			objectData.containerColor.push(print);
			break;
		case "Angle":
			//no pseudo fx min, max/any - set default
			if (!objectData.custom_ranges) {
				objectData.slider_ranges[0] = -360;
				objectData.slider_ranges[1] = 360;
			}

			print += '<small><div class="icon angle"></div>' + objectData.title + pseudoFxNameEndfix.css + "</small>";
			print += '<div fx-number="' + objectData.fx_number + '" fx-extra-pseudo="' + objectData.fx_pseudo_prop + '">';
			print +=
				'<input tooltip="' +
				objectData.fx_value +
				'" tooltip-position="top" tooltip-type="customizerRange" name="slider_' +
				objectData.fx_number +
				'" type="range" class="style_customize_slider noselect" min="' +
				objectData.slider_ranges[0] +
				'" max="' +
				objectData.slider_ranges[1] +
				'" value="' +
				objectData.fx_value +
				'"/>';
			print += "</div>";

			objectData.containerSliders.push(print);
	}
	return print;
}

/**
 * Generate customize content from JSX app for After Effects (AE)
 * @param {*} obj_data
 */
function generateCustomizeContent_AfterEffects(obj_data, customPlace) {
	try {
		var compInfoData = obj_data[0];
		var dataContent = obj_data[1];
		var controlRangeSetByNames = obj_data[2];
		var textsObjData = obj_data[3];
		var placeholdersObjData = obj_data[4];
		var customizerCommentsObjData = obj_data[5];

		//save to temp var - compInfoData
		currentComposerCompCustomizer = compInfoData;

		var customize_html_line = "";

		var colorControlInstanceInitialize = [];
		var effectNumber_cycle = 1;

		//arr with types of properties
		var arrContainerFor_color = [];
		var arrContainerFor_slidersAndPoints = [];
		var arrContainerFor_checkbox = [];

		//Create Tab Buttons
		customize_html_line += '<ul class="tabs-nav">';
		if (textsObjData || placeholdersObjData) {
			//if text exists - add menu button
			customize_html_line += '<li class="tab-active" data="sp_customizer_main">Customize</li>';
			customize_html_line += '<li data="sp_customizer_edit_text">Text / Holders</li>';
		} else {
			if (customPlace == "ATOM_CUSTOMIZER_GROUP_PM_PICKS") {
				customize_html_line +=
					'<li style="width:100%;text-align:left;padding-left:10px;" switch="back_pm_previews" data="sp_customizer_main">&laquo; Back to Preview</li>';
			} else {
				customize_html_line += '<li style="width:100%" class="tab-active" data="sp_customizer_main">Customize</li>';
			}
		}
		customize_html_line += "</ul>";

		//Start Tab Content
		customize_html_line += '<div class="tabs-stage"><div data="sp_customizer_main" style="display: block;">';

		customize_html_line += '<ul class="customizeElement">';

		//alert(dataContent["Color 1"][1].split(',')[0]);
		for (var control in dataContent) {
			var MG_propertyName = control;
			var MG_effect_type = dataContent[control][0];
			var MG_main_data = dataContent[control][1];

			var lineSaver = "";

			//set custom ranges from - to (get from package options by prop name)
			var setRanges = [-500, 500, 1];
			//Rewrite range selector
			if (controlRangeSetByNames && controlRangeSetByNames[MG_propertyName]) {
				setRanges = controlRangeSetByNames[MG_propertyName];
			}

			/* Pseudo effects */
			if (MG_effect_type == "pseudo") {
				/* Start new cycle inside current cycle for parse properties of pseudo effect */

				for (var pseudoFxName in MG_main_data) {
					var MG_type = MG_main_data[pseudoFxName].type;
					var MG_value = MG_main_data[pseudoFxName].data;
					var MG_prop_fx_number = MG_main_data[pseudoFxName].prop_number;
					var MG_has_min_max = MG_main_data[pseudoFxName].custom_ranges; //Has custom min/max values for Pseudo FX

					lineSaver += parseCustomizeProperties_AfterEffects(
						MG_type, //parse by fx types
						{
							/* MAIN PARAMETERS */
							title: pseudoFxName,
							fx_name_endfix: MG_propertyName,
							fx_number: effectNumber_cycle,
							fx_value: MG_value,
							fx_pseudo_prop: MG_prop_fx_number,
							slider_ranges: setRanges,
							custom_ranges: MG_has_min_max,

							/* PUSH CONTAINERS (checkboxes/sliders/pointer/colors) */
							containerSliders: arrContainerFor_slidersAndPoints,
							containerCheckbox: arrContainerFor_checkbox,
							containerColor: arrContainerFor_color,
							colorControlInstanceInit: colorControlInstanceInitialize
						}
					);
				}
			} else {
				/* Default effects */
				var MG_type = MG_main_data.type;
				var MG_value = MG_main_data.data;

				lineSaver += parseCustomizeProperties_AfterEffects(
					MG_type, //parse by fx types
					{
						/* MAIN PARAMETERS */
						title: MG_propertyName,
						fx_number: effectNumber_cycle,
						fx_value: MG_value,
						fx_pseudo_prop: "",
						slider_ranges: setRanges,

						/* PUSH CONTAINERS (checkboxes/sliders/pointer/colors) */
						containerSliders: arrContainerFor_slidersAndPoints,
						containerCheckbox: arrContainerFor_checkbox,
						containerColor: arrContainerFor_color,
						colorControlInstanceInit: colorControlInstanceInitialize
					}
				);
			}

			effectNumber_cycle++; //up
		}

		//COLORS BLOCK - resize for panel layout
		if (arrContainerFor_color.length > 0) {
			var new_clm = "";
			var countingWidthDevider = 100 / arrContainerFor_color.length + "%";
			new_clm += '<li><div class="title"><div class="icon color"></div>Colors</div>';
			new_clm += '<div type="colors" class="block colors clearfix">';
			new_clm += arrContainerFor_color.join("").replace(/REPLACE_COLOR_BLOCK_WIDTH/g, countingWidthDevider);
			new_clm += "</div></li>";
			// alert(new_clm);

			customize_html_line += new_clm;
		}

		//CHECKBOXES BLOCK
		if (arrContainerFor_checkbox.length > 0 || arrContainerFor_slidersAndPoints.length > 0) {
			var new_clm = "<li>";
			new_clm += '<div class="title"><div class="icon control"></div>Controls</div>';

			//CHECBOXES
			if (arrContainerFor_checkbox.length > 0) {
				new_clm += '<div type="checkbox" class="block">';
				new_clm += arrContainerFor_checkbox.join("");
				new_clm += "</div>";
			}
			//SLIDERS/POINTS
			if (arrContainerFor_slidersAndPoints.length > 0) {
				new_clm += '<div type="sliderPoint" class="block">';
				new_clm += arrContainerFor_slidersAndPoints.join("");
				new_clm += "</div>";
			}

			customize_html_line += new_clm + "</li>";
		}

		/* Customizer show comments to user (main/text holders differently) */
		if (customizerCommentsObjData && customizerCommentsObjData[0]) {
			var new_show_comment = '<li class="commentNotify">';
			new_show_comment += '<div class="title"><div class="icon notify_comment"></div>Comment</div>';

			new_show_comment += '<div class="tableCell">';
			new_show_comment += '<textarea scrollbar readonly="true" type="text">' + customizerCommentsObjData[0] + "</textarea>";
			new_show_comment += "</div>";
			customize_html_line += new_show_comment + "</li>";
		}

		customize_html_line += "</ul>"; //end UL
		if (customPlace != "ATOM_CUSTOMIZER_GROUP_PM_PICKS") {
			customize_html_line += '<div class="btnOpenCustomizer">Open default customizer</div>'; //Btn - open default customizer
		}

		customize_html_line += "</div>"; //END CUSTOMIZER BLOCK

		//EDIT TEXT TAB

		if (textsObjData || placeholdersObjData) {
			customize_html_line += '<div data="sp_customizer_edit_text">';

			/* Placeholders */
			if (placeholdersObjData) {
				customize_html_line += '<ul class="customizeElement placeholderEditor">';
				for (var holderName in placeholdersObjData) {
					var holderCompId = placeholdersObjData[holderName];
					customize_html_line += '<li comp-id="' + holderCompId + '">';
					customize_html_line += "<span>" + holderName + "<sub>Click to open</sub></span>"; //add comp name
					customize_html_line += "";

					customize_html_line += "</li>";
				}
				customize_html_line += "</ul>";
			}

			/* Text Holders */
			if (textsObjData) {
				customize_html_line += '<ul class="customizeElement textEditor">';
				for (var text_comp in textsObjData) {
					var compNameWithText = text_comp;
					var textLayerName = textsObjData[text_comp];

					// customize_html_line += '<ul class="buttons"><strong><small style="opacity:0.6">comp:</small> '+compNameWithText+'</strong>'; //add comp name

					for (var text_layer = 0; text_layer < textLayerName.length; text_layer++) {
						var thisTextLayerName = textLayerName[text_layer][0];
						var thisTextLayerId = textLayerName[text_layer][1];
						var thisTextLayerCompId = textLayerName[text_layer][2];

						//if no values
						if (thisTextLayerName == "") {
							thisTextLayerName = "NONE";
							titleTipFull = "NONE";
						}

						customize_html_line += '<li comp-id="' + thisTextLayerCompId + '" layer-id="' + thisTextLayerId + '">';
						customize_html_line += '<div class="tableCell">';
						customize_html_line += '<textarea scrollbar type="text" name="editText_' + thisTextLayerId + '">' + thisTextLayerName + "</textarea>";
						//'<input type="text" name="editText_' + thisTextLayerId + '" value="' + thisTextLayerName + '"/>';
						customize_html_line += "</div>";
						customize_html_line += '<div class="tableCell">';
						customize_html_line += '<div tooltip="Open original" tooltip-position="left" tooltip-type="customizer" class="btnEditTextOrigin"></div>';
						customize_html_line += "</div>";
						customize_html_line += "</li>";
					}
				}
				customize_html_line += "</ul>";

				/* Customizer show comments to user (Text Holders section) */
				if (customizerCommentsObjData && customizerCommentsObjData[1]) {
					customize_html_line += '<ul class="customizeElement">';
					var new_show_comment = '<li class="commentNotify">';
					new_show_comment += '<div class="title"><div class="icon notify_comment"></div>Comment</div>';

					new_show_comment += '<div class="tableCell">';
					new_show_comment += '<textarea scrollbar readonly="true" type="text">' + customizerCommentsObjData[1] + "</textarea>";
					new_show_comment += "</div>";
					customize_html_line += new_show_comment + "</li>";
					customize_html_line += "</ul>";
				}
			}
			customize_html_line += "</div>";
		}

		customize_html_line += "</div>"; //end tabs-stage

		customPlace = customPlace ? customPlace : "ATOM_CUSTOMIZER_GROUP";
		$('#content .coBlock[data-view="' + customPlace + '"]').html(customize_html_line);

		//Binding color inputs with colorLib (Spectrum)
		for (var i = 0; i < colorControlInstanceInitialize.length; i++) {
			var getFullColorID = colorControlInstanceInitialize[i].toString();
			$(getFullColorID).spectrum({
				type: "text",
				showPalette: false,
				showInput: true,
				showInitial: true,
				showButtons: false,
				allowEmpty: false,
				showAlpha: false, //disable alpha
				move: function (tinycolor) {
					//get fx-number, double parent than in other inputs (coz color library spectrum dynamically created container and drop input into)
					var getFxNumber = $(this).parent().parent().attr("fx-number");
					var getFxExtraPseudoIndex = $(this).parent().parent().attr("fx-extra-pseudo"); //for Pseudo Effects
					var setNewValue = convertColorRgbToAppSystem(tinycolor.toRgb());

					sendToUpdateCustomizeChanges("edit_customizer", setNewValue, getFxNumber, currentComposerCompCustomizer, getFxExtraPseudoIndex);
				}
			});
		}
		return true;
	} catch (e) {
		createMessage("CustomizerAE Form Error", e.message, "error", true, true);
	}
}

/**
 * Generate customize content from JSX app for Premiere Pro (PR)
 * @param {*} obj_data
 */
function generateCustomizeContent_PremierePro(obj_data) {
	try {
		var itemOnTimeLine = obj_data[0];
		var dataContent = obj_data[1];
		var controlRangeSetByNames = obj_data[2];
		var textFields = obj_data[3];

		//save to temp var - itemOnTimeLine
		currentComposerCompCustomizer = itemOnTimeLine;

		var customize_html_line = "";

		var colorControlInstanceInitialize = [];

		//arr with types of properties
		var arrContainerFor_color = [];
		var arrContainerFor_slidersAndPoints = [];
		var arrContainerFor_checkbox = [];

		//Create Tab Buttons
		// customize_html_line += '<ul class="tabs-nav"><li class="tab-active" data="sp_customizer_main">Customize</li><li data="sp_customizer_edit_text">Edit Text</li></ul>';

		//Create Tab Buttons
		customize_html_line += '<ul class="tabs-nav">';
		if (textFields) {
			//if text exists - add menu button
			customize_html_line += '<li class="tab-active" data="sp_customizer_main">Customize</li>';
			customize_html_line += '<li data="sp_customizer_edit_text">Edit Text</li>';
		} else {
			customize_html_line += '<li style="width:100%" class="tab-active" data="sp_customizer_main">Customize</li>';
		}
		customize_html_line += "</ul>";

		//Start Tab Content
		customize_html_line += '<div class="tabs-stage"><div data="sp_customizer_main" style="display: block;">';

		customize_html_line += '<ul class="customizeElement">';

		for (var control in dataContent) {
			var MG_propertyName = control;
			var MG_propIndex = dataContent[control][0];
			var MG_type = dataContent[control][1];
			var MG_value = dataContent[control][2];
			var lineSaver = "";

			var specialValueIndexChangeType = "";

			//set custom ranges from - to (get from package options by prop name)
			var setRanges = [-500, 500, 1];
			if (controlRangeSetByNames && controlRangeSetByNames[MG_propertyName]) {
				setRanges = controlRangeSetByNames[MG_propertyName];

				//change type via pack inside options
				if (setRanges[3]) {
					MG_type = setRanges[3];

					if (MG_type == "Slider") {
						//from Point to Slider
						MG_value = MG_value[0];
						specialValueIndexChangeType = 'value-index="double"';
					}
				}
			}

			switch (MG_type) {
				case "Slider":
					lineSaver += '<small><div class="icon slider"></div>' + MG_propertyName + "</small>";
					lineSaver += '<div prop-type="' + MG_type + '" fx-number="' + MG_propIndex + '">';
					lineSaver +=
						"<input " +
						specialValueIndexChangeType +
						' tooltip="' +
						Math.round(MG_value) +
						'" tooltip-position="top" tooltip-type="customizerRange" name="slider_' +
						MG_propIndex +
						'" type="range" class="style_customize_slider noselect" min="' +
						setRanges[0] +
						'" max="' +
						setRanges[1] +
						'" step="' +
						setRanges[2] +
						'" value="' +
						MG_value +
						'"/>';
					lineSaver += "</div>";

					arrContainerFor_slidersAndPoints.push(lineSaver);
					break;
				case "Checkbox":
					var checkboxChecked = MG_value == 1 ? "checked" : "";

					lineSaver += '<label prop-type="' + MG_type + '" fx-number="' + MG_propIndex + '" class="labelBox">' + MG_propertyName;
					lineSaver += '<input type="checkbox" name="checkbox_name_' + MG_propIndex + '" ' + checkboxChecked + ">";
					lineSaver += '<span class="checkmark"></span>';
					lineSaver += "</label>";

					arrContainerFor_checkbox.push(lineSaver);
					break;
				case "Color":
					//get only RGB (default from Premiere ARGB - first alpha channel)

					var getHexColor = convertColorArgbToHexPR(MG_value);
					lineSaver +=
						'<div prop-type="' +
						MG_type +
						'" fx-number="' +
						MG_propIndex +
						'" style="width: REPLACE_COLOR_BLOCK_WIDTH;" tooltip="' +
						MG_propertyName +
						'" tooltip-position="bottom" tooltip-type="customizer">';
					lineSaver += '<input name="color_' + MG_propIndex + '" type="text" id="colorPicker_' + MG_propIndex + '" value="' + getHexColor + '"/>';
					lineSaver += "</div>";

					colorControlInstanceInitialize.push(MG_propIndex);
					arrContainerFor_color.push(lineSaver);
					break;
				case "Point":
					lineSaver += '<small><div class="icon point"></div>' + MG_propertyName + "</small>";
					lineSaver += '<div prop-type="' + MG_type + '" fx-number="' + MG_propIndex + '" class="multiSlidersXY clearfix">';
					lineSaver +=
						'<input value-index="1" tooltip="' +
						MG_value[0] +
						'" tooltip-position="top" tooltip-type="customizerRange" name="point_name1_' +
						MG_propIndex +
						'" type="range" class="style_customize_slider noselect" min="' +
						setRanges[0] +
						'" max="' +
						setRanges[1] +
						'" value="' +
						MG_value[0] +
						'"/>';
					lineSaver +=
						'<input value-index="2" tooltip="' +
						MG_value[1] +
						'" tooltip-position="top" tooltip-type="customizerRange" name="point_name2_' +
						MG_propIndex +
						'" type="range" class="style_customize_slider noselect" min="' +
						setRanges[0] +
						'" max="' +
						setRanges[1] +
						'" value="' +
						MG_value[1] +
						'"/>';
					lineSaver += "</div>";

					arrContainerFor_slidersAndPoints.push(lineSaver);
					break;

				//case "None":
			}
		}

		//COLORS BLOCK
		if (arrContainerFor_color.length > 0) {
			var new_clm = "";
			var countingWidthDevider = 100 / arrContainerFor_color.length + "%";
			new_clm += '<li><div class="title"><div class="icon color"></div>Colors</div>';
			new_clm += '<div type="colors" class="block colors clearfix">';
			new_clm += arrContainerFor_color.join("").replace(/REPLACE_COLOR_BLOCK_WIDTH/g, countingWidthDevider);
			new_clm += "</div></li>";
			// alert(new_clm);

			customize_html_line += new_clm;
		}

		//CHECKBOXES BLOCK
		if (arrContainerFor_checkbox.length > 0 || arrContainerFor_slidersAndPoints.length > 0) {
			var new_clm = "<li>";
			new_clm += '<div class="title"><div class="icon control"></div>Controls</div>';

			//CHECBOXES
			if (arrContainerFor_checkbox.length > 0) {
				new_clm += '<div type="checkbox" class="block">';
				new_clm += arrContainerFor_checkbox.join("");
				new_clm += "</div>";
			}
			//SLIDERS/POINTS
			if (arrContainerFor_slidersAndPoints.length > 0) {
				new_clm += '<div type="sliderPoint" class="block">';
				new_clm += arrContainerFor_slidersAndPoints.join("");
				new_clm += "</div>";
			}

			customize_html_line += new_clm + "</li>";
		}

		customize_html_line += "</ul>"; //end UL
		customize_html_line += "</div>"; //END CUSTOMIZER BLOCK

		//EDIT TEXT TAB

		if (textFields) {
			customize_html_line += '<div data="sp_customizer_edit_text">';
			customize_html_line += '<ul class="customizeElement textEditor">';

			for (var text_comp in textFields) {
				var compNameWithText = text_comp;
				var textIndex = textFields[text_comp][0];
				var textValue = textFields[text_comp][1];

				//if no values
				if (textValue == "") {
					textValue = "NONE";
					titleTipFull = "NONE";
				}

				customize_html_line += '<li index-id="' + textIndex + '">';
				customize_html_line += '<div class="tableCell">';
				customize_html_line += '<textarea type="text" name="editText_' + textIndex + '">' + textValue + "</textarea>";
				// customize_html_line += '<input type="text" name="editText_' + textIndex + '" value="' + textValue + '"/>';
				customize_html_line += "</div>";
				customize_html_line += '<div class="tableCell">';
				// customize_html_line += '<div tooltip="Open original" tooltip-position="left" tooltip-type="customizer" class="btnEditTextOrigin"></div>';
				customize_html_line += "</div>";
				customize_html_line += "</li>";
			}

			customize_html_line += "</ul></div>"; //end UL and EDIT TEXT BLOCK
		}

		customize_html_line += "</div>"; //end tabs-stage

		$('#content .coBlock[data-view="ATOM_CUSTOMIZER_GROUP"]').html(customize_html_line);

		//Binding color inputs with colorLib (Spectrum)
		for (var i = 0; i < colorControlInstanceInitialize.length; i++) {
			var getFullColorID = "#colorPicker_" + colorControlInstanceInitialize[i];
			$(getFullColorID).spectrum({
				type: "text",
				showPalette: false,
				showInput: true,
				showInitial: true,
				showButtons: false,
				allowEmpty: false,
				showAlpha: false, //disable alpha
				move: function (tinycolor) {
					//get fx-number, double parent than in other inputs (coz color library spectrum dynamically created container and drop input into)
					var getFxNumber = $(this).parent().parent().attr("fx-number");
					var setNewValue = tinycolor.toRgb();

					sendToUpdateCustomizeChanges("Color", [setNewValue["r"], setNewValue["g"], setNewValue["b"]], getFxNumber, currentComposerCompCustomizer);
				}
			});
		}
		return true;
	} catch (e) {
		createMessage("CustomizerPR Form Error", e.message, "error", true, true);
	}
}

/**
 * Text Presets Customizer [AE] - MASS ACTIONS
 * @param {string} attr_data_type IN/OUT/BOTH
 * @param {boolean} by_one if by one
 */
function TP_updateCustomizerCountButtons(attr_data_type, by_one) {
	var get_count_old = 0;
	var both_name = "IN/OUT";

	$(".coBlock ul.customizeElement.TPMassAction li .block div").each(function (e) {
		var d_type = $(this).attr("data");
		var d_value = $(this).attr("count");
		if (attr_data_type == "BOTH") {
			//each if global BOTH
			if (d_type == "BOTH") {
				d_type = both_name;
			}
			$(this).html(d_type + " <sup>[0]</sup>");
			$(this).attr("count", 0);
		} else {
			if (d_type == attr_data_type) {
				get_count_old = d_value;

				var set_this_value = 0;
				if (by_one == true) {
					get_count_old = get_count_old - 1;
					set_this_value = get_count_old;
				}
				$(this).html(d_type + " <sup>[" + set_this_value + "]</sup>");
				$(this).attr("count", set_this_value);
			}
			if (d_type == "BOTH") {
				var set_both = Number(d_value - get_count_old);
				if (by_one == true) {
					set_both = Number(d_value - 1);
				}

				$(this).html(both_name + " <sup>[" + set_both + "]</sup>");
				$(this).attr("count", set_both);
			}
		}

		if ($(this).attr("count") == 0) {
			$(this).addClass("disabled");
		}
	});
}

/**
 * Send customize changes to JSX in Application with delay (90ms)
 * @param {*} type
 * @param {*} newValue
 * @param {*} fxNumber
 * @param {*} curCompInfo
 */
async function sendToUpdateCustomizeChanges(type, newValue, fxNumber, curCompInfo, valueIndex) {
	var collectedToSendObj = {
		type: type,
		value: newValue,
		arg: fxNumber,
		comp: curCompInfo,
		valueIndex: valueIndex
	};

	_sleep(90); //Anti-flood trick (need better solution in future)

	if (newValue === "resize_items") {
		const parsedPayload = await evalES(`$._copyPasteSystem.getResolution()`)
			.then((data) => {
				return JSON.parse(data);
			})
			.catch(console.log);
		console.log(parsedPayload);
		if (parsedPayload && !parsedPayload.isResolutionExists) {
			await prepareAdjustmentProject(parsedPayload.resolution);
			await sleep(1000);
			const ptxPath = isWin32() ? getFolderDocumentsCommonPTX().replace(/\\/g, "\\\\") : getFolderDocumentsCommonPTX().replace(/\\/g, "/");
			await evalES(`$._copyPasteSystem.importAdjustmentSequence("${ptxPath}")`).then(console.log);
			await sleep(1000);
		}
		csInterface.evalScript(`$._copyPasteSystem.resizeTransition()`, () => {
			itemResponseListFromEngine("RESIZED");
		});
	} else {
		csInterface.evalScript('customizeHandler("_SET", ' + JSON.stringify(collectedToSendObj) + ")", function (result) {
			itemResponseListFromEngine(result);
		});
	}
}

/**
 * Send customize changes to JSX in Application with delay (90ms)
 * @param {*} type
 * @param {*} newValue
 * @param {*} fxNumber
 * @param {*} curCompInfo
 */
function sendToUpdateCustomizeChangesWithChecking(type, newValue, fxNumber, curCompInfo, valueIndex, callback) {
	var collectedToSendObj = {
		type: type,
		value: newValue,
		arg: fxNumber,
		comp: curCompInfo,
		valueIndex: valueIndex
	};

	_sleep(90); //Anti-flood trick (need better solution in future)
	csInterface.evalScript('customizeHandler("_SET", ' + JSON.stringify(collectedToSendObj) + ")", function (result) {
		if (result != "undefined") {
			if (result == "RESET_CUSTOMIZER_DATA_COMPLECT") {
				customizerIComposer("ATOM_CUSTOMIZER_GROUP");
			} else {
				itemResponseListFromEngine(result);
			}
		} else {
			if (callback) {
				callback();
			}
		}
	});
}

//#endregion

//#region ENGINE RESPONSES

/**
 * Errors for work with item applying
 * Comparing on errors (if equal one with list = error, or return true)
 * @param {*} result Compare Object/String with this result switch list
 * @return {boolean} True if no errors (no compares with list)
 */
function itemResponseListFromEngine(result) {
	var caseType = result,
		caseArg = "",
		schar = "|",
		_msg = {};
	if (caseType.toString().indexOf(schar) != -1) {
		var splitResult = caseType.toString().split(schar);
		caseType = splitResult[0];
		caseArg = splitResult[1];
	}

	switch (caseType) {
		//GENERAL
		//APPLYING ITEM RESPONSES
		case "COMP":
			_msg = preMsgHelper("Select Composition", "Please select the timeline and try again", "info");
			break;
		case "LAYER":
			_msg = preMsgHelper("Select Layer", "Please select layer!", "info");
			break;
		case "TEXT_LAYER":
			_msg = preMsgHelper("Text Layer", "Please select the text layer!", "info");
			break;
		case "ITEM_SELECTION":
			_msg = preMsgHelper("No Selection", "Please select item(s) in project structure", "info");
			break;

		case "MISSING":
			_msg = preMsgHelper("Missing Files", "Template/footage files is missing!", "error");
		case "MISSING_PRESETS":
			_msg = preMsgHelper("Missing Presets", "Preset files is missing!", "error");
			break;
		case "NO_MATCH":
			_msg = preMsgHelper("Missing Item", "This item not found!", "info");
			break;
		case "UNKNOWN_ERROR":
			_msg = preMsgHelper("Unknown Error", "Strange error: " + caseArg, "error", true);
			break;
		case "DEBUG":
			_msg = preMsgHelper("Debug Info", caseArg, "info", true);
			break;
		case "NO_PASTE_PRESETS":
			_msg = preMsgHelper("Nothing to paste", "There are no presets to paste", "info");
			break;
		case "NO_PRESET_DELETE":
			_msg = preMsgHelper("Nothing to delete", "There are no presets to delete", "info");
			break;

		case "DUPLICATE_SEQ_ERROR":
			_msg = preMsgHelper("Duplicate Error", "Not found duplicated sequence!", "error", true);
			break;
		case "NO_SUPPORT_APP":
			_msg = preMsgHelper(
				"Wrong software",
				"This item only for <strong>" + softAssetsByAppID[currentTempPackagePrefab.pack.appID]["name"] + "</strong> software",
				"info",
				true
			);
			break;
		case "REQUIRE_UPDATES":
			_msg = preMsgHelper("Need Updates", "Please update the extension to use this item", "info");
			break;

		//CUSTOMIZER FOR ITEMS
		case "NOT_FOUND_LAYER":
			_msg = preMsgHelper("Layer", "Not found layer!", "error");
			break;
		case "NOT_FOUND_COMP":
			_msg = preMsgHelper("Composition", "Not found composition!", "error");
			break;
		case "NO_CUSTOMIZER":
			_msg = preMsgHelper("Customizer", "Customizer layer not found", "error");
			break;
		case "NO_CONTROLS":
			_msg = preMsgHelper("No controls", "No controls on customizer layer", "error");
			break;
		case "COMP_LAYER":
			_msg = preMsgHelper("Comp Layer", "Layer should be the composition", "error");
			break;

		case "NOT_FOUND_ITEM":
			_msg = preMsgHelper("Item", "Please select item to customize", "error");
			break;
		case "OTHER_ITEM_OPTIONS":
			_msg = preMsgHelper("Other Item", "Cannot use options from other item", "info");
			break;
		case "NOT_MGT_COMPONENT":
			_msg = preMsgHelper("Not MOGRT", "Select MOGRT and try again", "info");
			break;
		case "SELECT_VIDEO_TRACKS":
			_msg = preMsgHelper("Only Video Tracks", "Select item on video tracks", "info");
			break;

		//PACK TOOLBAR BUTTON ACTIONS
		//AE
		case "NO_MARKER_DATA":
			_msg = preMsgHelper("Wrong", "Not found time controls to set!", "info");
			break;
		case "CANNOT_SET_TIME_REMAPPING":
			_msg = preMsgHelper("Wrong Layer", "Use another type layer to set!", "error");
			break;
		case "REMOVED_UNUSED_OK":
			_msg = preMsgHelper("Items Removed", caseArg + " unused items successfully removed!", "success");
			break;
		case "REMOVED_UNUSED_NO":
			_msg = preMsgHelper("No Unused", "You have no unused items to remove!", "info");
			break;

		//PR
		case "CONSOLITED_ITEMS_PR":
			_msg = preMsgHelper("Consolidated", "Duplicates are consolidated", "success");
			break;
		case "PREVIEW_CACHE_CLEAR":
			_msg = preMsgHelper("Cache Clear", "All video and audio preview files deleted", "success");
			break;
		case "SOURCE_CLIPS_CLOSED":
			_msg = preMsgHelper("Sources Closed", "The source monitor is clean", "success");
			break;
		case "DUP_NEST_SUCCESS":
			_msg = preMsgHelper("Nest Duplicator", "Sequence and nest items was duplicated", "success");
			break;
		case "SELECT_SEQ_IN_PROJECT":
			_msg = preMsgHelper("Select Sequence", "Select one in Project view", "info");
			break;
		case "SELECT_ONLY_ONE_SEQ":
			_msg = preMsgHelper("One Sequence", "Select only one sequence", "info");
			break;
		case "RESIZED":
			_msg = preMsgHelper("Resized", "Items are resized", "success");
			break;

		//DRAG AND DROP ACTIONS [PR]
		case "SEQUENCE":
			_msg = preMsgHelper("Select Sequence", "Please select active sequence!", "error");
			break;
		case "NO_SEQUENCE":
			_msg = preMsgHelper("Missing Sequence", "This sequence not found!", "error");
			break;
		case "NO_PROJECT":
			_msg = preMsgHelper("Missing Project", "Project file not found", "error");
			break;
		case "NO_MOGRT":
			_msg = preMsgHelper("Missing MOGRT", "MOGRT file not found", "error");
			break;
		case "NO_ENC_MOGRT":
			_msg = preMsgHelper("Missing encrypted MOGRT", "MOGRT asset not found", "error");
			break;

		case "CANT_ADD_MOGRT":
			_msg = preMsgHelper("Wrong MOGRT", "Can't add this MOGRT to timeline", "error");
			break;
		case "WRONG_TRACK_VIDEO":
			_msg = preMsgHelper("Wrong Video Track", "Please drag the item on the <strong>video track</strong>", "error");
			break;
		case "WRONG_TRACK_AUDIO":
			_msg = preMsgHelper("Wrong Audio Track", "Please drag the item on the <strong>audio track</strong>", "error");
			break;
		case "MOGRT_NOT_SUPPORTED":
			_msg = preMsgHelper("Required CC 2019", "Upgrade Premiere Pro to <strong>CC 2019+</strong> for continue", "error");
			break;
		case "PROJECT_NOT_SUPPORTED":
			_msg = preMsgHelper("Required CC 2020", "Upgrade Premiere Pro to <strong>CC 2020+</strong> for continue", "error");
			break;

		//PR project errors
		case "CANT_IMPORT_PPROJ":
			_msg = preMsgHelper("No Rights To Import", "Anti-virus or firewall blocked Premiere Pro", "error");
			break;
		case "MISSING_CACHE_FILE":
			_msg = preMsgHelper("Missing Cache File", "Cached template file not found!", "error");
			break;
		case "CANNOT_DECODE_BIN":
			_msg = preMsgHelper("Decryption Failed", "Can't decrypt <code>*.atomxasset</code>!", "error");
			break;

		case "DEV_NO_SELECTION_SEQ":
			_msg = preMsgHelper("Dev: No Selection", "Please select sequences in project window", "info");
			break;

		default:
			return true;
	}

	if (_msg["title"] && _msg["body"]) {
		createMessage(_msg["title"], _msg["body"], _msg["type"], _msg["hold"], _msg["cancel_pbar"]);
	}
}

/**
 * Errors for work with pack installation
 * Comparing on errors (if equal one with list = error, or return true)
 * @param {*} result Compare Object/String with this result switch list
 * @return {boolean} True if no errors (no compares with list)
 */
function packResponseListFromEngine(result) {
	var caseType = result,
		caseArg = "",
		schar = "|",
		_msg = {};
	if (caseType.toString().indexOf(schar) != -1) {
		var splitResult = caseType.toString().split(schar);
		caseType = splitResult[0];
		caseArg = splitResult[1];
	}
	switch (caseType) {
		//PACK LOAD/INITIALIZATION

		case "NO_PACK_STRUCTURE":
			_msg = preMsgHelper("No Pack Structure", "Broken package structure", "error", true, true);
			break;
		case "NO_PACK_SETTINGS":
			_msg = preMsgHelper("No Pack Settings", "Broken package settings", "error", true, true);
			break;
		case "SYS_ERROR":
			_msg = preMsgHelper("System Error", "Info: " + caseArg, "error", true, true);
			break;
		case "CORRUPTED_TEST_PACK":
			_msg = preMsgHelper("Corrupted Test Pack", "Fix: " + caseArg, "error", false, true);
			break;
		case "CORRUPTED_PACK":
			_msg = preMsgHelper("Corrupted Package", "Package file is corrupted", "error", false, false);
			break;
		case "CANT_INIT":
			_msg = preMsgHelper("Cant Init", "Wrong ID Code in Old Atom Package", "error", false, false);
			break;
		case "CANT_OPEN":
			_msg = preMsgHelper("Cant Read", "Cannot open the package file", "error", false, false);
			break;
		case "PACK_NOT_FOUND":
			_msg = preMsgHelper("Not found", "Package file not found, please reinstall", "error", false, false);
			break;
		case "CANT_SAVE_PACK_PREFS":
			_msg = preMsgHelper("Cant Save", "Cannot save the package data", "error");
			break;
		case "PACK_PREF_NOT_FOUND":
			_msg = preMsgHelper("Pack Not Found", "Package to load not found", "error", true);
			break;
		case "UNKNOWN_ERROR":
			_msg = preMsgHelper("Unknown Error", "See debug data.", "error");
			break;
		case "WRONG_PACKPRINT_FILE":
			_msg = preMsgHelper("Wrong Packprint", "Wrong packprint, please reinstall the package", "error", true, false);
			break;
		case "WRONG_PACKPRINT_PREF":
			_msg = preMsgHelper("Packprint Pref", "The package configuration file is corrupted", "error", true, false);
			break;
		case "WRONG_HASH_SIGNATURE":
			_msg = preMsgHelper("Wrong Signature", "Please recompile the package", "error", true, false);
			break;

		//ANOTHER WITH INIT
		// case "REMOVE_LAST_PACKAGE":
		//     reloadExtensionPanel();
		//     break;

		//PACK INSTALLATION CHECKS
		case "DUPLICATE":
			_msg = preMsgHelper("Duplicate", "This package is already installed", "info");
			break;
		case "DUPLICATE_LOWER_VERSION":
			_msg = preMsgHelper("Older Version", "Cannot install older version of the package", "info");
			break;
		case "COPIED_PACK_FAILED":
			_msg = preMsgHelper("Cant Copy Files", "Failed to install package, please try again", "error");
			break;
			// Install package REQUIRES
		case "REQUIRE_UPDATES":
			_msg = preMsgHelper("Need Updates", "Please update the extension to install this package", "info");
			break;
		case "REQUIRE_UPDATED_SOFTWARE":
			_msg = preMsgHelper("Requires " + caseArg, "Please update software to install this package", "info");
			break;
		case "REQUIRED_SAME_SOFTWARE":
			_msg = preMsgHelper("This package is for " + caseArg, "Please install it while in " + caseArg + '+', "info");
			break;
			// RUN package REQUIRES
		case "REQUIRE_UPDATED_SOFTWARE_RUNNING":
			_msg = preMsgHelper("Requires " + caseArg, "Please update software to run this package", "info");
			break;
		case "REQUIRED_SAME_SOFTWARE_RUNNING":
			_msg = preMsgHelper("This package is for " + caseArg, "Please run it while in " + caseArg + '+', "info");
			break;
			
			
		case "DOWNGRADE_DEMO_PACK":
			_msg = preMsgHelper("Downgrade", "You cannot downgrade full package to demo", "error");
			break;
		case "ASSETS_NOT_FOUND":
			_msg = preMsgHelper("Lost Assets", "Assets folder not found", "error");
			break;
		default:
			return true;
	}

	if (_msg["title"] && _msg["body"]) {
		createMessage(_msg["title"], _msg["body"], _msg["type"], _msg["hold"], _msg["cancel_pbar"]);
	}
	installationTempXHRObject = {}; //reset installation XHR OBJECT if any errors on installation processing
}

function preMsgHelper(title, body, type, hold, cancel_pbar, changeStyleAsBrokenPackage) {
	return {
		title: title,
		body: body,
		type: type || "error",
		hold: hold || false,
		cancel_pbar: cancel_pbar || true
	};
}

//#endregion
