/*
 * @Author: aniom
 * @Date:   2020-05-11 00:24:02
 * @Last Modified by:   aniom
 * @Last Modified time: 2020-09-02 08:24:35
 */

//#region GET ITEM/PREVIEW PATHS

/**
 * Create full path for files inside JS (instead JSX)
 * @param {string} item_id
 * @param {string} item_name
 * @param {string} instance_groups_string
 * @param {object} args_object
 * @param {string} action_btn
 * @return {object} "file" String path & "last" string of last group
 */
function getItemFilepath(
  item_id,
  item_name,
  instance_groups_string,
  args_object,
  action_btn
) {
  /* NEW SYSTEM TO TEMPLATE PATH (FROM AtomX 3.0) */

  var tempArrProps = instanceGroupSplit(instance_groups_string);
  if (!tempArrProps) {
    return false;
  }

  var insideOpts = currentTempPackageInsideOptionsSets;
  var packAppID = currentTempPackagePrefab.pack.appID;

  var lastGroupName = tempArrProps[tempArrProps.length - 1];

  var allGroups = tempArrProps;

  var itemInsGroups = tempArrProps.join("/");

  var getFile = "";
  var getNameWithExt = "";
  var itemCType = "";
  var encryptedFileType = "";

  if (args_object.aep_file_name || args_object.ppr_file_name) {
    var customProjectNameByApp = "";
    tempArrProps.pop(); //remove last arr item
    //custom project name for AE
    if (args_object.aep_file_name) {
      customProjectNameByApp = args_object.aep_file_name;
    }
    //custom project name for PR
    if (args_object.ppr_file_name) {
      customProjectNameByApp = args_object.ppr_file_name;
    }

    itemInsGroups =
      tempArrProps.length >= 1
        ? tempArrProps.join("/") + "/" + customProjectNameByApp
        : customProjectNameByApp;
  }

  var templateDir = getFolderWithTemplateItems() + itemInsGroups + "/";

  var fName = item_name;

  //Get path for AE and PR - different
  switch (packAppID) {
    case "AE":
      getNameWithExt =
        itemInsGroups + "." + softAssetsByAppID.AE.filetypes.main; //aep / itemInsGroups instead Item name - coz item name it is composition
      getFile = getFolderWithTemplateItems() + getNameWithExt;
      itemCType = "PROJECT";

      //Individual .AEP file for one composition
      if (args_object.individual_comp) {
        getNameWithExt = fName + "." + softAssetsByAppID.AE.filetypes.main;
        getFile = templateDir + getNameWithExt;
      }

      break;
    case "PR":
      var PrItemSourceType = insideOpts.source_type; //pack main sets source type
      //custom source type for item - PROJECT/or MOGRT
      if (args_object.custom_source_type) {
        PrItemSourceType = args_object.custom_source_type;
      }
      //set path for current source type
      if (PrItemSourceType == "PROJECT") {
        getNameWithExt =
          fName + "." + getFileTypeFileProtectionCached(packAppID);
      } //prproj
      if (PrItemSourceType == "MOGRT") {
        /* Multiuse MOGRT (ionestudio new MOGRT transition system) */
        if (args_object.custom_args.multiuse_ref_mogrt) {
          getNameWithExt = args_object.custom_args.multiuse_ref_mogrt + ".";
        } else {
          getNameWithExt = fName + ".";
        }

        if (
          currentTempPackageInsideOptionsSets.mogrt_files_protection_method &&
          currentTempPackageInsideOptionsSets.mogrt_files_protection_method ==
            "MG_ASSET"
        ) {
          getNameWithExt += basisProtectFileTypes.MG_ASSET;
          encryptedFileType = "MG_ASSET";
        } else {
          getNameWithExt += softAssetsByAppID.PR.filetypes.mg;
        }
      } //mogrt

      if (args_object.custom_files_folder) {
        getFile =
          getFolderWithTemplateItems() +
          "_Files/" +
          args_object.custom_files_folder +
          "/" +
          getNameWithExt;
      } else {
        getFile = templateDir + getNameWithExt;
      }

      itemCType = PrItemSourceType;
      break;
  }

  if (args_object.is_audio) {
    var assetsFolder = getFolderWithAssetsItems();
    var itemNameAudio = item_id;
    var setAudioType =
      args_object.custom_args && args_object.custom_args.filetype
        ? args_object.custom_args.filetype
        : "wav";
    //if name instead id
    if (args_object.preview_name_instead_id) {
      itemNameAudio = item_name;
    }
    getNameWithExt =
      itemNameAudio + "." + setAudioType.toString().toLowerCase();
    //another path to file - in Assets
    getFile = assetsFolder + itemInsGroups + "/" + getNameWithExt;
    itemCType = "AUDIO";
  }

  if (args_object.is_footage) {
    var setFootageFiletype =
      args_object.custom_args && args_object.custom_args.filetype
        ? args_object.custom_args.filetype
        : args_object.is_footage;
    getNameWithExt = fName + "." + setFootageFiletype.toString().toLowerCase();
    getFile = templateDir + getNameWithExt;
    itemCType = "FOOTAGE";
  }

  if (args_object.is_presets) {
    var asMultiplePreset = args_object.custom_args
      ? args_object.custom_args.multiple_preset
      : false;
    var presetFileNameSuffix = insideOpts.file_name_finder;

    if (asMultiplePreset) {
      if (action_btn == "PM_BOTH") {
        getNameWithExt = fName;
        getFile = templateDir;
      } else {
        var getTypeFromBtn = action_btn.replace("PM_", "");
        if (presetFileNameSuffix && presetFileNameSuffix[getTypeFromBtn]) {
          getNameWithExt =
            presetFileNameSuffix[getTypeFromBtn]["prefix"] +
            fName +
            presetFileNameSuffix[getTypeFromBtn]["suffix"] +
            ".ffx";
        } else {
          getNameWithExt = fName + ".ffx";
        }
        getFile = templateDir + getNameWithExt;
      }
    } else {
      /* Middle presets - only one (with suffix if exists this var in package) */
      if (presetFileNameSuffix) {
        if (presetFileNameSuffix["MID"]) {
          getNameWithExt =
            presetFileNameSuffix["MID"]["prefix"] +
            fName +
            presetFileNameSuffix["MID"]["suffix"] +
            ".ffx";
        } else {
          getNameWithExt = fName + ".ffx";
        }
      } else {
        getNameWithExt = fName + ".ffx";
      }
      getFile = templateDir + getNameWithExt;
    }

    itemCType = "PRESET";
  }

  /* END SYSTEM TO GET PATH */
  return {
    dir: convertToSystemPath(templateDir),
    file: convertToSystemPath(getFile),
    name: getNameWithExt,
    type: itemCType,
    last: lastGroupName,
    groups: allGroups,
    encrypted: encryptedFileType,
  };
}

//#endregion

//#region GENERAL

/**
 * Convert path "/"" or "\" for win/mac
 * @param {string} path_string Insert path to get converted
 * @return {string} Converted Path String
 */
function convertToSystemPath(path_string, unix_def) {
  var OSVersion =
    csInterface.getOSInformation().indexOf("Windows") >= 0 ? "win" : "mac";

  var separator = "";
  if (unix_def) {
    separator = "/";
  } else {
    if (OSVersion == "win") {
      //win
      separator = "\\";
    } else {
      //mac/unix
      separator = "/";
    }
  }
  return decodeURI(path_string).toString().replace(/\\|\//g, separator);
}

/**
 * Check Extension inside folder (in AppData), if not found - create
 * Used @var authorCopyrightName for AuthorName (aniom) and @var extCopyrightName for folder ext name (Atom Extension)
 * Set to global var - _globalPathObjects['atomDataFolder']
 */
function getOrCreateAtomAppDataFolder() {
  //userData - Roaming
  var folderUserData = init_sets["pathUserData"];
  //create global folder if not found
  var extAssetsFolder = fsmodule.checkOrCreateAbsolute(
    folderUserData + "/" + authorCopyrightName + "/" + extCopyrightName
  );
  _globalPathObjects["atomDataFolder"] = convertToSystemPath(extAssetsFolder);
}

function getFolderCacheFiles() {
  var prep = convertToSystemPath(
    _globalPathObjects["atomDataFolder"] + "/" + "_Cache"
  );
  //if no folder - create it
  if (!fsmodule.exists(prep)) {
    fsmodule.createFolder(prep);
  }
  return prep;
}

function getFolderOutsideLibs() {
  var prep = convertToSystemPath(
    _globalPathObjects["atomDataFolder"] + "/" + "_Libs"
  );
  //if no folder - create it
  if (!fsmodule.exists(prep)) {
    fsmodule.createFolder(prep);
  }
  return prep;
}

function getFolderSubscriptionPackages() {
  var isCustomPath = editLocalPSets(false, "useCustomPathBySubscription");
  var customPathFolder = editLocalPSets(false, "absCustomAbsolutePath");

  var prep = convertToSystemPath(
    _globalPathObjects["atomDataFolder"] + "/_ABS"
  );

  if (isCustomPath && customPathFolder) {
    prep = customPathFolder;
  }
  // var prep = convertToSystemPath(csInterface.getSystemPath(SystemPath.USER_DATA) + '/ABS'); //Roaming/ABS
  //if no folder - create it
  if (!fsmodule.exists(prep)) {
    fsmodule.createFolder(prep);
  }
  return prep;
}

function createDirRecursively(dir) {
  if (!fsmodule._fs.existsSync(dir)) {
    createDirRecursively(fsmodule._path.join(dir, ".."));
    fsmodule._fs.mkdirSync(dir);
  }
}

function getFolderDocumentsCommonPTX() {
  var folderPath =
    csInterface.getSystemPath(SystemPath.MY_DOCUMENTS) + "/Adobe/Common/PTX/";
  createDirRecursively(folderPath);
  var prep = convertToSystemPath(folderPath);
  return prep;
}

function getFolderImagesForExternalLibImports() {
  var folderPath =
    csInterface.getSystemPath(SystemPath.MY_DOCUMENTS) +
    "/External Lib Imports/";
  createDirRecursively(folderPath);
  var prep = convertToSystemPath(folderPath);
  return prep;
}

//#endregion

//#region COPYING FILES APPDATA
//NOT USED. USED JSX METHOD

/**
 * Main function to copy (like as install) package inside AppData
 * @param {string} packName Package Name
 * @param {string} packAppID Application ID to get app folder (with templates) - AE/AI/PS...
 * @param {File|string} packFilePath
 * @deprecated Now again used JSX method
 * @return {File} Full path to cloned package file
 */
function copyPackageIntoAppData(callback, packName, packAppID, packFilePath) {
  var packFileType = ".atom";
  //Create(copy) folders for app templates (if exists)
  var folderTemplateAppName = softAssetsByAppID[packAppID]["folder"];
  var folderExtAppData = _globalPathObjects["atomDataFolder"]; //Extension AppData
  var folderAssetsName = _globalPathObjects["atomAssetsPath"]; //Assets Folder Name

  //prepare path for folder pack (also add appID in end of line via -)
  var genAppFolderPath = folderExtAppData + "/" + packName + " - " + packAppID;
  //create folder for current pack (absolute path)
  fsmodule.checkOrCreateAbsolute(genAppFolderPath);

  //FILE PACK PATH
  var sourcePackFilePath = packFilePath;
  var targetPackFilePath = genAppFolderPath + "/" + packName + packFileType;

  //COPY SELECTIVELY - Package File, Assets, Templates [Current Application]

  fsmodule.copyFile(sourcePackFilePath, targetPackFilePath, function (err) {
    if (err)
      return systemDebuggerCommandLines.push(
        "copyPackageIntoAppData -> Cannot to copy package file: copiedPackage [" +
          copiedPackage.toString() +
          "]"
      );

    //Package file directory (to get assets/app templates)
    var packFileDirectory = fsmodule.fileDirectory(sourcePackFilePath);

    //COPY ASSETS FOLDER
    var oldPackAssetsPath = packFileDirectory + "/" + folderAssetsName;
    var newPackAssetsPath = genAppFolderPath; //not need add folder assets name (will copied from source)
    if (fsmodule.exists(oldPackAssetsPath)) {
      fsmodule.copyFolderRecursive(
        convertToSystemPath(oldPackAssetsPath),
        convertToSystemPath(newPackAssetsPath)
      );
    } else {
      systemDebuggerCommandLines.push(
        "copyPackageIntoAppData -> Not found: oldPackAssetsPath [" +
          oldPackAssetsPath.toString() +
          "]"
      );
    }

    //COPY APPLICATION TEMPLATES
    var oldPackTemplatesPath = packFileDirectory + "/" + folderTemplateAppName;
    var newPackTemplatesPath = currentPackFolder; //not need add folder templates name (will copied from source)
    if (fsmodule.exists(oldPackTemplatesPath)) {
      fsmodule.copyFolderRecursive(
        convertToSystemPath(oldPackTemplatesPath),
        convertToSystemPath(newPackTemplatesPath)
      );
    } else {
      systemDebuggerCommandLines.push(
        "copyPackageIntoAppData -> Not found: oldPackTemplatesPath [" +
          oldPackTemplatesPath.toString() +
          "]"
      );
    }
    callback(convertToSystemPath(targetPackFilePath));
  });
}

//#endregion

//#region ASSETS/TEMPLATE FOLDERS

/**
 * Check exists the package folder with Assets (Previews gif/png) /or application templates/elements by parent of package path file
 * @param {string} path Path to package (to get File.parent folder)
 * @param {string} assetFolder Set assets folder (optional), by default Atom Assets Folder name
 * @param {boolean} withoutExistsCheck For preview generating data to optimaze check for CD
 * @return {string} Folder path as string with OS Fixes path (like: C:\win, c:/mac)
 */
function getParentPackageFolderWith(path, assetFolder, withoutExistsCheck) {
  //set default folder with assets if not found another
  if (!assetFolder) {
    assetFolder = _globalPathObjects["atomAssetsPath"];
  }
  //get Assets folder in pack directory
  var folder_path = fsmodule.fileDirectory(path) + "/" + assetFolder + "/";
  if (fsmodule.exists(folder_path)) {
    return convertToSystemPath(folder_path);
  }
}

/**
 * Get folder with templates items by templates folder name for any applications
 * @return {string} Folder path with OS converting if exists
 */
function getFolderWithTemplateItems() {
  var curAppFolderName = softAssetsByAppID[getCurSoftShortID()].folder;
  return getParentPackageFolderWith(
    currentTempPackagePrefab.pack.path,
    curAppFolderName
  );
}

function getFolderWithAssetsItems() {
  var curAssetsFolderName = _globalPathObjects["atomAssetsPath"];
  return getParentPackageFolderWith(
    currentTempPackagePrefab.pack.path,
    curAssetsFolderName
  );
}

//#endregion

//#region PREF FILE HANDLER

/**
 * Get Pref file path from variables
 */
function getPrefFilePath() {
  return convertToSystemPath(
    _globalPathObjects["atomDataFolder"] +
      "/" +
      _globalFileNameObjects["prefFile"]
  );
}

/**
 * Save Preferences JSON File with global extension settings
 * Will created if not found (realization in other func)
 * @return {boolean} True if success saved/or False if not
 */
function savePrefJSON_File() {
  var prefFile = getPrefFilePath();
  if (fsmodule.exists(prefFile)) {
    fsmodule.writeFileSync(prefFile, JSON.stringify(localPreferences));
    return true;
  } else {
    return false;
  }
}

/**
 * Create Preference file by default template if file not found (realized in other func)
 * @param {string} filePath File object
 * @return {object} Object with created template
 */
function createPrefJSON_File(filePath) {
  //create file from template json
  fsmodule.writeFileSync(filePath, JSON.stringify(localPreferences));
  //return template without waiting async writing file
  return localPreferences;
}

/**
 * Open and parse preference JSON file/create by template @func createPrefJSON_File if not found
 * and set to global var - localPreferences
 * @version 2.0 Now instead another var to store loaded data - used local pref as main, before loaded JSON, local file used as template to create
 */
function getOrCreateParsedJsonPreferences() {
  var prefFile = getPrefFilePath();
  var strPrefs;
  //if exists pref file
  if (fsmodule.exists(prefFile)) {
    strPrefs = fsmodule.readFile(prefFile);
    if (strPrefs) {
      try {
        strPrefs = JSON.parse(strPrefs);
        //find and set new params if exist in local, and not found in loaded
        //added only in local (without saving), but any save will added in json file
        strPrefs = findUnknownParams(strPrefs);
      } catch (e) {
        return "PREF_FILE";
      }
    } else {
      //if file exists, but empty - create again
      strPrefs = createPrefJSON_File(prefFile);
    }
  } else {
    //not found file - create
    strPrefs = createPrefJSON_File(prefFile);
  }
  //set parsed object to global local var to use
  localPreferences = strPrefs;
}

/**
 * Compare template structure prefs and loaded json prefs - if in template struct more params - add him to cur
 * Need if added special params inside preferences in new versions of the AtomX
 * @version 2 - Now for global params too
 * @param {*} loadedPref Loaded JSON Pref to compare with local
 * @param {string} objKey main key for comparing inside object
 * @return {*} changed loaded object (with new keys from local) if found
 */
function findUnknownParams(loadedPref) {
  var lPrefGlobal = localPreferences;
  for (var key in lPrefGlobal) {
    if (lPrefGlobal.hasOwnProperty(key)) {
      //Global params (UISettings/PrefSettings and etc)...

      //found unknown in loaded/set from local
      if (loadedPref[key] == null) {
        loadedPref[key] = lPrefGlobal[key];
      }

      //Children params inside global
      var lPrefChildren = localPreferences[key]; //key in local
      for (var keyCh in lPrefChildren) {
        if (lPrefChildren.hasOwnProperty(keyCh)) {
          //found unknown in loaded/set from local
          if (loadedPref[key][keyCh] == null) {
            loadedPref[key][keyCh] = lPrefChildren[keyCh];
          }
        }
      }
    }
  }
  return loadedPref;
}

/**
 * Clear JSON Pref file (create default template without any content from old prefs when next init the extension)
 */
function clearPrefJSON_File() {
  var prefFile = getPrefFilePath();
  fsmodule.writeFileSync(prefFile, ""); //set nothing
  return true;
}

//#endregion
