/*
 * @Author: aniom
 * @Date:   2020-04-15 03:52:40
 * @Last Modified by:   aniom
 * @Last Modified time: 2020-05-28 10:04:15
 */

var savePreviousTreeGroup = null;

var contentStateReminded = null;

var dragAndDropSpecialTimerIsOver = null;
var dragAndDropData = {};

//#region GET STARTED (WHEN NO ONE PACKAGE INSTALLED)

$(document).on("click", ".getStarted [goto]", function () {
	var cgt = $(this).attr("goto");
	switch (cgt) {
		case "install":
			$(".dragAndDropInstallation .place input").click();
			break;
		case "tutorials":
			if (upServerContent("vtuts")) {
				popupContentSwitcher("ATOM_VIDEO_TUTS");
			}
			break;
		case "market":
			$("#header .headMenu").click();
			break;
		case "help":
			linkCore("link", "help_center");
			break;
	}
});

//#endregion

//#region SHOW CONTENT SPOILERS

//Show content in any space
$(document).on("click", "[in-show-content]", function () {
	var cur_data = $(this).attr("in-show-content");
	var cur_type = $(this).attr("show-content-type");

	var prefixCss = "";
	// Package Software switcher
	if (cur_type == "market") {
		prefixCss = ".poBlock.atomMarket";

		marketSelectedSoftware = cur_data;

		$(".atomMarket .market_tags_button li").removeClass("checked");
	}
	// Course Software Switcher
	if (cur_type == "course") {
		prefixCss = ".poBlock.atomMarket";

		coursesSelectedSoftware = cur_data;
		// $(".atomMarket .market_tags_button li").removeClass("checked");
	}

	//selected btn
	if (!$(this).hasClass("selected")) {
		$(prefixCss + " [in-show-content][show-content-type='" + cur_type + "']").removeClass("selected");
	}
	$(this).addClass("selected");
	//Content
	$(prefixCss + " .hideContent").hide(); //hide all
	$(prefixCss + ' .hideContent[show-content="' + cur_data + '"]').show(); //set current
});

$(document).on("click", "[in-show-content-gl-market-switcher]", function () {
	var cur_data = $(this).attr("in-show-content-gl-market-switcher");

	var prefixCss = "";
	prefixCss = ".poBlock.atomMarket";

	// $(prefixCss + " [in-show-content]").removeClass("selected");

	if (cur_data == "packages") {
		//Content
		$(prefixCss + " .hideContent").hide(); //hide all
		$(prefixCss + ' .hideContent[show-content="' + marketSelectedSoftware + '"]').show();
		$(prefixCss + ' .customizeElement[data-type="market_switcher"]:not([data-opt="global_switcher"])').hide();
		$(prefixCss + ' .customizeElement[data-type="market_switcher"][data-opt="package_softwares"]').show();

		// $(
		//   prefixCss +
		//     " [in-show-content='" +
		//     marketSelectedSoftware +
		//     "'][show-content-type='" +
		//     cur_data +
		//     "']"
		// ).addClass("selected");
	}
	if (cur_data == "courses") {
		//Content
		$(prefixCss + " .hideContent").hide(); //hide all
		$(prefixCss + ' .hideContent[show-content="course_ae"]').show();
		$(prefixCss + ' .customizeElement[data-type="market_switcher"]:not([data-opt="global_switcher"])').hide();
		$(prefixCss + ' .customizeElement[data-type="market_switcher"][data-opt="course_softwares"]').show();
		// $(
		//   prefixCss +
		//     " [in-show-content='" +
		//     coursesSelectedSoftware +
		//     "'][show-content-type='" +
		//     cur_data +
		//     "']"
		// ).addClass("selected");
	}
	//selected btn
	if (!$(this).hasClass("selected")) {
		$(prefixCss + " [in-show-content-gl-market-switcher]").removeClass("selected");
	}
	$(this).addClass("selected");
});

//Slide Up spoiler with content by cateogies type (used for video tutorials blocks)
$(document).on("click", "[spoiler]", function () {
	var spoiler_to = $(this).attr("spoiler");
	var spoiler_type = $(this).attr("spoiler-type");

	switch (spoiler_type) {
		case "vtuts":
			//close all if without current class selected (to close one)
			if (!$(this).hasClass("selected")) {
				$(".spoilerContainer").slideUp();
				$("[spoiler]").removeClass("selected");
			}

			//destroy IFrames youtube if switched
			// stopAllYoutubePlayers('.videoTutorials .videoBlock');

			//selected this item
			$(this).toggleClass("selected");
			break;
	}

	//slide show need content
	$('.spoilerContainer[data-view="' + spoiler_to + '"]').slideToggle();
});

//#endregion

//#region CUSTOMIZER EVENTS

//Tabs in customizer (Customize/Text/...)
$(document).on("click", "ul.tabs-nav li", function () {
	var cur_data = $(this).attr("data");
	var cur_switcher = $(this).attr("switch");

	if (cur_switcher) {
		if (cur_switcher == "back_pm_previews") {
			$('#tools .global li[data-view="ATOM_CUSTOMIZER_GROUP"]').click();
		}
	} else {
		//Tabs
		$("ul.tabs-nav li").removeClass("tab-active"); //hide all
		$(this).addClass("tab-active"); //set current

		//Content
		$(".tabs-stage > div").hide(); //hide all
		$('.tabs-stage > div[data="' + cur_data + '"]').show(); //set current
	}
});

//Auto-save input for application in customizer changes
//System for colors inside @func.js Spectrum Library

//Buttons - open default customizer (AE)
$(document).on("click", '.tabs-stage div[data="sp_customizer_main"] .btnOpenCustomizer', function () {
	sendToUpdateCustomizeChanges("open_customizer", "ONLY_OPEN", "", currentComposerCompCustomizer);
});

//Checkboxes
$(document).on("change", '.tabs-stage div[data="sp_customizer_main"] input[type="checkbox"]', function () {
	//AE
	var getFxNumber = $(this).parent().attr("fx-number");
	var getFxExtraPseudoIndex = $(this).parent().attr("fx-extra-pseudo"); //for Pseudo Effects
	//PR
	var getPropType = $(this).parent().attr("prop-type");
	//COMMON
	var setNewValue = this.checked;
	//Multiapplicator
	var engines = softAssetsByAppID[currentPackShortAppID]["engine"];
	switch (currentPackShortAppID) {
		case "AE":
			//_TEXT_PRESETS
			if (engines[0] == currentPackEngineType) {
			}
			//_COMPOSER or _TEXT_ANIMATOR or _PRESET_MANAGER
			if (
				engines[1] == currentPackEngineType ||
				engines[3] == currentPackEngineType ||
				engines[4] == currentPackEngineType ||
				engines[5] == currentPackEngineType
			) {
				sendToUpdateCustomizeChanges("edit_customizer", setNewValue, getFxNumber, currentComposerCompCustomizer, getFxExtraPseudoIndex);
			}

			break;
		case "PR":
			//_COMPOSER
			if (engines[0] == currentPackEngineType) {
				sendToUpdateCustomizeChanges(getPropType, setNewValue, getFxNumber, currentComposerCompCustomizer);
			}
			break;
	}
});

//Change ranges in customizer/and set params (also change tooltip info)
$(document).on("input", '.tabs-stage div[data="sp_customizer_main"] input[type="range"]', function () {
	//AE
	var getFxNumber = $(this).parent().attr("fx-number");
	var getFxExtraPseudoIndex = $(this).parent().attr("fx-extra-pseudo"); //for Pseudo Effects
	//PR
	var getPropType = $(this).parent().attr("prop-type");
	var getValueIndex = $(this).attr("value-index"); //new for MOGRT groups from CC2020
	//COMMON
	//set new value in tooltip
	$(this).attr("tooltip", this.value);
	//set value
	var setNewValue = this.value;

	//Multiapplicator
	var engines = softAssetsByAppID[currentPackShortAppID]["engine"];
	switch (currentPackShortAppID) {
		case "AE":
			//_TEXT_PRESETS
			if (engines[0] == currentPackEngineType) {
			}
			//_COMPOSER or _TEXT_ANIMATOR or _PRESET_MANAGER
			if (
				engines[1] == currentPackEngineType ||
				engines[3] == currentPackEngineType ||
				engines[4] == currentPackEngineType ||
				engines[5] == currentPackEngineType
			) {
				//for Point/Point3D (values in arr)
				var get_range_bundle = $(this).parent().children();
				if (get_range_bundle.length > 1) {
					var mapValues = [];
					for (var i = 0; i < get_range_bundle.length; i++) {
						mapValues[mapValues.length] = get_range_bundle[i].value;
					}
					setNewValue = mapValues;
				}
				//send to JSX Engine Cur App
				sendToUpdateCustomizeChanges("edit_customizer", setNewValue, getFxNumber, currentComposerCompCustomizer, getFxExtraPseudoIndex);
			}

			break;
		case "PR":
			//_COMPOSER
			if (engines[0] == currentPackEngineType) {
				sendToUpdateCustomizeChanges(getPropType, setNewValue, getFxNumber, currentComposerCompCustomizer, getValueIndex);
			}
			break;
	}
});

//Edit Text Input
$(document).on("input", '.tabs-stage div[data="sp_customizer_edit_text"] textarea', function () {
	//AE
	var getCompID = $(this).parent().parent().attr("comp-id"); //IMPORTANT CUSTOM COMP ID (if inside text in different comps)
	var getLayerID = $(this).parent().parent().attr("layer-id");
	//PR
	var getIndexID = $(this).parent().parent().attr("index-id");

	//COMMON
	var setNewValue = this.value;

	//Multiapplicator
	var engines = softAssetsByAppID[currentPackShortAppID]["engine"];
	switch (currentPackShortAppID) {
		case "AE":
			//_TEXT_PRESETS
			if (engines[0] == currentPackEngineType) {
			}
			//_COMPOSER or _TEXT_ANIMATOR
			if (engines[1] == currentPackEngineType || engines[3] == currentPackEngineType) {
				sendToUpdateCustomizeChanges("update_text", setNewValue, getLayerID, getCompID);
			}
			break;
		case "PR":
			//_COMPOSER
			if (engines[0] == currentPackEngineType) {
				sendToUpdateCustomizeChanges("Text", setNewValue, getIndexID, currentComposerCompCustomizer);
			}
			break;
	}
});

//Button Edit Original for Text Input (AE)
$(document).on("click", '.tabs-stage div[data="sp_customizer_edit_text"] ul.textEditor li div.btnEditTextOrigin', function () {
	var getCompID = $(this).parent().parent().attr("comp-id"); //IMPORTANT CUSTOM COMP ID (if inside text in different comps)
	var getLayerID = $(this).parent().parent().attr("layer-id");
	sendToUpdateCustomizeChanges("edit_text_in_viewer", "", getLayerID, getCompID);
});

//Button Open Placeholder (AE)
$(document).on("click", '.tabs-stage div[data="sp_customizer_edit_text"] ul.placeholderEditor li', function () {
	var getCompID = $(this).attr("comp-id"); //IMPORTANT CUSTOM COMP ID (if inside text in different comps)
	sendToUpdateCustomizeChanges("open_placeholder", "", "", getCompID);
});

//#endregion

//#region HEADER BLOCK EVENTS

// Get Info about pack version (swap author to show)
$(document).on(
	{
		mouseenter: function () {
			$(this).parent().find(".togglePackInfo").show();
			$(this).parent().find(".packAuthor").hide();
		},
		mouseleave: function () {
			$(this).parent().find(".togglePackInfo").hide();
			$(this).parent().find(".packAuthor").show();
		}
	},
	"#header .packDetails .packName"
);

//Click to author info in package
$(document).on("click", "#header .packDetails .packAuthor", function () {
	var authorText = $(this).find("strong").text();
	linkCore("author", authorText);
});

/* Personal Engine Click */
$(document).on("click", "#tools .external_engine_image", function () {
	linkCore("personal_engine", currentPackEngineType);
});

// Search box quering (event keyUp - unpress button)
$(document).on("keyup", "#tools .global input.search", function () {
	var search_value = this.value;
	var typeSearch = $(this).attr("data-find");
	switch (typeSearch) {
		case "items":
			previewPresaveInvoke = true;
			if (generatePackageContent("search", currentTempPackagePrefab, search_value)) {
				contentSwitcher("ATOM_SEARCH_GROUP", true, true);
				// readyUISettingsState();
			}
			break;
		case "ex-assets":
			inputDebounce(() => {
				$("external-lib-assets").scrollTop(0);
				stopObserver();
				loadNewContentExternalLibAssets(externalAssetLibDetails.lastType, 1, search_value, true);

				setTimeout(startObserver, 500);
			}, 750);

			// ,
			break;
	}
});

//TOOLS EVENTS

/* Special when Edit input for engine _TEXT_ANIMATOR */
$(document).on("keyup", '#tools .specialToolPlace[data-engine="_TEXT_ANIMATOR"] input', function () {
	var inItemsNowBtn = $('#tools .global li[data-view="SHOW_MAIN_ITEMS"]');
	if (!inItemsNowBtn.hasClass("disabled")) {
		inItemsNowBtn.click();
	}
});

/* Receive Message back from engine Text Animator */
csInterface.addEventListener("cep.sender.engine_text_animator.apply", function (event) {
	// csInterface.evalScript('$._AtomExt_aeComposer.addTextAnimatorRandomizer()')
	var mainData = event.data;
	var items = mainData.items;
	var mainText = mainData.mainText;
	// for (var key in items) {
	//     if (Object.hasOwnProperty.call(items, key)) {
	//         var element = items[key];
	//         alert(element.char);
	//     }
	// }

	setupProgressBar(true, "Applying");
	csInterface.evalScript(
		'applyItem("RANDOMIZE", false, false, false, ' + JSON.stringify(items) + ", " + JSON.stringify(mainText) + ")",
		function (result) {
			if (itemResponseListFromEngine(result)) {
				// createMessage('Applied', 'Element successfully applied', 'success');
				//set info about applying item
				// doApplyItem(false, false);
				setupProgressBar(false);

				/* Show customizer for _TEXT_ANIMATOR after doing all actions */
				$('#tools .global li[data-view="ATOM_CUSTOMIZER_GROUP"]').click();
			} else {
				cantApplyItem(result, false, false);
				setupProgressBar(false, "_STOP");
			}
		}
	);
});

function caseTextChecking(character) {
	if (character == character.toUpperCase()) {
		return "UPPERCASE";
	}
	if (character == character.toLowerCase()) {
		return "LOWERCASE";
	}
}

$(document).on("click", '#tools .specialToolPlace[data-engine="_TEXT_ANIMATOR"] .btn', function () {
	var btnAction = $(this).attr("data-action");
	if (btnAction == "open_randomizer") {
		var textAnimatorInput = $('#tools .specialToolPlace[data-engine="_TEXT_ANIMATOR"] input');
		if (textAnimatorInput.val()) {
			/* Run another extension */
			csInterface.requestOpenExtension("Atom.textAnimatorBuilder");

			setTimeout(function () {
				/* Create message to extension */
				var event = new CSEvent("cep.sender.engine_text_animator.sending");
				event.scope = "APPLICATION";
				event.data = JSON.stringify({
					text: textAnimatorInput.val(),
					samples_folder: getFolderWithAssetsItems(),
					template_folder: getFolderWithTemplateItems(),
					options: currentTempPackageInsideOptionsSets,
					structure: currentTempPackagePrefab.structure
				});
				csInterface.dispatchEvent(event);
			}, 1200);
		} else {
			textAnimatorInput.focus();
			return 0;
		}
	}
});

$(document).on("click", "external-lib-assets .masonry-grid .masonry-item .item-button-exlib", function () {
	var btnAction = $(this).attr("data-action");
	var assetSlug = $(this).parent().attr("data-slug");
	var downloadAct = $(this).parent().attr("data-download");
	var videoPreview = $(this).parent().attr("data-video-preview");
	switch (btnAction) {
		case "import":
			downloadExternalLibAssetToPc(downloadAct, assetSlug, videoPreview);
			break;
		case "view":
			break;
	}
});

$(document).on(
	{
		mouseenter: function () {
			// Проверяем, есть ли у элемента атрибут data-video-preview
			if ($(this).data("video-preview")) {
				var img = $(this).find("img");
				var videoSrc = $(this).data("video-preview");
				var video = $("<video/>", {
					src: videoSrc,
					muted: true,
					autoplay: true,
					loop: false
					// width: img.width(),
					// height: img.height()
				});

				// Начинаем воспроизведение видео
				video[0].play();

				// Останавливаем видео через 5 секунд
				setTimeout(() => {
					video[0].pause();
				}, 10000);

				// Скрываем изображение и вставляем видео
				img.hide();
				$(this).append(video);
			}
		},
		mouseleave: function () {
			if ($(this).data("video-preview")) {
				var video = $(this).find("video");
				var img = $(this).find("img");

				// Удаляем видео и показываем изображение
				video.remove();
				img.show();
			}
		}
	},
	"external-lib-assets .masonry-grid .masonry-item[data-video-preview]"
);

$(document).on(
	{
		click: function () {
			var data_type = $(this).data("type");
			var data_content_view = $(this).data("view");
			var engines = softAssetsByAppID[currentPackShortAppID]["engine"];
			//do main
			switch (data_type) {
				case "changeExLibAssetType":
					$("#tools .changeExLibAssetType li").removeClass("current"); //deselect engine toolbar btns
					$("#tools .global li").removeClass("current"); //deselect all toolbar buttons
					$(this).addClass("current");

					loadNewContentExternalLibAssets(data_content_view, 1, "");

					$('#tools .global input.search[data-find="ex-assets"]').val("");
					$("external-lib-assets").scrollTop(0);
					stopObserver();
					setTimeout(startObserver, 500);
					break;
				case "changeContentPanel":
					$("#tools .changeViewSwitcher li").removeClass("current"); //deselect engine toolbar btns
					$("#tools .global li").removeClass("current"); //deselect all toolbar buttons
					$(this).addClass("current");
					switch (data_content_view) {
						case "PACKAGE_ELEMENTS":
							$("#tools .global").hide();
							$("#tools .global[data-tools='default']").show();
							$("#container").show();
							$("external-lib-assets").hide();

							$("#tools .changeViewSwitcher .extraPanelViewSwitcherRight[data-view='EXTERNAL_LIB_ASSETS']").hide();

							stopObserver();
							break;
						case "EXTERNAL_LIB_ASSETS":
							preloadExternalLibAssets();
							$("#tools .global").hide();
							$("#tools .global[data-tools='external-assets']").show();
							$("#container").hide();

							$("#tools .changeViewSwitcher .extraPanelViewSwitcherRight[data-view='EXTERNAL_LIB_ASSETS']").show();

							$("#tools .global[data-tools='external-assets'] li[data-view='IMAGE']").addClass("current");

							setTimeout(startObserver, 500);

							$(".toolSpoilerContainer[data-view]").hide(); //hide tools from toolbar
							$("external-lib-assets").show();
							break;
					}
					break;
				case "engineSwitch":
					/* Engine _NEURO_PHOTO_ANIMATOR */
					// if(currentPackEngineType == engines[2]){
					$("#tools .extraSwitcher li").removeClass("current"); //deselect engine toolbar btns
					$("#tools .global li").removeClass("current"); //deselect all toolbar buttons
					$(this).addClass("current");
					switch (data_content_view) {
						case "PHOTO_ANIMATOR_MAIN":
							currentPackEngineType = engines[2];
							exePackEngineBindingJSX(engines[2]); //change JSX engine type like Photo Animator
							$("#tools .global").hide();
							// $('#tools .extraSwitcher').show();

							$("#container").hide();
							$("#photoAnimator").show();

							$(".toolSpoilerContainer[data-view]").hide(); //hide tools from toolbar

							break;
						case "PHOTO_ANIMATOR_ELEMENTS":
							//set toolbar as Composer
							currentPackEngineType = engines[1];
							exePackEngineBindingJSX(engines[1]); //change JSX engine type like Composer
							changeToolbarToEngine(engines[1], currentPackShortAppID);

							$("#tools .global").show();
							// $('#tools .extraSwitcher').hide();

							$("#container").show();
							$("#photoAnimator").hide();

							break;
					}
					// }

					break;
				case "content":
					if (!currentTempPackagePrefab["pack"]) {
						return false;
					} //cant open if no package
					//deselect all btn (except CHECKBOX type) before select
					$('#tools .global li:not([data-type="checkbox"])').removeClass("current");

					//set this li as current
					$(this).addClass("current");

					// contentStateReminded = data_content_view;
					//

					/* For special pointers */
					var showContent = true;
					switch (data_content_view) {
						case "ATOM_CUSTOMIZER_GROUP":
							previewPresaveInvoke = true;
							customizerIComposer(data_content_view);
							showContent = false;
							//
							break;
						case "ATOM_FAVORITES_GROUP":
							previewPresaveInvoke = true;
							if (generatePackageContent("favorites", currentTempPackagePrefab)) {
								// readyUISettingsState();
							}
							showContent = true;
							break;
					}
					//Show content and reset menu tree by current data_content_view
					if (showContent) {
						contentSwitcher(data_content_view, true);
					}

					$('#tools ul.global li[data-view="SHOW_MAIN_ITEMS"]').removeClass("current");

					break;
				case "popup":
					var openPopupFS = true;
					/* For special popup pointers */
					switch (data_content_view) {
						case "ATOM_VIDEO_TUTS":
							openPopupFS = upServerContent("vtuts");
							break;
					}
					//OPEN POPUP
					if (openPopupFS) {
						popupContentSwitcher(data_content_view);
					}

					break;

				/* Show items again (when disabled menu) */
				case "back_to_items":
					if (!currentTempPackagePrefab["pack"]) {
						return false;
					} //cant checked if no package

					//deselect all btn (except CHECKBOX type) before select
					$('#tools .global li:not([data-type="checkbox"])').removeClass("current");
					$("#menu li")[0].click();
					$('#tools ul.global li[data-view="SHOW_MAIN_ITEMS"]').addClass("current");

					break;
				case "checkbox":
					if (!currentTempPackagePrefab["pack"]) {
						return false;
					} //cant checked if no package
					$(this).toggleClass("current");
					$('.toolSpoilerContainer[data-view="' + data_content_view + '"]')
						.stop()
						.slideToggle({
							duration: 400,
							progress: panelLayoutResize
						});
					break;
			}
		},
		mouseenter: function () {
			//global hover image tip content
			if ($(this).hasClass("notifyGlow useTipParental")) {
				var data_content_view = $(this).data("view");

				switch (data_content_view) {
					case "SHOW_TOOLS":
						placeboardSwitcher(true, "tips", "Open toolbar to see next tip");
						break;
					case "ATOM_FAVORITES_GROUP":
						placeboardSwitcher(true, "tips", "Your favorite items are here");
						break;
					// case 'ATOM_CUSTOMIZER_GROUP': placeboardSwitcher(true, 'tips', 'You can use it to customize your project');
					//     break;
				}
				$(this).removeClass("notifyGlow");
			}
		},
		mouseleave: function () {
			placeboardSwitcher(false);
		}
	},
	"#tools ul li"
);

/* Special Toolbar sets */
$(document).on("input", "#tools .toolSpoilerContainer div[data-engine] .pr_speed_control input.ppro_range_speed", function () {
	var speedTitle = $(this).parent().find(".speed_icon_block .speed_title");
	speedTitle.data("speed", this.value);
	speedTitle.text(this.value + "%");
});

/* Special Toolbar for engine Photo Animator */
// $(document).on('click',  '#tools .extraSwitcher li', function(){
//     var data_type = $(this).data('type');
//     var data_content_view = $(this).data('view');

//     $('#tools .extraSwitcher li:not([data-type="checkbox"])').removeClass('current');

//     switch(data_content_view){
//         case 'PHOTO_ANIMATOR_MAIN':
//             $('#tools .global').hide();
//             $('#tools .extraSwitcher').show();

//             $('#container').hide();
//             $('#photoAnimator').show();
//             break;
//         case 'PHOTO_ANIMATOR_ELEMENTS':
//             $('#tools .global').show();
//             $('#tools .extraSwitcher').hide();

//             $('#container').show();
//             $('#photoAnimator').hide();
//             break;
//     }

//     $(this).addClass('current');
// });

//TOOLBAR PACK BUTTONS

$(document).on(
	{
		click: function () {
			var cur_action = $(this).attr("action");
			var only_premium_btn = $(this).attr("only-premium");
			var engines = softAssetsByAppID[currentPackShortAppID]["engine"];
			/* Send params for buttons tools panel */
			var paramsButtons = {};
			/* _PRESET_MANAGER */
			if (currentPackEngineType == engines[4] || currentPackEngineType == engines[5]) {
				if (currentTempPackagePrefab.pack.version == "DEMO" && only_premium_btn) {
					// placeboardSwitcher(true, 'requires', 'Available only in the full version');
					var packInfoString =
						'data-pack-name="' +
						currentTempPackagePrefab.pack["name"] +
						'" data-pack-appid="' +
						currentTempPackagePrefab.pack["appID"] +
						'" data-pack-author="' +
						currentTempPackagePrefab.pack["author"] +
						'"';
					return createMessage(
						"Full version required",
						"<a " + packInfoString + ' data-type="package">Click here</a> to buy the full version.',
						"info",
						true
					);
				}

				paramsButtons["frames"] = $("#tools .toolSpoilerContainer div[data-engine] input.pmLayersCount").val();
			}

			//do main
			sendToUpdateCustomizeChanges("button_action", cur_action, paramsButtons);
		},
		mouseenter: function () {
			if ($(this).hasClass("notifyGlow")) {
				//children button tip notify content
				var cur_action = $(this).attr("action");
				switch (cur_action) {
					case "remove_unused":
						placeboardSwitcher(true, "tips", "If work is done, you can clear unused assets");
						break;
				}
				$(this).removeClass("notifyGlow");
			}
		},
		mouseleave: function () {
			placeboardSwitcher(false);
		}
	},
	"#tools .toolSpoilerContainer > div ul.btns li[action]"
);

$(document).on("click", "#tools .toolSpoilerContainer .hiddenSubPanelTools.pmAnchorPoint div[data-direction]", function () {
	var cur_action = $(this).attr("data-direction");
	sendToUpdateCustomizeChanges("anchor_point_tool", cur_action);
});

//#endregion

//#region PACKAGE MANAGER

// Show Package manager (click to logo atom)
$(document).on("click", "#header .atomLogo", function () {
	if (maskedIVE.settings && maskedIVE.settings.marketAsPackageManager) {
		popupContentSwitcher("ATOM_MARKET");
	} else {
		changeShowHideBlurred(true, ".packageManager", 2);
	}
});

// Close packageManager
$(document).on("click", ".packageManager .close", function () {
	changeShowHideBlurred(false, ".packageManager", 2);
});

$(document).on("click", ".youtubeVideoView .close", function () {
	stopYtVideo();
});

// Action btn with packages inside packageManager
$(document).on("click", ".packageManager li .managerButtons .btn", function () {
	var packName = $(this).parent().parent().parent().data("name");
	var packAuthor = $(this).parent().parent().parent().data("author");
	var packAppID = $(this).parent().parent().parent().data("appid");
	var packAppVersion = $(this).parent().parent().parent().data("appversion");
	var actionType = $(this).data("action");
	switch (actionType) {
		case "apply":
			//collect arg to json
			var stringifyInput = {
				name: packName,
				author: packAuthor,
				appID: packAppID,
				appVersion: packAppVersion
			};

			runPackageHandler(false, stringifyInput, true);
			break;
		case "remove":
			//collect arg to json
			var stringifyInput = {
				name: packName,
				author: packAuthor,
				appID: packAppID,
				appVersion: packAppVersion
			};
			tempPackRemoveData = stringifyInput;
			changeShowHideBlurred(true, ".confirmRemovePackage", 4);
			// removePackageHandler(stringifyInput);
			break;
		case "similar":
			linkCore("package", {
				type: "similar",
				appid: packAppID,
				name: packName,
				author: packAuthor
			});

			break;
	}
});

// Click to package author link
$(document).on("click", ".packageManager li .packDetails .info_sector .author strong", function () {
	var packAuthor = $(this).parent().parent().data("author");
	linkCore("author", packAuthor);
});

//Click to links inside
$(document).on("click", ".packageManager a", function () {
	var linkWay = $(this).data("way");
	switch (linkWay) {
		//open file dialog to choose package
		case "install":
			$(".dragAndDropInstallation .place input").click();
			break;
		//open market here
		case "market":
			$(".packageManager .close").click(); //close packageManager
			$("#header .headMenu").click(); //load and open market
			break;
	}
});

// Add package to favorites
$(document).on("click", ".packageManager .favoritePackage", function () {
	var packName = $(this).parent().parent().data("name");
	var packAuthor = $(this).parent().parent().data("author");
	if ($(this).hasClass("active")) {
		$(this).removeClass("active");
		togglePackageAsFavorite(packName, packAuthor, false);
	} else {
		$(this).addClass("active");
		togglePackageAsFavorite(packName, packAuthor, true);
	}

	// alert(linkWay);
	// switch (linkWay) {
	//   //open file dialog to choose package
	//   case "install":
	//     $(".dragAndDropInstallation .place input").click();
	//     break;
	//   //open market here
	//   case "market":
	//     $(".packageManager .close").click(); //close packageManager
	//     $("#header .headMenu").click(); //load and open market
	//     break;
	// }
});

$(document).on("click", ".packageManager .sorting-dropdown-list > .sorting-dropdown-item", function () {
	// if ($(this).attr("name") == "packSortFavorited") {
	//   if ($(this).is(":checked")) {
	//     editLocalPSets(true, "packSortFavorited", 1);
	//   } else {
	//     editLocalPSets(true, "packSortFavorited", 0);
	//   }
	// }

	if ($(this).parent().parent().data("type") == "packSortByNames") {
		editLocalPSets(true, "packSortByNames", Number($(this).data("value")));
		UIPackSortSelecting("packSortByNames", $(this).data("value") == 0, $(this).text());
	}
	if ($(this).parent().parent().data("type") == "packSortApp") {
		editLocalPSets(true, "packSortApp", $(this).data("value"));
		UIPackSortSelecting("packSortApp", $(this).data("value") == "none", $(this).text());
	}

	packageManagerBuilder(packageGetLists(), packageGetIsLoad());
	saveLocalPreferences("PSets");
});

$(document).on("click", ".extraPanelViewSwitcherRight .sorting-dropdown-list > .sorting-dropdown-item", function () {
	if ($(this).parent().parent().data("type") == "exAssetsActionAfterDownload") {
		libAssetImportTo = $(this).attr("data-value");
		UIPackSortSelecting("exAssetsActionAfterDownload", true, $(this).text());
	}
});

/* Reset sorting by clicking to header */
$(document).on("click", ".packageManager .sorting-dropdown-header", function () {
	if ($(this).parent().data("type") == "packSortByNames") {
		editLocalPSets(true, "packSortByNames", Number($(this).data("value")));
		UIPackSortSelecting("packSortByNames", true, "Default");
	}
	if ($(this).parent().data("type") == "packSortApp") {
		editLocalPSets(true, "packSortApp", $(this).data("value"));
		UIPackSortSelecting("packSortApp", "none", "Any App");
	}

	packageManagerBuilder(packageGetLists(), packageGetIsLoad());
	saveLocalPreferences("PSets");
});

$(document).on("click", ".packageManager .sorting-by-favorited", function () {
	if ($(this).hasClass("active")) {
		editLocalPSets(true, "packSortFavorited", 0);
		UIPackSortSelecting("packSortFavorited", true);
	} else {
		editLocalPSets(true, "packSortFavorited", 1);
		UIPackSortSelecting("packSortFavorited", false);
	}

	packageManagerBuilder(packageGetLists(), packageGetIsLoad());
	saveLocalPreferences("PSets");
});

//#endregion

//#region MARKETPLACE

//open market
$(document).on("click", "#header .headMenu", function () {
	upServerContent("marketAndUpdater", "openMarket"); //load/reload market json data
	popupContentSwitcher("ATOM_MARKET");
});

//special right buttons in market top section
$(document).on("click", "#popupContent .poBlock.atomMarket .top .fbtn", function () {
	var curDataAct = $(this).attr("data-act");
	//[data-act="market_website"]
	switch (curDataAct) {
		case "market_website":
			linkCore("link", "marketplace");
			break;
		case "market_off_notify":
			marketTurnOffNotify(true);
			$(this).addClass("disabled").html('<div class="turnOffNotifyOk"></div>No notifications');
			break;

		/* Login (subscription) */
		case "market_login":
			// popupContentSwitcher();
			changeShowHideBlurred(true, ".personalizedMarketLogin", 3);

			// alert(1);
			// popupContentSwitcher('ATOM_LOGINS');
			break;
	}
});

//Click to market in down button - go to/load more
$(document).on("click", ".atomMarket .loadMoreButton", function () {
	linkCore("link", "marketplace");
});

$(document).on("click", ".atomMarket .market_tags_button li", function () {
	// linkCore("link", "marketplace");
	var checked = $(this).hasClass("checked");

	$(this).parent().find("li").removeClass("checked");
	if (checked) {
		sortMarketItems(null);
		$(this).removeClass("checked");
	} else {
		$('.customizeElement div[show-content-type="market"]').removeClass("selected");
		$('.customizeElement div[show-content-type="market"][in-show-content="all"]').addClass("selected");

		sortMarketItems($(this).text());
		$(this).addClass("checked");
	}
});

//When scrollbar in down - event - need works after more packages on page
// var scrollMarketCounter = 0;
// $(".poBlock.atomMarket .pbody").scroll(function() {
// /*     if ($(".poBlock.atomMarket .pbody").scrollTop() == $(document).height() - $(".poBlock.atomMarket .pbody").height() && scrollMarketCounter < 2) {
//         alert(scrollMarketCounter);
//     } */
//     var div = $(this).get(0);
//     if(div.scrollTop + div.clientHeight >= div.scrollHeight) {
//         // alert(1);
//     }

// });

//hide message from market when mouse move
$(document).on("mousemove", "#header .headMenu", function () {
	marketNewMessage(false);
});

//Market Item Hover
$(document).on(
	{
		mouseenter: function () {
			// $(this).toggleClass('selected');
			$(this).closest(".mitem").addClass("hovered");

			$(this).css("opacity", 1);
			$(this).find(".labelInstalledNotify").hide();
			$(this).find(".hiddenContent").stop().slideDown(150);

			//turn off new notify for one item
			var findNewBadge = $(this).find(".badgeNew");
			if (findNewBadge[0]) {
				var itemId = $(this).attr("item_id");
				$('.atomMarket .mitem[item_id="' + itemId + '"] .badgeNew').fadeOut();
				// findNewBadge.fadeOut();
				marketTurnOffNotify(false, itemId);
			}
		},
		mouseleave: function () {
			// $(this).toggleClass('selected');
			$(this).closest(".mitem").removeClass("hovered");

			$(this).find(".labelInstalledNotify").show();

			$(this).css("opacity", 1);
			$(this).find(".hiddenContent").stop().slideUp(150);
		}
	},
	".atomMarket .mitem"
);

//Run Youtube IFrame
//Updated AtomX 3.0.2 -r25 - now youtube player will be added only after click - for optimization.
//also used YouTube API - to create tag iframe/and destroy if click at other video/or close popup
$(document).on("click", ".atomMarket .mitem .play_button", function (ev) {
	ev.preventDefault();

	// changeShowHideBlurred(true, '.youtubeVideoView', 2);

	//prepare iframe code
	var videoId = $(this).closest(".mitem").attr("video_id");
	// var videoIdTag = $(this).parent().parent().find('.videoBlock div')[0].id;
	// var getPlayer = addIFrameYoutube(videoId, true);

	playYtVideo(videoId);

	//turn off all yt player and run current play
	// stopAllYoutubePlayers('.atomMarket .mitem .videoBlock');
	//add iframe and play
	// playIFrame(videoIdTag, videoId);

	//hide image to see iframe
	// $(this).parent().fadeOut();
});

$(document).on("click", ".atomMarket .mitem .apply_as_package", function (ev) {
	ev.preventDefault();
	var itemObj = $(this).closest(".mitem");

	var stringifyInput = {
		name: itemObj.attr("pack-name"),
		author: itemObj.attr("pack-author"),
		appID: itemObj.attr("pack-appid")
	};

	runPackageHandler(false, stringifyInput, true);
});

//Click to button in market item
$(document).on("click", ".atomMarket .mitem .hiddenContent .btn", function () {
	var btn_type = $(this).attr("btn-type");
	var global_item_e = $(this).closest(".mitem");
	var pack_name = global_item_e.attr("pack-name");
	var pack_appid = global_item_e.attr("pack-appid");
	var pack_author = global_item_e.attr("pack-author");
	var pack_version = global_item_e.attr("pack-version");
	var pack_appversion = global_item_e.attr("pack-appversion");
	var pack_ext_version = global_item_e.attr("pack-ext-version");
	// var market_item_type = global_item_e.attr('market_item_type');

	//For packages
	// if (market_item_type == 'Packages') {
	//     //New system: by subscription downloads
	//     if (btn_type == 'download_by_subs') {
	//         downloadPackageBySubscription({
	//             'type': btn_type,
	//             'name': pack_name,
	//             'appid': pack_appid,
	//             'author': pack_author,
	//             'version': pack_version
	//         });
	//     } else {
	//         //type: premium
	//         linkCore('package', {
	//             'type': btn_type, //premium
	//             'name': pack_name,
	//             'appid': pack_appid,
	//             'author': pack_author,
	//             'version': pack_version
	//         });
	//     }

	// } else {
	//     //Non packages items (templates/scripts/any)
	//     var item_id = global_item_e.attr('item_id');
	//     linkCore('e_market_item', {
	//         'type': btn_type,
	//         'item_id': item_id
	//     });
	// }

	if (btn_type == "download_by_subs") {
		downloadPackageBySubscription({
			type: btn_type,
			name: pack_name,
			appid: pack_appid,
			author: pack_author,
			version: pack_version,
			appversion: pack_appversion,
			ext_version: pack_ext_version
		});
	} else {
		//type: premium
		linkCore("package", {
			type: btn_type, //premium
			name: pack_name,
			appid: pack_appid,
			author: pack_author,
			version: pack_version
		});
	}
});

//Click to has version in compatibles/in description li
$(document).on("click", ".atomMarket .mitem .content [has-version]", function () {
	var global_item_e = $(this).closest(".mitem");

	//if custom href for bind pack compatible version
	var this_custom_href = $(this).attr("custom-href");
	var item_id = global_item_e.attr("item_id");

	//has appID version
	var t_open_version = $(this).attr("has-version");
	//mitem data
	var pack_name = global_item_e.attr("pack-name");
	var pack_author = global_item_e.attr("pack-author");

	var linkType = this_custom_href ? "e_market_item" : "package";
	linkCore(linkType, {
		type: "premium",
		name: pack_name,
		appid: t_open_version,
		author: pack_author,
		item_id: item_id
	});
});

//Click to author on time
$(document).on("click", ".atomMarket .mitem .content .author", function () {
	var t_author = $(this).closest(".mitem").attr("pack-author");
	linkCore("author", t_author);
});

//#endregion

//#region Video Tutorials

/* $(document).on('click', '.videoTutorials .play_button', function(ev) {
	ev.preventDefault();


	//prepare iframe code
	var parentLi = $(this).parent().parent();
	var videoId = parentLi.attr('video_id');
	var videoIdTag = parentLi.find('.videoBlock div')[0].id;

	//turn off all yt player and run current play
	stopAllYoutubePlayers('.videoTutorials .videoBlock');
	//add iframe and play
	playIFrame(videoIdTag, videoId, [320, 213]);
	
	//hide image to see iframe
	$(this).parent().fadeOut();
}); */

$(document).on("click", ".videoTutorials .over-video > div", function (ev) {
	ev.preventDefault();

	var actionType = $(this).data("action");

	if (actionType == "play") {
		//prepare iframe code
		var parentLi = $(this).parent().parent();
		var videoId = parentLi.attr("video_id");
		// var videoIdTag = parentLi.find('.videoBlock div')[0].id;

		//turn off all yt player and run current play
		// stopAllYoutubePlayers('.videoTutorials .videoBlock');
		//add iframe and play
		// playIFrame(videoIdTag, videoId, [320, 213]);
		playYtVideo(videoId);

		//hide image to see iframe
		// $(this).parent().fadeOut();
	}

	if (actionType == "open_browser") {
		var webYoutubeID = $(this).parent().parent().attr("video_id");
		var webAddress = encodeURI("https://www.youtube.com/watch?v=" + webYoutubeID);
		csInterface.openURLInDefaultBrowser(webAddress);
	}
});

$(document).on("click", ".youtubeVideoView .open_in_browser", function () {
	var webYoutubeID = $(this).data("video-id");
	var webAddress = encodeURI("https://www.youtube.com/watch?v=" + webYoutubeID);
	csInterface.openURLInDefaultBrowser(webAddress);
});

//#endregion

//#region ITEM CLICK EVENTS - APPLY/ADD
//item mouse hover/leave (start/stop animation)
$(document).on(
	{
		//New - Double click, created for Premiere Pro as replacing Dnd (if need), but possible use in AE if one button
		dblclick: function () {
			if (init_sets.appID != "PPRO" || currentTempPackagePrefab.pack.appID != "PR") {
				return false;
			}
			prepareToApplyPremierePro(false, $(this), dragAndDropData);
			applyItemPremiereProLikeAs(false, dragAndDropData);
			dragAndDropData = {};
		},
		//Hover
		mouseenter: function () {
			//Item arguments
			var getItemId = $(this).attr("item_id");
			var getItemName = $(this).attr("item_name");
			var getInstanceGroup = $(this).attr("instance_group");
			var getItemArguments = $(this).attr("arguments");

			var parseArguments = parseAndGetArguments(getItemArguments);
			var isAudioFile = parseArguments.is_audio;
			var isFootageFile = parseArguments.is_footage;
			var disableWebmItem = parseArguments.disable_webm_preview;
			var getItemCustomArgs = parseArguments.custom_args || {};
			if (!$(this).hasClass("is_demo_lock")) {
				if (isAudioFile) {
					var cPathAudio = getItemFilepath(getItemId, getItemName, getInstanceGroup, parseArguments).file;
					audioController(true, cPathAudio);
				}
			} else {
				placeboardSwitcher(true, "only_premium", "Available only in the premium version");
			}

			if (!editLocalUI(false, "previewAutoPlay")) {
				updateItemPreview($(this), isFootageFile, isAudioFile, disableWebmItem, true);
			}

			var get_body = $(this).find(".body");
			get_body.stop().show();

			//From AtomX 3.1+ check and show item for current version, or show message if no
			//if has customArg for required soft version, or global for group (customArg in priority)
			if (getItemCustomArgs["req_soft_version"] || parseArguments["group_req_soft_version"]) {
				reqSoftVersion = getItemCustomArgs["req_soft_version"] || parseArguments["group_req_soft_version"];
				//if current soft version lower than required - show message

				if (!compareSoftwareVersion(reqSoftVersion)) {
					var versionLikeCCNamed = creativeCloudNameVersion(reqSoftVersion, currentTempPackagePrefab.pack.appID);
					placeboardSwitcher(true, "requires", "This item requires " + versionLikeCCNamed + " or above");
				}
			}

			// if(parseArguments['mogrt_transition_system']){
			//     placeboardSwitcher(true, 'requires', 'Use double-click to apply');
			// }

			//show info footer text with item name
			if (editLocalUI(false, "previewLayoutSize") < 8) {
				footerInfoText(true, "<span class='faded'>Item </span>" + $(this).attr("item_name"));
			}
		},
		//Leave
		mouseleave: function () {
			//Item arguments
			var getItemArguments = $(this).attr("arguments");
			var parseArguments = parseAndGetArguments(getItemArguments);

			var isAudioFile = parseArguments.is_audio;
			var isFootageFile = parseArguments.is_footage;
			var disableWebmItem = parseArguments.disable_webm_preview;
			if (isAudioFile) {
				audioController(false);
			}

			//let's if not active autoplay
			// if (isFootageFile != "JPG" && isFootageFile != "PNG") {
			//   if (!editLocalUI(false, "previewAutoPlay")) {
			//     var img_holder = $(this).find("img.source");
			//     var img_src = img_holder.attr("src").replace(/\.gif$/i, ".png");
			//     img_holder.attr("src", img_src);
			//   }
			// }
			// updateItemPreview($(this), isFootageFile, isAudioFile, false);
			if (!editLocalUI(false, "previewAutoPlay")) {
				updateItemPreview($(this), isFootageFile, isAudioFile, disableWebmItem, false);
			}

			var get_body = $(this).find(".body");
			get_body.stop().hide();

			//From AtomX 3.1+ - fade off big header messages when leave from item
			placeboardSwitcher(false);

			//hide info footer text
			if (editLocalUI(false, "previewLayoutSize") < 8) {
				footerInfoText(false);
			}
		}
	},
	"#content .element"
);

/* Return to tree menu back when click on Add Animation (in engine _PRESET_MANAGER) */
$(document).on("click", "#content .element.placeholderToAdd", function () {
	if (savePreviousTreeGroup) {
		contentSwitcher(savePreviousTreeGroup, false);
	}
});

//click to control button inside item (any actions)
$(document).on("click", "#content .element .applyControls .button", function () {
	var this_element = $(this).parent().parent();
	var cur_action = $(this).attr("action");
	var cur_item_id = this_element.attr("item_id");
	var cur_item_name = this_element.attr("item_name");
	var cur_item_arguments = this_element.attr("arguments"); //already converted object to string
	var cur_item_instance_grp = this_element.attr("instance_group");
	var extra_arguments = {}; //need convert to string

	var isApplyItem = true;

	var parseArguments = parseAndGetArguments(cur_item_arguments);
	// var getItemId = $(this).attr('item_id');
	// var getItemName = $(this).attr('item_name');
	// var getInstanceGroup = $(this).attr('instance_group');
	// var getItemArguments = $(this).attr('arguments');

	// var parseArguments = parseAndGetArguments(getItemArguments);
	// var isAudioFile = parseArguments.is_audio;
	// var isFootageFile = parseArguments.is_footage;
	// if(isAudioFile){
	//     var cPathAudio = getItemFilepath(getItemId, getItemName, getInstanceGroup, parseArguments).file;
	//     audioController(true, cPathAudio);
	// }

	var engines = softAssetsByAppID[currentPackShortAppID]["engine"];
	//do main
	// currentPackEngineType = engines[2];

	if (currentTempPackagePrefab.pack.version == "DEMO" && this_element.hasClass("is_demo_lock")) {
		// placeboardSwitcher(true, 'requires', 'Available only in the full version');
		var packInfoString =
			'data-pack-name="' +
			currentTempPackagePrefab.pack["name"] +
			'" data-pack-appid="' +
			currentTempPackagePrefab.pack["appID"] +
			'" data-pack-author="' +
			currentTempPackagePrefab.pack["author"] +
			'"';
		return createMessage(
			"Full version required",
			"<a " + packInfoString + ' data-type="package">Click here</a> to buy the full version.',
			"info",
			true
		);
	} else {
		hideSystemMessage();
	}

	var itemFileData = getItemFilepath(cur_item_id, cur_item_name, cur_item_instance_grp, parseArguments, cur_action);
	extra_arguments["filepath"] = itemFileData.file;
	extra_arguments["last_group"] = itemFileData.last;
	extra_arguments["name"] = itemFileData.name;
	switch (cur_action) {
		// _COMPOSER
		case "APPLY":
			/* engine: _TEXT_ANIMATOR */
			if (currentPackEngineType == engines[3]) {
				var textAnimatorInput = $('#tools .specialToolPlace[data-engine="' + engines[3] + '"] input');
				if (textAnimatorInput.val()) {
					extra_arguments["animator_text"] = textAnimatorInput.val();
				} else {
					textAnimatorInput.focus();
					return 0;
				}
			}
			/* engine: _PRESET_MANAGER */
			if (currentPackEngineType == engines[4]) {
				// alert(1);
			}
			break;
		case "IMPORT":
			break;
		// _TEXT_PRESETS [now only AE]
		case "TP_IN":
		case "TP_BOTH":
		case "TP_OUT":
			/* engine: _TEXT_PRESETS */
			if (currentPackEngineType == engines[0]) {
				//convert extra argument to string
				extra_arguments["mix_mode"] = $(".toolSpoilerContainer input[name='checkbox-text-animation-mix-mode']:checked").val();
				extra_arguments["preset_type"] = cur_action.substr(3, 10); //remove TP_ before send in JSX
			}
			break;
		case "PM_SELECT":
			var pm_removeFxNum = this_element.attr("fx-number");
			customizerRequestCustom(pm_removeFxNum, "ATOM_CUSTOMIZER_GROUP_PM_PICKS");
			isApplyItem = false; //disable apply item
			break;
		case "PM_COPY":
			var attr_action_for = this_element.attr("pm_type");
			var pm_removeFxNum = this_element.attr("fx-number");
			changeBtnActionNotifyUser($(this), false, true, "pushUpAnimate");

			sendToUpdateCustomizeChangesWithChecking("control_preview_one", "COPY", attr_action_for, pm_removeFxNum, clipBoardPM_Presets);
			isApplyItem = false; //disable apply item
			break;
		case "PM_REMOVE":
			//remove single preset from text layer
			isApplyItem = false; //disable apply item

			var attr_action_for = this_element.attr("pm_type");
			var pm_removeFxNum = this_element.attr("fx-number");

			sendToUpdateCustomizeChangesWithChecking("control_preview_one", "DELETE", attr_action_for, pm_removeFxNum, "", function () {
				// $('.element[ref="customizer_PM"][pm_type="'+attr_action_for+'"]').stop().slideUp();
				// cuteRemovalAnimaiton($('.element[ref="customizer_PM"][pm_type="'+attr_action_for+'"]'));
				// counter_customize_text_presets[attr_action_for]--;
				// $('.customizerPM_presetsHead .btns[data-for="'+attr_action_for+'"] > div.count').html(countStrNaming(counter_customize_text_presets[attr_action_for], "Preset", "Presets"));
				// $('.customizerPM_presetsHead .btns[data-for="GLOBAL"] > div.count').html(countStrNaming(Number(counter_customize_text_presets["IN"] + counter_customize_text_presets["OUT"] + counter_customize_text_presets["MID"]), "Preset", "Presets"));
				customizerIComposer("ATOM_CUSTOMIZER_GROUP");
			});

			// this_element.slideUp(); //hide item
			// sendToUpdateCustomizeChanges('remove', tp_type, pm_removeFxNum, '');
			// //change counting in buttons (customizer)
			// TP_updateCustomizerCountButtons(tp_type, true);
			break;
		case "TP_REMOVE":
			//remove single preset from text layer
			isApplyItem = false; //disable apply item

			var tp_type = this_element.attr("tp_type");
			this_element.slideUp(); //hide item
			sendToUpdateCustomizeChanges("remove", tp_type, cur_item_id, "");
			//change counting in buttons (customizer)
			TP_updateCustomizerCountButtons(tp_type, true);
			break;
	}

	if (isApplyItem) {
		//do
		setupProgressBar(true, "Applying");
		csInterface.evalScript(
			'applyItem("' +
				cur_action +
				'", "' +
				cur_item_id +
				'", "' +
				cur_item_name +
				'", "' +
				cur_item_instance_grp +
				'", ' +
				cur_item_arguments +
				", " +
				JSON.stringify(extra_arguments) +
				")",
			function (result) {
				if (itemResponseListFromEngine(result)) {
					// createMessage('Applied', 'Element successfully applied', 'success');
					//set info about applying item
					doApplyItem(cur_item_name, cur_item_instance_grp);
					setupProgressBar(false);

					/* Show customizer for _TEXT_ANIMATOR after doing all actions */
					if (currentPackEngineType == engines[3]) {
						$('#tools .global li[data-view="ATOM_CUSTOMIZER_GROUP"]').click();
					}
				} else {
					cantApplyItem(result, cur_item_name, cur_item_instance_grp);
					setupProgressBar(false, "_STOP");
				}
			}
		);
		//fixed for audio (exactly as for Premiere Pro dragging item)
		$(".element").mouseleave();
	}
});

//click to item small buttons add/remove favorite/etc
$(document).on("click", "#content .element .body .usage .btn.favorite", function () {
	var curElement = $(this).parent().parent().parent();
	var curItemId = curElement.attr("item_id");
	var curElementDView = curElement.parent().attr("data-view");
	var markIsFavorite = favoriteHTMLEventHandler($(this), curElement, false, false); //html action - return true/false

	//control - save/delete favorites
	favoritesController(markIsFavorite, curItemId);
	//if in favorites/or search find element with ID and refresh favorite action
	// if (curElementDView == "ATOM_FAVORITES_GROUP" || curElementDView == "ATOM_SEARCH_GROUP" || curElementDView == "ATOM_CUSTOMIZER_GROUP") {
	var relativeEThis = $('#content .element[item_id="' + curItemId + '"]');
	favoriteHTMLEventHandler(relativeEThis.find(".favorite"), relativeEThis, true, markIsFavorite);
	// }
});

//#endregion

//#region CUSTOMIZER TEXT PRESETS

$(document).on(
	{
		click: function () {
			var attr_data_type = $(this).attr("data");

			sendToUpdateCustomizeChanges("remove", attr_data_type, "", "");

			//hide items from customizer
			if (attr_data_type == "BOTH") {
				$('.element[ref="customizer_TP"][tp_type="IN"]').stop().slideUp();
				$('.element[ref="customizer_TP"][tp_type="OUT"]').stop().slideUp();
			} else {
				$('.element[ref="customizer_TP"][tp_type="' + attr_data_type + '"]')
					.stop()
					.slideUp();
			}
			//change counting in buttons (customizer)
			TP_updateCustomizerCountButtons(attr_data_type, false);
		},
		mouseenter: function () {
			var attr_data_type = $(this).attr("data");
			if (attr_data_type == "BOTH") {
				$('.element[ref="customizer_TP"][tp_type="IN"]').find(".overlay_TP").stop().show();
				$('.element[ref="customizer_TP"][tp_type="OUT"]').find(".overlay_TP").stop().show();
			} else {
				$('.element[ref="customizer_TP"][tp_type="' + attr_data_type + '"]')
					.find(".overlay_TP")
					.stop()
					.show();
			}
		},
		mouseleave: function () {
			var attr_data_type = $(this).attr("data");
			if (attr_data_type == "BOTH") {
				$('.element[ref="customizer_TP"][tp_type="IN"]').find(".overlay_TP").stop().hide();
				$('.element[ref="customizer_TP"][tp_type="OUT"]').find(".overlay_TP").stop().hide();
			} else {
				$('.element[ref="customizer_TP"][tp_type="' + attr_data_type + '"]')
					.find(".overlay_TP")
					.stop()
					.hide();
			}
		}
	},
	".coBlock ul.customizeElement.TPMassAction li .block div"
);

function changeBtnActionNotifyUser(qThis, replaceText, withoutDisabled, addCustomClass) {
	var t_this = qThis;
	var oldHtmlBtn = t_this.html();
	if (!withoutDisabled) {
		if (replaceText) {
			t_this.html(replaceText).addClass("disabled");
		} else {
			t_this.addClass("disabled");
		}
	} else {
		if (replaceText) {
			t_this.html(replaceText);
		}
	}

	if (addCustomClass) {
		t_this.addClass(addCustomClass);
	}

	setTimeout(function () {
		if (!withoutDisabled) {
			t_this.html(oldHtmlBtn).removeClass("disabled");
		} else {
			t_this.html(oldHtmlBtn);
		}
		if (addCustomClass) {
			t_this.removeClass(addCustomClass);
		}
	}, 1000);
}

// var cs = new CSInterface();
// cs.addEventListener("documentCreated", function(event){
//   alert('Cool!' + event.data);
// });

// var extendScript = 'var externalObjectName = "PlugPlugExternalObject"; var mylib = new ExternalObject( "lib:" + externalObjectName ); app.project.activeItem.selectedLayers > 0; var eventObj = new CSXSEvent(); eventObj.type="documentCreated"; eventObj.data="blahblah"; eventObj.dispatch();'
// cs.evalScript(extendScript);

/* Customizer picks _PRESET_MANAGER */
$(document).on("click", ".coBlock .customizerPM_presetsHead .btns > div[data]", function () {
	var attr_data_type = $(this).attr("data");
	var attr_action_for = $(this).parent().attr("data-for");

	// var clipBoardPrepare = attr_action_for == 'GLOBAL' ? clipBoardPM_Presets : clipBoardPM_Presets[attr_action_for];
	if (attr_data_type == "COPY") {
		changeBtnActionNotifyUser($(this), "Copied");
	}

	sendToUpdateCustomizeChangesWithChecking("control_preview", attr_data_type, attr_action_for, "", clipBoardPM_Presets, function () {
		if (attr_data_type == "DELETE" || attr_data_type == "PASTE") {
			// if(attr_action_for == 'IN' || attr_action_for == 'OUT' || attr_action_for == 'MID'){
			//     // $('.element[ref="customizer_PM"][pm_type="'+attr_action_for+'"]').stop().slideUp();
			//     // cuteRemovalAnimaiton($('.element[ref="customizer_PM"][pm_type="'+attr_action_for+'"]'));
			//     // counter_customize_text_presets[attr_action_for] = 0;
			//     // $('.customizerPM_presetsHead .btns[data-for="'+attr_action_for+'"] > div.count').html(countStrNaming(0, "Preset", "Presets"));
			//     // $('.customizerPM_presetsHead .btns[data-for="GLOBAL"] > div.count').html(countStrNaming(Number(counter_customize_text_presets["IN"] + counter_customize_text_presets["OUT"] + counter_customize_text_presets["MID"]), "Preset", "Presets"));
			// }else if(attr_action_for == 'GLOBAL'){

			//     // counter_customize_text_presets['IN'] = 0;
			//     // counter_customize_text_presets['OUT'] = 0;
			//     // counter_customize_text_presets['MID'] = 0;
			//     // cuteRemovalAnimaiton($('.element[ref="customizer_PM"][pm_type="IN"]'));
			//     // cuteRemovalAnimaiton($('.element[ref="customizer_PM"][pm_type="OUT"]'));
			//     // cuteRemovalAnimaiton($('.element[ref="customizer_PM"][pm_type="MID"]'));
			//     // $('.customizerPM_presetsHead .btns[data-for="IN"] > div.count').html(countStrNaming(0, "Preset", "Presets"));
			//     // $('.customizerPM_presetsHead .btns[data-for="OUT"] > div.count').html(countStrNaming(0, "Preset", "Presets"));
			//     // $('.customizerPM_presetsHead .btns[data-for="MID"] > div.count').html(countStrNaming(0, "Preset", "Presets"));
			//     // $('.customizerPM_presetsHead .btns[data-for="GLOBAL"] > div.count').html(countStrNaming(0, "Preset", "Presets"));
			// }
			customizerIComposer("ATOM_CUSTOMIZER_GROUP");
		}
	});
	// sendToUpdateCustomizeChanges('control_preview', attr_data_type, attr_action_for, '');
});

function cuteRemovalAnimaiton(el) {
	el.animate({ opacity: "0" }, 150, function () {
		el.animate({ width: "0px" }, 150, function () {
			el.remove();
		});
	});
}

//#endregion

//#region POPUP CONTENT

//top buttons click
$(document).on("click", "#popupContent .poBlock .top .btn", function () {
	var btn_data = $(this).data("act");

	switch (btn_data) {
		//back / close popup
		case "back":
			//turn off all yt players when out from popup (works for market and tutorials)
			popupBackButton();

			break;
	}
});

//outsideWrapper
$(document).on("click", ".outsideWrapper .bsPackageSector .btn", function () {
	var btn_data = $(this).data("action");
	//links from any popupContent blocks
	switch (btn_data) {
		case "login":
			changeShowHideBlurred(true, ".personalizedMarketLogin", 3);
			break;
		case "renew":
			linkCore("link", "renew_subscription");
			break;
		case "refresh":
			reloadExtensionPanel();
			break;
	}
});

//POPUP ANOTHER LINKS
$(document).on("click", "#popupContent .poBlock .link", function () {
	var btn_data = $(this).data("open");
	//links from any popupContent blocks
	// switch (btn_data) {
	//     case 'openVTuts':
	//         linkCore('link', 'video_tutorials');
	//         break;
	// }
});

//special right buttons in market top section
$(document).on("click", "#popupContent .poBlock.videoTutorials .top .fbtn", function () {
	var curDataAct = $(this).attr("data-act");
	//[data-act="market_website"]
	switch (curDataAct) {
		case "watch_on_site":
			linkCore("link", "video_tutorials");
			break;
	}
});

//#endregion

//#region EXTENSION SETTINGS

//change inputs (radio/checkbox)
$(document).on("click", "#popupContent .poBlock.atomSettings input", function () {
	var getValue;
	var inputType = this.type;
	var inputName = this.name;
	switch (inputType) {
		case "checkbox":
			getValue = this.checked;
			// if(getValue){
			//     $('.atomSettings .absCustomPathBlock').show();
			// }else{
			//     $('.atomSettings .absCustomPathBlock').hide();
			// }
			break;
		case "radio":
			getValue = this.value;
			break;
	}

	//set new pref data JS in current key
	editLocalPSets(true, inputName, Number(getValue));
	//send new pref JS->JSX and save in JSON file
	saveLocalPreferences("PSets");

	/* Update changes Proxy Server */
	if (inputName == "defaultApiServer") {
		setDefaultApiServer();
	}
});

//click to button in settings
$(document).on("click", "#popupContent .poBlock.atomSettings .btn", function () {
	var getAction = $(this).data("action");
	switch (getAction) {
		case "reset_all_settings":
			changeShowHideBlurred(true, ".confirmResetAllSettings", 4);
			break;
		case "reload_extension":
			reloadExtensionPanel();
			break;
		case "remove_package_files":
			changeShowHideBlurred(true, ".confirmRemovePackageFiles", 4);
			break;
		case "browse_abs_folder":
			var chkAbsCustomPath = $('.atomSettings input[name="useCustomPathBySubscription"]');
			var chkAbsAbsolutePath = $('.atomSettings input[name="absCustomAbsolutePath"]');

			var newAbsFolder = cep.fs.showOpenDialog(false, true, "Select a new folder for packages by subscription...");
			if (newAbsFolder.data.length > 0) {
				var setNewPath = convertToSystemPath(newAbsFolder.data.toString().replace("file://", ""));
				chkAbsCustomPath.prop("checked", true);

				chkAbsAbsolutePath.val(setNewPath);
				editLocalPSets(true, "useCustomPathBySubscription", 1);
				editLocalPSets(true, "absCustomAbsolutePath", setNewPath);
			} else {
				chkAbsCustomPath.prop("checked", false);

				chkAbsAbsolutePath.val("");
				editLocalPSets(true, "useCustomPathBySubscription", 0);
				editLocalPSets(true, "absCustomAbsolutePath", "");
			}
			saveLocalPreferences("PSets");
			break;
	}
});

/* Confirm Reset All Settings */
$(document).on("click", ".confirmResetAllSettings .buttons .btn", function () {
	var btn_act = $(this).data("act");

	if (btn_act == "reset") {
		setupProgressBar(true, "Data reset");
		clearPrefJSON_File(); //rewrite prefs to default
		reloadExtensionPanel(); //reload
	}

	//hide ask window if cancel or any
	changeShowHideBlurred(false, ".confirmResetAllSettings", 4);
});
/* Confirm Remove Package Files */
$(document).on("click", ".confirmRemovePackageFiles .buttons .btn", function () {
	var btn_act = $(this).data("act");

	//remove files
	if (btn_act == "remove") {
		setupProgressBar(true, "Data reset");

		var dir = _globalPathObjects["atomDataFolder"] + "/";
		csInterface.evalScript("deleteExtensionChildFolder(" + JSON.stringify(dir) + ")", function (res) {
			if (res == "DELETED") {
				reloadExtensionPanel(); //reload
			} else {
				createMessage("Deletion Error", "Something wrong with deleting", "error", true);
			}
		});
	}

	//hide ask window if cancel or any
	changeShowHideBlurred(false, ".confirmRemovePackageFiles", 4);
});

//#endregion

//#region MAIN TREE MENU
function getFirstLeafInside($folderLi) {
  // Берём ближайший дочерний UL этой папки и первый лист с data-view
  const $ul = $folderLi.children("ul").first();
  if ($ul.length === 0) return $();

  const $leaf = $ul.find("li[data-view]").first(); // selfLeaf попадает сюда первым
  return $leaf.length ? $leaf : $();
}
//default ul li item clicks
// $(document).on("click", "#menu ul li", function () {
// 	var tab_id = $(this).data("view");
// 	var attr_special = $(this).data("type");

// 	if (attr_special) {
// 		switch (attr_special) {
// 			case "GET_FULL_VERSION":
// 				linkCore("package", {
// 					type: "premium",
// 					name: currentTempPackagePrefab.pack["name"],
// 					appid: currentTempPackagePrefab.pack["appID"],
// 					author: currentTempPackagePrefab.pack["author"]
// 				});
// 				break;
// 		}
// 	} else {
// 		//changed to works with multi childs
// 		if (tab_id) {
// 			if (tab_id != savePreviousTreeGroup) {
// 				/* To top scrolling of content */
// 				$("#content").scrollTop(0);
// 			}

// 			savePreviousTreeGroup = tab_id;
// 			//remove all current/add to current class item tree
// 			$("#menu ul li").removeClass("current").removeClass("last-active");
// 			$("#menu ul li").removeClass("top-active");
// 			$(this).addClass("current");
// 			$(this).parent().parent().addClass("last-active");

// 			previewPresaveInvoke = false;
// 			items.viewTemplateItems(tab_id);
// 			//reset and select content (clicked to li template item)
// 			contentSwitcher(tab_id);
// 		} else {
// 			//when pack startup/or changed has no tab_id
// 			savePreviousTreeGroup = $(this).find("li").data("view");
// 		}
// 	}
// });

// //for folders treeview slide animation menu (three-level folders inside)
// $(document).on("click", "#menu ul li.folder > div.title", function () {
// 	//auto open child from main group
// 	if (!$(this).parent().hasClass("active")) {
// 		//SET FIRST CHILD IN FOLDER (FROM ul li sub categories)
// 		//remove current from global (reset)
// 		$("#menu ul li").removeClass("current").removeClass("last-active");

// 		$("#menu ul li").removeClass("top-active");
// 		//current to first
// 		var get_first_child_sub_category = $(this).parent().find("ul li")[0];
// 		$(get_first_child_sub_category).addClass("current");

// 		//FIXED AUTO COLLAPSE TO CLICK (THIRD INSIDE CHILDRENS)
// 		var tab_id = $(get_first_child_sub_category).data("view");

// 		if (!tab_id) {
// 			//open in content
// 			tab_id = $($(this).parent().find("li.folder > ul li")[0]).data("view");

// 			if (!tab_id) {
// 				tab_id = $($(this).parent().find("li.folder.current li.folder > ul li")[0]).data("view");
// 			}

// 			$(this)
// 				.parent()
// 				.find('li.folder > ul li[data-view="' + tab_id + '"]')
// 				.addClass("current")
// 				.parent()
// 				.parent()
// 				.addClass("active")
// 				.addClass("last-active");

// 			$(this).closest("#menu > ul > li.folder").addClass("top-active");

// 			$(this).parent().find("li.folder.current > ul").slideDown("fast");
// 			$(get_first_child_sub_category).removeClass("current");
// 		} else {
// 			$(this).parent().addClass("last-active");
// 			$(this).closest("#menu > ul > li.folder").addClass("top-active");
// 		}
// 		//reset and select content (clicked to folder group)
// 		// $("#content .refreshedItems").html(previewPresaveContentBlocks[tab_id]);
// 		items.viewTemplateItems(tab_id);

// 		previewPresaveInvoke = false;
// 		contentSwitcher(tab_id);
// 	}
// 	// $("#content").html(previewPresaveContentBlocks[tab_id]);
// 	$(this).parent().toggleClass("active");
// 	$(this).parent().children("ul").slideToggle("normal");
// });

// ✅ Листья (только те, у кого есть data-view)
$(document).on("click", "#menu ul li[data-view]", function (e) {
  e.stopPropagation(); // не даём всплыть до обработчика папки
  const tab_id = $(this).data("view");
  if (!tab_id) return;

  if (tab_id != savePreviousTreeGroup) $("#content").scrollTop(0);
  savePreviousTreeGroup = tab_id;

  $("#menu ul li").removeClass("current last-active top-active");
  $(this)
    .addClass("current")
    .parents("li.folder")
    .addClass("last-active")
    .end()
    .closest("#menu > ul > li.folder")
    .addClass("top-active");

  previewPresaveInvoke = false;
  items.viewTemplateItems(tab_id);
  contentSwitcher(tab_id);
});

// ✅ Папки (клик по заголовку)
$(document).on("click", "#menu ul li.folder > div.title", function () {
  const $folder = $(this).parent();
  // открыть/закрыть
  $folder.toggleClass("active");
  $folder.children("ul").first().slideToggle("normal");

  // авто-выбор первого листа внутри, если надо
  const $firstLeaf = $folder.children("ul").find("li[data-view]").first();
  if ($firstLeaf.length) {
    const tab_id = $firstLeaf.data("view");
    $("#menu ul li").removeClass("current last-active top-active");
    $firstLeaf.addClass("current");
    $folder.addClass("last-active");
    $folder.closest("#menu > ul > li.folder").addClass("top-active");

    previewPresaveInvoke = false;
    items.viewTemplateItems(tab_id);
    contentSwitcher(tab_id);
    savePreviousTreeGroup = tab_id;
  }
});



//Resize split between menu and content
$("#separator").on("mousedown", function (e) {
	var md = {
		pageX: e.pageX,
		pageY: e.pageY,
		offsetLeft: $(this).css("left"),
		offsetTop: $(this).css("top"),
		firstWidth: $("#menu").width(),
		secondWidth: $("#content").width()
	};

	$(document).on("mouseup", function (e) {
		md = null;
	});
	$(document).on("mousemove", function (e) {
		if (md) {
			var delta = { x: e.pageX - md.pageX, y: e.pageY - md.pageY };
			delta.x = Math.min(Math.max(delta.x, -md.firstWidth), md.secondWidth);

			$("#separator").css("left", md.offsetLeft + delta.x);
			$("#menu").width(md.firstWidth + delta.x);
			//autosize elements when change separator position
			autoSizingPreviewItems();
		}
	});
});

//#endregion

//#region TEST MODE

$(document).on(
	{
		mouseenter: function () {
			$(this).children("p").hide();
			$(this).children(".testButtons").show();
		},
		mouseleave: function () {
			$(this).children("p").show();
			$(this).children(".testButtons").hide();
		}
	},
	"#footer .testMode"
);

//special button actions for test mode
$(document).on("click", "#footer .testMode .testButtons .cbtn", function () {
	var curAction = $(this).data("btn");
	if (curAction == "refresh") {
		//if need refresh package structure
		//disable message about installation test pack
		specialMemoryVariables["testModeFirstInit"] = false;
		//reinstall package with old pack file path
		installPackageFirstCheck(st_install["packFilePath"]);
	} else {
		//if disable mode
		testMode(false); //normal disable test mode
	}
});

$(document).on("click", ".testModeWindow .place a", function () {
	var curLink = $(this).attr("action");
	if (curLink == "exit") {
		testMode(true); //extra disable test mode
	} else {
		linkCore("link", curLink);
	}
});

//#endregion

//#region FOOTER EVENTS

// Footer Buttons Handler
$(document).on("click", "#footer .main_btn ul li span", function () {
	var data_type = $(this).parent().data("type");

	switch (data_type) {
		case "autoplay":
			var curUIAutoplay = editLocalUI(false, "previewAutoPlay");
			curUIAutoplay = !curUIAutoplay;
			autoPlayPreviewChange(curUIAutoplay, true);
			break;
		case "audio":
			var setVol = editLocalUI(false, "audioVolume") > 0 ? 0 : 100;
			audioVolumeChange(setVol, true);
			break;
		case "updating":
			linkCore("update");
			break;
		case "newItemsNotify":
			var curNewItemNotify = editLocalUI(false, "newItemsNotify");
			curNewItemNotify = !curNewItemNotify;
			newItemsNotifyInMenu(true, true, curNewItemNotify);
			break;
		case "sfxItems":
			var curNewItemNotify = editLocalUI(false, "sfxItems");
			// curNewItemNotify = !curNewItemNotify;
			sfxItemsEnable(true, true, curNewItemNotify == 1 ? 0 : 1);
			break;

		case "demoWithPremiumItems":
			var curNewItemNotify = editLocalUI(false, "demoWithPremiumItems");
			curNewItemNotify = !curNewItemNotify;
			demoWithPremiumItemsInMenu(true, true, curNewItemNotify);
			break;
	}
});

// Preview Layout Size Buttons
$(document).on("click", "#footer .change_view ul li span", function () {
	var data_type = $(this).parent().data("type");

	if (data_type == "autoFit") {
		var curAutoResizing = editLocalUI(false, "autoResizingItems");
		curAutoResizing = !curAutoResizing; // swap boolean
		// if(!curAutoResizing){
		//     $('.element.col').removeClass('col').addClass('col-auto');
		// }else{
		//     $('.element.col-auto').removeClass('col-auto').addClass('col');
		// }
		previewAutoResizingItems(curAutoResizing, false);
		//sort items with auto-resizing
		autoSizingPreviewItems();
	}

	if (data_type == "zoomOut" || data_type == "zoomIn") {
		var def_val = Number(editLocalUI(false, "previewLayoutSize"));
		if (data_type == "zoomOut") {
			def_val -= 1;
		}
		if (data_type == "zoomIn") {
			def_val += 1;
		}
		previewSizeLayoutChange(def_val, true);
	}
});
// Preview Layout Size Range Input
$(document).on("input", "#footer .change_view .previewRangeInput input", function () {
	var val = $(this).val();
	previewSizeLayoutChange(val, false);
});

/*      AUDIO CHANGE     */
// Show Range Input Container for Audio Volume Li Footer
$(document).on(
	{
		mouseover: function () {
			$(this).parent().find(".audioVolumeRangeContainer").show();
		},
		mouseout: function () {
			$(this).parent().find(".audioVolumeRangeContainer").hide();
		}
	},
	"#footer .main_btn ul li.audioVolume"
);

// Change Audio Volume Range Input
$(document).on("input", "#footer .main_btn ul li.audioVolume .audioVolumeRangeContainer input", function () {
	var vol = $(this).val();
	audioVolumeChange(vol, false);
});

//#endregion

//#region DRAG AND DROP HANDLER (INSTALLATION/DND APPLY ITEM/...)

// :INSTALLATION - global drag and drop to install packages
$(document)
	.on("drag dragover dragenter dragleave dragend drop", function (e) {
		//if exists - dnd to pp/else dnd to install
		if (dragAndDropData.item_id) {
			return false;
		}

		//if in photoAnimator step choose image - use custom dnd
		var NPA_engineDndImageClass = $('#photoAnimator .stepContent[data-view="startup"]');
		if (NPA_engineDndImageClass.is(".current")) {
			NPA_engineDndImageClass.find(".dragAndDropPhotoAnimator").addClass("draggedImageStatus");
			return false;
		}

		//disable default events
		e.preventDefault();
		e.stopPropagation();
		var dataTransfer = e.dataTransfer || (e.originalEvent && e.originalEvent.dataTransfer);
		dataTransfer.dropEffect = "copy";
		dataTransfer.effectAllowed = "all";
	})
	.on("dragover dragenter", function () {
		//if exists - dnd to pp/else dnd to install
		if (dragAndDropData.item_id) {
			return false;
		}
		//if in photoAnimator step choose image - use custom dnd
		var NPA_engineDndImageClass = $('#photoAnimator .stepContent[data-view="startup"]');
		if (NPA_engineDndImageClass.is(".current")) {
			if (!NPA_engineDndImageClass.find(".dragAndDropPhotoAnimator").hasClass("draggedImageStatus")) {
				NPA_engineDndImageClass.find(".dragAndDropPhotoAnimator").addClass("draggedImageStatus");
			}

			return false;
		}

		//if in activation progress
		if (installationTempXHRObject["name"]) {
			infoMessageInActivationWindow("Illegal during the activation process");
			return false;
		}
		//add drag over stylization
		$(".dragAndDropInstallation").addClass("is-dragover");
		//clear timeout to fix blinks
		clearTimeout(dragAndDropSpecialTimerIsOver);
	})
	.on("dragleave dragend drop", function (e) {
		//if exists - dnd to pp/else dnd to install
		if (dragAndDropData.item_id) {
			return false;
		}
		//if in photoAnimator step choose image - use custom dnd
		var NPA_engineDndImageClass = $('#photoAnimator .stepContent[data-view="startup"]');
		if (NPA_engineDndImageClass.is(".current")) {
			NPA_engineDndImageClass.find(".dragAndDropPhotoAnimator").removeClass("draggedImageStatus");
			return false;
		}

		dragAndDropSpecialTimerIsOver = setTimeout(function () {
			$(".dragAndDropInstallation").removeClass("is-dragover");
		}, 130);
	});

/* DND Image for PhotoAnimator Engine */
$(document).on("drop", '#photoAnimator .stepContent[data-view="startup"] .dragAndDropPhotoAnimator', function (e) {
	//Set File Object to input
	$(this).find(".place input")[0].files = e.originalEvent.dataTransfer.files;
	//do action
	inputPhotoAnimatorImage(e.originalEvent.dataTransfer.files[0]);
});

//Get file path (drop file into panel)
$(document).on("drop", ".dragAndDropInstallation", function (e) {
	packageInstallation(e.originalEvent.dataTransfer.files[0]);
});

var transferFilesX;
var timeoutTransfer;
//Get file path (click to install from pack manager/startup)
$(document).on("change blur", ".dragAndDropInstallation .place input", function (e) {
	var targetFiles = e.target.files.length > 0 ? e.target.files[0] : false;
	packageInstallation(targetFiles);
	$(this).val(""); //clear input val to use same file without errors
});
// :MOVE TO APPLY (only Premiere Pro) - special drag and drop to move item inside premiere pro timeline (via image)
$(document)
	.on("dragover dragenter", function () {
		//disable default events
		event.preventDefault();
		event.stopPropagation();
		event.dataTransfer.dropEffect = "copy";
		event.dataTransfer.effectAllowed = "all";
	})
	.on("dragstart", ".element", function () {
		//Use drag and drop only for Premiere Pro application and PR package
		if (init_sets.appID != "PPRO" || currentTempPackagePrefab.pack.appID != "PR") {
			return false;
		}

		prepareToApplyPremierePro(true, $(this), dragAndDropData);

		/* Disable drag and drop for new mogrt system - AtomX 3.0.7+ */
		if (!parseAndGetArguments(dragAndDropData.arguments)["mogrt_transition_system"]) {
			//event handler (add dnd image to replace it in future in JSX)
			event.dataTransfer.setData("com.adobe.cep.dnd.file.0", dragAndDropData.source_object);
		} else {
			placeboardSwitcher(true, "requires", "Use double-click to apply");
			dragAndDropData["disabled"] = true;
		}

		return true;
	})
	.on("drop", function () {
		if (dragAndDropData.disabled) {
			placeboardSwitcher(false);
		}
		//if drop on extension - error/set empty dnd data. Need drop only on application.
		dragAndDropData = {};
		return false;
	})
	.on("dragend", function () {
		//if item_id exists, dragend/drop in application - success / or return false;
		if (!dragAndDropData.item_id) {
			return false;
		}

		if (dragAndDropData.disabled) {
			return false;
		}

		//do
		//send to JSX and get response
		applyItemPremiereProLikeAs(true, dragAndDropData);

		//fixed unpress audio after drag and drop
		$(".element").trigger("mouseleave");
		//reset obj
		dragAndDropData = {};
		return true;
	});

//#endregion

//#region CONSTANT TIPS POPUP MESSAGE

$(document).on("click", ".userBigTip.noActiveComp .buttons .btn", function () {
	changeShowHideBlurred(false, ".noActiveComp", 4);
});

$(document).on("click", ".userBigTip.noAccessPPRO_mac .buttons .btn", function () {
	changeShowHideBlurred(false, ".noAccessPPRO_mac", 4);
});

$(document).on("click", ".userBigTip.noAccessPPRO_win .buttons .btn", function () {
	changeShowHideBlurred(false, ".noAccessPPRO_win", 4);
});

//#endregion CONSTANT TIPS POPUP MESSAGE

//#region CONFIRM POPUP MESSAGE

$(document).on("click", ".confirmRemovePackage .buttons .btn", function () {
	var btn_act = $(this).data("act");

	if (btn_act == "delete") {
		//if name exists go remove
		if (tempPackRemoveData["name"]) {
			removePackageHandler(tempPackRemoveData);
		}
	}

	// if(btn_act == 'cancel'){}

	//hide ask window
	changeShowHideBlurred(false, ".confirmRemovePackage", 4);
});

//choose installation method
//async waiting click to continue button
$(document).on("click", ".chooseInstallationMethod .buttons .btn", function () {
	var btn_act = $(this).data("act");

	if (btn_act == "continue") {
		var selectedType = 0;
		switch ($('.chooseInstallationMethod input[name="selectInstallationMethod"]:checked').val()) {
			case "default":
				selectedType = 0;
				break;
			case "portable":
				selectedType = 1;
				break;
		}

		editLocalPSets(true, "portablePackageInstallation", selectedType);

		//save and don't ask again - disable ask
		if ($('.chooseInstallationMethod input[name="dontAskAgainInstallationMethod"]').is(":checked")) {
			editLocalPSets(true, "askInstallationMethodEachTime", 0);
			saveLocalPreferences("PSets"); //save in prefs
		}

		settingsPanelInputs(true); //refresh this options in settings window

		//hide ask window
		changeShowHideBlurred(false, ".chooseInstallationMethod", 2);
		//continue install
		installPackageStepFileSystem();
	}
});

//#endregion

//#region LOGIN MARKET PERSONALIZED (SUBCRIPTION)

//fixed

//temp
var personalMarketCountTimeSeconds;

$(document).on("click", ".personalizedMarketLogin .btn", function () {
	var act = $(this).data("act");

	if (act == "login") {
		var personalMarketLoginBlockDelaySecondsFixed = 30;
		var personalMarketLoginFloodTimesFixed = 5;

		var email = $('.personalizedMarketLogin input[name="email"]').val();
		var token = $('.personalizedMarketLogin input[name="token"]').val();

		//if no email
		if (email.toString().length == 0) {
			infoMessageInActivationWindow("Please enter your E-mail!", false, "personalizedMarketLogin");
			return false;
		} else {
			//mail validation
			if (!validateEmail(email.toString())) {
				infoMessageInActivationWindow("Enter a valid E-mail!", false, "personalizedMarketLogin");
				return false;
			}
		}

		//if no password
		if (token.toString().length == 0) {
			infoMessageInActivationWindow(
				maskedIVE.settings.authWithSitePassword ? "Please enter password!" : "Please enter token!",
				false,
				"personalizedMarketLogin"
			);
			return false;
		}

		//anti-floor max 5 times and sleep
		if (loginPersonalizedMarketAntiFloodCounter < personalMarketLoginFloodTimesFixed) {
			//add to counter +1
			loginPersonalizedMarketAntiFloodCounter++;
			//do code to server
			packageMarketLoginService(false, email, token);
		} else {
			//counting to show users about remaining seconds
			if (!loginPersonalizedMarketAntiFloodTimerIntervalObj["interval"]) {
				personalMarketCountTimeSeconds = personalMarketLoginBlockDelaySecondsFixed;
				//set interval
				loginPersonalizedMarketAntiFloodTimerIntervalObj["interval"] = setInterval(function () {
					personalMarketCountTimeSeconds = parseInt(personalMarketCountTimeSeconds) - 1;
					if (personalMarketCountTimeSeconds <= 0) {
						//full reset
						loginPersonalizedMarketAntiFloodCounter = 0;
						clearTimeout(loginPersonalizedMarketAntiFloodTimerIntervalObj["interval"]);
						loginPersonalizedMarketAntiFloodTimerIntervalObj["interval"] = null;
					}
				}, 1000);
			}
			//more > 5 trying
			infoMessageInActivationWindow("Please wait " + personalMarketCountTimeSeconds + " seconds to try again", false, "personalizedMarketLogin");
			return false;
		}
	}

	if (act == "relogin") {
		// $('.personalizedMarketLogin .content div[data-signed=0]').show();
		// $('.personalizedMarketLogin .content div[data-signed=1]').hide();
		checkAuthLogin(false, false, true);
	}
	//hide window (all temp vars will resets when again open verify window)
	if (act == "cancel") {
		infoMessageInActivationWindow(false, false, "personalizedMarketLogin");
		changeShowHideBlurred(false, ".personalizedMarketLogin", 3); //hide window
	}
	//open browser to renew subscription
	if (act == "renew") {
		linkCore("link", "renew_subscription");
	}
	//recheck subscription status
	if (act == "recheck") {
		packageMarketLoginService(true);
	}
});

//#endregion

//#region ACTIVATION VERIFY WINDOW

//fixed
var blockDelaySecondsFixed = 30;
var floodTimesFixed = 5;
//temp
var countTimeSeconds;
//main buttons on panel
$(document).on("click", ".verifyInstallationPack .buttons .btn", function () {
	var act = $(this).data("act");

	if (act == "activate") {
		var email = $('.verifyInstallationPack input[name="email"]').val();
		var code = $('.verifyInstallationPack input[name="code"]').val();
		var subscribeNewPackage = $('input[name="subscribeNewPackage"]').is(":checked");

		if (!installationTempXHRObject["none_collect_email"]) {
			//no email
			if (email.toString().length == 0) {
				infoMessageInActivationWindow("Please enter your E-mail!");
				return false;
			} else {
				//mail validation
				if (!validateEmail(email.toString())) {
					infoMessageInActivationWindow("Enter a valid E-mail!");
					return false;
				}
			}
		}

		//no code
		if (code.toString().length == 0) {
			infoMessageInActivationWindow("Please enter Purchase Code!");
			return false;
		}

		//anti-floor max 5 times and sleep
		if (installationAntiFloodCounter < floodTimesFixed) {
			//add to counter +1
			installationAntiFloodCounter++;
			//do code to server
			var sendToFunc = installationTempXHRObject;
			sendToFunc["code"] = code.toString(); //add code to obj
			sendToFunc["email"] = email.toString(); //add email to obj
			sendToFunc["subscribe_newsletter"] = subscribeNewPackage; //add email to obj
			packageActivationServer(true, sendToFunc);
		} else {
			//counting to show users about remaining seconds
			if (!installationAntiFloodTimerIntervalObj["interval"]) {
				countTimeSeconds = blockDelaySecondsFixed;
				//set interval
				installationAntiFloodTimerIntervalObj["interval"] = setInterval(function () {
					countTimeSeconds = parseInt(countTimeSeconds) - 1;
					if (countTimeSeconds <= 0) {
						//full reset
						installationAntiFloodCounter = 0;
						clearTimeout(installationAntiFloodTimerIntervalObj["interval"]);
						installationAntiFloodTimerIntervalObj["interval"] = null;
					}
				}, 1000);
			}
			//more > 5 trying
			infoMessageInActivationWindow("Please wait " + countTimeSeconds + " seconds to try again");
			return false;
		}
	}
	//hide window (all temp vars will resets when again open verify window)
	if (act == "cancel") {
		installationTempXHRObject = {}; //clear temp xhr object (to again possible dnd to install)
		changeShowHideBlurred(false, ".verifyInstallationPack", 3); //hide window
	}
});

//help links in verify window
$(document).on("click", ".verifyInstallationPack .hlink", function () {
	var href = $(this).data("href");
	//links
	if (href == "help_purchase_code") {
		linkCore("link", "help_get_code");
	}
	if (href == "privacy_policy") {
		linkCore("link", "privacy_policy");
	}
	if (href == "terms_conditions") {
		linkCore("link", "terms_conditions");
	}
});

//extension by subscription - auth links
$(document).on("click", ".personalizedMarketLogin .hlink", function () {
	var href = $(this).data("href");
	//links
	if (href == "help_auth_data") {
		linkCore("link", "help_auth_data");
	}
});

$(document).on("click", ".personalizedMarketLogin .authorizationLists .btn", function () {
	var usid = $(this).data("usid");
	var ip = $(this).data("ip");
	$(this).parent().fadeOut();
	revokeDeviceByUSID(usid, ip);
	// alert(usid);
	//links
	// alert(sessionId);
});

//#endregion

//#region SYSTEM EVENTS

/* Dev Panel */

$(document).on("click", "#footer .debugButtons div[data-btn]", function () {
	var btnAct = $(this).data("btn");
	switch (btnAct) {
		case 1: //Export Sequence simple (*.prproj)
			setupProgressBar(true, "Dev: Exporting [prproj]");
			csInterface.evalScript('$._AtomExt_ppComposer.exportProjectDev("prproj")', function (res) {
				if (itemResponseListFromEngine(res)) {
					//do not need encryptions - just GZIP by default

					createMessage("Dev: Exported", "Sequences are exported to <code>.PRPROJ</code> in project dir", "success", true);
					setupProgressBar(false);
				} else {
					setupProgressBar(false, "_STOP");
				}
			});
			break;
		case 2: //Export Sequence with protection (*.atomxassets)
			setupProgressBar(true, "Dev: Exporting [atomxasset]");
			csInterface.evalScript('$._AtomExt_ppComposer.exportProjectDev("atomxasset")', function (res) {
				if (itemResponseListFromEngine(res)) {
					var parseArrFilePaths = JSON.parse(res); //encrypt this files to b64
					for (var i = 0; i < parseArrFilePaths.length; i++) {
						var tFilePath = parseArrFilePaths[i];
						rw_protectionFileAssets(true, "BIN_AX", tFilePath, tFilePath);
					}

					createMessage("Dev: Exported", "Sequences are exported to <code>.ATOMXASSETS</code> in project dir", "success", true);
					setupProgressBar(false);
				} else {
					setupProgressBar(false, "_STOP");
				}
			});

			break;
		case 6: //Export MOGRT with protection (*.mgasset)
			var encryptMogrts = window.cep.fs.showOpenDialogEx(true, 0 /* Choose as directory */, "Choose your MOGRT files to encrypt", null, ["mogrt"]);
			if (encryptMogrts.data) {
				setupProgressBar(true, "Dev: Encrypting [mgasset]");
				for (var i = 0; i < encryptMogrts.data.length; i++) {
					var tFilePath = encryptMogrts.data[i].toString();
					// var re = /(?:\.([^.]+))?$/;
					// var getFileWithoutFormat = re.exec(tFilePath)[1];
					var filePathWithoutFormat = tFilePath.substring(0, tFilePath.lastIndexOf("."));
					// .substring(0, x.lastIndexOf('.'))
					// alert(getFileWithoutFormat + '.' + basisProtectFileTypes.MG_ASSET);
					rw_protectionFileAssets(true, "MG_ASSET", tFilePath, filePathWithoutFormat + "." + basisProtectFileTypes.MG_ASSET);
				}

				createMessage("Dev: Encrypted", "MOGRT are encrypted to <code>.MGASSET</code> in project dir", "success", true);
				setupProgressBar(false);
			}

			break;
		case 3:
			csInterface.evalScript("devPanelEngineCallerPremierePro(1)", function (res) {
				$('input[name="devTerminal"]')
					.val('"timing_offset_ticks": ' + res.toString())
					.addClass("result");
			});
			break;
		case 4:
			csInterface.evalScript("devPanelEngineCallerPremierePro(2)", function (res) {
				$('input[name="devTerminal"]')
					.val('"duration_ticks": ' + res.toString())
					.addClass("result");
			});
			break;
		case 5:
			csInterface.evalScript("devPanelEngineCallerPremierePro(3)", function (res) {
				$('input[name="devTerminal"]').val("Done").addClass("result");
			});
			break;
		case "hide":
			userDevDebugPanel(true);
			break;
		case "enter":
			devActions($('input[name="devTerminal"]').val());
			break;
	}
});

//Execute Terminal JSX - Enter code
$(document).on("keyup", '.debugButtons input[name="devTerminal"]', function (e) {
	//.systemMessage .content small - button
	if (e.keyCode === 13) {
		var terminalCode = this.value;
		devActions(terminalCode);
	}
});

//Disable animation opacity when focused console response
$(document).on("focus", ".console_panel textarea", function () {
	if ($(this).hasClass("result")) {
		$(this).removeClass("result red green");
	}
});

//Disable animation opacity when focused termninal with result
$(document).on("focus", '.debugButtons input[name="devTerminal"]', function () {
	//.systemMessage .content small - button
	if ($(this).hasClass("result")) {
		$(this).removeClass("result");
	}
});

//Close system message on click
$(document).on("click", ".systemMessage .content", function () {
	//.systemMessage .content small - button
	$(".systemMessage").stop().animate({ top: "-130px" }, 100);
});

$(document).on("click", ".systemMessage .content p a", function () {
	//.systemMessage .content small - button
	var action = $(this).data("action");
	var type = $(this).data("type");

	if (type == "popup") {
		changeShowHideBlurred(true, action, 3);
	} else if (type == "package") {
		linkCore("package", {
			type: "premium",
			name: $(this).data("pack-name"),
			appid: $(this).data("pack-appid"),
			author: $(this).data("pack-author")
		});
	} else {
		linkCore("link", action);
	}
});

// Debug Refresh Extension Content (Right Click Mouse)
if (appDebugMode == true) {
	$(document).contextmenu(function (event) {
		event.preventDefault();
		location.reload();
	});
} else {
	$(document).contextmenu(function (event) {
		if (
			!(
				(event.target.type &&
					(event.target.type == "text" || event.target.type == "password" || event.target.type == "textarea" || event.target.type == "date")) ||
				$(event.target).is("code")
			)
		) {
			event.preventDefault();
		}
	});
}

//#endregion

//#region PHOTO ANIMATOR ENGINE

//Click to browse file file path (choose file via input)
$(document).on("change", ".dragAndDropPhotoAnimator .place input", function (e) {
	inputPhotoAnimatorImage(e.target.files[0]);
});

$(document).on("click", "#photoAnimator .buttonContent > div", function () {
	var getBtnStep = $(this).data("step");

	var selectImageStartup = $(".dragAndDropPhotoAnimator .place input");
	var getImageFileObject = selectImageStartup[0].files[0];
	var getImagePath = getImageFileObject.path;
	//upload image when clicked to continue
	if ($(this).data("action") == "continueUploadImage") {
		uploadPhotoAnimatorImageToServer(getImageFileObject);
	}

	//start/pause video carousel
	if (getBtnStep == "selectAnimatorType") {
		carouselVideoSwipe("animatorType", 0, "start");
	} else {
		carouselVideoSwipe("animatorType", 0, "pause");
	}

	if (getBtnStep == "selectFinal") {
		//find step classes

		var selectResolutionParams = $('#photoAnimator .stepContent[data-view="selectResolution"] .thumbnailPlate li.current');
		var selectAnimatorTypeParams = $('#photoAnimator .stepContent[data-view="selectAnimatorType"] .carouselContent li.current');

		//get params from steps

		var getResolution = [];
		//get custom resolutions
		if (selectResolutionParams.data("pickplace") == "custom") {
			var inputCustomRes = selectResolutionParams.find("input");
			getResolution = [parseInt(inputCustomRes.eq(0).val()), parseInt(inputCustomRes.eq(1).val())];
		} else {
			getResolution = selectResolutionParams.data("resolution").toString().split("-");
		}
		//get animator type
		var getAnimatorType = selectAnimatorTypeParams.data("current-type");

		var cur_item_arguments = {
			resolution: getResolution,
			image: getImagePath
		};

		var aepProjectsByAnimatorType = {
			portrait: "Portrait Mode.aep",
			perspective: "Perspective Mode.aep"
		};

		var extra_arguments = {
			filepath: convertToSystemPath(getFolderWithTemplateItems() + "_NPA" + "/" + aepProjectsByAnimatorType[getAnimatorType]),
			last_group: "_Photo Animator Files",
			comp_name: "Portrait Mode"
		};

		//final - wait the depth map from server
		setupProgressBar(true, "Creating scenes");
		csInterface.evalScript(
			`applyItem("${getAnimatorType}", "", "", "", ${JSON.stringify(cur_item_arguments)}, ${JSON.stringify(extra_arguments)})`,
			function (result) {
				if (itemResponseListFromEngine(result)) {
					setupProgressBar(false);
					//if portrait
					if (getAnimatorType == "portrait") {
						changeStepByStepContentSwitcher("selectPortraitConfiguration");
					} else {
						changeStepByStepContentSwitcher("successAfterGeneration");
					}

					// photoAnimatorArgumentSaver['imageUploaded']
				} else {
					setupProgressBar(false, "_STOP");
				}
			}
		);
	} else {
		changeStepByStepContentSwitcher(getBtnStep);
	}
});

$(document).on("click", "ul.thumbnailPlate li[data-pickplace]", function () {
	$("ul.thumbnailPlate li[data-pickplace]").removeClass("current");
	$(this).addClass("current");

	var getApplyButton = $('#photoAnimator .stepContent[data-view="selectResolution"] .buttonContent .applyButton');
	if ($(this).data("pickplace") == "custom") {
		var validInputCount = 0;

		if (parseInt($(this).find("input").first().val().toString())) {
			validInputCount++;
		}
		if (parseInt($(this).find("input").last().val().toString())) {
			validInputCount++;
		}

		if (validInputCount == 2) {
			getApplyButton.removeClass("disabled");
		} else {
			getApplyButton.addClass("disabled");
		}
	} else {
		getApplyButton.removeClass("disabled");
	}
});

$(document).on("keyup ", 'ul.thumbnailPlate li[data-pickplace="custom"] input', function () {
	var parentInputs = $(this).parent().find("input");
	var validInputCount = 0;
	if (parseInt(parentInputs.first().val().toString())) {
		validInputCount++;
	}
	if (parseInt(parentInputs.last().val().toString())) {
		validInputCount++;
	}

	var getApplyButton = $('#photoAnimator .stepContent[data-view="selectResolution"] .buttonContent .applyButton');
	if (validInputCount == 2) {
		getApplyButton.removeClass("disabled");
	} else {
		getApplyButton.addClass("disabled");
	}
});

//#endregion
