var csInterface = new CSInterface();
csInterface.setWindowTitle('Text Randomizer');

setupProgressBar(true, "Launch", 0, 1200);

csInterface.addEventListener('cep.sender.engine_text_animator.sending', function(event) {
    /* Disable loader */
    setupProgressBar(false);
    /* Get sent data */
    var getData = event.data;
    /* Params */
    var mainText = getData.text;
    var samplesFolder = getData.samples_folder;
    var projectFolder = getData.template_folder;
    var packOptions = getData.options;
    var packStructure = getData.structure;

    /* Prepare */
    var availableChars = packOptions.available_symbols_base64 ? b64DecodeUnicode(packOptions.available_symbols_base64) : packOptions.available_symbols;
    var preparedStructure = parsePackStructure(packStructure);
    var mainCharStyle = packOptions.main_character_style;

    /*** FIRST INITIALIZATION ***/
    /* Randomize it */

    randomizationText(mainText, mainCharStyle, samplesFolder, projectFolder, availableChars, preparedStructure);


    /*** EVENTS ***/
    /* Event - Change individual symbol */
    $(document).on('click', '.placeSigns img', function() {
        var getChar = $(this).attr('data-char');
        var getNumber = parseInt($(this).attr('data-number'));
        var getCount = parseInt($(this).attr('data-count'));
        var getStructIndex = $(this).attr('data-struct-index');

        /* Multiple preview in one */
        var nextNumber = getNumber;
        var nextStructIndex = getStructIndex;
        if (getNumber < getCount) {
            nextNumber++;
        } else {
            if (nextStructIndex < preparedStructure.length - 1) {
                nextStructIndex++;
            } else {
                nextStructIndex = 0;
            }
            nextNumber = 1;
        }
        /* Replace whole image */
        $(this).replaceWith(prepareImage(false, preparedStructure, nextNumber, nextStructIndex, getChar, mainCharStyle, samplesFolder, projectFolder));
    });


    $(document).on('click', '.tasButtons div', function() {
        var curBtn = $(this).attr('data-action');
        switch (curBtn) {
            case 'randomize':
                randomizationText(mainText, mainCharStyle, samplesFolder, projectFolder, availableChars, preparedStructure);
                break;
            case 'apply':
                var returnObj = []
                $('.placeSigns img').each(function(e) {
                    returnObj.push({
                        // 'char': $(this).attr('data-char'),
                        'curChar': $(this).attr('data-cur-char'),
                        'layerResize': $(this).attr('data-layer-resize'),
                        'item': $(this).attr('data-item'),
                        'project': $(this).attr('data-project-path'),
                        'multiple': parseInt($(this).attr('data-count')) > 1 ? $(this).attr('data-number') : false,
                        // 'file': getItemFilepath()
                    });
                });


                /* Send msg back with randomizer data */
                var eventReturn = new CSEvent("cep.sender.engine_text_animator.apply");
                eventReturn.scope = "APPLICATION";
                eventReturn.data = JSON.stringify({
                    'items': returnObj,
                    'mainText': mainText
                });
                csInterface.dispatchEvent(eventReturn);
                /* Close extension */
                csInterface.closeExtension();
                break;
        }
    });
});




function getSymbolPath(path, letter_style, symbol, multiple_num) {

    if (letter_style == 'BOTH') {
        letter_style = false;
    }

    var checkCasing = letter_style ? letter_style : caseTextChecking(symbol);

    var prePath = path + checkCasing + '/' + symbol;

    if (multiple_num) {
        return prePath + ' (' + multiple_num + ').jpg';
    } else {
        return prePath + '.jpg';
    }
}

function caseTextChecking(character) {
    if (character == character.toUpperCase()) {
        return "UPPERCASE";
    }
    if (character == character.toLowerCase()) {
        return "LOWERCASE";
    }
}

function prepareImage(massRandomize, preparedStructure, curItemNumber, curItemRndIndex, curChar, charStyle, curSampleFolder, curProjectFolder) {

    try {
        var saveOldCurChar = curChar;
        var randomVariantItem = preparedStructure[curItemRndIndex];
        var customCharStyle = randomVariantItem.character_style ? randomVariantItem.character_style : charStyle;
        switch (customCharStyle) {
            case "UPPERCASE":
                curChar = curChar.toUpperCase();
                break;
            case "LOWERCASE":
                curChar = curChar.toLowerCase();
                break;
            default:
                customCharStyle = false;
        }
        var folderPath = curSampleFolder + randomVariantItem.path;
        var projectPath = curProjectFolder + randomVariantItem.template;

        var newItemNumber = curItemNumber;
        var dataMaxCount = 1;
        var preparePath = getSymbolPath(folderPath, customCharStyle, curChar, false);

        if (randomVariantItem.multiple) {
            var multipleInsideItems = massRandomize ? getRandomInt(1, randomVariantItem.multiple) : curItemNumber;
            newItemNumber = multipleInsideItems;
            dataMaxCount = randomVariantItem.multiple;
            preparePath = getSymbolPath(folderPath, customCharStyle, curChar, multipleInsideItems);
        }

    } catch (error) {
        alert(error);
    }

    return "<img\
    src='" + convertToSystemPath(preparePath) + "'\
    data-struct-index='" + curItemRndIndex + "'\
    data-item='" + randomVariantItem.name + "'\
    data-layer-resize='" + randomVariantItem.layer_resize + "'\
    data-cur-char='" + curChar + "'\
    data-char='" + saveOldCurChar + "'\
    data-project-path='" + convertToSystemPath(projectPath) + "'\
    data-asset-path='" + convertToSystemPath(folderPath) + "'\
    data-number='" + newItemNumber + "'\
    data-count='" + dataMaxCount + "'\
    >";
}

function randomizationText(curTextSigns, charStyle, curSampleFolder, curProjectFolder, availableChars, preparedStructure) {


    var placeForSamples = $('.placeSigns');
    var samplesImageStr = '';
    for (var index = 0; index < curTextSigns.length; index++) {
        var curChar = curTextSigns[index];

        if (curChar == ' ') {
            samplesImageStr += '<span class="whitespace"></span>';
        } else if (availableChars.indexOf(curChar) != -1) {
            var curItemRndIndex = getRandomInt(0, preparedStructure.length);

            samplesImageStr += prepareImage(true, preparedStructure, 1, curItemRndIndex, curChar, charStyle, curSampleFolder, curProjectFolder);

        } else {
            samplesImageStr += '<span class="empty">No Sign</span>';
        }
    }

    placeForSamples.html(samplesImageStr);
}

function parsePackStructure(structureObject) {
    var allPieces = [];
    for (var pName_1 in structureObject) {
        var objectItem = structureObject[pName_1];

        if (objectItem.preview) {
            var previewItem = objectItem.preview;
            for (var prev in previewItem) {
                var insideItem = previewItem[prev];
                var insideItemArgs = insideItem.custom_args;

                /* Available for randomizer */
                if (insideItemArgs.part_of_randomizer) {
                    /* Static item with multiple images and count */

                    allPieces.push({
                        'character_style': insideItemArgs.character_style ? insideItemArgs.character_style : false,
                        'name': insideItem.name,
                        'layer_resize': insideItemArgs.layer_resize,
                        'template': pName_1 + '/' + insideItem.name + '.aep',
                        'path': pName_1 + '/' + insideItem.name + '_RANDOMIZER' + '/',
                        'multiple': insideItemArgs.multiple_symbol_sequences,

                    });
                }
            }
        }
    }

    return allPieces;
}

function b64DecodeUnicode(str) {
    // Going backwards: from bytestream, to percent-encoding, to original string.
    return decodeURIComponent(atob(str).split('').map(function(c) {
        return '%' + ('00' + c.charCodeAt(0).toString(16)).slice(-2);
    }).join(''));
}