/**
 * Counters for folder groups/favorites/search
 */
var counter_folder_items = {
    "MAIN": 0,
    "GLOBAL": 0,
    "MIDDLE": 0
};



var counter_enabled_only_items = {
    "MAIN": 0,
    "GLOBAL": 0,
    "MIDDLE": 0
};

var counter_new_items = {
    "MAIN": 0,
    "GLOBAL": 0,
    "MIDDLE": 0
};
/**
 * Counters for AE (Text Presets) _TEXT_PRESETS engine
 */
var counter_customize_text_presets = {
    "IN": 0,
    "OUT": 0,
    "MID": 0
};


var clipBoardPM_Presets = {};

//#region GENERAL FUNCTIONS

/**
 * Create string from array by char for category instance arg
 * @param {array} inputGroupHierarchyArr 
 * @return {string} joined array by char
 */
function instanceGroupJoin(inputGroupHierarchyArr) {
    return inputGroupHierarchyArr.join(instanceGroupCategoryJoinChar);
}

/**
 * Create array from string by char for category instance arg
 * @param {string} inputGroupString
 * @return {array} Array from string with cats
 */
function instanceGroupSplit(inputGroupString) {
    var tempArrProps = [];
    for (var i = 0; inputGroupString.toString().split(instanceGroupCategoryJoinChar)[i]; i++) {
        tempArrProps.push(inputGroupString.toString().split(instanceGroupCategoryJoinChar)[i]);
    }
    return tempArrProps;
}

/**
 * Set item argument in JSON obj to Stringify it in future
 * @param {*} set_json_obj Object to set
 * @param {*} item_obj item object
 * @param {*} arg_name object key
 * @param {*} custom_arg_value custom arg if need
 */
function setNewJSONItemArgument(set_json_obj, item_obj, arg_name, custom_arg_value) {
    if (item_obj[arg_name]) {
        var arg_value = custom_arg_value ? custom_arg_value : item_obj[arg_name];
        set_json_obj[arg_name] = arg_value;
    }
}

/**
 * Piece for content item to replace image/gif if error (not found, check via JS onerror) to dummie image (any aspect ratio)
 * @function createContentItem
 * @param {*} img Object $(this) from img onerror
 * @param {string} dummie_type aspect ratio type [DEFAULT/VERTICAL/BOX_MIN/BOX_MAX ...]
 */
function notImgFillDummies(img, dummie_type) {
    $(img).attr('src', init_sets['extMainPath'] + "/img/poster_dummies/" + dummie_type.toString().toLowerCase() + ".png");
    $(img).parent().addClass('not_found');
}



/**
 * Search module (simple comparing) - piece of @func createContentItem
 * @param {string} query_string String to compare
 * @param {string} item_string_name Item name to compare
 * @return {boolean} true if found/false if no (for enabled item)
 */
function querySearching(query_string, item_string_name) {
    if (query_string) {
        var itemStrLC = item_string_name.toString().toLowerCase();
        var queryStrLC = query_string.toString().toLowerCase();

        //if query ALL in any transform text - show all items
        if (queryStrLC == "all") {
            return true;
        } else {
            if (itemStrLC.indexOf(queryStrLC) != -1) {
                return true;
            } else {
                return false;
            }
        }
    }
}


/**
 * Piece func to change icon tree menu (except appID info/and folders)
 * @function generatePackageContent
 * @param {*} object_f Pack item group arguments
 * @param {string} preview_group_icon Str with default data, set new data if found
 * @return {string} Old data icon or new
 */
function setPreviewGroupIconSpecialForTreeMenu(object_f, preview_group_icon) {
    if (object_f.is_audio) { preview_group_icon = 'SFX'; }
    if (object_f.is_footage) { preview_group_icon = 'FOOTAGE'; }
    if (object_f.is_presets) { preview_group_icon = 'PRESETS'; }
    return preview_group_icon;
}


//#endregion

//#region GENERATE CONTENT (MENU/ITEMS)
var is_new_mark_enabled = false;
var is_premium_demo_shy_enabled = false;
/**
 * Main function to create package tree menu/all item content
 * @param {string} type Type to create (default/favorites/search ...)
 * @param {object} prefab_full_object Full prefab object from JSX
 * @param {string} special_arg Special Arg (for search query and etc...)
 * @return {boolean} Return true if without errors
 */
function generatePackageContent(type, prefab_full_object, special_arg) {


    var parsed_pack_structure = prefab_full_object.structure;
    var current_pack_favorites = ''; //convertFavoritesToArr(prefab_full_object.pack.favorites);
    //create tree folder
    var line_tree = '',
        line_content = '',
        last_counted = 0;
    //reset counter text customizer types
    counter_customize_text_presets["IN"] = 0;
    counter_customize_text_presets["OUT"] = 0;
    counter_customize_text_presets["MID"] = 0;


    var pack_path = prefab_full_object.assets;

    var preview_group_icon_app = prefab_full_object.pack.appID.toString();
    //set icon for tree elements (default AE)
    var preview_group_icon = '';



    is_new_mark_enabled = false;
    is_premium_demo_shy_enabled = false;
    
    // switch(prefab_full_object.pack.appID.toString()){
    //     case "AE": preview_group_icon = "AE"; break;
    //     case "PR": preview_group_icon = "PR"; break;
    //     case "PS": preview_group_icon = "PS"; break;
    //     case "AI": preview_group_icon = "AI"; break;
    // }

    if (type == "default") {
        /* Special customize picks for Preset manager */
        line_content += '<div class="coBlock" data-view="ATOM_CUSTOMIZER_GROUP_PM_PICKS">CUSTOMIZER</div>';


        line_content += '<div class="coBlock" data-view="ATOM_CUSTOMIZER_GROUP">CUSTOMIZER</div>';
        line_content += '<div class="coBlock" data-view="ATOM_FAVORITES_GROUP">FAVORITES</div>';
        line_content += '<div class="coBlock" data-view="ATOM_SEARCH_GROUP">SEARCH</div>';

        
        
    } else {
        counter_folder_items["MAIN"] = 0; //reset for Favorites/Search counter
        counter_folder_items["GLOBAL"] = 0;
        counter_folder_items["MIDDLE"] = 0;

        counter_enabled_only_items["MAIN"] = 0;
        counter_enabled_only_items["GLOBAL"] = 0;

        counter_new_items["MAIN"] = 0;
        counter_new_items["GLOBAL"] = 0;
    }

    var new_group_mark = '';
    //CREATE MENU GROUPS (MAX 3 CHILD INSIDE) - new updates
    if(type != 'customizer_PM'){
        var loopContent = mainItemParserLoop(type, parsed_pack_structure, preview_group_icon_app, pack_path, special_arg);
        line_content += loopContent.content;
        line_tree += loopContent.tree;
        last_counted = loopContent.last_count;
    }


    //FINAL ADD HTML TO PANEL OUTSIDE CYCLE
    if (type == "default") {
        //if version demo - add new menu into end of tree [get full]
        if (prefab_full_object.pack.version == "DEMO") {
            line_tree += '<li class="used_demo" data-type="GET_FULL_VERSION">Get Full Version »</li>';


        }
        //add to html tags
        $('#container #menu').html("<ul>" + line_tree + "</ul>");
        // $('#container #content').html(line_content);

        items.viewHtml(line_content);
        // $("#content .refreshedItems").html(line_content);
        /* Activate icon button if has new item marks */
        newItemsNotifyInMenu(is_new_mark_enabled);
        if (prefab_full_object.pack.version == "DEMO") {
            demoWithPremiumItemsInMenu(is_premium_demo_shy_enabled);
        }

    }

    if (type == "favorites") {
        if (line_content == "") {
            line_content = "<strong>You have no favorite items.</strong>";
        } else {
            line_content = "<strong>Your favorites:</strong>" + line_content;
        }


        // $('#content .coBlock[data-view="ATOM_FAVORITES_GROUP"]').html(line_content);
        // $("#content .refreshedItems").html(line_content);
        items.viewHtml(line_content);
        // $('#content').html("<div class='coBlock' data-view='ATOM_FAVORITES_GROUP'>" + line_content + '</div>');
    }

    if (type == "search") {
        if (special_arg) {
            if (line_content == "") {
                line_content = "<strong>No found items with this name.</strong>";
            } else {
                line_content = "<strong>Found items:</strong>" + line_content;
            }
        } else {
            line_content = "<strong>Please enter the element name.</strong>";
        }
        // $('#content .coBlock[data-view="ATOM_SEARCH_GROUP"]').html(line_content);
        items.viewHtml(line_content);
    }
    /* Customizer for text presets (v1) */
    if (type == "customizer_TP") {
        if (line_content == "") {
            line_content = "<strong>No presets on layer</strong>";
        } else {

            var mulCountInAndOut = Number(counter_customize_text_presets["IN"] + counter_customize_text_presets["OUT"]);


            var disabled_zero_in = counter_customize_text_presets["IN"] == 0 ? 'disabled' : '';
            var disabled_zero_out = counter_customize_text_presets["OUT"] == 0 ? 'disabled' : '';
            var disabled_zero_in_out = mulCountInAndOut == 0 ? 'disabled' : '';

            var buttons_html = '<ul class="customizeElement TPMassAction"><li><div class="title"><div class="icon shuffle"></div>Change the presets</div><div class="block clearfix">';
            buttons_html += '<div data="IN" count="' + counter_customize_text_presets["IN"] + '" class="btn ' + disabled_zero_in + '" style="width:33.3%">IN <sup>[' + counter_customize_text_presets["IN"] + ']</sup></div>';
            buttons_html += '<div data="OUT" count="' + counter_customize_text_presets["OUT"] + '" class="btn ' + disabled_zero_out + '" style="width:33.3%">OUT <sup>[' + counter_customize_text_presets["OUT"] + ']</sup></div>';
            buttons_html += '<div data="BOTH" count="' + mulCountInAndOut + '" class="btn ' + disabled_zero_in_out + '" style="width:33.3%">IN/OUT <sup>[' + mulCountInAndOut + ']</sup></div>';
            buttons_html += '</div></li></ul>';

            line_content = buttons_html + line_content;
        }
        $('#content .coBlock[data-view="ATOM_CUSTOMIZER_GROUP"]').html(line_content);
    }

    if(type == 'customizer_PM'){

        // _fo(special_arg['pointers']['IN']);
        try {
            clipBoardPM_Presets = {}; //reset clipboard presets copy
            if(special_arg['pointers']){
                /* IN presets */
                var loopContentIn = mainItemParserLoop(type, parsed_pack_structure, preview_group_icon_app, pack_path, [special_arg['pointers']['IN'], 'IN']);
                if(loopContentIn.content){
                    var btnsIn = pmMassPreviewControl('In Animation Presets', 'IN', counter_customize_text_presets["IN"]);
                    line_content += btnsIn + loopContentIn.content + pmAddItemPlaceholder('IN');
                }
    
                /* MIDDLE Presets */
                var loopContentMiddle = mainItemParserLoop(type, parsed_pack_structure, preview_group_icon_app, pack_path, [special_arg['pointers']['MID'], 'MID']);
                if(loopContentMiddle.content){
                    var btnsMid = pmMassPreviewControl('Middle Animation Presets', 'MID', counter_customize_text_presets["MID"]);
                    line_content += btnsMid + loopContentMiddle.content + pmAddItemPlaceholder('MID');
                }
                /* OUT Presets */
                var loopContentOut = mainItemParserLoop(type, parsed_pack_structure, preview_group_icon_app, pack_path, [special_arg['pointers']['OUT'], 'OUT']);
                if(loopContentOut.content){
                    var btnsOut = pmMassPreviewControl('Out Animation Presets', 'OUT', counter_customize_text_presets["OUT"]);
                    line_content += btnsOut + loopContentOut.content + pmAddItemPlaceholder('OUT');
                }


                var mulCountInAndOut = Number(counter_customize_text_presets["IN"] + counter_customize_text_presets["OUT"] + counter_customize_text_presets["MID"]);

                var buttons_html = '<div class="customizerPM_layer"><div class="curLayer">Layer: '+special_arg['layerName']+'</div></div><div class="customizerPM_presetsHead clearfix">';
                buttons_html += '<div class="title left">All Animation Presets</div><div class="right btns" data-for="GLOBAL">';
                buttons_html += '<div class="count">'+countStrNaming(mulCountInAndOut, "Preset", "Presets")+'</div>';
                buttons_html += '<div data="PASTE" class="paste">Paste <div class="cpm paste"></div></div>';
                buttons_html += '<div data="COPY" class="copy">Copy all <div class="cpm copy"></div></div>';
                buttons_html += '<div data="DELETE" class="delete">Delete all <div class="cpm delete"></div></div>';
                buttons_html += '</div></div>';
            }
        } catch (error) {
            alert(error);
        }

        /* Multiple layers selected */
        if(special_arg['massSelect']){
            var buttons_html = '<div class="customizerPM_layer"><div class="curLayer">'+special_arg['layerName']+'</div></div><div class="customizerPM_presetsHead clearfix">';
            buttons_html += '<div class="title left">All Animation Presets</div><div class="right btns" data-for="GLOBAL">';
            buttons_html += '<div data="PASTE" class="paste">Paste <div class="cpm paste"></div></div>';
            buttons_html += '<div data="DELETE" class="delete">Delete all <div class="cpm delete"></div></div>';
            buttons_html += '</div></div>';
        }else{
            /* No presets on one layer selected */
            if(!line_content){
                var buttons_html = '<div class="customizerPM_layer"><div class="curLayer">Layer: '+special_arg['layerName']+'</div></div><div class="customizerPM_presetsHead clearfix">';
                buttons_html += '<div class="title left">All Animation Presets</div><div class="right btns" data-for="GLOBAL">';
                buttons_html += '<div class="count">'+countStrNaming(0, "Preset", "Presets")+'</div>';
                buttons_html += '<div data="PASTE" class="paste">Paste <div class="cpm paste"></div></div>';
                buttons_html += '</div></div>';
                buttons_html += pmAddItemPlaceholder('ANY');
            }
        }



        line_content = buttons_html + line_content;

        $('#content .coBlock[data-view="ATOM_CUSTOMIZER_GROUP"]').html(line_content);

        // $('#content').html("<div class='coBlock' data-view='ATOM_CUSTOMIZER_GROUP'>" + line_content + '</div>');
    }

    counter_folder_items["MAIN"] = 0; //reset all counter outside cycle
    return true;
}


function pmAddItemPlaceholder(name){
    return '<div class="element placeholderToAdd" res="DEFAULT">\
    <img src="img/overlays/add_animation.png" style="width: 174px;">\
    </div>';
}

function pmMassPreviewControl(name, forx, count){
    var buttons_html = '<div class="customizerPM_presetsHead one clearfix clear">';
    buttons_html += '<div class="title left">'+name+'</div><div class="right btns" data-for="'+forx+'">';
    buttons_html += '<div class="count">'+countStrNaming(count, "Preset", "Presets")+'</div>';
    buttons_html += '<div data="COPY" class="copy">Copy <div class="cpm copy"></div></div>';
    buttons_html += '<div data="DELETE" class="delete">Delete <div class="cpm delete"></div></div>';
    buttons_html += '</div></div>';
    return buttons_html;
}



function mainItemParserLoop(
  type,
  parsed_pack_structure,
  preview_group_icon_app,
  pack_path,
  special_arg
) {
  const is_new_mark_html = '<div class="is_new"></div>';
  const is_new_mark_group_html = '<span class="is_new_group">NEW</span>';
  let line_tree = "";
  let line_content = "";
  let last_counted = 0;

  const counters = {
    items: {},
    newItems: {},
    premiumItems: {}
  };

  function processItemRecursively(obj, key, tabData, level = 1) {
    const hasPreview = obj.preview !== undefined;
    const new_group_mark = obj.is_new_mark ? is_new_mark_html : "";
    const uniqueId = `${level}_${key}`;
    
    if (obj.is_new_mark) {
      is_new_mark_enabled = true;
    }

    counters.items[uniqueId] = 0;
    counters.newItems[uniqueId] = 0;
    counters.premiumItems[uniqueId] = 0;

    if (!hasPreview) {
      const groupCountPlaceholder = `_GROUP_COUNT_${uniqueId}`;
      const groupUpdatesPlaceholder = `_GROUP_HAS_UPDATES_${uniqueId}`;
      const groupPremiumPlaceholder = `_GROUP_PREMIUM_ITEMS_${uniqueId}`;
      
      line_tree += `<li class="folder">
        <div class="title"><div class="icon folder"></div>${key}${groupUpdatesPlaceholder}<sup>${groupCountPlaceholder}</sup>${groupPremiumPlaceholder}</div>
        <ul style="display: none;">`;

      let childrenHTML = "";
      for (const childKey in obj) {
        const child = obj[childKey];
        const childTabData = [...tabData, childKey];
        childrenHTML += processItemRecursively(child, childKey, childTabData, level + 1);
        
        const childUniqueId = `${level + 1}_${childKey}`;
        counters.items[uniqueId] += counters.items[childUniqueId];
        counters.newItems[uniqueId] += counters.newItems[childUniqueId];
        counters.premiumItems[uniqueId] += counters.premiumItems[childUniqueId];
      }
      
      line_tree += childrenHTML;
      line_tree += "</ul></li>";

      if (type === "default") {
        line_tree = line_tree.replace(
          new RegExp(groupCountPlaceholder.replace(/[.*+?^${}()|[\]\\]/g, '\\$&'), 'gm'),
          counters.items[uniqueId]
        );
        line_tree = line_tree.replace(
          new RegExp(groupUpdatesPlaceholder.replace(/[.*+?^${}()|[\]\\]/g, '\\$&'), 'gm'),
          counters.newItems[uniqueId] > 0 ? is_new_mark_group_html : ""
        );
        line_tree = line_tree.replace(
          new RegExp(groupPremiumPlaceholder.replace(/[.*+?^${}()|[\]\\]/g, '\\$&'), 'gm'),
          counters.premiumItems[uniqueId] > 0 ? `<sup class='is_premium_group'>${counters.premiumItems[uniqueId]}</sup>` : ""
        );
      }
    } else {
      const preview_group_icon = setPreviewGroupIconSpecialForTreeMenu(
        obj,
        preview_group_icon_app
      );

      const templateCountPlaceholder = `_TEMPLATE_COUNT_${uniqueId}`;
      const templateCountOnlyPlaceholder = `_TEMPLATE_COUNT_ONLY_${uniqueId}`;

      line_tree += `<li data-count-items="${templateCountOnlyPlaceholder}" data-view="${instanceGroupJoin(
        tabData
      )}"><div class="icon ${preview_group_icon}"></div>${key}<sup>${templateCountPlaceholder}</sup>${new_group_mark}</li>`;

      const levelKey = level === 1 ? "GLOBAL" : level === 2 ? "MAIN" : "MIDDLE";
      const prevCounterValue = counter_folder_items[levelKey];

      if (previewPresaveInvoke) {
        line_content += createContentItem(
          type,
          obj,
          pack_path,
          tabData,
          special_arg
        );
      } else {
        items.presaveObjectItems(
          type,
          obj,
          pack_path,
          tabData,
          special_arg
        );
      }

      const currentItems = counter_folder_items[levelKey] - prevCounterValue;
      counters.items[uniqueId] = currentItems;
      
      if (obj.is_new_mark) {
        counters.newItems[uniqueId] = 1;
      }
      
      if (obj.premium || obj.enabled_only) {
        const prevPremiumValue = counter_enabled_only_items[levelKey];
        const currentPremiumItems = counter_enabled_only_items[levelKey] - prevPremiumValue;
        counters.premiumItems[uniqueId] = currentPremiumItems;
      }

      if (type === "default") {
        const displayCount = (currentTempPackagePrefab.pack.version === "DEMO" && counters.items[uniqueId] === 0) ? "No Demo" : counters.items[uniqueId];
        
        line_tree = line_tree.replace(
          new RegExp(templateCountPlaceholder.replace(/[.*+?^${}()|[\]\\]/g, '\\$&'), 'gm'), 
          displayCount
        );
        line_tree = line_tree.replace(
          new RegExp(templateCountOnlyPlaceholder.replace(/[.*+?^${}()|[\]\\]/g, '\\$&'), 'gm'), 
          counters.items[uniqueId]
        );
      }
    }

    return "";
  }

  for (const prop in parsed_pack_structure) {
    const obj = parsed_pack_structure[prop];
    const tabData = [prop];

    processItemRecursively(obj, prop, tabData);

    if (type !== "default") {
      last_counted++;
    }
  }

  return {
    tree: line_tree,
    content: line_content,
    last_count: last_counted,
  };
}





function countStrNaming(num, text1, text2){
    if(num == 1){
        return num + ' ' + text1;
    }else{
        return num + ' ' + text2;
    }
}


/**
 * Create element content (item) al design/attr and etc...
 * @param {string} type Default/Favorites and etc...
 * @param {*} current_object Package Preview object
 * @param {string} pack_path Assets path (Atom Assets Folder)
 * @param {array} arr_props Like [Folder1, Folder2, Preview] => Folder1-Folder2-Preview
 * @param {string} special_arg String query for Search/Any special...
 */
function createContentItem(type, current_object, pack_path, arr_props, special_arg) {
    var ext_image = fileTypes['extImage'],
        ext_preview = fileTypes['extPreview'],
        ext_audio_file = fileTypes['extAudio'];

    var temp_line_content = '';
    var get_instance_group = instanceGroupJoin(arr_props); //All piece of folders joined via - (like Typography-Basic)
    //create content data - body for items if default
    if (type == "default") { temp_line_content += '<div class="coBlock rowb" data-view="' + get_instance_group + '">'; }

    //LET CYCLE WITH ITEM CONTENT
    for (var content_item_id in current_object.preview) {

        var temp_cycle_content = '';
        //special for item/group arguments to transfer for each item into JSX when applying
        var arguments_object = {};


        var temp_adding_string = '';

        /* GROUP CUSTOM ARGUMENTS */
        //AFFECTS ON ITEM SETTINGS (DIFF FOR SOFTWARES)

        //AppID - AE

        var aep_file_name = current_object.aep_file_name;
        var label_color_num = current_object.label_color_num;

        var change_auto_size_composition = current_object.change_auto_size_composition;
        var change_duplicate_origin_setting = current_object.change_duplicate_origin_setting;
        var change_use_start_timeline_pointer = current_object.change_use_start_timeline_pointer;
        var change_layer_index_position = current_object.change_layer_index_position;

        //AppID - PR, AI, PS
        var change_layer_index_position = current_object.group_resize_properties;


        //AppID - GLOBAL
        var custom_preview_res_thumbnail = current_object.custom_preview_res_thumbnail;
        var change_engine = current_object.change_engine;
        var preview_name_instead_id = current_object.preview_name_instead_id;
        var custom_folder = current_object.custom_folder;

        var is_audio = current_object.is_audio;
        var is_footage = current_object.is_footage;

        var is_new_mark = current_object.is_new_mark;

        /* ITEM CUSTOM ARGUMENTS */
        //INSIDE EACH PREVIEW ITEM
        var global_preview = current_object.preview;
        //children preview sets
        var item_enabled = global_preview[content_item_id].enabled;
        var item_name = global_preview[content_item_id].name;
        var item_options = global_preview[content_item_id].options;
        var item_custom_args = global_preview[content_item_id].custom_args;


        //create new system of favorites (from new AtomX 3.0)
        var item_isFavorite = currentPackFavoritesObject[content_item_id] ? true : false;



        var part_path = ''; // path/Main Group Name/Sub Folder If Exist/Name

        //custom sub folder path
        if (custom_folder) { part_path = custom_folder; } else { part_path = arr_props[arr_props.length - 1]; }

        //use name for previews instead of ID
        var replaced_item_name = content_item_id;
        if (preview_name_instead_id) {
            replaced_item_name = item_name;
        } else {
            replaced_item_name = content_item_id;
        }

        /**
         * Create preview path for item (multi-level menu params hierarchy)
         * @since AtomX 3.0
         */

        var generic_main_path = pack_path; //def: pack_path + '/';
        if (arr_props.length > 0) {
            for (var i = 0; i < arr_props.length - 1; i++) {
                generic_main_path += arr_props[i] + '/';
            }
        }
        generic_main_path += part_path + '/' + replaced_item_name;



        var prepare_path_poster = convertToSystemPath(generic_main_path + ext_image);
        var prepare_path_preview = convertToSystemPath(generic_main_path + ext_preview);


        //custom_preview_res_thumbnail - PART
        var newPreviewAspectRatio = custom_preview_res_thumbnail ? custom_preview_res_thumbnail : "DEFAULT";

        //ADDING TO HTML (WILL TRANSFERED TO JSX)
        //PREVIEW ITEM ARGUMENTS [custom_args]
        if (item_custom_args) { arguments_object['custom_args'] = item_custom_args; }

        //GROUP ARGUMENTS FOR ITEM CHILDREN (add new if changes in JSX core for Composer Module)
        //will transfer as String to each item - to send in JSX (applying the item)

        /* AFTER EFFECTS ARGUMENTS */
        /* Def arguments  */
        setNewJSONItemArgument(arguments_object, current_object, 'aep_file_name');
        setNewJSONItemArgument(arguments_object, current_object, 'label_color_num');
        setNewJSONItemArgument(arguments_object, current_object, 'change_auto_size_composition');
        setNewJSONItemArgument(arguments_object, current_object, 'change_duplicate_origin_setting');
        setNewJSONItemArgument(arguments_object, current_object, 'change_use_start_timeline_pointer');
        setNewJSONItemArgument(arguments_object, current_object, 'change_layer_index_position');
        setNewJSONItemArgument(arguments_object, current_object, 'is_presets');
        setNewJSONItemArgument(arguments_object, current_object, 'individual_comp');




        /* PREMIERE PRO ARGUMENTS */
        setNewJSONItemArgument(arguments_object, current_object, 'custom_source_type');
        setNewJSONItemArgument(arguments_object, current_object, 'ppr_file_name');
        setNewJSONItemArgument(arguments_object, current_object, 'change_auto_size_sequence');
        setNewJSONItemArgument(arguments_object, current_object, 'custom_assets_folder');
        setNewJSONItemArgument(arguments_object, current_object, 'custom_files_folder');
        setNewJSONItemArgument(arguments_object, current_object, 'group_resize_properties');
        setNewJSONItemArgument(arguments_object, current_object, 'mogrt_transition_system');
        setNewJSONItemArgument(arguments_object, current_object, 'ae_transition_system');


        /* GLOBALLY ARGUMENTS [FOR ANY SOFTWARES] */
        /* Added more arguments (for preview and etc...) */
        setNewJSONItemArgument(arguments_object, current_object, 'custom_folder');
        setNewJSONItemArgument(arguments_object, current_object, 'preview_name_instead_id');
        setNewJSONItemArgument(arguments_object, current_object, 'custom_preview_res_thumbnail');
        setNewJSONItemArgument(arguments_object, current_object, 'change_engine');
        setNewJSONItemArgument(arguments_object, current_object, 'change_auto_size_footage');
        setNewJSONItemArgument(arguments_object, current_object, 'group_req_soft_version');
        setNewJSONItemArgument(arguments_object, current_object, 'disable_webm_preview');





        //is_audio - set full path to file as true 
        if (is_audio) {
            setNewJSONItemArgument(arguments_object, current_object, 'is_audio'); //, convertToSystemPath(generic_main_path + ext_audio_file)
            //previews for audio
            var curAudioImgPath = init_sets['extMainPath'] + "/img/overlays/audio_file";
            prepare_path_poster = convertToSystemPath(curAudioImgPath + ext_image);
            prepare_path_preview = convertToSystemPath(curAudioImgPath + ext_preview);
            //default preview [boxes]
            newPreviewAspectRatio = custom_preview_res_thumbnail == "BOX_MAX" ? "BOX_MAX" : "BOX_MIN";
        }

        //is_footage - set another changes for footage preview and path
        setNewJSONItemArgument(arguments_object, current_object, 'is_footage');

        var is_demo_favorited_item = false;

        var skipObjectMainCreation = false;

        /* END ARGUMENTS BLOCK */

        //Convert JSON Arguments to string
        var composer_args_string = convertArgumentsToString(arguments_object);

        //query searching
        if (type == "search") {
            var searchBool = querySearching(special_arg, item_name);
            if(!item_enabled && searchBool){
                is_demo_favorited_item = true;
            }else{
                is_demo_favorited_item = false;
                item_enabled = searchBool;
            }
        }
        //favorites
        if (type == "favorites") {
            if(!item_enabled && item_isFavorite){
                is_demo_favorited_item = true;
            }else{
                item_enabled = item_isFavorite ? item_isFavorite : false;
                is_demo_favorited_item = false;
            }
            
        }


        //generate customize items (text presets)
        if (type == "customizer_TP") {

            var TP_IN = special_arg['IN'] ? special_arg['IN'][0] : {};
            var TP_OUT = special_arg['OUT'] ? special_arg['OUT'][0] : {};
            var TP_cur_type = '';

            if (TP_IN[content_item_id] || TP_OUT[content_item_id]) {
                //IN
                if (TP_IN[content_item_id]) {
                    counter_customize_text_presets["IN"]++;
                    TP_cur_type = "IN";
                    item_enabled = true;
                }
                //OUT
                if (TP_OUT[content_item_id]) {
                    counter_customize_text_presets["OUT"]++;
                    TP_cur_type = "OUT";
                    item_enabled = true;
                }
                //BOTH
                if (TP_IN[content_item_id] && TP_OUT[content_item_id]) {
                    TP_cur_type = "BOTH";
                }

                temp_adding_string = 'tp_type="' + TP_cur_type + '"';
            } else {
                item_enabled = false;
            }
        }
        /* _PRESET_MANAGER */
        if (type == "customizer_PM") {

            var PM_object_curData = special_arg ? special_arg[0] : {};
            var PM_object_curType = special_arg ? special_arg[1] : '';
            var TP_cur_type = '';

            var asFxName = item_custom_args.custom_fx_name ? item_custom_args.custom_fx_name : item_name;

            if (PM_object_curData && PM_object_curData[asFxName]) {
                var fxNumbers = PM_object_curData[asFxName]['fxNumbers'];

                TP_cur_type = PM_object_curType;

                var objLinkPreset = {};

                if(!clipBoardPM_Presets[TP_cur_type]){
                    clipBoardPM_Presets[TP_cur_type] = {};
                }
                

                /* Has duplicates */
                if(fxNumbers instanceof Array && fxNumbers.length > 1){
                    for (var fxIndex = 0; fxIndex < fxNumbers.length; fxIndex++) {
                        counter_customize_text_presets[PM_object_curType]++;
                        var curFxNumberBIndex = fxNumbers[fxIndex];

                        temp_adding_string = 'pm_type="' + TP_cur_type + '"';
                        temp_adding_string += 'fx-number="' + curFxNumberBIndex + '"';
                        temp_cycle_content += createOneItemPreview(
                            item_enabled,
                            type,
                            is_demo_favorited_item,
                            is_new_mark,
                            newPreviewAspectRatio,
                            currentTempPackagePrefab,
                            currentPackEngineType,
                            change_engine,
                            prepare_path_poster,
                            is_audio, 
                            item_name,
                            item_options, 
                            item_isFavorite, 
                            item_custom_args, 
                            TP_cur_type, 
                            content_item_id, 
                            get_instance_group, 
                            composer_args_string, 
                            temp_adding_string,
                            arguments_object
                        );

                        // objLinkPreset[curFxNumberBIndex] = getItemFilepath(content_item_id, item_name, get_instance_group, arguments_object, "PM_"+TP_cur_type).file;
                        clipBoardPM_Presets[TP_cur_type][curFxNumberBIndex] = getItemFilepath(content_item_id, item_name, get_instance_group, arguments_object, "PM_"+TP_cur_type).file;
                    }
                    /* Skip next creation - because created before */
                    skipObjectMainCreation =  true;
                }else{
                    /* Don't skip creation of preview objec */
                    skipObjectMainCreation =  false;
                    counter_customize_text_presets[PM_object_curType]++;
                    temp_adding_string = 'pm_type="' + TP_cur_type + '"';
                    temp_adding_string += 'fx-number="' + fxNumbers[0] + '"';
                    
                    // objLinkPreset[fxNumbers[0]] = getItemFilepath(content_item_id, item_name, get_instance_group, arguments_object, "PM_"+TP_cur_type).file;
                    clipBoardPM_Presets[TP_cur_type][fxNumbers[0]] = getItemFilepath(content_item_id, item_name, get_instance_group, arguments_object, "PM_"+TP_cur_type).file;
                }
                
            }else{
                continue;
            }
        }

        if(!skipObjectMainCreation){
            temp_cycle_content += createOneItemPreview(
                item_enabled,
                type,
                is_demo_favorited_item,
                is_new_mark,
                newPreviewAspectRatio,
                currentTempPackagePrefab,
                currentPackEngineType,
                change_engine,
                prepare_path_poster,
                is_audio, 
                item_name,
                item_options, 
                item_isFavorite, 
                item_custom_args, 
                TP_cur_type, 
                content_item_id, 
                get_instance_group, 
                composer_args_string, 
                temp_adding_string,
                arguments_object
            );
        }


        //separate BOTH (to differently pieces IN and OUT for text presets customizer)
        if (type == "customizer_TP") {

            //BOTH
            if (TP_IN[content_item_id] && TP_OUT[content_item_id]) {
                //devide content to both
                var re = new RegExp("BOTH", 'g');

                temp_cycle_content = temp_cycle_content.replace(re, "IN") + temp_cycle_content.replace(re, "OUT");
            }
        }
        //set temp item from cycle to temp line (outside cycle as globally for func)
        temp_line_content += temp_cycle_content;

    }
    //end .coBlock for elements
    if (type == "default") { temp_line_content += '</div>'; }

    return temp_line_content;
}



function createOneItemPreview(item_enabled, type, is_demo_favorited_item, is_new_mark, newPreviewAspectRatio, currentTempPackagePrefab, currentPackEngineType, change_engine, prepare_path_poster, is_audio, item_name, item_options, item_isFavorite, item_custom_args, TP_cur_type, content_item_id, get_instance_group, composer_args_string, temp_adding_string, argumentsObject){
    var temp_cycle_content = '';
    var demo_locked_item = '';
    var demo_locked_item_style = '';
    if (!item_enabled) {
        if(type == 'search' && !is_demo_favorited_item){
            return '';
        }
        if(type == 'favorites' && !is_demo_favorited_item){
            return '';
        }
        if(currentTempPackagePrefab.pack.version == "DEMO" && currentTempPackageInsideOptionsSets.show_premium_items_demo){
            demo_locked_item = ' is_demo_lock ';
            counter_enabled_only_items["MAIN"] = 1;
            counter_enabled_only_items["GLOBAL"] = 1;
            counter_enabled_only_items["MIDDLE"] = 1;
            demo_locked_item_style = !editLocalUI(false, 'demoWithPremiumItems') ? 'display:none;' : '';
        }else{
            return '';
        }
    }else{
        // if(item_isFavorite && )
    }

    var addFavoriteBorder = item_isFavorite ? "pinBorder" : "";

    var dnd_element = '';
    if (currentTempPackagePrefab.pack.appID == "PR") {
        dnd_element = 'draggable="true"';
    }



    //NEW ELEMENT LAYOUT
    temp_cycle_content += '<div style="'+demo_locked_item_style+'" ref="' + type + '" ' + temp_adding_string + ' ' + dnd_element + ' class="element  ' + demo_locked_item + addFavoriteBorder + '" res="' + newPreviewAspectRatio + '" item_id="' + content_item_id + '" item_name="' + item_name + '" instance_group="' + get_instance_group + '" arguments=\'' + composer_args_string + '\'>';
    temp_cycle_content += '<div class="pinFavoriteInside"></div>'; //pin favorite (for pinBorder)
    temp_cycle_content += '<div class="lockedDemo"></div>'; //pin favorite (for pinBorder)

    if (type == "customizer_TP") { temp_cycle_content += '<div class="overlay_TP"><div class="inside"><p><h1>[' + TP_cur_type + ']</h1></p></div></div>'; }
    // if (type == "customizer_PM") { temp_cycle_content += '<div class="overlay_TP"><div class="inside"><p><h1>[' + TP_cur_type + ']</h1></p></div></div>'; }
    

    //MAIN PREVIEW IMAGE
    //if preview not found - plug it for all poster elements
    if (
      currentTempPackageInsideOptionsSets &&
      currentTempPackageInsideOptionsSets.use_webm_preview &&
      !argumentsObject.is_audio &&
      !argumentsObject.disable_webm_preview
    ) {
      // temp_cycle_content += '<img class="source" src="' + prepare_path_poster + '" onerror="notImgFillDummies(this, \'' + newPreviewAspectRatio + '\');" />';
      // argumentsObject.change_use_webm_preview

      var webmPartVideoTake = prepare_path_poster.replace(
        /\.png$/i,
        currentTempPackageInsideOptionsSets.use_webm_preview == "mp4"
          ? ".mp4"
          : ".webm"
      );
      temp_cycle_content += `<video style="display:block;" class="source" preload="metadata" src="${webmPartVideoTake}" muted loop="true" poster="${prepare_path_poster}"/>`;
    } else {
      temp_cycle_content +=
        '<img class="source" src="' +
        prepare_path_poster +
        '" onerror="notImgFillDummies(this, \'' +
        newPreviewAspectRatio +
        "');\" />";
    }


    var isE_presetManager = currentPackEngineType == "_PRESET_MANAGER" || currentPackEngineType == "_CM_PRESET_MANAGER" ? 'whiteFills' : '';
    //PREVIEW BUTTONS (set before body, and after image)
    temp_cycle_content += '<div class="applyControls '+isE_presetManager+'">';

    //If Premiere Pro - let's only drag and drop
    if (currentTempPackagePrefab.pack.appID != "PR") {
        //Inside ApplyControl buttons
        if (type == "customizer_TP") {
            //for text presets inside customizer
            temp_cycle_content += '<div class="button" action="TP_REMOVE" type="' + TP_cur_type + '">REMOVE [' + TP_cur_type + ']<div class="icon removeTp"></div></div>';
        }else if(type == "customizer_PM"){
            temp_cycle_content += '<div title="Select" class="button" action="PM_SELECT" type="' + TP_cur_type + '">Select<div class="icon select"></div></div>';
            temp_cycle_content += '<div title="Copy" class="button" action="PM_COPY" type="' + TP_cur_type + '">Copy<div class="icon copy"></div></div>';
            temp_cycle_content += '<div title="Delete" class="button" action="PM_REMOVE" type="' + TP_cur_type + '"><div class="icon pmDeleteItem hoverInvert"></div></div>';
        } else {
            /* _COMPOSER (with change_engine texts) or _TEXT_PRESETS */
            if ((change_engine == "_TEXT_PRESETS") || (currentPackEngineType == "_TEXT_PRESETS")) {
                temp_cycle_content += '<div class="button" action="TP_IN"><div class="icon presetIn"></div>IN</div>';
                temp_cycle_content += '<div class="button" action="TP_BOTH"><div class="icon presetInOut"></div></div>';
                temp_cycle_content += '<div class="button" action="TP_OUT">OUT<div class="icon presetOut"></div></div>';
            /* _PRESET_MANAGER engine for NeuronFX */
            }else if(currentPackEngineType == "_PRESET_MANAGER" || currentPackEngineType == "_CM_PRESET_MANAGER"){
                if(!item_custom_args['multiple_preset']){
                    temp_cycle_content += '<div class="button" action="APPLY"><div class="icon create"></div>Apply</div>';
                }else{
                    temp_cycle_content += '<div class="button" action="PM_IN"><div class="icon pmPresetIn hoverInvert"></div>IN</div>';
                    temp_cycle_content += '<div class="button" action="PM_BOTH"><div class="icon pmPresetBoth hoverInvert"></div></div>';
                    temp_cycle_content += '<div class="button" action="PM_OUT">OUT<div class="icon pmPresetOut hoverInvert"></div></div>';
                }
            }else {
                /* Default for _COMPOSER */
                if (is_audio) {
                    temp_cycle_content += '<div class="button" action="IMPORT"><div class="icon add"></div>Import</div>';
                } else {
                    temp_cycle_content += '<div class="button" action="APPLY"><div class="icon create"></div>Apply</div>';
                }

            }
        }
        //end applyControl buttons
    }

    temp_cycle_content += '</div>'; //end .applyControls
    temp_cycle_content += '<div class="body clearfix">'; //start .body

    //if name length very long (more)
    if (item_name.length > 20) {
        var len_item_name = item_name.substr(0, 18) + "..";
        temp_cycle_content += '<div class="title" title="' + item_name + '">' + len_item_name + '</div>';
    } else {
        temp_cycle_content += '<div class="title">' + item_name + '</div>';
    }

    temp_cycle_content += '<div class="usage">'; //start .usage

    //item info if exist
    if (item_options) {
        var item_text = '',
            current_options_icon = '',
            multi_options = false;

        if (item_options.toString().indexOf("@") != -1) {
            //if more details as - TYPE:DESCRIPTION
            current_options_icon = item_options.toString().split("@")[0];
            multi_options = true;
        } else {
            //default detail as - TYPE
            current_options_icon = item_options;
            multi_options = false;
        }

        switch (current_options_icon) {
            case "threeD":
                item_text = "3D Animation";
                break;
            case "puzzlePart":
                item_text = "Mask Path";
                break;
            case "diamondPick":
                item_text = "Our choice";
                break;
            case "plugIn":
                item_text = "Need Plug-in";
                break;
            case "pen":
                item_text = "Font";
                break;
            case "pen2":
                item_text = "Font Mix";
                break;
            case "winnerCup":
                item_text = "Fresh Item";
                break;
            case "info":
                item_text = item_options;
                break;
                //options exist without matched - info
            default:
                current_options_icon = "info";
                item_text = item_options;
        }
        if (multi_options == true) { item_text = item_options.toString().split("@")[1]; }

        temp_cycle_content += '<div class="btn info_message ' + current_options_icon + '" tooltip="' + item_text + '" tooltip-type="items"></div>';
    }

    //Favorites
    if (item_isFavorite) {
        temp_cycle_content += '<div class="btn favorite active" tooltip="Remove" tooltip-type="items"></div>';
    } else {
        temp_cycle_content += '<div class="btn favorite" tooltip="Add to favorite" tooltip-type="items"></div>';
    }



    temp_cycle_content += '</div>'; //end .usage
    temp_cycle_content += '</div></div>'; //end .body & .element
    temp_cycle_content += '<!-- END ITEM -->'; //end item comment

    //counting for groups/folders
    // counter_folder_items["MAIN"]++; //size up
    // counter_folder_items["GLOBAL"]++;
    // counter_folder_items["MIDDLE"]++;

    if (is_new_mark) {
        counter_new_items["MAIN"] = 1; //size up
        counter_new_items["GLOBAL"] = 1;
        counter_new_items["MIDDLE"] = 1;
    }



    return temp_cycle_content;  
}




//#endregion