/**
 * Clear init (load packs and etc) to test design details
 * @option 0 - disabled
 * @option 1 - test design (disable preloading bar)
 * @option 2 - show special buttons & default test with scripts before load pack (test JSX part)
 * @option 3 - disable load packages (show startup page)
 * @option 10 - run test mode with prepared pack (without global settings)
 */
var adminDebugMode = 0; //D:\DRAYVER\Projects\Atom AE Extension\Test Packs\Example for After Effects\After Effects Package
var adminDebugTestPackFile = "D:\\DRAYVER\\Projects\\AtomX\\Test Packages\\Premiere Pro Package\\webm.atom";
// var adminDebugTestPackFile; // = "C:\\Users\\papin\\Downloads\\Spunkram Library 4.6 for Premiere Pro\\ATOMX\\Spunkram Library Pr 4.6_Test Mode.atom";
//"C:\\Users\\papin\\Downloads\\Gal Toolkit 3.5 for Premiere Pro\\02 Toolkit Files\\03 ATOMX\\Premiere Gal Toolkit - Demo 3.5.atom";

//layout resize normalize (when load and resize panel)
$(window).ready(panelLayoutResize).resize(panelLayoutResize);
// //preload app (get preferences and etc...)
$(window).load(preloadExtension);

// $('.packageManager').show();

// changeShowHideBlurred(true, ".packageManager", 2);
// changeShowHideBlurred(true, '.atomMarket', 2);
// upServerContent("vtuts");
// changeShowHideBlurred(true, '.videoTutorials', 2);

// changeShowHideBlurred(true, '.chooseInstallationMethod', 2);
// changeShowHideBlurred(true, '.confirmRemovePackage', 2);

// changeShowHideBlurred(true, '.verifyInstallationPack', 2);

//#region GLOBAL INIT

function runTestDesign() {
	// changeShowHideBlurred(true, ".personalizedMarketLogin", 3);
	// changeShowHideBlurred(true, '.atomMarket', 2);
	// changeShowHideBlurred(true, ".packageManager", 2);
	// setTimeout(function() {
	//     setupProgressBar(true, 'Load First', 100, 3000);
	// }, 1200);
	// setTimeout(function() {
	//     setupProgressBar(true, 'Load Second', 40);
	// }, 2400);
	// setTimeout(function() {
	//     setupProgressBar(true, 'Load Third', 80);
	// }, 4500);
	// setTimeout(function() {
	//     setupProgressBar(false);
	// }, 6000);
}

/**
 * Main preload function (loading themeManager, core, preferences, menus and etc)
 */
function preloadExtension() {
	//Init ThemeManager (to set def panel background colors and etc)
	themeManager.init();

	//Flyout menu XML string
	var flyoutXML = "";
	flyoutXML += "<Menu>";
	//------menu content
	//reload btn
	flyoutXML += '<MenuItem Id="reloadPanel" Label="Reload Panel" Enabled="true" Checkable="true" Checked="false"/>';
	//debug btn
	flyoutXML += '<MenuItem Id="debugger" Label="Debugger" Enabled="true" Checkable="true" Checked="false"/>';
	//settings btn
	flyoutXML += '<MenuItem Id="settings" Label="Settings" Enabled="true" Checkable="true" Checked="false"/>';
	//test mode btn
	flyoutXML += '<MenuItem Id="testMode" Label="Test Mode" Enabled="true" Checkable="true" Checked="false"/>';
	//test mode btn
	flyoutXML += '<MenuItem Id="fixFontIssues" Label="Fix Font Problems" Enabled="true" Checkable="true" Checked="false"/>';

	//dev panel btn
	flyoutXML += '<MenuItem Id="devUserPanel" Label="Dev Panel" Enabled="true" Checkable="true" Checked="false"/>';
	//---devider
	flyoutXML += '<MenuItem Label="---" />';

	//if extension created with personalization for brand
	if (maskedIVE) {
		//copyright
		flyoutXML += '<MenuItem Id="copyright" Label="Powered by © AtomX" Enabled="false" Checkable="true" Checked="false"/>';
	} else {
		//become a partner
		flyoutXML += '<MenuItem Id="getPanel" Label="Get the AtomX panel for projects" Enabled="true" Checkable="true" Checked="false"/>';
		//copyright
		flyoutXML += '<MenuItem Id="copyright" Label="AtomX Extension © get-atomx.com" Enabled="false" Checkable="true" Checked="false"/>';
	}

	//-----end menu content
	flyoutXML += "</Menu>";

	//Uses the XML string to build the menu
	function flyoutMenuClickedHandler(event) {
		switch (event.data.menuId) {
			case "reloadPanel":
				reloadExtensionPanel();
				break;
			case "debugger":
				systemDebugger();
				break;
			case "getPanel":
				linkCore("link", "get_panel");
				break;
			case "settings":
				popupContentSwitcher("ATOM_EXTENSION_SETTINGS");
				break;
			case "testMode":
				testMode(false);
				break;
			case "fixFontIssues":
				editLocalPSets(true, "useSystemFonts", 1);
				saveLocalPreferences("PSets", 500);
				setFixedFont();
				break;
			case "devUserPanel":
				userDevDebugPanel();
				break;
		}
	}

	csInterface.setPanelFlyoutMenu(flyoutXML);
	csInterface.addEventListener("com.adobe.csxs.events.flyoutMenuClicked", flyoutMenuClickedHandler);

	/* Pre-settings inits */
	var getHostEnv = csInterface.getHostEnvironment();
	var extMainPath = getExtensionPath();
	var path_js_folder = extMainPath + "/js/";
	var path_jsx_folder = extMainPath + "/jsx/";
	var path_html_folder = extMainPath + "/design/";
	var path_bins_folder = extMainPath + "/bin/";

	//get async data about user
	fsmodule.systemInfo.getAsyncData();

	init_sets["appVersion"] = getHostEnv["appVersion"];
	init_sets["appLocale"] = getHostEnv["appLocale"];
	init_sets["appID"] = getHostEnv["appId"];
	init_sets["osVersion"] = csInterface.getOSInformation();
	init_sets["pathUserData"] = csInterface.getSystemPath(SystemPath.USER_DATA);
	init_sets["extMainPath"] = extMainPath;
	init_sets["extJSPath"] = path_js_folder;
	init_sets["extJSXPath"] = path_jsx_folder;
	init_sets["extBINPath"] = path_bins_folder;

	atomxCore.boot.throwBootLoader("Pre-settings"); //throw to array debug list

	//First preloader
	setupProgressBar(true, "Preloading", 0, 3400);

	//if need design tests - disable preloading
	if (adminDebugMode == 1) {
		setupProgressBar(false);
	}

	//LOAD MAIN
	//set global data variable to object (to use in future)
	try {
		//Apply html pieces to extension
		applyHtmlTemplate(path_html_folder);
		//Change html content for new skin (if branded for personalized extension)
		htmlReskinning();
		//Apply Panel Layout Resize for content
		panelLayoutResize();
		runTestDesign();

		/* Load Lib JSX */
		//main engine - native import and initial global JSX (main controller to load others JSX and control core)
		csInterface.evalScript('$.evalFile("' + path_jsx_folder + "/engine.jsx" + '")');
		//load JSON2
		csInterface.evalScript('$._AtomExt_engine.evalFile("' + path_js_folder + '/libs/json2.js")');
		// csInterface.evalScript('$._AtomExt_engine.evalFile("' + path_js_folder + '/libs/json2.js")');
		//load all JSX in folder (can be loaded only after main engine)
		csInterface.evalScript('$._AtomExt_engine.evalFiles("' + path_jsx_folder + '")');

		/* INIT BIT TEST ZONE TO TEST JSX AND ANY BEFORE MAIN LOAD EXT */
		if (adminDebugMode == 2) {
			//show debug buttons
			$("#footer .debugButtons").show();
			setupProgressBar(false);
			return 0;
		}
		if (adminDebugMode == 3) {
			//load startup page
			setupProgressBar(false);
			packageNoFirstExtRun();
			return 0;
		}
		/* END TEST ZONE */

		/* General load functions */
		//get or create extension folder in AppData (before loading JSON Preferences) used like:  _globalPathObjects['atomDataFolder']
		getOrCreateAtomAppDataFolder();
		//load preferences inside AppData Atom Folder and set to global var like localPreferences
		if (getOrCreateParsedJsonPreferences() == "PREF_FILE") {
			return createMessage("Wrong Preferences", "The settings file is corrupted", "error", true);
		}
		/* NEW: set default API server from preferences */
		setDefaultApiServer();

		/* Set options for personal extension */
		if (maskedIVE) {
			if (maskedIVE.settings && maskedIVE.settings.setOptionsByDefault) {
				var iveSetOptionsByDef = maskedIVE.settings.setOptionsByDefault;
				for (var index = 0; index < iveSetOptionsByDef.length; index++) {
					var element = iveSetOptionsByDef[index];
					switch (element) {
						/* Set macos bins to load from server */
						case "macos_bins":
							if (!editLocalPSets(false, "useGPUSupports") || !editLocalPSets(false, "useContinueAnyway")) {
								editLocalPSets(true, "useGPUSupports", 1);
								editLocalPSets(true, "useContinueAnyway", 1);
							}
							break;
					}
				}
			}
		}

		atomxCore.boot.throwBootLoader("JSX Libs"); //throw to array debug list

		atomxCore.boot.throwBootLoader("App Exec Libs"); //throw to array debug list

		//Load module preferences from localMemory [market/grace and etc...]
		/* Default Market */
		tempLocalMarketHandleData = handleMarketNotifierPrefs(false);
		/* Personalized Market */
		tempLocalPersonalizedMarketHandleData = handlePersonalMarketNotifierPrefs(false);
		/* Personalized Auth Login */
		tempLocalPersonalizedAuthSystemData = handlePersonalAuthSystemPrefs(false);
		/* Grace Module */
		tempGraceModuleContent = graceModulePrefs(false);

		var sendStructToJsxCore = JSON.stringify({
			initSAppID: getCurSoftShortID(),
			softAppData: softAssetsByAppID,
			maskedIVE: maskedIVE
		});

		var useSystemFonts = editLocalPSets(false, "useSystemFonts");
		if (useSystemFonts) {
			setFixedFont();
		}

		//Load special app libs (exe/exec) for Premiere Pro helpers
		getPrAppHelperPath(true);

		//main initializing
		csInterface.evalScript("initEngineJSX(" + sendStructToJsxCore + ")", function (result) {
			try {
				// if founded packages from old Atom (JSXBIN packs) - add and save json file
				if (result && result != "undefined") {
					var parseOldJSXPack = JSON.parse(result);
					if (parseOldJSXPack) {
						var oldPackArr = parseOldJSXPack["oldPackArr"];
						var oldLoadPack = parseOldJSXPack["oldLoadPack"];
						var oldPackAllFavs = parseOldJSXPack["oldPackAllFavs"];

						if (oldPackArr.length > 0) {
							var tempPackArr = [];
							for (var pa = 0; pa < oldPackArr.length; pa++) {
								var curOAP = oldPackArr[pa];

								var pName = curOAP[0];
								var pAuthor = curOAP[1];
								var pVersion = curOAP[2];
								var pPath = curOAP[3];
								var pEngine = curOAP[4];

								if (!packageGetBy(pName, pAuthor, "AE")) {
									//set cur pack to load
									var disable_load_package = pName == oldLoadPack ? false : true;
									//insert new package to preferences

									tempPackArr.push(
										packageTestPackage(
											pName,
											pAuthor,
											pVersion,
											convertToSystemPath(pPath),
											pEngine,
											"AE",
											"CC17",
											oldPackAllFavs,
											disable_load_package
										)
									);
								}
							}

							//found pack to add in pref
							if (tempPackArr.length > 0) {
								//unload all packs before adding new
								handlerPackagePrefs("unloadAllPacks");
								for (var v = 0; v < tempPackArr.length; v++) {
									localPreferences["packages"].push(tempPackArr[v]);
								}
								//save new packages in prefs
								savePrefJSON_File();
							}
						}
					}
				}

				atomxCore.boot.throwBootLoader("Init Engine"); //throw to array debug list

				/* TEST CONNECTION */
				// cHttpPostAsync(
				//   "http://api.get-atomx.com/atomx/v1/verification?method=342",
				//   JSON.stringify({
				//     zaya: "saymeWhat",
				//     todoNumber: 1882,
				//     booleanPlease: true,
				//   }),
				//   {
				//     "X-Requested-With": "Atom_X",
				//     "User-Agent": "AniomExtension_Atom",
				//     "Content-Type": "application/json",
				//   },
				//   function (result, success) {
				//     if (success && result) {
				//       try {
				//         alert(result);
				//       } catch (ex) {
				//         alert(ex);
				//       }
				//     } else {
				//       //XHR results
				//       if (result == "NO_CONNECTION") {
				//         result = "NO_CONNECTION";
				//       }
				//       if (result == "REQUEST_TIMEOUT") {
				//         result = "TIMEOUT";
				//       } //timeout loading
				//       if (result == "NO_SUCCESS_LOAD" || !result) {
				//         result = "NO_SUCCESS_LOAD";
				//       } //set status if no results
				//       alert(result);
				//     }
				//   }
				// );

				/* END TEST CONNECTION */

				/* TEST ZONE NUM 10 - RUN TEST PACK */
				if (adminDebugMode == 10) {
					//run pack in test mode
					testMode(false);
					specialMemoryVariables["testModeFirstInit"] = false;
					installPackageFirstCheck(adminDebugTestPackFile);
					setupProgressBar(false);
					return 0;
				}
				/* END TEST ZONE */

				//main initialization of the extension
				var parsed_ui_sets = editLocalUI(false); //User UI Settings
				var parsed_pref_sets = editLocalPSets(false); //Main PrefSets

				atomxCore.boot.throwBootLoader("Load Pref Sets"); //throw to array debug list

				//if UI sets exist - set to global UI sets from JSON preferences
				if (!parsed_ui_sets || !parsed_pref_sets) {
					return createMessage("No Pref Keys", "No preference keys", "info", true);
				}

				//add settings param and values in html
				settingsPanelInputs();
				/* Package manager sort options at startup */
				packageManagerPanelInputs();

				var packLists = packageGetLists();
				var packIsLoad = false;
				//try on errors lists, if no errors then execute package

				//load market under package (personalized if exists)
				// upServerContent('marketAndUpdater');

				if (packLists.length > 0) {
					packIsLoad = packageGetIsLoad();

					//if first load pack by subscription (async run package only after load data from market/auth/subscription status)
					if (packIsLoad.abs) {
						// runPackageHandler(true, packIsLoad, false, 'init');
						upServerContent("marketAndUpdater", false, function () {
							runPackageHandler(true, packIsLoad, false, "init");
						});
					} else {
						//first load package without subscriptions (async) and after load data from market (don't need await server data to load the package)
						//load server data inside @exePackage with checks
						runPackageHandler(true, packIsLoad, false, "init");
					}
				} else {
					//if no have package (first load ext as sample with started menu)
					packageNoFirstExtRun();
					upServerContent("marketAndUpdater");
				}

				//Load this anyway (even if no packs, or failed to load)
				//load market/notify data

				// csInterface.requestOpenExtension('Atom.hiddenDialog1');

				//send parsed packs to builder manager (other var out loadPack in case of errors with pack) - by default included in @func exePackage
				packageManagerBuilder(packLists, packIsLoad);

				atomxCore.boot.throwBootLoader("Pack List Build"); //throw to array debug list
				atomxCore.boot.throwBootLoader("Complete initialization"); //throw to array debug list

				//Timer delays
				//turn off progress (completed)
				setTimeout(function () {
					/* Load Tuts to show assigned selected package */

					setupProgressBar(false);
				}, 1500);
			} catch (em) {
				createMessage("Engine JSX Error", "@initEngineJSX->" + em.toString(), "error", true);
			}
		});

		/* Load test design options */
		// runTestDesign();
	} catch (ex) {
		createMessage("Global Init Error", "@preloadExtension->" + ex.toString(), "error", true);
	}
}

function setFixedFont() {
	$("head").append(
		"<style>*{font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif!important;}</style>"
	);
}

/**
 * Apply HTML pieces (include and replace <template> tags)
 * @param {string} htmlFolder Folder path for HTML files
 */
function applyHtmlTemplate(htmlFolder) {
	/* Template Tags */
	/* Tag Name = Html page for tag */
	var tags = {
		header: "header.html",
		"package-manager": "package-manager.html",
		"popup-content": "popup-content.html",
		"verify-panel": "verify-panel.html",
		"confirmation-popup": "confirmation-popup.html",
		"tips-content": "tips-content.html",
		"info-placeboard": "info-placeboard.html",
		"test-mode-panel": "test-mode-panel.html",
		toolbar: "toolbar.html",
		"get-started-content": "get-started-content.html",
		footer: "footer.html",
		dnd: "dnd.html",
		"engine-photo-animator": "engine-photo-animator.html",
		"external-lib-assets": "external-lib-assets.html"
	};

	for (var tagName in tags) {
		if (Object.hasOwnProperty.call(tags, tagName)) {
			var htmlName = tags[tagName];
			var filePath = htmlFolder + htmlName;
			if (fsmodule.exists(filePath)) {
				var getFile = fsmodule.readFile(filePath);
				$(tagName).html(getFile);
			}
		}
	}
}

/**
 * Change skin for extension if personalized version
 */
function htmlReskinning() {
	//if need rechange html params for new skin
	if (maskedIVE) {
		$(".dragAndDropInstallation input[type=file]").attr("accept", "." + mainPackageFiletype);

		$(".packageManager .titleFooter a").text(maskedIVE.name + " Market");

		$(".getStarted li[goto=install] .dataBlock").html(
			"Install the first package<p>Browse the file (*." + mainPackageFiletype + ")</p><p> or use drag and drop</p>"
		);
		$(".getStarted li[goto=tutorials] .dataBlock").html("Watch the video tutorials<p>Learn useful tips & guides for</p><p>working with packages</p>");
		$(".getStarted li[goto=market] .dataBlock").html("Get more packages<p>Open the market to get more</p><p> free & premium items</p>");

		/* stylization part */

		//replace logo to new
		if (maskedIVE.stylization) {
			var msk_style = maskedIVE.stylization;
			var msk_files = "img/masked_content/";
			if (msk_style.logo) {
				var logoImgURL = msk_files + msk_style.logo;
				var logoImgSize = msk_style.logoSize || 100;
				var logoImgPosition = msk_style.logoPosition || [0, 0];
				var logoMain =
					'<img src="' +
					logoImgURL +
					'" width="' +
					logoImgSize +
					'px" style="position:relative;left:' +
					logoImgPosition[0] +
					"px;top:" +
					logoImgPosition[1] +
					'px;">';
				$("#header .atomLogo").html('<div class="logo">' + logoMain + "</div>");
			}

			//set default header - none atomx
			var sColor = "#B71A65";
			var sImage = "img/headers/if_not_image_header.png";
			$("#header").css("background", 'url("' + sImage + '") no-repeat left center ' + sColor); //set new header image

			var stylesheets = [];

			//replace atom svg boxes on untitled
			stylesheets.push(".dragAndDropInstallation .place .atomBoxLogo{background: url('img/masked_content/masked_upload_pack.svg') no-repeat;}");
			stylesheets.push(".bsPackageSector .place .atomBrokenLogo{background: url('img/masked_content/masked_broken_pack.svg') no-repeat;}");
			stylesheets.push(".packageManager .no_packages .boxLogo{background: url('img/masked_content/masked_no_packs.svg') no-repeat;}");
			stylesheets.push(".testModeWindow .place .atomDevLogo{background: url('img/masked_content/masked_test_mode_active.svg') no-repeat;}");

			if (msk_style.menuMainColor) {
				var menuMainColor = msk_style.menuMainColor;
				stylesheets.push("#menu ul li.current{border-right-color:" + menuMainColor + ";}");
				stylesheets.push("#menu ul li.folder.active > .title sup, #menu ul li.used_demo{background:" + menuMainColor + "!important;}");
				// stylesheets.push('#menu ul li.folder.active sup, #menu ul li.folder.active ul li.folder.active sup, #menu ul li.used_demo{background:' + menuMainColor + ';}');
				stylesheets.push("#menu ul li.folder.active, #menu ul li.folder.last-active:hover{border-left-color:" + menuMainColor + ";}");
				stylesheets.push("#tools .notifyToolbarBadge.hasNotify{background:" + menuMainColor + ";}");
			}

			if (msk_style.packAuthorField) {
				stylesheets.push("#header .packDetails .packAuthor{background:" + msk_style.packAuthorField + ";}");
			}

			if (msk_style.marketIcon) {
				var marketIconFile = msk_files + msk_style.marketIcon;
				stylesheets.push('#header .headMenu .shoppingCart .marketIcon{background-image:url("' + marketIconFile + '")');
			}

			if (stylesheets.length) {
				$("head").append("<style>" + stylesheets.join("") + "</style>");
			}
		}

		/* special settings */
		if (maskedIVE.settings) {
			var msk_sets = maskedIVE.settings;

			if (msk_sets.disableUpdater) {
				$('#footer .main_btn li[data-type="updating"]').hide();
			}

			if (msk_sets.externalAssetsLib) {
				// $('#footer .main_btn li[data-type="updating"]').hide();
				$("#tools .changeViewSwitcher[data-special-switcher-btw='external-assets']").show();
			}

			if (msk_sets.marketAsPackageManager) {
				$("#header .headMenu").hide();
			}
		}
	}
}

//#endregion

//#region PERSONALIZATION OF THE EXTENSION OPTIONS

/* PERSONALIZATION WORKS ONLY IF PACK LOADED, AND SEND AUTHOR OF ONLY FIRST LOADED PACKAGE */

/**
 * Check from server this extension with personalized options (market/vtuts/any links and etc)
 */
// function doPersonalizedAuthorToServer() {
//     //if personalized extension used (if set-up used as MAIN)
//     if (maskedIVE) {
//         personalizedMarketAuthor = maskedIVE.author;
//         return getIsPersonalAuthorURI();
//     }
//     //if default extension but with custom market/other datas
//     var loadedCPack = currentTempPackagePrefab ? currentTempPackagePrefab.pack : false;//packageGetIsLoad(); //changed - now we get prefab instead parse pack isLoad
//     if (loadedCPack) {
//         //NEW! add endfix package author - to create personalized market
//         personalizedMarketAuthor = loadedCPack.author;
//         return getIsPersonalAuthorURI();
//     }
// }

// function getIsPersonalAuthorURI() {
//     if (personalizedMarketAuthor) {
//         return 'king=' + personalizedMarketAuthor;
//     }
// }

//#endregion

//#region SYSTEM FUNCTIONS

/**
 * Send object pack data to work with Adobe's application inside JSX engine
 */
atomxCore.appTransfer = {
	exePackBindingJSX: function () {
		//send inits to JSX core
		var sendJSX = JSON.stringify({
			packObject: currentTempPackagePrefab.pack,
			packInsideOptions: currentTempPackageInsideOptionsSets,
			shortAppID: getCurSoftShortID(),
			packFileDir: fsmodule.fileDirectory(currentTempPackagePrefab.pack.path)
		});
		csInterface.evalScript("transferExeSwitchTrigger(" + sendJSX + ")");
	}
};

function setDefaultApiServer() {
	if (useTestServer) {
		mainApiURI = testServerURI;
	} else {
		var defServerSlug = editLocalPSets(false, "defaultApiServer");
		mainApiURI = defServerSlug ? proxyServersURI[defServerSlug] : proxyServersURI[0];
	}
}

function exePackEngineBindingJSX(newEngineType) {
	csInterface.evalScript('transferExeEngineSwitchTrigger("' + newEngineType + '")');
}

/**
 * Get Extension Path (full)
 * @return {string} Path as string in via "/"
 */
function getExtensionPath() {
	return csInterface.getSystemPath(SystemPath.EXTENSION);
}

/**
 * Get Extension Path (full)
 * @return {string} Path as string in via "/"
 */
function getUserDocumentPath() {
	return csInterface.getSystemPath(SystemPath.MY_DOCUMENTS);
}

var loadedExternalAssetsLibInit = false;
var externalAssetLibDetails = {
	lastType: "IMAGE",
	lastPage: 1,
	lastSearch: ""
};
function preloadExternalLibAssets() {
	if (loadedExternalAssetsLibInit) return;

	loadedExternalAssetsLibInit = true;
	loadNewContentExternalLibAssets("IMAGE", 1, "");
}

function loadNewContentExternalLibAssets(type, page, search, updateObserver) {
	var xhURI = mainApiURI + "external_lib_assets";
	//personalization for Video Tutorials content
	externalAssetLibDetails.lastPage = page;
	externalAssetLibDetails.lastType = type;
	externalAssetLibDetails.lastSearch = search;

	var uriPiecesArr = [];
	uriPiecesArr.push("type=" + type);
	uriPiecesArr.push("action=" + (search ? "search" : "collection"));
	uriPiecesArr.push("page=" + page);
	uriPiecesArr.push("search=" + search);

	xhURI += "?" + uriPiecesArr.join("&");
	var putToErrContent = "";
	// if (!serverTempVideoTutsJSON || (serverTempVideoTutsJSON && atomxCore.personalizer.checkRefreshContent(isPersonalizingAuthorName))) {
	if (!serverTempExLibraryAssetsJSON[type] || updateObserver == true) {
		cHttpAsync(xhURI, function (result, success) {
			if (success && result) {
				try {
					//prepare to JSON obj from string
					var json_content = JSON.parse(result);

					if (json_content.content.length == 0) {
						stopObserver();
						putToErrContent = changePreloadServerInfoBlock(false, page > 1 ? "end_search" : "bad_search");

						if (page > 1) {
							$("external-lib-assets").append(putToErrContent + "<br><br>");
							$("external-lib-assets .loader").hide();
						} else {
							$("external-lib-assets").html(putToErrContent);
						}

						return;
					}
					//save this json in temp to use inside session without connect to server
					serverTempExLibraryAssetsJSON[type] = json_content.content;
					//create video tuts content from json
					genExternalLibContentItems(serverTempExLibraryAssetsJSON[type], page > 1);
				} catch (ex) {
					//if can't read JSON from server
					putToErrContent = changePreloadServerInfoBlock(false, "parse");
					$("external-lib-assets").html(putToErrContent);
				}
			} else {
				//no connection/any errors
				if (result == "NO_CONNECTION") {
					putToErrContent = changePreloadServerInfoBlock(false, "connect");
				}
				//timeout loading
				if (result == "REQUEST_TIMEOUT") {
					putToErrContent = changePreloadServerInfoBlock(false, "timeout");
				}
				//no success load or no content in result
				if (result == "NO_SUCCESS_LOAD" || !result) {
					putToErrContent = changePreloadServerInfoBlock(false, "load");
				}
				$("external-lib-assets").html(putToErrContent);
			}
		});
	} else {
		//recreate content with temp json from server (special if switched package to bind within)
		genExternalLibContentItems(serverTempExLibraryAssetsJSON[type], page > 1);
	}
}

var libAssetImportTo = 0;

function downloadExternalLibAssetToPc(xhURI, slug, videoPreview) {
	var currentFilePath = convertToSystemPath(getFolderImagesForExternalLibImports() + slug + (videoPreview ? ".mp4" : ".jpg"));

	var params = {
		importAs: libAssetImportTo,
		path: currentFilePath
	};

	if (fsmodule.exists(currentFilePath)) {
		setupProgressBar(true, "Importing");

		csInterface.evalScript(`importExAssetLibItem(${JSON.stringify(params)})`, function (result) {
			if (itemResponseListFromEngine(result)) {
				setupProgressBar(false);
			} else {
				cantApplyItem(result, cur_item_name, cur_item_instance_grp);
				setupProgressBar(false, "_STOP");
			}
		});
		return;
	}

	cHttpAsyncBinaryFile(
		xhURI,
		function (result, success) {
			// $('input[name="devTerminal"]').val(xhURI).addClass('result');

			if (success && result) {
				try {
					fsmodule._fs.writeFile(currentFilePath, result, function (err) {
						if (err) {
							createMessage("Unable to download asset file", "File Write access error", "error", true);
							return false;
						}
						setupProgressBar(true, "Importing");
						csInterface.evalScript(`importExAssetLibItem(${JSON.stringify(params)})`, function (result) {
							if (itemResponseListFromEngine(result)) {
								setupProgressBar(false);
							} else {
								cantApplyItem(result, cur_item_name, cur_item_instance_grp);
								setupProgressBar(false, "_STOP");
							}
						});
					});
				} catch (ex) {
					//if can't read JSON from server
					createMessage("Unknown Error", "Error:" + ex.message, "error", true);
				}
			} else {
				if (result == "NO_CONNECTION") {
					result = "NO_CONNECTION";
				}
				if (result == "REQUEST_TIMEOUT") {
					result = "TIMEOUT";
				} //timeout loading
				if (result == "NO_SUCCESS_LOAD" || !result) {
					result = "NO_SUCCESS_LOAD";
				} //set status if no results

				var mainMsg = "";
				try {
					var parseSData = JSON.parse(result);
					mainMsg = parseSData["code"];
				} catch (e) {
					mainMsg = "SERVER_ERROR";
				}
				var msgData = marketLoginResponseList(mainMsg, "head");
				return createMessage(msgData["title"], msgData["body"], "error", true);
			}
		},
		15000,
		"Downloading"
	);
}

function genExternalLibContentItems(contentJson, addedToEnd) {
	let contentParse = "";
	// contentJson = JSON.parse(contentJson);

	for (const key in contentJson) {
		if (Object.prototype.hasOwnProperty.call(contentJson, key)) {
			const contentArr = contentJson[key];
			if (contentArr["video_preview"]) {
				contentParse += `<div class="masonry-item" data-slug="${contentArr["slug"]}" data-video-preview="${contentArr["video_preview"]}" data-download="${contentArr["download"]}"><img src="${contentArr["image"]}&sig=${key}" loading="lazy"/> <button class="item-button-exlib" data-action="import">Import</button></div>`;
			} else {
				contentParse += `<div class="masonry-item" data-slug="${contentArr["slug"]}" data-download="${contentArr["download"]}"><img src="${contentArr["image"]}&sig=${key}" loading="lazy"/> <button class="item-button-exlib" data-action="import">Import</button></div>`;
			}
		}
	}

	// contentParse = "2323";
	if (addedToEnd) {
		$("external-lib-assets .masonry-grid").append(contentParse);
	} else {
		$("external-lib-assets").html(
			' <div class="masonry-grid">' + contentParse + '</div><div class="observer-trigger"></div><div class="ci loader"></div>'
		);
	}
}
let observer = null; // Глобальная переменная для хранения Observer

function startObserver() {
	if (observer) return; // Если Observer уже запущен, ничего не делаем

	observer = new IntersectionObserver(
		(entries) => {
			entries.forEach((entry) => {
				if (entry.isIntersecting) {
					loadNewContentExternalLibAssets(
						externalAssetLibDetails.lastType,
						externalAssetLibDetails.lastPage + 1,
						externalAssetLibDetails.lastSearch,
						true
					);
				}
			});
		},
		{
			rootMargin: "0px 0px 500px 0px", // Подгружаем заранее (за 200px до конца)
			threshold: 0.1 // Срабатывает, когда 10% элемента видно
		}
	);
	// const observerTrigger = $(
	//   " .masonry-grid .observer-trigger"
	// );
	var observerTrigger = document.getElementsByClassName("observer-trigger")[0];
	// Начинаем наблюдение за триггером
	if (observerTrigger) {
		observer.observe(observerTrigger);
	}
}

// Функция для остановки Observer
function stopObserver() {
	if (observer) {
		observer.disconnect(); // Останавливаем наблюдение
		observer = null; // Удаляем Observer
	}
}

/* OBSERVER WEBM/mp4 PREVIEWS */
let observerWebm = null; // Глобальная переменная для хранения Observer
function observerWebmPreviews() {
	if (observerWebm) return; // уже есть

	observerWebm = new IntersectionObserver(
		(entries) => {
			entries.forEach((entry) => {
				var container = $(entry.target);
				if (entry.isIntersecting) {
					// в зоне видимости — вставляем видео
					// if (container.find("video.source-video").length === 0) {
					//     var mp4Src = img_holder.attr("src").replace(/\.png$/i, ".mp4");
					//     var width = img_holder.outerWidth();
					//     var height = img_holder.outerHeight();

					//     var video = $('<video>', {
					//         src: mp4Src,
					//         autoplay: true,
					//         loop: true,
					//         muted: !webmPreviewAudio,
					//         playsinline: true,
					//         class: "source-video"
					//     }).css({
					//         width: width,
					//         height: height,
					//         display: "block"
					//     });

					//     img_holder.hide();
					//     container.append(video);

					//     // подстраховка mute/play
					//     video[0].muted = !webmPreviewAudio;
					//     video[0].play();
					// }

					itemPreviewWebmPart(container, false, true);
				} else {
					// вне зоны видимости — удаляем видео, показываем png
					// container.find("video.source-video").remove();
					// img_holder.show();
					itemPreviewWebmPart(container, false, false);
				}
			});
		},
		{
			// root: document.querySelector('#content > .refreshedItems'), // ТВОЙ scrollable контейнер
			root: null,
			// rootMargin: '100px',
			threshold: 0
		}
	);

	// навешиваем observer на все items
	attachObserverToItems();
}
function attachObserverToItems() {
	$(".element").each(function () {
		observerWebm.observe(this);
	});
}
function destroyWebmObserver() {
	if (observerWebm) {
		observerWebm.disconnect();
		observerWebm = null;
	}
}

// пример включения/отключения Observer в зависимости от настроек
function updateWebmObserverState() {
	if (editLocalUI(false, "previewAutoPlay") && currentTempPackageInsideOptionsSets && currentTempPackageInsideOptionsSets.use_webm_preview) {
		// включаем observer
		observerWebmPreviews();
	} else {
		// выключаем observer
		destroyWebmObserver();
	}
}

updateWebmObserverState();

/**
 * Injector application uses for Premiere Pro Copy-Paste Sequence method
 * @version 2.0 now files in GZIP - need unzip via nodeJS before using
 * @return {string} Path with filetype (prepared for OS path) or false if not exists file
 */
function getPrAppHelperPath(first_init) {
	//if Premiere Pro - do it
	if (getCurSoftShortID() == "PR") {
		var commonPtxPath = getFolderDocumentsCommonPTX();
		var getOS = getOSVersion().toString();

		/* Fake options to load external libraries (trick) */
		var usedGPU = editLocalPSets(false, "useGPUSupports");
		var usedContinueErrors = editLocalPSets(false, "useContinueAnyway");

		// if(!first_init){
		//     // setupProgressBar(false, "_STOP");
		//     createMessage('Sequence issues', "Currently unavailable", 'info', true);
		//     return false;
		// }

		if (first_init) {
			if (getOS == "mac") {
				loadAndInstallRequires("mac_helper_native_0908", commonPtxPath, getOS, true);
				/* Trick - if availble both - download external binaries for Premiere Pro Sequences (it's lib from AlexWhite) */
				if (usedGPU && usedContinueErrors) {
					var arrGetGitByOS = {
						// 'win': 'gpu_accel_1829091',
						mac: "gpu_accel_1829981"
					};
					loadAndInstallRequires(arrGetGitByOS[getOS], commonPtxPath, getOS, true);
				}
			}
		} else {
			// alert(JSON.stringify(currentTempPackageInsideOptionsSets));
			if (currentTempPackageInsideOptionsSets.source_type === "FULL_PROJECT" && getOS == "mac") {
				return;
			}
			if (usedGPU && usedContinueErrors && getOS == "mac") {
				var appNames = {
					// 'win': encoder.extras.b64_to_ascii('cHBjaC5leGU='),
					mac: encoder.extras.b64_to_ascii("cHBjaA==")
				};
				//add endfix filename
				var unzipAppFilePath = commonPtxPath + appNames[getOS];
				if (fsmodule.exists(unzipAppFilePath)) {
					return {
						type: "pt",
						app: unzipAppFilePath
					};
				} else {
					createMessage("No Helper Apps", "Reinstall the extension or contact support", "error");
					return false;
				}
			} else {
				if (getOS == "win") {
					return {
						type: "pprs",
						app: init_sets["extBINPath"] + "pprsequencer.exe"

						// 'app': 'D:/DRAYVER/Projects/Atom AE Extension/Binary CPP/AtomXMemPPro/x64/Release/pprsequencer.exe'
					};
				} else if (getOS == "mac") {
					createMessage("Mac OS issues", "Currently unavailable on Mac OS - contact support", "info");
					return false;
				}
			}
		}
	}
}

function uncompressCommandMacOnlyRun(cmd, args, opts = {}) {
	const { spawn } = require("child_process");
	return new Promise((resolve, reject) => {
		const ps = spawn(cmd, args, { stdio: "inherit", ...opts });
		ps.on("exit", (code) => (code === 0 ? resolve() : reject(new Error(`${cmd} exited ${code}`))));
		ps.on("error", reject);
	});
}

async function extractCommandArchiveMacOnly(type, archivePath, outDir) {
	//   await fsp.mkdir(outDir, { recursive: true });

	createDirRecursively(outDir);

	if (type == "zip") {
		// ditto корректно восстановит xattrs/права — идеально для .app
		await uncompressCommandMacOnlyRun("/usr/bin/ditto", ["-x", "-k", archivePath, outDir]);
		return;
	}

	if (type == "tar" || type == "unknown") {
		// Легаси TAR (или неизвестное — попробуем как tar)
		await uncompressCommandMacOnlyRun("/usr/bin/tar", ["--xattrs", "--xattrs-include=*", "-xpf", archivePath, "-C", outDir]);
		return;
	}
}

function loadAndInstallRequires(loadName, commonPtxPath, os, needUncompress) {
	var forInOneFilePath = commonPtxPath + loadName;

	var existsCheck = forInOneFilePath;

	cHttpAsync(mainApiURI + "git?load=" + loadName, function (result, success) {
		if (success && result) {
			try {
				//prepare to JSON obj from string
				var json_linkers = JSON.parse(result);

				// extractCommandArchiveMacOnly('zip', forInOneFilePath, commonPtxPath);

				// if (true) {
				if (!fsmodule.exists(existsCheck) || (fsmodule.exists(existsCheck) && json_linkers["update"])) {
					var tar = require("tar-fs");
					var unzipper = require("unzipper");
					var oneUrlPath = json_linkers["path"];

					var xhr = new XMLHttpRequest();
					// load `document` from `cache`
					xhr.open("GET", oneUrlPath, true);
					xhr.responseType = "blob";
					xhr.onload = function (e) {
						if (this.status === 200) {
							// `blob` response
							// alert(1);
							var reader = new FileReader();

							reader.onload = function (e) {
								var convertedPathOS = convertToSystemPath(forInOneFilePath);
								fsmodule._fs.appendFileSync(convertedPathOS, Buffer(e.target.result));

								if (!json_linkers["type"] || json_linkers["type"] == "binary") {
									console.log("Loaded external helper file: " + json_linkers["type"]);
									var readStream = fsmodule._fs.createReadStream(convertedPathOS);
									readStream.on("error", (err) => {
										console.log("Ошибка при чтении архива:", err);
									});

									var extractStream = tar.extract(commonPtxPath);
									extractStream.on("error", (err) => {
										// alert(1);
										console.log("Ошибка при распаковке:", err);
									});

									readStream.pipe(extractStream);
								}

								if (json_linkers["type"] == "app") {
									fsmodule._fs
										.createReadStream(convertedPathOS)
										.pipe(unzipper.Extract({ path: commonPtxPath }))
										.on("close", () => console.log("done"))
										.on("error", console.error);
								}

								if (json_linkers["type"] == "native_zip") {
									extractCommandArchiveMacOnly("zip", convertedPathOS, commonPtxPath);
								}

								if (json_linkers["type"] == "native_tar") {
									extractCommandArchiveMacOnly("tar", convertedPathOS, commonPtxPath);
								}
							};
						}
						reader.readAsArrayBuffer(this.response);
					};

					xhr.onerror = function () {
						return createMessage("No Library Data", "Use previous version of the AtomX", "error", true);
					};
					xhr.send();
				}
			} catch (ex) {
				return createMessage("Init Libraries", "Can't initialize required libraries", "error", true);
			}
		} else {
			// return createMessage('Unavailable', 'The repository is temporarily unavailable', 'error', true);
		}
	});
}

/**
 * Get OS Version
 * @return {string} version as: win or mac
 */
function getOSVersion() {
	var getOS = csInterface.getOSInformation();
	if (getOS.indexOf("Windows") >= 0) {
		//win
		return "win";
	} else {
		//mac/unix
		return "mac";
	}
}

/**
 * Convert string to Base64
 * @param {string} string
 * @return Converted String (Base64)
 */
function cBase64(string) {
	var characters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
	var result = "";

	var i = 0;
	do {
		var a = string.charCodeAt(i++);
		var b = string.charCodeAt(i++);
		var c = string.charCodeAt(i++);

		a = a ? a : 0;
		b = b ? b : 0;
		c = c ? c : 0;

		var b1 = (a >> 2) & 0x3f;
		var b2 = ((a & 0x3) << 4) | ((b >> 4) & 0xf);
		var b3 = ((b & 0xf) << 2) | ((c >> 6) & 0x3);
		var b4 = c & 0x3f;

		if (!b) {
			b3 = b4 = 64;
		} else if (!c) {
			b4 = 64;
		}

		result += characters.charAt(b1) + characters.charAt(b2) + characters.charAt(b3) + characters.charAt(b4);
	} while (i < string.length);
	return result;
}

/**
 * Tester Mode to check created package before compilation
 * @param {boolean} disable Force disable test mode
 */
function testMode(disable) {
	if (disable) {
		changeShowHideBlurred(false, ".testModeWindow", 3);
		$("#footer .testMode").hide();
		checkIsActiveTestMode = false;
	} else {
		if (checkIsActiveTestMode) {
			//if active = disable test mode
			reloadExtensionPanel();
		} else {
			//if non-active = activate test mode
			// createMessage('Test Mode is enabled', 'Develop your the packages easily!', 'info');
			changeShowHideBlurred(true, ".testModeWindow", 3); //show popup window
			$("#footer .testMode").show(); //test mode label
			checkIsActiveTestMode = true;
		}
	}
	specialMemoryVariables["testModeFirstInit"] = true;
	return checkIsActiveTestMode;
}

/**
 * Debugger - get pieces of array with content and save to file
 * Open folder dialog to save txt file.
 * Execute txt file after saving.
 * @param {*} sourceObjData Source HTML CEP EXTENSION Content - JSON.stringify($('body').html())
 * @return {string} Saved file name (.txt) with endifx timestamp - to show in JS
 */
function systemDebugger() {
	// DO DEBUGGER DATA
	var bigDeviderStr = "\n\n---------------\n\n";
	var getTimeStamp = new Date().getTime();
	getTimeStamp = getTimeStamp.toString().substr(getTimeStamp.toString().length - 4);
	var specialFileNamePrefix = "AtmDbg_" + getTimeStamp;

	//Set to debug info
	systemDebuggerContent.push("Atom Extension version: " + extensionAppVersion + "x" + extensionRevisionInfo);
	systemDebuggerContent.push("Report date: " + new Date().toString());
	systemDebuggerContent.push("(init) JS-JSX Initial Sets: \n\n" + JSON.stringify(init_sets));
	systemDebuggerContent.push("(init) Preferences (JSON): \n\n" + JSON.stringify(localPreferences));
	systemDebuggerContent.push("(init) Global Path Object: \n\n" + JSON.stringify(_globalPathObjects));

	//join all lines
	var contentToSave = "";
	contentToSave += systemDebuggerContent.join(bigDeviderStr);
	contentToSave += bigDeviderStr;
	contentToSave += "(com) Boot Loader:\n\n" + systemDebuggerBootLoader.join("\n");
	contentToSave += bigDeviderStr;
	contentToSave += "(*) Command Lines:\n\n" + systemDebuggerCommandLines.join("\n");
	contentToSave += bigDeviderStr;
	contentToSave += "(systemDebugger) Source Panel HTML: \n\n" + $("body").html().toString();

	var selectedFolderFile = cep.fs.showSaveDialogEx("Select folder to save debug file", getUserDocumentPath(), ["txt"], specialFileNamePrefix);
	if (selectedFolderFile.data) {
		var cPath = selectedFolderFile.data + ".txt";
		fsmodule.writeFileAsync(cPath, contentToSave);

		var getOnlySelectedName = /[ \w-]+?(?=\.)/.exec(cPath)[0];
		createMessage("Debugging file", "Send the <code>" + getOnlySelectedName + ".txt" + "</code> to developer", "success", true);
	}
}

function userDevDebugPanel(pHide) {
	if (pHide) {
		checkIsDevUserPanel = false;
	} else {
		checkIsDevUserPanel = !checkIsDevUserPanel;
	}

	if (checkIsDevUserPanel) {
		$("#footer .debugButtons").show();
	} else {
		//also close Console Response Box
		$(".console_panel").hide();
		$("#footer .debugButtons").hide();
	}
}

function _toConsole(Text) {
	$(".console_panel").show();
	$(".console_panel textarea").html(Text);
}

function parseAlert(obj) {
	var str = "";
	for (var key in obj) {
		if (obj.hasOwnProperty(key)) {
			var element = obj[key];
			str += key + "\r";
		}
	}

	alert(str);
}

/**
 * Fast output data inside div.packName
 * @param {*} output_data Output HTML
 */
function _f(output_data) {
	$("#container").html(output_data.toString());
}

function _fo(object) {
	var setBody = "";
	for (var key in object) {
		if (object.hasOwnProperty(key)) {
			setBody += key + ": " + object[key] + "<br><br>";
		}
	}
	$("#container").html(setBody);
}

function _fa(object, separator) {
	if (!separator) {
		separator = "\n";
	}
	var setBody = "";
	for (var key in object) {
		if (object.hasOwnProperty(key)) {
			setBody += key + ": " + object[key] + separator;
		}
	}
	return setBody;
}

/**
 * Delay in MS
 * @param {*} ms Miliseconds
 */
function _Yes(ms) {
	ms += new Date().getTime();
	while (new Date() < ms) {}
}

function devActions(consoleInput) {
	var $console = $(".console_panel");
	var $console_text = $console.find("textarea");

	csInterface.evalScript(consoleInput, function (result) {
		$console_text.removeClass("result red green");
		$console.show(); //show console panel
		if (result != "undefined") {
			$console_text.val(result.toString()).addClass("result green");
		} else {
			$console_text.val(terminalCode.toString() + " is " + result.toString()).addClass("result red");
		}
	});
}

/**
 * Get current application short ID
 * @return {string} Short appID (like AE/PR/...)
 */
function getCurSoftShortID() {
	var getPackShortAppID = "AE"; //!IMPORTANT required if launched first time (errors on MacOS Catalina - Premiere Pro CC19)
	switch (init_sets["appID"]) {
		//After Effects
		case "AEFT":
			getPackShortAppID = "AE";
			break;
		//Premiere Pro
		case "PPRO":
			getPackShortAppID = "PR";
			break;
		//Illustator
		case "ILST":
			getPackShortAppID = "AI";
			break;
		//Photoshop (both PHSP/PHXS)
		case "PHXS":
		case "PHSP":
			getPackShortAppID = "PS";
			break;
	}

	return getPackShortAppID;
}

function getFileTypeFileProtectionCached(packAppID, diffFileType) {
	diffFileType = diffFileType || "main";
	switch (currentTempPackageInsideOptionsSets.files_protection_method) {
		case "BIN_AX": //atomxasset
			return basisProtectFileTypes.BIN_AX;
			break;
		default: //return default AE: aep, PR: prproj
			return softAssetsByAppID[packAppID]["filetypes"][diffFileType];
	}
}

/**
 * Reload extension (including the JSX file coz another connect method, can reload jsx via reload html panel)
 */
function reloadExtensionPanel() {
	location.reload();
}

//#endregion

//#region SERVER XHR/LINKER/UPDATER

/**
 * Async XHR Requester to server (_GET)
 * @param {string} uri Uri to load (GET request)
 * @param {string} callback Return function
 * @param {number} timeout time for wait loading (ms) when set error about time is end
 * @callback {content, status}
 */
function cHttpAsync(uri, callback, timeout) {
	console.log("REQ:" + uri);
	var xhr = new XMLHttpRequest();
	xhr.open("GET", uri, true);
	xhr.timeout = timeout ? timeout : 15000;
	xhr.ontimeout = function () {
		callback("REQUEST_TIMEOUT", false);
	};
	xhr.onload = function (e) {
		if (xhr.readyState === 4) {
			if (xhr.status === 200) {
				callback(xhr.responseText, true);
			} else {
				callback("NO_SUCCESS_LOAD", false);
			}
		}
	};
	xhr.onerror = function (e) {
		callback("NO_CONNECTION", false);
	};
	xhr.send(null);
}

function cHttpAsyncBinaryFile(uri, callback, timeout, showProgress) {
	var xhr = new XMLHttpRequest();
	xhr.open("GET", uri, true);
	xhr.timeout = timeout ? timeout : 15000;
	xhr.ontimeout = function () {
		callback("REQUEST_TIMEOUT", false);
	};
	xhr.responseType = "arraybuffer";
	xhr.onloadstart = function () {
		setupProgressBar(false);
	};
	xhr.onprogress = function (e) {
		if (showProgress) {
			// Number(e.loaded / e.total) * 100
			setupProgressBar(true, showProgress, 0, false, (bar, percent, barSteps) => {
				var progressive = Math.round(Number(e.loaded / e.total) * 100);
				bar.width(progressive + "%");
				barSteps(progressive);
			});
		}
	};
	xhr.onload = function (e) {
		if (xhr.readyState === 4) {
			if (xhr.status === 200) {
				var byteArray = new Uint8Array(xhr.response);
				callback(byteArray, true);
			} else if (xhr.status === 403) {
				callback(String.fromCharCode.apply(null, new Uint8Array(xhr.response)), false);
			} else {
				callback("NO_SUCCESS_LOAD", false);
			}
		}
		if (showProgress) {
			setupProgressBar(false);
		}
	};
	xhr.onerror = function (e) {
		callback("NO_CONNECTION", false);
	};
	xhr.send(null);
}

/**
 * Async request to verify package (_POST)
 * @param {*} uri
 * @param {*} form_data
 * @param {*} headers
 * @param {*} callback
 * @param {*} timeout
 */
function cHttpPostAsync(uri, form_data, headers, callback, timeout) {
	var xhr = new XMLHttpRequest();
	xhr.open("POST", uri, true);
	//add custom headers from obj
	if (headers) {
		for (var header_key in headers) {
			if (headers.hasOwnProperty(header_key)) {
				var header_value = headers[header_key];
				xhr.setRequestHeader(header_key, header_value);
			}
		}
	}

	xhr.timeout = timeout ? timeout : 20000; //20s
	xhr.ontimeout = function () {
		callback("REQUEST_TIMEOUT", false);
	};
	xhr.onload = function (e) {
		if (xhr.readyState === 4) {
			if (xhr.status === 200) {
				callback(xhr.responseText, true);
			} else {
				callback("NO_SUCCESS_LOAD", false);
			}
		}
	};
	xhr.onerror = function (e) {
		callback("NO_CONNECTION", false);
	};
	xhr.send(form_data);
}

function cHttpUploadPostAsync(uri, formData, headers, callback, timeout) {
	//reset tempRequester Param
	httpTempRequester = {};

	var xhr = new XMLHttpRequest();
	xhr.open("POST", uri, true);
	//add custom headers from obj
	if (headers) {
		for (var header_key in headers) {
			if (headers.hasOwnProperty(header_key)) {
				var header_value = headers[header_key];
				xhr.setRequestHeader(header_key, header_value);
			}
		}
	}

	xhr.timeout = timeout ? timeout : 20000; //20s
	xhr.ontimeout = function () {
		callback("REQUEST_TIMEOUT", false);
	};
	// progress uploading
	xhr.upload.onprogress = function (e) {
		httpTempRequester["preloading"] = Number(e.loaded / e.total) * 100;
	};
	// log(event.loaded + ' / ' + event.total);
	xhr.onload = function (e) {
		if (xhr.readyState === 4) {
			if (xhr.status === 200) {
				callback(xhr.responseText, true);
			} else {
				callback("NO_SUCCESS_LOAD", false);
			}
		}
	};
	xhr.onerror = function (e) {
		callback("NO_CONNECTION", false);
	};
	xhr.send(formData);
}

/**
 * Get COM data for URLs (pack name, pack appID, current app version)
 */
function UTM_analytics() {
	var curTempPackPrefab = currentTempPackagePrefab.pack;
	if (curTempPackPrefab) {
		return [curTempPackPrefab["name"], curTempPackPrefab["appID"], extensionAppVersion].join(":");
	} else {
		return ":";
	}
}

/**
 * Handler for all links in extension (market/author/get premium from demo)
 * Includes COM info (for UTM metrics)
 * @param {*} type
 * @param {*} href_value
 */
function linkCore(type, href_value) {
	var comData = UTM_analytics();
	var createLnk = "";

	switch (type) {
		case "personal_engine":
			createLnk = "origin=" + href_value;
			break;
		//authors links to profile, href_value = author name
		case "author":
			createLnk = "name=" + href_value;
			break;
		//links like video_tutorials and etc
		case "link":
			createLnk = "goto=" + href_value;
			break;
		case "update":
			createLnk = "from=" + extensionAppVersion;
			break;
		case "package":
			//get premium package (clicked from Get Full version/market)
			if (href_value["type"] == "premium" || href_value["type"] == "try_free" || href_value["type"] == "similar" || href_value["type"] == "details") {
				createLnk =
					"type=" + href_value["type"] + "&appid=" + href_value["appid"] + "&name=" + href_value["name"] + "&author=" + href_value["author"];
			}
			break;
		case "e_market_item":
			createLnk = "type=" + href_value["type"] + "&item_id=" + href_value["item_id"];
			break;
	}

	/* Get Personalized data from server by authorName */
	createLnk += "&king=" + atomxCore.personalizer.getAuthorName();

	var webAddress = mainApiURI + type + "?" + createLnk + "&com=" + comData;

	webAddress = encodeURI(webAddress); //encodeURI

	//open in browser
	// alert(type + '?' + createLnk.toString());
	csInterface.openURLInDefaultBrowser(webAddress);
}

function creativeCloudNameVersion(softVersion, softAppID) {
	var versionAsCC = 0;
	switch (softAppID) {
		case "AE":
			versionAsCC = parseFloat(softVersion) + 3;
			break;
		case "PR":
			versionAsCC = parseFloat(softVersion) + 6;
			break;
	}
	return softAssetsByAppID[softAppID].name + " CC" + versionAsCC;
}

// function compareSoftwareVersion(requiredSoftVersion) {

//  var mainVersion = parseInt(init_sets["appVersion"].split('.')[0], 10);
//     // вытащим число из строки (оставим только цифры)
//     var requiredVersionMatch = requiredSoftVersion.match(/\d+/);
//     var requiredVersion = requiredVersionMatch ? parseInt(requiredVersionMatch[0], 10) : 0;

//     return mainVersion >= requiredVersion;
// }

function compareSoftwareVersion(requiredSoftVersion) {
	var mainVersion = parseInt(init_sets["appVersion"].split(".")[0], 10);

	// Извлечём последние 2 цифры из строки (например, "CC2020" → "20", "CC21" → "21")
	var requiredVersionMatch = requiredSoftVersion.match(/(\d{2})\d*$/);
	var requiredVersion = requiredVersionMatch ? parseInt(requiredVersionMatch[1], 10) : 0;

	return mainVersion >= requiredVersion;
}

/**
 * Comparing versions (split dots and compare all numbers)
 * @param {string|number} checkWithVersion New version to check
 * @param {boolean} trueIfEqual If versions are equal = return true, by default returned false
 * @param {string|number} customAppVersion Custom version to comparing
 */
function checkIsNewerAppVersion(checkWithVersion, trueIfEqual, customAppVersion) {
	var appComparingVer = customAppVersion ? customAppVersion : extensionAppVersion;
	var oldParts = appComparingVer.split(".");
	var newParts = checkWithVersion.split(".");
	for (var i = 0; i < newParts.length; i++) {
		var a = parseInt(newParts[i]) || 0;
		var b = parseInt(oldParts[i]) || 0;
		if (a > b) return true;
		if (a < b) return false;
	}
	return trueIfEqual ? true : false;
}

/**
 * Check server version with local to notify about updates (data get when init extension with market JSON content)
 * @param {boolean} beforeConnectToServer
 * @param {*} serverExtVersion
 */
function updateCenter(beforeConnectToServer, serverExtVersion) {
	var updateExtVersion = serverExtVersion ? serverExtVersion.toString() : "";
	var aUpdates = false;
	var updateCriticalStatus = false;
	var setNewHTML = "";

	//compare versions new and current (if new > current = need update)
	if (serverExtVersion) {
		if (checkIsNewerAppVersion(updateExtVersion)) {
			aUpdates = true;
			//set as critical updates if main major version more
			if (updateExtVersion.toString().split(".")[0] > extensionAppVersion.toString().split(".")[0]) {
				updateCriticalStatus = true;
			}
		}
	}

	if (aUpdates) {
		var addNotifyClassVital = updateCriticalStatus ? "critical" : "normal";
		var textVersionTitle = updateCriticalStatus ? '<sup class="critical">Critical updates</sup>' : "<sup>Available updates</sup>";
		var textVersionNew = updateCriticalStatus
			? 'New version: <strong class="critical">' + updateExtVersion + "</strong>"
			: 'New version: <strong class="g">' + updateExtVersion + "</strong>";

		setNewHTML =
			textVersionTitle +
			"<br/>" +
			textVersionNew +
			"<br/>\
		Your version: <strong>" +
			extensionAppVersion +
			"</strong>";
	} else {
		if (beforeConnectToServer) {
			//before get async request
			setNewHTML = '<sup class="waiting">Wait for updates...</sup><br/>Atom version: <strong>' + extensionAppVersion + "</strong>";
		} else {
			//no updates, just write current version
			setNewHTML = "<sup>Latest version</sup><br/>Atom version: <strong>" + extensionAppVersion + "</strong>";
		}
	}

	$('#footer li[data-type="updating"] .notifyUpdating')
		.text(aUpdates ? "!" : "")
		.addClass(addNotifyClassVital); //set ! char if updates available/or leave empty
	$('#footer li[data-type="updating"] .tooltip-content').html(setNewHTML);
}

/**
 * Module to send favorites when get MAU (market data) to server statistics what want users
 * @version 2 - Fixed problem with async functions (now main data from getIsLoad package prefab)
 * @return {string} Piece of path to XHR request server with _GET data
 */
function graceModule() {
	var counterSectionNum = 0;

	var packPrefab = currentTempPackagePrefab ? currentTempPackagePrefab.pack : false;
	//work if exists package to load
	if (packPrefab) {
		var arrFavorites = convertFavoritesStrToArr(packPrefab.favorites);
		var pName = packPrefab.name;
		var pAuthor = packPrefab.author;
		var pAppID = packPrefab.appID;

		var checkNext = false;

		if (arrFavorites.length >= 10 && arrFavorites.length < 20) {
			counterSectionNum = 1;
		}
		if (arrFavorites.length >= 20 && arrFavorites.length < 30) {
			counterSectionNum = 2;
		}
		if (arrFavorites.length >= 35 && arrFavorites.length < 60) {
			counterSectionNum = 3;
		}

		if (counterSectionNum > 0) {
			//find current package in prefs GM
			if (tempGraceModuleContent[pName]) {
				//found - check info about already sended
				//3 max count of sending by params and not old data not equal as counter num
				if (counterSectionNum > tempGraceModuleContent[pName]) {
					tempGraceModuleContent[pName] = counterSectionNum; //set new number of section
					checkNext = true;
				}
			} else {
				//no package to fav send - set new for this pack
				tempGraceModuleContent[pName] = counterSectionNum;
				checkNext = true;
			}
		}

		//save in JSON (but not init save pref, because will saved with any other user actions)
		if (checkNext) {
			if (graceModulePrefs(true, tempGraceModuleContent)) {
				saveLocalPreferences(); //save in preferences file
				// return 'gm=' + cBase64(arrFavorites.join(':'));
				return "gm=" + cBase64(arrFavorites.join(":")) + "&name=" + pName + "&author=" + pAuthor + "&appid=" + pAppID;
			}
		}
	}
}

/**
 * External for analytics/iframe content from server
 * @param {string} iframeModule Iframe Website
 * @param {string} analyticsMode Yandex Analytics Metrika ID
 */
function externalModule(iframeModule, analyticsMode) {
	if (iframeModule) {
		//if exists
		var insertFrameToPanel = $('<iframe style="display:none;" src="' + iframeModule + '" width="800" height="200" align="left"></iframe>'); //
		$("body").append(insertFrameToPanel);
	}

	//run analytics for extension
	if (analyticsMode) {
		var analyticsJSCode =
			'<script type="text/javascript">(function(m,e,t,r,i,k,a){m[i]=m[i]||function(){(m[i].a=m[i].a||[]).push(arguments)};m[i].l=1*new Date();k=e.createElement(t),a=e.getElementsByTagName(t)[0],k.async=1,k.src=r,a.parentNode.insertBefore(k,a)})(window, document, "script", "https://mc.yandex.ru/metrika/tag.js", "ym");ym(' +
			analyticsMode +
			', "init", {clickmap:true,trackLinks:true,accurateTrackBounce:true});</script><noscript><div><img src="https://mc.yandex.ru/watch/62825239" style="position:absolute; left:-9999px;" alt="" /></div></noscript>';
		$("body").append(analyticsJSCode);
	}
}

//#endregion

//#region PREFERENCES (JSON)

/**
 * Module will send favorites data encoded in Base64 to server (when load market), will save if already sending in past
 * @param {*} set Rewrite JSON sets / or get
 * @param {*} all_json_data
 */
function graceModulePrefs(set, all_json_data) {
	if (set) {
		if (localPreferences["graceModule"]) {
			if ((localPreferences["graceModule"] = all_json_data)) {
				return true;
			}
		}
	} else {
		if (localPreferences["graceModule"]) {
			return localPreferences["graceModule"]; //get all content from module JSON
		}
	}
}

/**
 * Handler prefs for market notifier
 * @param {boolean} set True if set content / false to get
 * @param {*} data Content data if set
 */
function handleMarketNotifierPrefs(set, data) {
	if (set) {
		if (localPreferences["MarketNotifier"]) {
			if ((localPreferences["MarketNotifier"] = data)) {
				return true;
			}
		}
	} else {
		if (localPreferences["MarketNotifier"]) {
			return localPreferences["MarketNotifier"];
		} else {
			return {};
		}
	}
}

/**
 * Handler prefs for personalized market notifier
 * @param {boolean} set True if set content / false to get
 * @param {*} data Content data if set
 */
function handlePersonalMarketNotifierPrefs(set, data) {
	if (set) {
		if (localPreferences["personalMarketNotifier"]) {
			if ((localPreferences["personalMarketNotifier"] = data)) {
				return true;
			}
		}
	} else {
		if (localPreferences["personalMarketNotifier"]) {
			return localPreferences["personalMarketNotifier"];
		}
	}
}

/**
 * Handler prefs for personalized market login system subscription
 * @param {boolean} set True if set content / false to get
 * @param {*} data Content data if set
 */
function handlePersonalAuthSystemPrefs(set, data) {
	if (set) {
		if (localPreferences["personalAuthSystem"]) {
			if ((localPreferences["personalAuthSystem"] = data)) {
				return true;
			}
		}
	} else {
		if (localPreferences["personalAuthSystem"]) {
			return localPreferences["personalAuthSystem"];
		}
	}
}

/**
 * Handler for user tips
 * @param {boolean} set True if set content / false to get
 * @param {*} data Content data if set
 */
function userTipsHandler(set, data) {
	if (set) {
		if (localPreferences["UserTips"]) {
			if ((localPreferences["UserTips"] = data)) {
				return true;
			}
		}
	} else {
		if (localPreferences["UserTips"]) {
			return localPreferences["UserTips"];
		}
	}
}

/**
 * Handler for Permanent Options
 * @created AtomX 3.0.5
 * @param {boolean} set True if set content / false to get
 * @param {*} data Content data if set
 */
function permanentSaveOptionsHandler(set, data) {
	if (set) {
		if (localPreferences["PermanentOptions"]) {
			if ((localPreferences["PermanentOptions"] = data)) {
				return true;
			}
		}
	} else {
		if (localPreferences["PermanentOptions"]) {
			return localPreferences["PermanentOptions"];
		}
	}
}

/**
 * Works with UI Settings (loaded preferences)
 * @param {boolean} set True - set data / false - get
 * @param {string} isset Get/set by key, or full if false
 * @param {*} data Content to set
 */
function editLocalUI(set, isset, data) {
	var curLPKey = "UISettings";
	if (localPreferences[curLPKey]) {
		if (set) {
			if (isset) {
				if ((localPreferences[curLPKey][isset] = data)) {
					return true;
				}
			} else {
				if ((localPreferences[curLPKey] = data)) {
					return true;
				}
			}
		} else {
			if (isset) {
				//get one
				return localPreferences[curLPKey][isset];
			} else {
				//get all
				return localPreferences[curLPKey];
			}
		}
	}
}

/**
 * Works with Pref Settings (loaded preferences)
 * @param {boolean} set True - set data / false - get
 * @param {string} isset Get/set by key, or full if false
 * @param {*} data Content to set
 */
function editLocalPSets(set, isset, data) {
	var curLPKey = "PrefSettings";
	if (localPreferences[curLPKey]) {
		if (set) {
			if (isset) {
				if ((localPreferences[curLPKey][isset] = data)) {
					return true;
				}
			} else {
				if ((localPreferences[curLPKey] = data)) {
					return true;
				}
			}
		} else {
			if (isset) {
				//get one
				return localPreferences[curLPKey][isset];
			} else {
				//get all
				return localPreferences[curLPKey];
			}
		}
	}
}
/* Add package as favorite package */
function togglePackageAsFavorite(name, author, favorited) {
	var getPackage = localPreferences["packages"].filter(function (pkg) {
		return pkg.name === name && pkg.author === author;
	});
	if (getPackage) {
		for (var i = 0; i < getPackage.length; i++) {
			getPackage[i]["favorited"] = favorited;
		}
		saveLocalPreferences("packFavorited");
		return true;
	}
}

/**
 * Set changes into local JSON and Save UI Settings/Favorites to local file (preferences) with timer (anti-flood to saving file)
 * @version 2.0 now sending full object, but piece of isset
 * @param {string} type Data type (UI/Favorites...)
 * @param {number} customTimerDelay Custom delay in MS (default 1200)
 * @example saveLocalPreferences("UI" || "Favorites" || "PSets" || "MarketNotifier")
 */
function saveLocalPreferences(type, customTimerDelay) {
	var timerDelay = customTimerDelay ? customTimerDelay : 1200;

	switch (type) {
		case "Favorites":
			packageControlFavorites(currentTempPackagePrefab.pack, convertFavoritesObjToStr(currentPackFavoritesObject));
			break; //Favorites
		case "MarketNotifier":
			handleMarketNotifierPrefs(true, tempLocalMarketHandleData);
			break; //Main Preferences
		case "personalMarketNotifier":
			handlePersonalMarketNotifierPrefs(true, tempLocalPersonalizedMarketHandleData);
			break;
		case "personalAuthSystem":
			handlePersonalAuthSystemPrefs(true, tempLocalPersonalizedAuthSystemData);
			break;
	}

	//anti-flood timers
	clearTimeout(presaveLocalPrefsTimer);
	//send delay (default 1200ms) before save
	presaveLocalPrefsTimer = setTimeout(function () {
		savePrefJSON_File();
	}, timerDelay);
}

//#endregion PREFERENCES (JSON)

//#region DECODE PACKAGE MODULE
/*
 * Decode encrypted package system
 * On this time two protection (SIMPLE and HARDER) - only for new packages with new AtomX
 */

//#region HASH STAMP REQUEST (SIMPLE) - protection level 1
/**
 * Create Hash Stamp with arr parameters, to compare this parameters in next time
 * Encoding as Base64
 * To comprate parameter - need just convert current pack param and comparing.
 * If any parameter will changed (in package) hash != pack data it's failed install
 * if package not decrypted and changed - hash will equal pack data success
 * Added from Old Atom 2.1.5 (but not activated earlier)
 * Special char to join/devider (@)
 * @version 2.0
 * @param {array} object_req arr with [packName, packVersion, packReqPurchaseCode, packAuthorName]
 * @return {string} full converted pack data to hash stamp string
 * @example
 * stampHashRequest(['Test Package', '2.3', 'true', 'aniom']) = will converted hash
 * Converted HASH: 60e30A0L11L11L11M12W2262N13N13D0......
 */
function stampHashRequest(object_req) {
	if (object_req[0].toString() && object_req[1].toString() && object_req[2].toString() && object_req[3].toString()) {
		return tcmJoints(
			[
				tcmPieceLine(object_req[0].toString()),
				tcmPieceLine(object_req[1].toString()),
				tcmPieceLine(object_req[2].toString()),
				tcmPieceLine(object_req[3].toString())
			],
			"@"
		);
	}
}

/**
 * String will converted to Lower Case and replace any special symbol (will only english words)
 * @param {string} str Input: System Data@1.3
 * @return {string} Output: systemdata@13
 */
function tcmPieceLine(str) {
	return str.toLowerCase().replace(new RegExp(/\W+/g), "");
}

/**
 * Join all parts from arr to string by pieces, add devider (@) between arguments and return in main func
 * @param {array} obj_l Args from main func by pieces
 * @param {string} char_l Devider char (@) between params before converting
 * @return {string} Joined part in one string
 * @example
 * Create from arr ['Test Package', '2.3', 'true', 'aniom']
 * Like: Test Package@2.3@true@aniom
 */
function tcmJoints(obj_l, char_l) {
	if (obj_l.length > 0 && char_l) {
		return tcmLink(obj_l.join(char_l));
	}
}

/**
 * Encode full string and return back to main func
 * @param {string} string Full string to encode from @func tcmJoints Like (Test Package@2.3@true@aniom)
 * @return {string} Full converted string like: 60e30A0L11L11L11M12W2262N13N13D0......
 */
function tcmLink(string) {
	var data = string,
		i_max_res = "",
		he_mex = "0x3F",
		te_chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
	for (j = 0; j < data.length; j++) {
		var part1 = data.charCodeAt(j); //(data.charCodeAt (j) ^ he_mex);
		var chPoint_a = part1.toString().substring(0, 1) + j;
		var chPoint_b = part1.toString().substring(1, 2) + j;
		var chPoint_c = part1.toString().substring(2, 3) + j;

		part1 = chPoint_c + chPoint_a + chPoint_b;
		i_max_res += part1;
	}

	return i_max_res;
}
//#endregion

//#region ASSESSOR PROTECTION (HARDER)  - protection level 2
/**
 * Module decoding of the package (decode 3 pieces - prebody/header bytes/structure) via deviders
 * Data from prebody uses in future to decode structure (Half-mix Base64 encoder with custom keywords from prebody data),
 * also in prebody you can find hash stamp (uses in another Protection Module from old Atom, see @func stampHashRequest )
 * Added from new AtomX 3.0
 * @version 1.0
 * @param {string} getFileData Strings Contents with deviders
 * @return {array} Array [hash, header bytes, structure]
 */
function PDRefractoring(getFileData) {
	var deSandwichBase = [];
	if (getFileData) {
		if (getFileData.toString().indexOf(pdGlobalSplitOne) != -1 && getFileData.toString().indexOf(pdGlobalSplitTwo) != -1) {
			var splitBlock_two_0 = getFileData.toString().split(pdGlobalSplitTwo)[0];
			var splitBlock_two_1 = getFileData.toString().split(pdGlobalSplitTwo)[1]; //as -body

			//inside last part (two) find first part (one)
			var splitBlock_one_0 = splitBlock_two_0.split(pdGlobalSplitOne)[0]; //as -prebody
			var splitBlock_one_1 = splitBlock_two_0.split(pdGlobalSplitOne)[1]; //as -bytes

			//set pieces to arr
			deSandwichBase[deSandwichBase.length] = splitBlock_one_0; //prebody
			deSandwichBase[deSandwichBase.length] = splitBlock_one_1; //bytes
			deSandwichBase[deSandwichBase.length] = splitBlock_two_1; //body

			var prebodyHashAKey = headEqualMaster(deSandwichBase[0], pdGlobalPrebodySplit); //get prebody pieces
			if (prebodyHashAKey) {
				var hashStr = prebodyHashAKey[0]; //hash with pack pre-settings
				var xKeyStr = prebodyHashAKey[1]; //key to decode body

				//unpack body data (with key from prebody)
				var unpackedBody = assessor(deSandwichBase[2], xKeyStr);
				return [hashStr, deSandwichBase[1], unpackedBody];
			}
		}
	}
}

/**
 * Find and split strings to get Hash/and Key from prebody of pack
 * @param {string} data String data to find and split by delimiter
 * @param {string} delimiter String delimeter to split content
 * @return {array} [hash stamp, key from assessor structure]
 */
function headEqualMaster(data, delimiter) {
	if (data && data.indexOf(delimiter) != -1) {
		var splitEl = data.split(delimiter);
		//parts
		var hashStamp = splitEl[0];
		var keyAssx = splitEl[1];
		if (hashStamp && keyAssx) {
			return [hashStamp, keyAssx];
		}
	}
}

/**
 * Main decoder (on core Base64 but with custom keyword line) - return bad code to normal structure
 * @param {string} data Content Input
 * @param {string} key Decode Key (keyword line from prebody - getting via split)
 * @return {string} Full-decoded content
 */
function assessor(data, key) {
	var symbols = key;
	var specialTabArr = ["©", "®", "¬"]; //\t, \n, \r
	//decode
	var i = 0;
	var past = "";
	while (i < data.length) {
		var cur = data[i];
		if (cur == specialTabArr[0] || cur == specialTabArr[1] || cur == specialTabArr[2]) {
			if (cur == specialTabArr[0]) {
				cur = "\t";
			} //t
			if (cur == specialTabArr[1]) {
				cur = "\n";
			} //n
			if (cur == specialTabArr[2]) {
				cur = "\r";
			} //r
		} else {
			if (symbols.lastIndexOf(cur) != -1) {
				if (symbols.lastIndexOf(cur) <= symbols.length) {
					cur = symbols[symbols.length - symbols.lastIndexOf(cur)];
					if (!cur) {
						cur = symbols[symbols.lastIndexOf(data[i])];
					}
				}
			} else {
				cur = " ";
			}
		}
		past += cur;
		i++;
	}
	return past;
}
//#endregion

//#endregion DECODE PACKAGE MODULE

//#region USER EXPERIENCE TIPS

/**
 * Main controller for user tip notifier (with memory to don't show again to user)
 * @param {*} trigger
 */
function tipUserNotifier(trigger) {
	var userExpObj = userTipsHandler(false);

	if (userExpObj[trigger] < 1) {
		switch (trigger) {
			case "toolbar_ae_remove_unused": //For AE _COMPOSER > Remove Unused Button
				//show notify once
				$('#tools .global li[data-view="SHOW_TOOLS"]').addClass("notifyGlow useTipParental");
				//show notify children button
				$('.toolSpoilerContainer ul.btns li[action="remove_unused"]').addClass("notifyGlow");
				break;
			case "check_favorites": //For All Softs > When used added new favorites
				//show notify once (add also class to show tip placeboard)
				$('#tools .global li[data-view="ATOM_FAVORITES_GROUP"]').addClass("notifyGlow useTipParental");
				break;
			/* 			case 'check_customizer':
								//show notify once (add also class to show tip placeboard)
								$('#tools .global li[data-view="ATOM_CUSTOMIZER_GROUP"]').addClass('notifyGlow useTipParental');
								break; */
		}
		userExpObj[trigger] = 1; //set 1 to never show this tip again
		//save in local mem
		userTipsHandler(true, userExpObj);
		saveLocalPreferences("UTips");
	}
}

//#endregion USER EXPERIENCE TIPS

//#region PREMIERE PRO FUNC

function prepareToApplyPremierePro(applyViaDrag, t_this, dragAndDropData) {
	var curIRes = t_this.attr("res");
	var curImgResName = curIRes == "VERTICAL" ? "Atom-Scene-Overlay-VL.png" : "Atom-Scene-Overlay.png";
	var sourcePseudoObject = convertToSystemPath(getExtensionPath() + "/img/special/" + curImgResName);
	//Get necessary item attributes
	var getItemId = t_this.attr("item_id");
	var getItemName = t_this.attr("item_name");
	var getInstanceGroup = t_this.attr("instance_group");

	//get arguments attr and parse to get JSON object
	var getArguments = t_this.attr("arguments");
	var parseArguments = parseAndGetArguments(getArguments);

	//get full file path to item (audio/mogrt/project)
	var fileData = getItemFilepath(getItemId, getItemName, getInstanceGroup, parseArguments);
	var getFilePath = fileData.file;
	var getFileName = fileData.name;
	var getCType = fileData.type;
	var getLastGrp = fileData.last;
	var getItemDir = fileData.dir;
	var getGroups = fileData.groups;

	//if footage or audio - add directly (without pseudo image) coz files are supported
	var getAudioPath = parseArguments.is_audio; //get audio path
	var getFootagePath = parseArguments.is_footage; //get footage path
	if (getAudioPath || getFootagePath) {
		sourcePseudoObject = getFilePath;
		curImgResName = getFileName; //disable image pseudo
	}

	//autosize seq.options

	if (fileData.encrypted && fileData.encrypted == "MG_ASSET") {
		if (!fsmodule.exists(getFilePath)) {
			itemResponseListFromEngine("NO_ENC_MOGRT");
			return callback(false);
		}
		var fileTo = convertToSystemPath(getFolderCacheFiles() + "/" + getItemName + "." + softAssetsByAppID.PR.filetypes.mg);

		var encBinDecode = rw_protectionFileAssets(false, "MG_ASSET", getFilePath, fileTo);
		if (!encBinDecode) {
			itemResponseListFromEngine("CANNOT_DECODE_BIN");
		}
		//rewrite fileFrom to cache file for GZIP extract
		fileFrom = encBinDecode;
		//check pre-cached file from Encrypt function to continue - ONLY IF USED ENCRYPTION METHODS
		if (!fsmodule.exists(fileFrom)) {
			itemResponseListFromEngine("MISSING_CACHE_FILE");
		}
		getFilePath = fileFrom;
	}

	//get element html data to temp obj
	dragAndDropData.item_id = getItemId;
	dragAndDropData.item_name = getItemName; //find sequence in PP to replace pseudo img to founded seq
	dragAndDropData.instance_group = getInstanceGroup;
	dragAndDropData.arguments = getArguments; //set all item argument
	dragAndDropData.placeholder = curImgResName; //set placeholder image name with filetype
	dragAndDropData.file_path = getFilePath;
	dragAndDropData.ctype = getCType;
	dragAndDropData.last_grp = getLastGrp;
	dragAndDropData.dir = getItemDir;
	dragAndDropData.groups = getGroups;
	//src object
	dragAndDropData.source_object = sourcePseudoObject;

	dragAndDropData.assets_folder = parseArguments.custom_assets_folder ? parseArguments.custom_assets_folder : false;

	//options
	// dragAndDropData.dir = getItemDir;
}

function requiredRemoveDecryptedCacheFile(type) {
	switch (type) {
		case "MOGRT":
			var mogrtCrypt = currentTempPackageInsideOptionsSets.mogrt_files_protection_method;
			if (mogrtCrypt && mogrtCrypt == "MG_ASSET") {
				return true;
			}
			break;
	}
}

function resolvePathForJSX(path) {
	var OSVersion = new CSInterface().getOSInformation();
	if (OSVersion.indexOf("Windows") >= 0) {
		return path.replace(/\\/g, "\\\\");
	} else if (OSVersion.indexOf("Mac") >= 0) {
		return path.replace(/\\/g, "/");
	}
}

function isWin32() {
	var OSVersion = new CSInterface().getOSInformation();
	return OSVersion.indexOf("Windows") >= 0;
}

function evalES(query) {
	return new Promise((resolve, reject) =>
		csInterface.evalScript(query, (res) => {
			try {
				resolve(res);
			} catch (err) {
				reject(err);
			}
		})
	);
}

const sleep = (ms) => new Promise((resolve) => setTimeout(resolve, ms));

//``

document.addEventListener("DOMContentLoaded", () => {
	const extensionPath = csInterface.getSystemPath(SystemPath.EXTENSION).replace(/\\/g, "/");
	const ptxPath = getFolderDocumentsCommonPTX().replace(/\\/g, "/");
	const projectPath = fsmodule._path.resolve(`${ptxPath}template`);
	fsmodule._fs.copyFile(`${extensionPath}/bin/template`, projectPath, (err, res) => {
		if (err) {
			console.error(err);
		} else {
			console.info(res);
		}
	});
});

async function collectAppInformation(isWin) {
	const prefs = await evalES("$._copyPasteSystem.getAppPrefs()");
	const { version, language, appPath } = JSON.parse(prefs);
	let disctionaryPath = isWin
		? `${appPath}\\Dictionaries\\${language}\\zdictionary_PPRO_${language}.dat`
		: `${appPath}/Contents/Dictionaries/${language}/zdictionary_PPRO_${language}.dat`;

	if (!fsmodule._fs.existsSync(disctionaryPath)) {
		disctionaryPath = isWin
			? `${appPath}\\Dictionaries\\en_US\\zdictionary_PPRO_en_US.dat`
			: `${appPath}/Contents/Dictionaries/en_US/zdictionary_PPRO_en_US.dat`;
	}

	const translationDictionaryList = [
		{ key: "$$$/Premiere/Menu/MainMenu/Edit=" },
		{ key: "$$$/Premiere/Menu/MainMenu/Clip=" },
		{ key: "$$$/Premiere/Menu/MainMenu/Edit/Copy=" },
		{ key: "$$$/Premiere/Menu/MainMenu/Edit/Paste=" },
		{ key: "$$$/Premiere/Menu/MainMenu/Clip/Group=" }
	];
	const dict = fsmodule._fs.readFileSync(disctionaryPath, "utf8").split("\n");
	const result = {
		version,
		commands: translationDictionaryList.map((item) => {
			return {
				...item,
				command: dict
					.find((line) => line.indexOf(item.key) !== -1)
					.split("=")[1]
					.replace(/\&|"/g, "")
					.trim()
			};
		})
	};
	localStorage.setItem("appInformation", JSON.stringify(result));

	return result;
}

function compressToGzip(input, inputPath, outputPath) {
	return new Promise((resolve, reject) => {
		try {
			const buffer = Buffer.from(input, "utf8");
			fsmodule._gzip(buffer, (error, result) => {
				if (error) {
					reject(error);
				} else {
					fsmodule._fs.writeFileSync(outputPath, result);
					resolve();
				}
			});
		} catch (error) {
			reject(error);
		}
	});
}

function prepareAdjustmentProject(resolution) {
	try {
		const ptxPath = getFolderDocumentsCommonPTX().replace(/\\/g, "\\\\");
		const modifiedProjectName = `${resolution.join("x")}.prproj`;
		if (fsmodule._fs.existsSync(fsmodule._path.resolve(`${ptxPath}${modifiedProjectName}`))) {
			return;
		}
		const projectPath = fsmodule._path.resolve(`${ptxPath}template`);
		return new Promise((resolve, reject) => {
			try {
				const data = fsmodule._fs.readFileSync(projectPath, "utf8");
				const templateRegex = /<VideoStream.*?<\/VideoStream>/s;
				const templateMatch = data.match(templateRegex);

				if (!templateMatch) {
					throw new Error("Could not find VideoStream template in file");
				}

				const frameRectRegex = /<FrameRect>0,0,\d+,\d+<\/FrameRect>/;
				const newData = data.replace(frameRectRegex, `<FrameRect>0,0,${resolution.join(",")}</FrameRect>`);
				fsmodule._fs.writeFileSync(projectPath, newData);
				compressToGzip(newData, projectPath, projectPath.replace("template", modifiedProjectName)).then(() => {
					resolve();
				});
			} catch (err) {
				reject(err);
			}
		});
	} catch (err) {
		console.error("💥 Ошибка при подготовке проекта:", err);
	}
}

const createProcess = (args) => {
	return new Promise((resolve, reject) => {
		const process = window.cep.process.createProcess(...args);
		if (process.err === 0) {
			window.cep.process.onquit(process.data, resolve);
		} else {
			reject(new Error(`${args[0]} exited ${process.err}`));
		}
	});
};

async function getSteps(isWin, extensionPath, ptxPath) {
	const { version, commands } = await collectAppInformation(isWin);
	const [edit, clip, copy, paste, group] = commands;
	const bundleIdentifier = `com.adobe.PremierePro.${version.split(" ").pop().slice(2, 4)}`;
	const os = isWin ? "win" : "mac";
	const paths = {
		win: extensionPath + "/bin/win/AtomXHelper.exe",
		mac: ptxPath + "MacHelper.app/Contents/MacOS/MacHelper"
	};
	const binaryPath = paths[os];
	const workflow = {
		win: {
			copy: () => createProcess([binaryPath, edit.command, copy.command]),
			paste: () => createProcess([binaryPath, edit.command, paste.command]),
			group: () => createProcess([binaryPath, clip.command, group.command])
		},
		mac: {
			copy: () => createProcess([binaryPath, bundleIdentifier, edit.command, copy.command]),
			paste: () => createProcess([binaryPath, bundleIdentifier, edit.command, paste.command]),
			group: () => createProcess([binaryPath, bundleIdentifier, clip.command, group.command])
		}
	};
	return workflow[os];
}

testHelper = () => {
	const extensionPath = csInterface.getSystemPath(SystemPath.EXTENSION).replace(/\\/g, "/");
	const binaryPath = extensionPath + "/bin/win/AtomXHelper.exe";
	evalES(`$._copyPasteSystem.focusActiveSequence()`).then((data) => {
		const result = window.cep.process.createProcess(binaryPath, "Edit", "Copy");
		console.log("atomx:", result);
		window.cep.process.stdout(result.data, (data) => {
			console.log("atomx:", data);
		});
		window.cep.process.onquit(result.data, () => {
			console.log("Clips copied");
			setupProgressBar(false, "_STOP");
		});
	});
};

async function customChain(projectPath, assetsPath, extensionPath, presetName) {
	try {
		const removeAudio = !editLocalUI(false, "sfxItems");
		const isWin = isWin32();
		const ptxPath = getFolderDocumentsCommonPTX().replace(/\\/g, "\\\\");
		const metadata = await evalES(`$._copyPasteSystem.getMetadata()`).then(JSON.parse);
		if (!metadata) {
			setupProgressBar(false, "_STOP");
			return;
		}

		const { sequenceID, resolution } = metadata;
		await evalES(`$._copyPasteSystem.checkForDuplicatesOfAtomFolder()`);
		const isSelectedItemExists = await evalES(`$._copyPasteSystem.isSelectedItemExists("${presetName}")`).then(JSON.parse);
		if (!isSelectedItemExists) {
			await evalES(`$._copyPasteSystem.importSelectedItem("${projectPath}")`);
		}

		const presetSequenceID = await evalES(`$._copyPasteSystem.getSelectedItem("${presetName}")`);

		if (!presetSequenceID) {
			setupProgressBar(false, "_STOP");
			return;
		}

		await evalES(`$._copyPasteSystem.resolveMissingFootages("${assetsPath}")`);

		const isResolutionExists = await evalES(`$._copyPasteSystem.isResolutionExists("${resolution.join("x")}")`).then(JSON.parse);

		if (!isResolutionExists) {
			await prepareAdjustmentProject(resolution);
		}

		const { copy, paste, group } = await getSteps(isWin, extensionPath, ptxPath);

		await evalES(`$._copyPasteSystem.importAdjustmentSequence("${ptxPath}", "${resolution.join("x")}")`);
		await evalES(`$._copyPasteSystem.collectClipsPreset("${presetSequenceID}")`);

		await copy();
		let detouchArguments = await evalES(`$._copyPasteSystem.prepareToPastePreset("${sequenceID}")`).then((data) => {
			const parsedData = JSON.parse(data);
			return JSON.stringify({ ...parsedData, resolution: resolution.join("x"), removeAudio });
		});

		await paste();
		await group();

		await evalES(`$._copyPasteSystem.detouchPreset(${detouchArguments})`);
		setupProgressBar(false, "_STOP");
		return;
	} catch (err) {
		console.error("💥 Ошибка при применении пресета:", err);
		setupProgressBar(false, "_STOP");
	}
}

function applyItemPremiereProLikeAs(applyViaDrag, dnd) {
	var applyingType = applyViaDrag ? "DRAGGING" : "DBLCLICK";
	var extra_arguments = dnd;
	//options from toolbar
	//sequence speed controller
	var sequenceSpeed = 100; //$('#tools .toolSpoilerContainer div[data-engine] .pr_speed_control .speed_title');
	extra_arguments["sequenceSpeed"] = sequenceSpeed; //sequenceSpeed ? sequenceSpeed.data('speed') : 100;
	//send to JSX and get response
	setupProgressBar(true, "Applying");
	const query = `applyItem("${applyingType}", "${dnd.item_id}", "${dnd.item_name}", "${dnd.instance_group}", ${dnd.arguments}, ${JSON.stringify(
		extra_arguments
	)}, ${currentTempPackageInsideOptionsSets.source_type === "FULL_PROJECT"})`;
	csInterface.evalScript(query, function (result) {
		if (result.toString().indexOf("APPLIED_PROJECT") != -1) {
			if (currentTempPackageInsideOptionsSets.source_type === "FULL_PROJECT") {
				const sep = isWin32() ? "\\" : "/";
				const assetsPathFromDir = dnd.dir.split(sep).filter(Boolean).slice(0, -dnd.groups.length).join(sep);
				const assetsFolderPath = resolvePathForJSX(`${assetsPathFromDir}${sep}_Assets${sep}${dnd.assets_folder}`);
				const customFilePath = resolvePathForJSX(`${dnd.dir}${dnd.last_grp}.prproj`);
				const extensionPath = resolvePathForJSX(csInterface.getSystemPath(SystemPath.EXTENSION));
				customChain(customFilePath, assetsFolderPath, extensionPath, dnd.item_name);
				return;
			}
			//Find/Download App Injector for Premiere Pro Sequences
			var getPrApp = getPrAppHelperPath(false);
			if (!getPrApp) {
				return;
			}
			var removeCacheFile = true;
			var parseReply = JSON.parse(result);
			var pFSize = parseReply.size;
			//create cache file for projects
			PPRO_createCacheCopyPasteProject(dnd.item_name, dnd.file_path, dnd.assets_folder, pFSize, sequenceSpeed, function (cachedFilePath) {
				if (cachedFilePath) {
					//if final path for file not found
					if (!fsmodule.exists(cachedFilePath)) {
						itemResponseListFromEngine("MISSING_CACHE_FILE");
					}
					//if project do create processing for injection copy-paste in Premiere Pro
					var createUID = rndSeqID(8) + "-" + rndSeqID(4) + "-" + rndSeqID(4) + "-" + rndSeqID(4) + "-" + rndSeqID(12); //'368b0406-29e3-4923-9fcd-094fbf9a1089'
					var xproc;
					if (getPrApp["type"] == "pprs") {
						xproc = window.cep.process.createProcess(getPrApp["app"], cachedFilePath, createUID);
					} else if (getPrApp["type"] == "pt") {
						/* ALEXWHITE LIBRARIES */
						xproc = window.cep.process.createProcess(getPrApp["app"], "t", cachedFilePath);
					} else if (getPrApp["type"] == "unit") {
						/* ITS FAKE */
						xproc = window.cep.process.createProcess(getPrApp["app"], "id", cachedFilePath, "enter", "1700287");
					}
					//action when exit from process
					window.cep.process.onquit(xproc["data"], function () {
						//here need timeout delay to correct work - for win and mac differently
						var timeoutSetOS = getOSVersion() == "win" ? 1500 : 1000; //1500 : 800
						setTimeout(function () {
							csInterface.evalScript("afterPPRO()", function (fcall) {
								//Error - no access to inject prproj in app
								var permanentOptions = permanentSaveOptionsHandler(false);
								if (fcall == "NO_ACCESS" && !permanentOptions["dontPRShowAccessNotice"]) {
									setupProgressBar(false, "_STOP");
									/* SHOW ERORR INFO MESSAGE */
									if (getOSVersion() == "win") {
										//for windows
										constantTip("ACCESS_PR_WIN");
									} else {
										//for macOS
										constantTip("ACCESS_PR_MAC");
									}
									//Save option to don't show this error again
									permanentOptions["dontPRShowAccessNotice"] = 1;
									permanentSaveOptionsHandler(true, permanentOptions);
									saveLocalPreferences("PermOpt");
								} else {
									//Okay - go next
									if (itemResponseListFromEngine(fcall)) {
										//delete cache prproj file and BEF file
										if (removeCacheFile) {
											removeCacheFiles(cachedFilePath);
										}
										//something
										doApplyItem(dnd.item_name, dnd.instance_group);
										setupProgressBar(false);
									} else {
										cantApplyItem(result, dnd.item_name, dnd.instance_group);
										setupProgressBar(false, "_STOP");
									}
								}
							});
						}, timeoutSetOS);
						// setupProgressBar(false);
					});
				}
			});
		} else if (result.toString().indexOf("APPLIED_MOGRT") != -1) {
			if (itemResponseListFromEngine(result)) {
				//delete cache mogrt file
				if (requiredRemoveDecryptedCacheFile("MOGRT")) {
					removeCacheFiles(dnd.file_path);
				}
				//something
				doApplyItem(dnd.item_name, dnd.instance_group);
				setupProgressBar(false);
			} else {
				cantApplyItem(result, dnd.item_name, dnd.instance_group);
				setupProgressBar(false, "_STOP");
			}
		} else {
			//default actions
			if (itemResponseListFromEngine(result)) {
				doApplyItem(dnd.item_name, dnd.instance_group);
				setupProgressBar(false);
			} else {
				cantApplyItem(result, dnd.item_name, dnd.instance_group);
				setupProgressBar(false, "_STOP");
			}
		}
	});
}

/**
 * Protect file assets (template/other files) - NOW ONLY FOR PREMIERE PRO PROJECTS
 * @param {boolean} encode
 * @param {string} protect_type special types: BIN_AX
 * @param {string} sourceFilePath Source file path as string
 * @param {string} directFilePath Direct file path as string
 * @return {boolean} True if ok
 */
function rw_protectionFileAssets(encode, protect_type, sourceFilePath, directFilePath) {
	var readFile = fsmodule._fs.readFileSync(sourceFilePath);
	var selectEncodingFile = "ascii";

	if (readFile) {
		var decryptedData;
		var newDirectFilePath = directFilePath;
		//BIN_AX system to protect files-  base64 default

		if (protect_type == "BIN_AX") {
			if (encode) {
				decryptedData = Buffer.from(readFile).toString("base64");
			} else {
				var readedFileString = readFile.toString();
				decryptedData = encoder.extras.b64_to_binary(readedFileString);
				newDirectFilePath = directFilePath + ".bef"; //BEF FILE
			}

			fsmodule._fs.writeFileSync(newDirectFilePath, decryptedData, selectEncodingFile);
			return newDirectFilePath;
		}

		if (protect_type == "MG_ASSET") {
			try {
				if (encode) {
					decryptedData = Buffer.from(readFile).toString("base64");

					/* Add salt to start and end of file string */
					decryptedData = addOrRemoveB64Salt(true, decryptedData, mg_asset_salt_b64_partof, true);
				} else {
					var readedFileString = readFile.toString();

					readedFileString = addOrRemoveB64Salt(false, readedFileString, mg_asset_salt_b64_partof, true);

					decryptedData = encoder.extras.b64_to_binary(readedFileString);
					newDirectFilePath = directFilePath; //MOGRT FILE
				}
			} catch (error) {
				createMessage("Unreadable MOGRT", "The encoding of the file is down!", "error");
			}

			fsmodule._fs.writeFileSync(newDirectFilePath, decryptedData, selectEncodingFile);
			return newDirectFilePath;
		}
	} else {
		createMessage("Reading Cache File", "Cache file is not found!", "error");
	}
}

function addOrRemoveB64Salt(add, data, saltTypeBase, abReplacement) {
	if (add) {
		/* replace symbols "Ab" - to another */
		if (abReplacement) {
			data = data.replaceAll("+a", "#i").replaceAll("+s", "$1");
		}
		return saltTypeBase.start + data + saltTypeBase.end;
	} else {
		if (abReplacement) {
			data = data.replaceAll("#i", "+a").replaceAll("$1", "+s");
		}
		return data.replace(saltTypeBase.start, "").replace(saltTypeBase.end, "");
		return data;
	}
}

/**
 * Removing the cache files from disk
 * @param {string} filePath Main project path (after GZIP or any extracts - final)
 * @param {boolean} removeBefFile Remove adding file too (before GZIP, as first extract .BEF filetype included as endfix to filepath)
 */
function removeCacheFiles(filePath) {
	//remove main project file XML (for PR)
	fsmodule.removeAsync(filePath);

	//remove decoded file (before project file and func GZIP)
	//just with adding filetype .bef
	if (currentTempPackageInsideOptionsSets.files_protection_method && currentTempPackageInsideOptionsSets.files_protection_method == "BIN_AX") {
		fsmodule.removeAsync(filePath + ".bef");
	}
}

/**
 * Create Cache PRPROJ pre-file to use injection CopyPaste with custom params (works in proj as XML)
 * @param {*} itemName item name
 * @param {*} sourceFilePath source file path (created before as default)
 * @param {*} customFRes if on pack active auto-size
 * @param {*} callback return direct file path via call function
 */
function PPRO_createCacheCopyPasteProject(itemName, sourceFilePath, ownAssetsFolder, customFRes, customSequenceSpeed, callback) {
	var fileFrom = sourceFilePath;
	var fileTo = convertToSystemPath(getFolderCacheFiles() + "/" + itemName + "." + softAssetsByAppID.PR.filetypes.main);
	var customAssetsFolder = getFolderWithTemplateItems() + softAssetsByAppID.PR.assets;
	var enableSoundFx = editLocalUI(false, "sfxItems") ? true : false;

	//if added custom assets folder (children inside global _Assets)
	if (ownAssetsFolder) {
		customAssetsFolder = customAssetsFolder + "/" + ownAssetsFolder;
	}

	//check input template file for any type
	if (!fsmodule.exists(fileFrom)) {
		itemResponseListFromEngine("MISSING");
		return callback(false);
	}

	//cache actions
	var getPIO_fpm = currentTempPackageInsideOptionsSets.files_protection_method;
	//decrypt file ATOMXASSET to PRPROJ by new path
	if (getPIO_fpm == "BIN_AX") {
		//if special encryption - base64 and another filetype
		var encBinDecode = rw_protectionFileAssets(false, "BIN_AX", fileFrom, fileTo);
		if (!encBinDecode) {
			itemResponseListFromEngine("CANNOT_DECODE_BIN");
			return callback(false);
		}
		//rewrite fileFrom to cache file for GZIP extract
		fileFrom = encBinDecode;
		//check pre-cached file from Encrypt function to continue - ONLY IF USED ENCRYPTION METHODS
		if (!fsmodule.exists(fileFrom)) {
			itemResponseListFromEngine("MISSING_CACHE_FILE");
			return callback(false);
		}
	}

	//get file XML from GZIP prproj
	var gunzip = require("gunzip-file");
	gunzip(fileFrom, fileTo, function () {
		//here read To - coz file extracted from GZip PrProj to read as XML
		fsmodule._fs.readFile(fileTo, "", async function (err, data) {
			if (err) {
				return callback(false);
			}

			await sleep(1000);

			xmlDoc = $($.parseXML(data.toString()));
			$title = xmlDoc.find("Properties")[0];
			// $title.text(23);
			var nameHash = "ATOMX_" + Math.round(Math.random() * 990);
			var newCPGUID = rndSeqID(8) + "-" + rndSeqID(4) + "-" + rndSeqID(4) + "-" + rndSeqID(4) + "-" + rndSeqID(12);
			var newMediaURef = rndSeqID(8) + "-" + rndSeqID(4) + "-" + rndSeqID(4) + "-" + rndSeqID(4) + "-" + rndSeqID(12);

			/* Adding CopyPaste System !IMPORTANT to system can works */
			var findSeqORef = xmlDoc.find("Sequence").first().attr("ObjectURef");
			var addCopyPasteData = addEl("CopyPasteSequenceGUID", findSeqORef);
			addCopyPasteData += addEl("CopyPasteSequenceID", "1");
			xmlDoc.find("Properties").first().html(addCopyPasteData);

			/* Change filepaths for media files */
			var getAllMediaObjectUID = xmlDoc.find("Media[ObjectUID]");
			jQuery.each(getAllMediaObjectUID, function () {
				var curMediaFilePath = $(this).find("FilePath");
				var curMediaActualMediaFilePath = $(this).find("ActualMediaFilePath");

				//for Win/Mac file paths
				var filePathRegExp = /^(.+)[\\|\/]([^\\|\/]+)$/m;
				//if success parsed by regexp go next
				if ((parseFileName = filePathRegExp.exec(curMediaFilePath.text().toString())) !== null) {
					var getParseGroup = parseFileName[2];
					var getNewFilePathForMedia = convertToSystemPath(customAssetsFolder + "/" + getParseGroup);
					//rewrite FilePath
					curMediaFilePath.html(getNewFilePathForMedia);
					//rewrite ActualMediaFilePath
					curMediaActualMediaFilePath.html(getNewFilePathForMedia);
				}
			});

			/* FrameRect */
			/* Change item size (actual for transitions) */
			if (customFRes) {
				var getVideoObject_FrameRect = xmlDoc.find("FrameRect");
				getVideoObject_FrameRect.html(customFRes.join(","));
			}

			/* VideoMediaSource -> Media */
			/* New ID From ObjectURef to ObjectUID  */
			var getVideoMediaSource_MediaObjectURef = xmlDoc.find("VideoMediaSource").first().find("Media");
			var MediaObjectUREF_text = getVideoMediaSource_MediaObjectURef.attr("ObjectURef");
			getVideoMediaSource_MediaObjectURef.attr("ObjectURef", newMediaURef);
			xmlDoc.find('Media[ObjectUID="' + MediaObjectUREF_text + '"]').attr("ObjectUID", newMediaURef);

			/* VideoClip -> ClipID */
			/* Generic randomize for each */
			var getVideoClip_ClipID = xmlDoc.find("VideoClip").find("ClipID");
			jQuery.each(getVideoClip_ClipID, function () {
				var genNewClipID = rndSeqID(8) + "-" + rndSeqID(4) + "-" + rndSeqID(4) + "-" + rndSeqID(4) + "-" + rndSeqID(12);
				$(this).html(genNewClipID);
			});

			/* Change layer adjustments name to resolve problem if used one name layer with differents resolutions */
			var changeAdjustmentLayerNames = xmlDoc.find("Name");
			jQuery.each(changeAdjustmentLayerNames, function () {
				var curName = $(this).text();
				if (
					curName.toString().toLowerCase() == "adjustment" ||
					curName.toString().toLowerCase() == "adjustment layer" ||
					curName.toString().toLowerCase() == "do not touch" ||
					curName.toString().toLowerCase() == "do not edit" ||
					curName.toString().toLowerCase() == "adj layer"
				) {
					$(this).html(curName + " " + nameHash);
				}
			});

			var changeAdjustmentClipNameLayer = xmlDoc.find("ClipName");
			jQuery.each(changeAdjustmentClipNameLayer, function () {
				var curName = $(this).text();
				if (
					curName.toString().toLowerCase() == "adjustment" ||
					curName.toString().toLowerCase() == "adjustment layer" ||
					curName.toString().toLowerCase() == "do not touch" ||
					curName.toString().toLowerCase() == "do not edit" ||
					curName.toString().toLowerCase() == "adj layer"
				) {
					$(this).html(curName + " " + nameHash);
				}
			});

			/* NEW - Adding Speed control for keyframes/clips */

			var setSpeed = customSequenceSpeed && parseInt(customSequenceSpeed) != 100 ? 100 / parseInt(customSequenceSpeed) : false;
			if (setSpeed) {
				/* Change Clip Start */
				var changeClipStart = xmlDoc.find("Start");
				jQuery.each(changeClipStart, function () {
					var curPreviousTime = $(this).text();
					var finalString = Number(curPreviousTime) * setSpeed.toString();
					$(this).html(finalString);
				});

				/* Change Clip End */
				var changeClipEnd = xmlDoc.find("End");
				jQuery.each(changeClipEnd, function () {
					var curPreviousTime = $(this).text();
					var finalString = Number(curPreviousTime) * setSpeed.toString();
					$(this).html(finalString);
				});

				/* Change Clip InPoint */
				var changeClipInPoint = xmlDoc.find("InPoint");
				jQuery.each(changeClipInPoint, function () {
					var curPreviousTime = $(this).text();
					var finalString = Number(curPreviousTime) * setSpeed.toString();
					$(this).html(finalString);
				});

				/* Change Clip OutPoint */
				var changeClipInPoint = xmlDoc.find("OutPoint");
				jQuery.each(changeClipInPoint, function () {
					var curPreviousTime = $(this).text();
					var finalString = Number(curPreviousTime) * setSpeed.toString();
					$(this).html(finalString);
				});

				/* Change Keyframes Speed */
				var changeKeyframesSpeed = xmlDoc.find("Keyframes");
				jQuery.each(changeKeyframesSpeed, function () {
					var curKeyframes = $(this).text();
					var finalString = "";
					if (curKeyframes.indexOf(";") != -1) {
						var arraysWrapperArray = curKeyframes.split(";");

						for (var j = 0; j < arraysWrapperArray.length; j++) {
							var tempMass = arraysWrapperArray[j].split(",");
							if (tempMass.length == 1) {
								continue;
							}
							tempMass[0] = Number(tempMass[0]) * setSpeed.toString();
							var newPartOfFinalString = tempMass.join(",");
							finalString += newPartOfFinalString + ";";
						}
					} else {
						var keyFrameArray = curKeyframes.split(",");
						keyFrameArray[0] = Number(keyFrameArray[0]) * setSpeed.toString();
						finalString = keyFrameArray.join(",");
					}

					$(this).html(finalString);
				});
			}

			/* Disable Sound FX if disabled volume on panel */
			if (!enableSoundFx) {
				var changeAudioTrackGroup = xmlDoc.find("AudioTrackGroup");
				jQuery.each(changeAudioTrackGroup, function () {
					jQuery.each($(this).find("Tracks"), function () {
						$(this).html("");
					});
				});
			}

			var saveString = new XMLSerializer().serializeToString(xmlDoc.context);
			/* MASS REPLACING AS TEXT MODE */
			//replace all Sequence ObjectURef (need random, if will matches - not works)
			saveString = saveString.replace(new RegExp(findSeqORef, "g"), newCPGUID);
			//save file
			fsmodule._fs.writeFileSync(fileTo, saveString);

			return callback(fileTo);
		});
	});
}

//#endregion

//#region ANTI-HACK TRICKS

/**
 * Double checking server status (simple comparing data and adding +1 to variable "doubleServerCheckingStatus")
 * @return {boolean}
 */
function specialComparingResultServer() {
	var data = getActivationGatekeeper();
	if (data) {
		try {
			var json = data["json"];
			var str = data["string"];
			if (typeof json === "object") {
				str = JSON.parse(str);
				//Check = true Str and Json, and Code as "SUCCESS" in base64 x2 times encode and x1 times encode
				if (json.check && str.check && json.code == window.atob(window.atob("VTFWRFEwVlRVdz09")) && str.code == window.atob("U1VDQ0VTUw==")) {
					doubleServerCheckingStatus++;
					return true;
				}
			}
		} catch (e) {}
	}
	doubleServerCheckingStatus = 0; //reset double server checking status
	return false;
}

function setActivationGatekeeper(stringCode, jsonCheckStatus, stringCheckStatus) {
	installVerifyGateKeeperUsedKey = {
		code: stringCode,
		json: jsonCheckStatus,
		string: stringCheckStatus
	};
}

/**
 * @return {array} with 2 keys
 */
function getActivationGatekeeper() {
	return installVerifyGateKeeperUsedKey;
}

function resetParamsBeforeNextInstallation() {
	installVerifyGateKeeperUsedKey = {}; //reset gatekeeper
	doubleServerCheckingStatus = 0; //reset double server checking status
}

/**
 * Break data of package - because he is hacked - let's fun!
 * @param {*} filePath path for package
 * @param {*} writeData Bytes from image or any useless data write to pack
 */
function toBreakPiratedPackageFile(filePath, writeData) {
	if (!writeData) {
		writeData = window.atob(
			"x8y0y147rm1s2y349om1s0r110ss1o1n142xm1n8y941ss1y2s147rm1n1s190so4y8y445rr7y7y740qx8y9y642qr6y7y648nn8y1n110ss1n7y445om1n1s190s"
		);
	}
	fsmodule._fs.writeFile(convertToSystemPath(filePath), writeData, function (err) {
		if (err) {
			// append failed
		} else {
			// done
		}
	});
}

/**
 * Create encoded line with user computer data to save in package when installation and check on server
 * @fixed Fixed for CC17 (problem with nodejs macaddress)
 * @returns Encoded Line String with user data (mac/name,OS)
 */
function getUserSystemPrint(createNewPackageToPrefs) {
	var collect = JSON.stringify({
		mac: userUSPData.mac, //mac address
		user: userUSPData.user, //OS user name
		os: userUSPData.os //current OS name
	});
	return security.encodeUserSystemServerPrint(collect);
}

function encryptPurchaseCodeToSilenceChecks(purchaseCode) {
	if (purchaseCode) {
		return encoder.extras.utf8_to_b64(purchaseCode);
	} else {
		return "X19fX05PX1NZU1RFTV9EQVRBX19fXw==";
	}
}

//#endregion ANTI-HACK TRICKS
