/* Slide Buttons */
$(document).on('click', '[data-slide]', function(){
    //carousel
    var currentCarouselName = $(this).parent().data('carousel');
    var findCarouselContentByName = $(`[data-carousel-content="${currentCarouselName}"] > li`);

    // var slideContent = findCarouselContentByName.children('li');
    
    //slide
    var slideType = $(this).data('slide');


    var dotsNumber = false, slidesDots;
    if(!isNaN(slideType)){
        //slide by number
        dotsNumber = slideType;
        slidesDots = $(this).parent().find('> li');
    }else{
        //slide by direction
        slidesDots = $(`[data-carousel="${currentCarouselName}"][data-carousel-dots] > li`);
    }

    var defaultDirectionMove = slideType == 'right' ? true : false;

    carouselSlider(findCarouselContentByName, slidesDots, defaultDirectionMove, dotsNumber, 'swipe');

});

function sliderContent(slides, slideDots, turnDirection, focusDotsNumber, carouselName) {

    

    if(turnDirection){
        $(slides[numberSliderObj[carouselName]]).css({left:0}).stop().animate({left:-1000}, "slow").removeClass('current');
    }else{
        $(slides[numberSliderObj[carouselName]]).css({left: 0}).stop().animate({left:1000}, "slow");
    }
    

    //dots
    if(slideDots){
        $(slideDots[cslide]).removeClass('active');
    }
    
    
    if(focusDotsNumber){
        numberSliderObj[carouselName] = focusDotsNumber - 1;
    }else{
        numberSliderObj[carouselName] = Number(numberSliderObj[carouselName]) + 1;
        numberSliderObj[carouselName] = numberSliderObj[carouselName] >= slides.length ? 0 : numberSliderObj[carouselName];
    }

    if(turnDirection){
        $(slides[numberSliderObj[carouselName]]).css({left:1000}).stop().show().animate({left:0}, "slow").addClass('current');
    }else{
        $(slides[numberSliderObj[carouselName]]).css({left: -1000}).stop().show().animate({left:0}, "slow");
    }

    
    //dots
    if(slideDots){
        $(slideDots[numberSliderObj[carouselName]]).addClass('active');
    }
    

}


function carouselVideoSwipe(carouselVideoName, curNumber, type){

    var indexVideo = curNumber;
    var cVideo = $(`.carouselVideo[data-video-carousel="${carouselVideoName}"]`);
    var videoSrcArr = cVideo.data('video').split(':');
    var videoTag = cVideo.children(0);
    var finalVideoSrc = convertToSystemPath(getFolderWithAssetsItems() + '_NPA/' + videoSrcArr[indexVideo]);
    
    switch(type){
        case 'start':
            //if first time
            if(!videoTag.attr('src')){
                videoTag.attr('src', finalVideoSrc);
            }
            videoTag[0].play();
            break;
        case 'pause':
            videoTag[0].pause();
            break;
        case 'change':
            videoTag.attr('src', finalVideoSrc);
            if(videoTag[0].paused){
                videoTag[0].play();
            }
            break;
    }

    
}

function carouselSlider(slides, slideDots, rightMoveDirection, focusDotsNumber, animationType) {
    var numberic = slides.filter('.current').index();
    var swipeLeftPos = rightMoveDirection ? 650 : -650;
    //hide all slides
    switch(animationType){
        case 'opacity':
            slides.stop().fadeOut(300, function() {
                $(this).removeClass('current');
            });
            break;
        case 'swipe':
            slides.eq(numberic).css({opacity: 1, left:0}).stop().animate({
                left: swipeLeftPos,
                opacity: 0
            }, 300, function(){
                $(this).removeClass('current');
            });
            break;
        default:
            slides.removeClass('current');
    }


    if(focusDotsNumber){
        numberic = focusDotsNumber - 1;
    }else{
        numberic = rightMoveDirection ? numberic + 1 : numberic - 1;
    }

    //reset if more than <>
    if(numberic >= slides.length){
        numberic = 0;
    }else if(numberic < 0){
        numberic = slides.length-1;
    }

    //show current by index slide
    switch(animationType){
        case 'opacity':
            slides.eq(numberic).stop().fadeIn(500, function() {
                $(this).addClass('current');
            });
            break;
        case 'swipe':
            slides.eq(numberic).css({opacity: 0, left:-swipeLeftPos}).stop().addClass('current').animate({
                left: 0,
                opacity: 1
            }, 500);
            break;
        default:
            slides.addClass('current');
    }

    //change dots
    if(slideDots){
        slideDots.removeClass('current');
        slideDots.eq(numberic).addClass('current');
    }

    //video swipe with carousel
    var hasVideoCarousel = slides.parent().data('video-carousel');
    if(hasVideoCarousel){
        carouselVideoSwipe(hasVideoCarousel, numberic, 'change');
    }
}