/*
 * @Author: aniom
 * @Date:   2020-05-01 00:27:56
 * @Last Modified by:   aniom
 * @Last Modified time: 2020-05-01 00:42:53
 */
var audioVisualizationNewAC;
var srcSource;
var analyser;
var ctx;


function letAudiowaveForm(thisAudio, visualizerStyle){

    try{
        var canvas = document.getElementById("audioBody");


        
        if(!audioVisualizationNewAC && !srcSource){
            audioVisualizationNewAC = new AudioContext();
            srcSource = audioVisualizationNewAC.createMediaElementSource(thisAudio);
            analyser = audioVisualizationNewAC.createAnalyser();
            canvas.width = window.innerWidth;
            canvas.height = window.innerHeight; // / 2
            ctx = canvas.getContext("2d");
            srcSource.connect(analyser);
            analyser.connect(audioVisualizationNewAC.destination);
            analyser.fftSize = 2048;//2048;//256;
            analyser.smoothingTimeConstant = 0.59;


            var bufferLength = analyser.frequencyBinCount;
            var dataArray = new Uint8Array(bufferLength);
            
            var WIDTH = canvas.width;
            var HEIGHT = canvas.height;
        
            var barWidth = (WIDTH / bufferLength) * 2.5;
            var barHeight;
            // var x = 0;
            
    
            if(visualizerStyle == 1){
                
               // spectrum();
            
                (function spectrum(){
          
                    analyser.getByteTimeDomainData(dataArray);
            
                    barWidth = (WIDTH / bufferLength) * 4.5;
                    
                    ctx.clearRect(0, 0, WIDTH, HEIGHT);
                    ctx.lineWidth = 14;
                    ctx.strokeStyle = "#2FC1FA";//"#ddd";
            
                    // ctx.lineJoin  = 'bevel';
                    ctx.beginPath();
                    var sliceWidth = canvas.width * 1.5 / bufferLength;
                    ctx.setLineDash([4, 2]);
                    ctx.shadowBlur = 70;
                    ctx.shadowColor = "#2FC2FF";
                    ctx.shadowOffsetX = 20;
                    ctx.shadowOffsetY = 20;
                    var gradient = ctx.createLinearGradient(0, 0, 0, HEIGHT);
                    gradient.addColorStop(0, "#2FC2FF");
                    gradient.addColorStop(1, "#74FAFF");
            
                    ctx.strokeStyle = gradient;
                    x = 0;
                  
                    for (var i = 0; i < bufferLength; i++) {
            
                        var v = dataArray[i] / 128.0;
                        var y = v * canvas.height / 2;
                        
            
                      if (i === 0) {
                        ctx.moveTo(x, y);
                      } else {
                        ctx.lineTo(x, y);
                      }
                  
                      x += sliceWidth;
                    }
                  
                    ctx.lineTo(canvas.width, canvas.height / 2);
                    ctx.stroke();
                    requestAnimationFrame(spectrum);
                })();


            }
            if(visualizerStyle == 2){
                //barchars();
                (function barchars(){


                    x = 0;
                    analyser.getByteFrequencyData(dataArray);
        
                    barWidth = 4;//(WIDTH / bufferLength) * 2;
        
                    ctx.fillStyle = "#262626";
                    ctx.fillRect(0, 0, WIDTH, HEIGHT);
                    ctx.clearRect(0, 0, WIDTH, HEIGHT);
                    var gradient = ctx.createLinearGradient(0, 0, 0, HEIGHT);
                    gradient.addColorStop(0, "#2FC2FF");
                    gradient.addColorStop(1, "#74FAFF");
                    
        
                    for (var i = 0; i < bufferLength; i++) {
                        barHeight = dataArray[i]   * 2;
            
                        var r = 225; //barHeight + (24 * (i/bufferLength));
                        var g = 214;
                        var b = 30;
        
                        ctx.fillStyle = gradient;//"rgb(" + r + "," + g + "," + b + ")";
                        // ctx.fillRect(x, barHeight, barWidth, barHeight);
        
                        ctx.fillRect(x, (HEIGHT - barHeight), barWidth, barHeight);
                        x += barWidth; //barWidth + 1;
                    }

                    requestAnimationFrame(barchars);
                })();
            
            }
        }

        // function barchars(){
        //     var dif = Date.now() - lst;
        //     lst = Date.now();
        //     if (useTime) step = rps * dif/1000;
        //     x = 0;
        //     analyser.getByteFrequencyData(dataArray);

        //     barWidth = 4;//(WIDTH / bufferLength) * 2;

        //     ctx.fillStyle = "#262626";
        //     ctx.fillRect(0, 0, WIDTH, HEIGHT);
        //     ctx.clearRect(0, 0, WIDTH, HEIGHT);
        //     var gradient = ctx.createLinearGradient(0, 0, 0, HEIGHT);
        //     gradient.addColorStop(0, "#2FC2FF");
        //     gradient.addColorStop(1, "#74FAFF");
            

        //     for (var i = 0; i < bufferLength; i++) {
        //         barHeight = dataArray[i]*2.2;
    
        //         var r = 225; //barHeight + (24 * (i/bufferLength));
        //         var g = 214;
        //         var b = 30;

        //         ctx.fillStyle = gradient;//"rgb(" + r + "," + g + "," + b + ")";
        //         // ctx.fillRect(x, barHeight, barWidth, barHeight);

        //         ctx.fillRect(x, (HEIGHT - barHeight), barWidth, barHeight);
        //         x += barWidth; //barWidth + 1;
        //     }
        //     requestAnimationFrame(barchars);
        // }

    }catch(e){
        alert(e);
    }
}